<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- ************************************************ -->
    <!-- creation de la webographie pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->

    <xsl:template name="UVED_WEBOGRAPHIE">

        <xsl:call-template name="ecrireDansFichier">
           <xsl:with-param name="fichier" select="concat($cheminSite,'webographie.html')"/>
           <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource" />
                    <body>
                        <xsl:call-template name="bodyheaderRessource" />
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-section">
                                <h3>Ressources</h3>
                                <h4>Webographie</h4>
                            </div>
    
                            <!-- creation de la liste des ressources accessibles -->
                            <xsl:call-template name="selectressources" />
    
                            <table>
                                <thead>
                                    <tr>
                                        <th class="gras">
                                            Contenu du site
                                        </th>
                                        <th class="gras">URL</th>
                                    </tr>
                                </thead>
                                <tbody>
    
                                    <!-- affichage des adresses de la webographie-->
                                    <xsl:for-each
                                        select="UVED//REFERENCEWEBOGRAPHIQUE">
                                        <xsl:sort order="ascending"
                                            select="@URL" />
                                        <xsl:if
                                            test="not(preceding::REFERENCEWEBOGRAPHIQUE/@URL=@URL)">
                                            <tr>
                                                <td
                                                    class="cellule-alternative">
                                                    <span class="gras">
                                                        <xsl:apply-templates
                                                            select="DESCRIPTION" />
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="{@URL}"
                                                        target="_blank">
                                                        <xsl:value-of
                                                            select="@URL" />
                                                    </a>
                                                </td>
                                            </tr>
                                        </xsl:if>
                                    </xsl:for-each>
                                </tbody>
                            </table>
    
                        </div>
                    <xsl:call-template name="footerRessource">
                         <xsl:with-param name="pageActive">webographie</xsl:with-param>
                    </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>


    <!-- ************************************************ -->
    <!-- creation liste des ressources-->
    <!-- ************************************************ -->
    <xsl:template name="selectressources">
        <div class="selection">
            <fieldset>
                <form action="">
                    <select
                        onchange="location=this.options[this.selectedIndex].value;">
                        <option>Voir une autre ressource...</option>

                        <xsl:if test="count(UVED//MOTDUGLOSSAIRE)>0">
                            <option value="glossaire.html">
                                - Glossaire
                            </option>
                        </xsl:if>

                        <xsl:if
                            test="count(UVED//REFERENCEBIBLIOGRAPHIQUE)>0">
                            <option value="bibliographie.html">
                                - Bibliographie
                            </option>
                        </xsl:if>
                    </select>
                </form>
            </fieldset>
        </div>
    </xsl:template>

    <xsl:template match="DESCRIPTION">
        <p>
            <xsl:value-of select="." />
        </p>
    </xsl:template>

</xsl:stylesheet>
