<?xml version="1.0" encoding='ISO-8859-1' ?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- version 0.5 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
<xsl:include href="./UVED_OUTILS.xsl" />
<!-- ************************************************ -->
<!-- header des pages presentation et ressources UVED-->
<!-- ************************************************ -->
   <xsl:template name="headerRessource">
      <xsl:variable name="nomFichier" select="//CHAPITRE[1]/@label" />
      <xsl:variable name="cheminNomFichier" select="concat($nomFichier,'.html')" />
      <head>
        <title>UVED - Ressources</title>

        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript">
			function getCurrentCoursePage()
			{
				var currentCoursePage = CIRM.utils.Cookie.read( "currentCoursePage" );
				if ( currentCoursePage != null )
				{
					document.location.href = currentCoursePage;
				}
				else
				{
					document.location.href = "<xsl:value-of select="$cheminNomFichier" />";
				}
				
			};
			function _initialize()
			{
				CIRM.utils.Frame.initialize();
			};
			YAHOO.util.Event.on( window, "load", _initialize );
		</script>
		
      </head>
   </xsl:template>

<!-- ************************************************ -->
<!-- header des pages UVED - Prsentation-->
<!-- ************************************************ -->
   <xsl:template name="headerPresentation">
      <xsl:variable name="nomFichier" select="//CHAPITRE[1]/@label" />
      <xsl:variable name="cheminNomFichier" select="concat($nomFichier,'.html')" />
      <head>
        <title>UVED - Prsentation</title>

        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript">
			function getCurrentCoursePage()
			{
				var currentCoursePage = CIRM.utils.Cookie.read( "currentCoursePage" );
				if ( currentCoursePage != null )
				{
					document.location.href = currentCoursePage;
				}
				else
				{
					document.location.href = "<xsl:value-of select="$cheminNomFichier" />";
				}
				
			};
			function _initialize()
			{
				CIRM.utils.Frame.initialize();
			};
			YAHOO.util.Event.on( window, "load", _initialize );
		</script>
		
      </head>
   </xsl:template>

<!-- ************************************************ -->
<!-- header des pages UVED - Bibliographie-->
<!-- ************************************************ -->
   <xsl:template name="headerBiblio">
      <xsl:variable name="nomFichier" select="//CHAPITRE[1]/@label" />
      <xsl:variable name="cheminNomFichier" select="concat($nomFichier,'.html')" />
      <head>
        <title>UVED - Bibliographie</title>

        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript">
			function getCurrentCoursePage()
			{
				var currentCoursePage = CIRM.utils.Cookie.read( "currentCoursePage" );
				if ( currentCoursePage != null )
				{
					document.location.href = currentCoursePage;
				}
				else
				{
					document.location.href = "<xsl:value-of select="$cheminNomFichier" />";
				}
				
			};
			function _initialize()
			{
				CIRM.utils.Frame.initialize();
			};
			YAHOO.util.Event.on( window, "load", _initialize );
		</script>
		
      </head>
   </xsl:template>

<!-- ************************************************ -->
<!-- header de toutes les pages de cours UVED-->
<!-- ************************************************ -->
   <xsl:template name="headerPage">
      <xsl:param name="idPage"/>
       
      <head>
        <title>UVED - Cours</title>

        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
        <link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
        <script type="text/javascript" src="../medias/scripts/qcm.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript">
			var treeInstance;
            var forcedNodeId="<xsl:value-of select="$idPage" />";
			function _getCurrentNodeId()
			{
				var ulElement = document.getElementById( "tree" );
				var aElement = ulElement.getElementsByTagName( "a" );
				for ( var i = 0; aElement.length >= i; i++ )
				{
					var current = aElement[ i ];
					var currentFileName = _getFileName( current.getAttribute( "href" ) );
					var documentFileName = _getFileName( document.location.href );
					if ( currentFileName == documentFileName || _startsWith( currentFileName, documentFileName ) )
					{
						return current.parentNode.id;
					}
				}
			};
			function _getFileName(url)
			{
				var array = url.split( "/" );
				var result = array[ array.length - 1 ];
				return result;
			};
			function _initialize()
			{
				CIRM.utils.Frame.initialize();
				treeInstance = new CIRM.utils.TreeView( "tree" );
				var currentNodeId = ( forcedNodeId != "" ) ? forcedNodeId : _getCurrentNodeId();
				treeInstance.expandTo( currentNodeId );
				CIRM.utils.Cookie.write( "currentNodeId", currentNodeId );
				CIRM.utils.Cookie.write( "currentCoursePage", _getFileName( document.location.href ) );
			};
			function _startsWith(source, value)
			{
				if ( source.indexOf( value ) == 0 )
				{
					return true;
				}
				return false;
			};
			YAHOO.util.Event.on( window, "load", _initialize );
		</script>
       
      </head>
   </xsl:template>


<!-- ************************************************ -->
<!-- header pour la page plan du cours UVED-->
<!-- ************************************************ -->
 <xsl:template name="headerPagePlan">
      <head>
         <title>UVED - Plan</title>

         <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
         <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
         <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript">
			var treeInstance;
			function _getCurrentNodeId()
			{
				return CIRM.utils.Cookie.read( "currentNodeId" );
			};
			function _initialize()
			{
				treeInstance = new CIRM.utils.TreeView( "tree" );
				treeInstance.expandTo( _getCurrentNodeId() );
			};
			YAHOO.util.Event.on( window, "load", _initialize );
		</script>
		<style type="text/css">
			html,
			body
			{
				overflow: auto;
			}
		</style>
      </head>
   </xsl:template>

<!-- ************************************************ -->
<!-- header de toutes les pages d'annexe UVED-->
<!-- ************************************************ -->
   <xsl:template name="headerPageAnnexe">
      <head>
        <title>UVED - Annexe</title>

        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Style-Type" content="text/css" ><xsl:value-of select="''"/></meta>
        <meta http-equiv="Content-Script-Type" content="text/javascript" ><xsl:value-of select="''"/></meta>
        <link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-tooltip.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/cirm/cirm-treeview.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/style.css" media="screen" ><xsl:value-of select="''"/></link>
		<link rel="stylesheet" type="text/css" href="../medias/styles/module/print.css" media="print" ><xsl:value-of select="''"/></link>
		<script type="text/javascript" src="../medias/scripts/yahoo.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/event.js"><xsl:value-of select="''"/></script>
		<script type="text/javascript" src="../medias/scripts/cirm.js"><xsl:value-of select="''"/></script>
        <script type="text/javascript" src="../medias/scripts/qcm.js"><xsl:value-of select="''"/></script>

      </head>
   </xsl:template>
  
<!-- ************************************************ -->
<!-- header de la page de crdits UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerCredits">
        <!-- HEADER --><head>
            <title>
                <xsl:value-of select="UVED/CONTENUS/@titre" />
            </title>
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
            <meta http-equiv="Content-Style-Type" content="text/css" />
            <meta http-equiv="Content-Script-Type" content="text/javascript" />
        </head>
        
        <link rel="stylesheet" type="text/css" title="NORMAL" href="../medias/styles/module/author.css" media="screen" ><xsl:value-of select="''"/></link>
    </xsl:template>

<!-- ************************************************ -->
<!-- header des pages d'aide pour les QCMs UVED-->
<!-- ************************************************ -->
    <xsl:template name="headerAideQCM">
        <!-- HEADER --><head>
            <title>
                <xsl:value-of select="name()" />
            </title>
            <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
            <meta http-equiv="Content-Style-Type" content="text/css" />
            <meta http-equiv="Content-Script-Type" content="text/javascript" />
        </head>
        
        <link rel="stylesheet" type="text/css" title="NORMAL" href="../medias/styles/module/aideqcm.css" media="screen" ><xsl:value-of select="''"/></link>
    </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les pages de cours UVED -->
<!-- ************************************************ -->
   <xsl:template name="bodyheaderPage">
      <!-- HEADER -->
      <div id="header">
         <div id="titre-axe"><h1>UVED</h1></div>

         <div id="titre-module">
            <h2><xsl:value-of select="//CONTENUS/@titre" /></h2>
         </div>

         <div id="menu-haut">
            <ul>
               <li>
                  <a href="index.html" accesskey="A" id="rubrique1" title="Prsentation"><span>Prsentation</span></a>
               </li>

               <li>
                  <a href="#" accesskey="Z" id="rubrique2" class="current" title="Cours"><span>Cours</span></a>
               </li>

               <li>
                  <a href="ressources.html" accesskey="R" id="rubrique4" title="Ressources"><span>Ressources</span></a>
               </li>
            </ul>
         </div>

        
      </div>
      
      <div id="breadcrumb">&#xA0;</div>
   </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les annexes -->
<!-- ************************************************ -->
   <xsl:template name="bodyheaderPageAnnexe">
       <!-- HEADER -->
     <div id="header">
         <div id="titre-axe"><h1>UVED</h1></div>

         <div id="titre-module">
            <h2><xsl:value-of select="//CONTENUS/@titre" /></h2>
         </div>
      </div>
   </xsl:template>

<!-- ************************************************ -->
<!-- body header de toutes les pages de ressources -->
<!-- ************************************************ -->
   <xsl:template name="bodyheaderRessource">
      <!-- HEADER -->
      <div id="header">
         <div id="titre-axe"><h1>UVED</h1></div>

         <div id="titre-module">
            <h2><xsl:value-of select="//CONTENUS/@titre" /></h2>
         </div>

         <div id="menu-haut">
            <ul>
               <li>
                  <a href="index.html" accesskey="A" id="rubrique1" title="Prsentation"><span>Prsentation</span></a>
               </li>

               <li>
                  <a href="javascript:getCurrentCoursePage();" accesskey="Z" id="rubrique2" title="Cours"><span>Cours</span></a>
               </li>

               <li>
                  <a href="ressources.html" accesskey="R" id="rubrique4" title="Ressources"><span>Ressources</span></a>
               </li>
            </ul>
         </div>
      </div>
      <div id="breadcrumb">&#xA0;</div>
   </xsl:template>

<!-- ************************************************ -->
<!-- footer des pages presentation et ressources UVED -->
<!-- ************************************************ -->
   <xsl:template name="footerRessource">
      <xsl:param name="pageActive" />
      <!-- FOOTER -->
      <div id="footer">
            <ul id="menu-bas">
               <li id="map">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('plan.html',600,600,'Plan');" title="Plan"><span>Plan</span></a>
               </li>
               <li id="help">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('../medias/html/aide.html',800, 600, 'Aide');" title="Aide"><span>Aide</span></a>
               </li>
               <li id="credits">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('credits.html', 600, 400, 'Credits');" title="Crdits"><span>Crdits</span></a>
               </li>
               <li id="print">
                  <a href="javascript:print();" title="Imprimer la page"><span>Imprimer</span></a>
               </li>
            </ul>

         <div class="copyright">
            <span><a href="javascript:CIRM.utils.Window.openCenterWindow('../medias/html/mentions.html',600, 400, 'Mentions');" title="Afficher les mentions lgales">mentions lgales</a> - @ 2006 - UVED</span>
         </div>
      </div>
   </xsl:template>

<!-- ************************************************ -->
<!-- footer de toutes les pages du cours UVED-->
<!-- ************************************************ -->
   <xsl:template name="footerPage">
      <xsl:param name="pageActive" />
      <xsl:param name="pagePrecedente" />
      <xsl:param name="pageSuivante" />
      <xsl:param name="testPagePrecedente" />
      <xsl:param name="testPageSuivante" />

      <!-- FOOTER -->
      <div id="footer">
            <ul id="menu-bas">
               <li id="map">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('plan.html',600,600,'Plan');" title="Plan"><span>Plan</span></a>
               </li>
               <li id="help">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('../medias/html/aide.html',800, 600, 'Aide');" title="Aide"><span>Aide</span></a>
               </li>
               <li id="credits">
                  <a href="javascript:CIRM.utils.Window.openCenterWindow('credits.html', 600, 400, 'Credits');" title="Crdits"><span>Crdits</span></a>
               </li>
               <li id="print">
                  <a href="javascript:print();" title="Imprimer la page"><span>Imprimer</span></a>
               </li>
              <xsl:choose>
                  <xsl:when test="$testPagePrecedente='vide'">
                     <li id="previous">
                        <a href="#" title="Page prcdente" class="disabled"><span>Page prcdente</span></a>
                     </li>
                  </xsl:when>

                  <xsl:otherwise>
                     <li id="previous">
                        <a href="{$pagePrecedente}" title="Page prcdente"><span>Page prcdente</span></a>
                     </li>
                  </xsl:otherwise>
               </xsl:choose>

               <xsl:choose>
                  <xsl:when test="$testPageSuivante='vide'">
                     <li id="next">
                        <a href="#" title="Page suivante" class="disabled"><span>Page suivante</span></a>
                     </li>
                  </xsl:when>

                  <xsl:otherwise>
                     <li id="next">
                        <a href="{$pageSuivante}" title="Page suivante"><span>Page suivante</span></a>
                     </li>
                  </xsl:otherwise>
               </xsl:choose>
            </ul>
 
         <div class="copyright">
            <span><a href="javascript:CIRM.utils.Window.openCenterWindow('../medias/html/mentions.html',600, 400, 'Mentions');" title="Afficher les mentions lgales">mentions lgales</a> - @ 2006 - UVED</span>
         </div>
      </div>
   </xsl:template>

<!-- ************************************************ -->
<!-- sommaire de toutes les pages de cours UVED -->
<!-- ************************************************ -->
   <xsl:template name="sommairePage">
      <!-- traitement des chapitres -->
      <xsl:for-each select="UVED//CHAPITRE">
         <xsl:variable name="labelchapitre" select="./@label" />
         <li id="{./@label}">
               <a href="{./@label}.html"><xsl:value-of select="./@titre" /></a>

            <xsl:if test="count(./PARTIE)>0">
            <!-- traitement des parties -->
               <ul>
                  <xsl:for-each select="./PARTIE">
                     <xsl:variable name="labelpartie" select="./@label" />
                     <xsl:variable name="hrefpartie"><xsl:call-template name="sommaireGetPagePARTIE" /></xsl:variable>

                     <li id="{concat($hrefpartie,'_',$labelpartie)}">
                        <a href="{$hrefpartie}.html#{$labelpartie}"><xsl:value-of select="./@titre" /></a>

                        <xsl:if test="count(./SOUSPARTIE)>0">
                        <!-- traitement des sous-parties -->
                           <ul>
                              <xsl:for-each select="./SOUSPARTIE">
                                 <xsl:variable name="hrefsouspartie"><xsl:call-template name="sommaireGetPageSOUSPARTIE" /></xsl:variable>
                                 <xsl:variable name="labelsouspartie" select="./@label" />
                                 <li id="{concat($hrefsouspartie,'_',$labelsouspartie)}">
                                     <a href="{$hrefsouspartie}.html#{./@label}"><xsl:value-of select="./@titre" /></a>
                                 </li>
                              </xsl:for-each>
                           </ul>
                        </xsl:if>
                     </li>
                  </xsl:for-each>
               </ul>
            </xsl:if>
         </li>
      </xsl:for-each>
   </xsl:template>


<!-- ************************************************ -->
<!-- Sommaire pour la page plan du cours UVED-->
<!-- ************************************************ -->
   <xsl:template name="sommairePagePlan">
      <!-- traitement des chapitres -->
      <xsl:for-each select="UVED//CHAPITRE">
         <xsl:variable name="labelchapitre" select="./@label" />

         <li id="{./@label}">
            <a href="{./@label}.html"><xsl:value-of select="./@titre" /></a>

            <xsl:if test="count(./PARTIE)>0">
            <!-- traitement des parties -->
               <ul>
                  <xsl:for-each select="./PARTIE">
                     <xsl:variable name="labelpartie" select="./@label" />

                     <xsl:variable name="hrefpartie"><xsl:call-template name="sommaireGetPagePARTIE" /></xsl:variable>

                     <li id="{concat($hrefpartie,'_',$labelpartie)}">
                        <a href="{$hrefpartie}.html"><xsl:value-of select="./@titre" /></a>

                        <xsl:if test="count(./SOUSPARTIE)>0">
                        <!-- traitement des sous-parties -->
                           <ul>
                              <xsl:for-each select="./SOUSPARTIE">
                                 <xsl:variable name="hrefsouspartie"><xsl:call-template name="sommaireGetPageSOUSPARTIE" /></xsl:variable>
                                 <xsl:variable name="labelsouspartie" select="./@label" />
                                 <li id="{concat($hrefsouspartie,'_',$labelsouspartie)}">
                                       <a href="{$hrefsouspartie}.html"><xsl:value-of select="./@titre" /></a>
                                 </li>
                              </xsl:for-each>
                           </ul>
                        </xsl:if>
                     </li>
                  </xsl:for-each>
               </ul>
            </xsl:if>
         </li>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="sommaireGetPagePARTIE">
   <!-- La page qui contient la PARTIE est soit le saut de page precedent, soit le CHAPITRE -->
      <xsl:choose>
         <xsl:when test="count(parent::CHAPITRE//SAUTPAGEHTML)>0">
            <xsl:variable name="idSautPage" select="generate-id(preceding::SAUTPAGEHTML[1])" />
            <!-- vrifier que le noeud appartient au parent -->
            <xsl:variable name="verif" ><xsl:call-template name="sommaireGetPagePARTIEverifParent">
            <xsl:with-param name="idSautPage" select="$idSautPage"/></xsl:call-template></xsl:variable>
            <xsl:choose>
            <xsl:when test="contains($verif,'Oui')">
            <xsl:choose>
               <xsl:when test="$idSautPage!=''">
                  <xsl:for-each select="parent::CHAPITRE//SAUTPAGEHTML">
                     <xsl:if test="generate-id(current())=$idSautPage">
                         <xsl:choose>
                           <xsl:when test="name(..)='SOUSPARTIE'">
                              <xsl:for-each select="ancestor::SOUSPARTIE/SAUTPAGEHTML">
                                 <xsl:if test="generate-id(current())=$idSautPage">
                                    <xsl:variable name="numSautPageHtml" select="position()" />
                                    <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',ancestor::SOUSPARTIE/@label,'_',$numSautPageHtml)" />
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:when>

                           <xsl:when test="name(..)='PARTIE'">
                              <xsl:for-each select="ancestor::PARTIE/SAUTPAGEHTML">
                                 <xsl:if test="generate-id(current())=$idSautPage">
                                    <xsl:variable name="numSautPageHtml" select="position()" />
                                    <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',$numSautPageHtml)" />
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:when>

                           <xsl:otherwise>
                              <xsl:for-each select="ancestor::CHAPITRE/SAUTPAGEHTML">
                                 <xsl:if test="generate-id(current())=$idSautPage">
                                    <xsl:variable name="numSautPageHtml" select="position()" />
                                    <xsl:value-of select="concat(parent::CHAPITRE/@label,'_',$numSautPageHtml)" />
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:otherwise>
                        </xsl:choose>
                     </xsl:if>
                  </xsl:for-each>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="parent::CHAPITRE/@label" />
               </xsl:otherwise>
            </xsl:choose>
	        </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="parent::CHAPITRE/@label" />
            </xsl:otherwise>
          </xsl:choose>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="parent::CHAPITRE/@label" />
         </xsl:otherwise>
      </xsl:choose>
  </xsl:template>

   <xsl:template name="sommaireGetPagePARTIEverifParent">
       <xsl:param name="idSautPage"/>
       <xsl:for-each select="parent::CHAPITRE//SAUTPAGEHTML">
          <xsl:if test="generate-id(current())=$idSautPage">
              <xsl:value-of select="'Oui'" />
          </xsl:if>
       </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="sommaireGetPageSOUSPARTIE">
   <!-- La page qui contient la SOUSPARTIE est soit le saut de page prcdent -->
   <!-- soit le saut de page avant la PARTIE parente -->
   <!-- soit le CHAPITRE parent -->
      <xsl:choose>
         <xsl:when test="count(ancestor::CHAPITRE//SAUTPAGEHTML)>0">
         <!-- Il y a des sauts de page dans la PARTIE -->
         <!-- Il faut prendre celui qui precde la SOUSPARTIE s'il existe -->
         <!-- Sinon remonter aux sauts dans le CHAPITRE -->
            <xsl:variable name="sommaireGetPageSOUSPARTIE1">
               <xsl:call-template name="sommaireGetPageSOUSPARTIE1" />
            </xsl:variable>

            <xsl:choose>
               <xsl:when test="$sommaireGetPageSOUSPARTIE1!=''">
                  <xsl:value-of select="$sommaireGetPageSOUSPARTIE1" />
               </xsl:when>

               <xsl:otherwise>
                   <xsl:value-of select="ancestor::CHAPITRE/@label" />
              </xsl:otherwise>
            </xsl:choose>
         </xsl:when>

         <xsl:otherwise>
             <xsl:value-of select="ancestor::CHAPITRE/@label" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template name="sommaireGetPageSOUSPARTIE1">
      <xsl:variable name="idSautPage" select="generate-id(preceding::SAUTPAGEHTML[1])" />

      <xsl:for-each select="ancestor::CHAPITRE//SAUTPAGEHTML">
         <xsl:if test="generate-id(current())=$idSautPage">
            <xsl:variable name="numSautPageHtml" select="position()" />

            <xsl:choose>
               <xsl:when test="name(..)='SOUSPARTIE'">
                  <xsl:variable name="labelChapitre" select="ancestor::CHAPITRE/@label" />
                  <xsl:variable name="labelPartie" select="ancestor::PARTIE/@label" />
                  <xsl:variable name="labelSousPartie" select="ancestor::SOUSPARTIE/@label" />
                  <xsl:for-each select="ancestor::CHAPITRE[@label=$labelChapitre]/PARTIE[@label=$labelPartie]/SOUSPARTIE[@label=$labelSousPartie]/SAUTPAGEHTML">
                     <xsl:if test="generate-id(current())=$idSautPage">
                        <xsl:variable name="numSautPageHtml" select="position()" />
                        <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',ancestor::SOUSPARTIE/@label,'_',$numSautPageHtml)" />
                     </xsl:if>
                  </xsl:for-each>
               </xsl:when>

               <xsl:when test="name(..)='PARTIE'">
                  <xsl:variable name="labelChapitre" select="ancestor::CHAPITRE/@label" />
                  <xsl:variable name="labelPartie" select="ancestor::PARTIE/@label" />
                  <xsl:for-each select="ancestor::CHAPITRE[@label=$labelChapitre]/PARTIE[@label=$labelPartie]/SAUTPAGEHTML">
                     <xsl:if test="generate-id(current())=$idSautPage">
                        <xsl:variable name="numSautPageHtml" select="position()" />
                        <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',$numSautPageHtml)" />
                     </xsl:if>
                  </xsl:for-each>
               </xsl:when>

               <xsl:otherwise>
                  <xsl:variable name="labelChapitre" select="ancestor::CHAPITRE/@label" />
                  <xsl:for-each select="ancestor::CHAPITRE[@label=$labelChapitre]/SAUTPAGEHTML">
                     <xsl:if test="generate-id(current())=$idSautPage">
                        <xsl:variable name="numSautPageHtml" select="position()" />
                        <xsl:value-of select="concat(parent::CHAPITRE/@label,'_',$numSautPageHtml)" />
                     </xsl:if>
                  </xsl:for-each>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>

<!-- ************************************************ -->
<!-- Traitement des lments d'un bloc  -->
<!-- ************************************************ -->
   <xsl:template match="PARAGRAPHE" mode="unique">
      <div class="bloc-standard">
         <xsl:if test="@titre">
         	<h6><xsl:value-of select="@titre"/></h6>
         </xsl:if>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="PARAGRAPHE">
         <xsl:if test="@titre">
         	<h6><xsl:value-of select="@titre"/></h6>
         </xsl:if>
         <p>
            <xsl:apply-templates />
         </p>
   </xsl:template>
   
   <xsl:template match="DEFINITION" mode="unique">
      <div class="bloc-definition">
         <h6>Dfinition</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>

   <xsl:template match="INTRODUCTION" mode="unique">
      <div class="bloc-introduction">
         <h6>Introduction</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>

   <xsl:template match="REMARQUE" mode="unique">
      <div class="bloc-remarque">
         <h6>Remarque</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>

   <xsl:template match="EXEMPLE" mode="unique">
      <div class="bloc-exemple">
         <h6>Exemple</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="CONCLUSION" mode="unique">
      <div class="bloc-conclusion">
         <h6>Conclusion</h6>
         <div class="content">
			<xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="METHODE" mode="unique">
      <div class="bloc-methode">
         <h6>Mthode</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="RAPPEL" mode="unique">
      <div class="bloc-rappel">
         <h6>Rappel</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="COMPLEMENT" mode="unique">
      <div class="bloc-complement">
         <h6>Complment</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="ENSAVOIRPLUS" mode="unique">
      <div class="bloc-ensavoirplus">
         <h6>En savoir plus</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="ATTENTION" mode="unique">
      <div class="bloc-attention">
         <h6>Attention</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="SYNTAXE" mode="unique">
      <div class="bloc-syntaxe">
         <h6>Syntaxe</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="EXPLICATION" mode="unique">
      <div class="bloc-explication">
         <h6>Explication</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="CONSEIL" mode="unique">
      <div class="bloc-conseil">
         <h6>Conseil</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="CONFERE" mode="unique">
      <div class="bloc-confere">
         <h6>Confre</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="CITATION" mode="unique">
      <div class="bloc-citation">
         <h6>Citation</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
   <xsl:template match="ACTIVITE" mode="unique">
      <div class="bloc-activite">
         <h6>Activit</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
<!-- ************************************************ -->
<!-- QCM  -->
<!-- ************************************************ -->

   
    <xsl:template match="QCM" mode="unique">
        <div class="bloc-activite">
          <h6>Activit</h6>
          <div class="content">
            <b>Questionnaire  choix multiples</b>
            <xsl:variable name="numqcm"><xsl:number level="any" from="UVED" count="QCM" /></xsl:variable>
            <!-- remarque: le onsubmit ne marchera pas sur de vieux navigateurs, mais c'est le seul
                moyen d'avoir un code valide -->
            <p>    
            <form name="qcm{$numqcm}" action="#" onsubmit="resultat({$numqcm - 1}); return false">
                <xsl:apply-templates/>
                <br></br>
                <input value="Solution" type="submit"/>&#xA0;
                <xsl:apply-templates select="AIDE" mode="qcm"/>
            </form>
            </p>
          </div>
        </div>
    </xsl:template>
    
    <xsl:template match="AIDE" mode="qcm">
        <xsl:variable name="aide">
            <xsl:apply-templates/>
        </xsl:variable>
    
        <xsl:variable name="numaide">
            <xsl:number level="any" from="UVED" count="AIDE | SOLUTION"/>
        </xsl:variable>
        
        <xsl:if test="$aide!=''">
            <a href="javascript:CIRM.utils.Window.openCenterWindow('aide{$numaide - 1}.html',600, 400, 'Aide QCM');" title="Aide"><span class="help"><span>Aide</span></span></a>
        </xsl:if>
    </xsl:template>

    <xsl:template match="AIDE">
    </xsl:template>    

    <xsl:template match="QUESTIONQCM">
        <div class="questionqcm">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="ENONCE">
        <div class="enonceqcm">
            <xsl:apply-templates/>
        </div>
    </xsl:template>
    
    <xsl:template match="REPONSE">
        <br/>
        <xsl:variable name="vraifaux"><xsl:choose>
            <xsl:when test="@bonne='oui'">V</xsl:when>
            <xsl:when test="@bonne='non'">F</xsl:when>
            <xsl:otherwise><xsl:choose>
                <xsl:when test="COMMENTAIREREP='ok'">V</xsl:when>
                <xsl:otherwise>F</xsl:otherwise>
            </xsl:choose></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="numquestion"><xsl:number level="any" from="QCM" count="QUESTIONQCM" /></xsl:variable>
        <input type="radio" name="repq{$numquestion}" value="{$vraifaux}{normalize-space(COMMENTAIREREP)}"/>
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="TEXTEREP">
        <span class="reptexte">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    
    <xsl:template match="COMMENTAIREREP">
    </xsl:template>
   
<!-- ************************************************ -->
<!-- Traitement des lments du groupe styletexte -->
<!-- ************************************************ -->

    <xsl:template match="B">
        <b>    
            <xsl:apply-templates />
        </b>
    </xsl:template>

    <xsl:template match="I">
        <i>    
            <xsl:apply-templates />
        </i>
    </xsl:template>
       
    <xsl:template match="EM">
        <em>    
            <xsl:apply-templates />
        </em>
    </xsl:template>
    
    <xsl:template match="SUP">
        <sup>    
            <xsl:apply-templates />
        </sup>
    </xsl:template>
    
    <xsl:template match="SUB">
        <sub>    
            <xsl:apply-templates />
        </sub>
    </xsl:template>
    
    <xsl:template match="NBSP">&#xA0;</xsl:template>
    
    <xsl:template match="BR">
        <br/>
    </xsl:template>

<!-- ************************************************ -->
<!-- Traitement des lments de titre -->
<!-- ************************************************ -->
   <xsl:template match="SAUTPAGEHTML" mode="unique">
    <xsl:if test="./@titre">
      <div class="titre-section">
         <a name="{@label}">&#xA0;</a>
         <xsl:choose>
	         <xsl:when test="name(..)='CHAPITRE'">
	         <xsl:if test="name(following-sibling::*[1]) != 'PARTIE'">
		         <h1 class="titre-chapitre">
		            <xsl:value-of select="@titre" />
		         </h1>
		     </xsl:if> 
	         </xsl:when>
	         <xsl:when test="name(..)='PARTIE'">
		         <xsl:if test="name(following-sibling::*[1]) != 'SOUSPARTIE'">
			         <h1 class="titre-sschapitre">
			            <xsl:value-of select="@titre" />
			         </h1>
			     </xsl:if> 
	         </xsl:when>
	         <xsl:when test="name(..)='SOUSPARTIE'">
		         <h1 class="titre-partie">
		            <xsl:value-of select="@titre" />
		         </h1>
	         </xsl:when>
         </xsl:choose>
      </div>
    </xsl:if>
   </xsl:template>

   <xsl:template match="CHAPITRE" mode="unique">
      <div class="titre-section">
         <a name="{@label}">&#xA0;</a>
         <h1 class="titre-chapitre">
            <xsl:value-of select="@titre" />
         </h1>
      </div>
   </xsl:template>

   <xsl:template match="PARTIE" mode="unique">
      <div class="titre-section">
         <a name="{@label}">&#xA0;</a>
         <h2 class="titre-sschapitre">
            <xsl:value-of select="@titre" />
         </h2>
      </div>
   </xsl:template>

   <xsl:template match="SOUSPARTIE" mode="unique">
      <div class="titre-section">
         <a name="{@label}">&#xA0;</a>
         <h3 class="titre-partie">
            <xsl:value-of select="@titre" />
         </h3>
      </div>
   </xsl:template>
   
   <!--GESTION DES LISTES-->
   <xsl:template match="LISTE" mode="unique">
      <h4><xsl:value-of select="@titre" /></h4>
          <xsl:choose>
              <xsl:when test="@type = 'puces'">
                  <ul><xsl:apply-templates select="ITEM" mode="unique"/></ul>
              </xsl:when>
              <xsl:otherwise>
                  <ol><xsl:apply-templates select="ITEM" mode="unique"/></ol>
              </xsl:otherwise>
          </xsl:choose>
   </xsl:template>
   
      <xsl:template match="LISTE" >
          <h6><xsl:value-of select="@titre" /></h6>
          <xsl:choose>
             <xsl:when test="@type = 'puces'">
                <ul><xsl:apply-templates select="ITEM" mode="unique"/></ul>
             </xsl:when>
             <xsl:otherwise>
                <ol><xsl:apply-templates select="ITEM" mode="unique"/></ol>
              </xsl:otherwise>
            </xsl:choose>
   </xsl:template>
   
   <xsl:template match="ITEM" mode="unique">
        <LI><xsl:apply-templates /></LI>
   </xsl:template>
   
   <!--GESTION DES TABLES-->
    <xsl:template match="ZONETABLE" mode="unique">
        <span align="center"><b><xsl:value-of select="@titre" /></b></span>
    </xsl:template>
    
    <xsl:template match="TABLE" mode="unique">
        <table border="1" cellspacing="0" cellpadding="2" >
           <xsl:apply-templates select="TR" mode="unique" />
        </table>
    </xsl:template>

    <xsl:template match="TR" mode="unique"> 
        <tr>   
        <xsl:apply-templates select="TH" mode="unique" />
        <xsl:apply-templates select="TD" mode="unique" />
        </tr>
    </xsl:template>
        
    <xsl:template match="TH" mode="unique">    
      <th>
          <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
          <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
          <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
          <xsl:apply-templates />
      </th>
    </xsl:template>
        
    <xsl:template match="TD" mode="unique">
      <td>
          <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
          <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
          <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
          <xsl:apply-templates />
      </td>
    </xsl:template>
    
<!-- ************************************************ -->
<!-- Traitement des medias -->
<!-- ************************************************ -->    
    <xsl:template match="MEDIA" mode="unique">
      <div class="bloc-media">
        <xsl:if test="@titre">
                <h2><xsl:value-of select="@titre"/></h2>
        </xsl:if>
		<div class="content">
        <xsl:choose>
            <xsl:when test="./FICHIER/@format='gif' or ./FICHIER/@format='jpeg' or ./FICHIER/@format='png'">
              <img src="{./FICHIER/@chemin}">
                 <xsl:if test="./TAILLE/@largeur and not(./TAILLE/@largeur='')">
                    <xsl:attribute name="width">
                    <xsl:value-of select="./TAILLE/@largeur"/>
                    </xsl:attribute>
                 </xsl:if>
                 <xsl:if test="./TAILLE/@hauteur and not(./TAILLE/@hauteur='')">
                    <xsl:attribute name="height">
                    <xsl:value-of select="./TAILLE/@hauteur"/>
                    </xsl:attribute>
                 </xsl:if>
              </img>
            </xsl:when>
            <xsl:when test="./FICHIER/@format='mpeg'">
            <embed src="{./FICHIER/@chemin}" type="video/mpg" width="{./TAILLE/@largeur}" 
                 height="{./TAILLE/@hauteur}">
                <xsl:for-each select="./PARAMETRES/PARAMETRE">
                    <param name="@nom" value="@valeur" />
                </xsl:for-each>
            </embed>
            <noembed>
            Il faut un lecteur de vido lisant le format mpeg pour afficher cette squence.
              </noembed>     
            </xsl:when>
            <xsl:when test="./FICHIER/@format='java'">
                <xsl:variable name="class" select="./PARAMETRES/PARAMETRE[@nom='classe']/@valeur" />
                <xsl:variable name="archive" select="./PARAMETRES/PARAMETRE[@nom='archive']/@valeur" />
                <xsl:variable name="codebase" select="./PARAMETRES/PARAMETRE[@nom='codebase']/@valeur" />
                <object classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" 
                        width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}">
                    <param name="archive" value="{$archive}" />
                    <param name="codebase" value="{$codebase}" />
                    <param name="code" value="{$class}" />
                    <xsl:comment><![CDATA[[if gte IE 7]> <!]]></xsl:comment>
                    <object classid="java:{$class}"
                            codebase="{$codebase}"
                            type="application/x-java-applet"
                            archive="{$archive}"
                            width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}">
                        <!-- Konqueror browser needs the following param -->
                        <param name="archive" value="{$archive}" />
                        <param name="code" value="{$class}" />
                        <!-- Safari browser needs the following param -->
                        <param name="JAVA_CODEBASE" value="{$codebase}" />
                        alt : <a href="{$codebase}/{$archive}"><xsl:value-of select="$archive"/></a>
                    </object>
                    <xsl:comment><![CDATA[<![endif]-->
                    <!--[if lt IE 7]>
                    alt : <a href="{$codebase}/{$archive}"><xsl:value-of select="$archive"/></a>
                    <![endif]]]></xsl:comment>
                </object> 
            </xsl:when>
            <xsl:when test="./FICHIER/@format='flash'">
                <object codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,24,0" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}" title="{@titre}">
                    <param name="movie" value="{./FICHIER/@chemin}"/>
                    <xsl:variable name="parametres"><xsl:call-template name="getParametres"/></xsl:variable>
                     <param name="flashvars" value="{$parametres}" />
                    <xsl:choose>
                        <xsl:when test="$parametres">
                                <embed src="{./FICHIER/@chemin}?{$parametres}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}"></embed>
                        </xsl:when>
                        <xsl:otherwise>
                                <embed src="{./FICHIER/@chemin}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}"></embed>
                        </xsl:otherwise>
                    </xsl:choose>        
                </object>
            </xsl:when>
        </xsl:choose>
        </div>
        <!-- LEGENDE et CREDITS -->
        <xsl:if test="./CREDITS">
               <xsl:apply-templates select="./CREDITS"  mode="media"/>
        </xsl:if>
        <xsl:if test="./LEGENDE">
               <xsl:apply-templates select="./LEGENDE"  mode="media"/>
        </xsl:if>
      </div>
    </xsl:template>       
    <xsl:template name="getParametres">
        <xsl:for-each select="./PARAMETRES/PARAMETRE">
           <xsl:value-of select="concat(@nom,'=',@valeur,'&#38;')" />
        </xsl:for-each>
    </xsl:template>

   <xsl:template match="LEGENDE" mode="media">
      <div class="bloc-legende">
         <h6>Lgende</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>

   <xsl:template match="CREDITS" mode="media">
      <div class="bloc-credits">
         <h6>Crdits</h6>
         <div class="content">
            <xsl:apply-templates />
         </div>
      </div>
   </xsl:template>
   
    <xsl:template match="LEGENDE">
      <p class="legende">
        <xsl:apply-templates />
      </p>
    </xsl:template>
    
    <xsl:template match="CREDITS">
      <p class="credits">
        <xsl:apply-templates />
      </p>
    </xsl:template>

    <xsl:template match="MEDIA">
      <div class="bloc-media">
        <xsl:if test="@titre">
                <h2><xsl:value-of select="@titre"/></h2>
        </xsl:if>
        <div class="content">
        <xsl:choose>
            <xsl:when test="./FICHIER/@format='gif' or ./FICHIER/@format='jpeg' or ./FICHIER/@format='png'">
              <img src="{./FICHIER/@chemin}" width="{./TAILLE/@largeur}"  height="{./TAILLE/@hauteur}"/>
            </xsl:when>
            <xsl:when test="./FICHIER/@format='mpeg'">
            <embed src="{./FICHIER/@chemin}" type="video/mpg" width="{./TAILLE/@largeur}" 
                 height="{./TAILLE/@hauteur}">
                <xsl:for-each select="./PARAMETRES/PARAMETRE">
                    <param name="@nom" value="@valeur" />
                </xsl:for-each>
            </embed>
            <noembed>
            Il faut un lecteur de vido lisant le format mpeg pour afficher cette squence.
              </noembed>     
            </xsl:when>
            <xsl:when test="./FICHIER/@format='java'">
                <xsl:variable name="class" select="./PARAMETRES/PARAMETRE[@nom='classe']/@valeur" />
                <xsl:variable name="archive" select="./PARAMETRES/PARAMETRE[@nom='archive']/@valeur" />
                <xsl:variable name="codebase" select="./PARAMETRES/PARAMETRE[@nom='codebase']/@valeur" />
                <object classid="clsid:8AD9C840-044E-11D1-B3E9-00805F499D93" 
                        width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}">
                    <param name="archive" value="{$archive}" />
                    <param name="codebase" value="{$codebase}" />
                    <param name="code" value="{$class}" />
                    <xsl:comment><![CDATA[[if gte IE 7]> <!]]></xsl:comment>
                    <object classid="java:{$class}"
                            codebase="{$codebase}"
                            type="application/x-java-applet"
                            archive="{$archive}"
                            width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}">
                        <!-- Konqueror browser needs the following param -->
                        <param name="archive" value="{$archive}" />
                        <param name="code" value="{$class}" />
                        <!-- Safari browser needs the following param -->
                        <param name="JAVA_CODEBASE" value="{$codebase}" />
                        alt : <a href="{$codebase}/{$archive}"><xsl:value-of select="$archive"/></a>
                    </object>
                    <xsl:comment><![CDATA[<![endif]-->
                    <!--[if lt IE 7]>
                    alt : <a href="{$codebase}/{$archive}"><xsl:value-of select="$archive"/></a>
                    <![endif]]]></xsl:comment>
                </object> 
            </xsl:when>
            <xsl:when test="./FICHIER/@format='flash'">
                <object codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,24,0" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}" title="{@titre}">
                    <param name="movie" value="{./FICHIER/@chemin}"/>
                    <xsl:variable name="parametres"><xsl:call-template name="getParametres"/></xsl:variable>
                     <param name="flashvars" value="{$parametres}" />
                    <xsl:choose>
                        <xsl:when test="$parametres">
                                <embed src="{./FICHIER/@chemin}?{$parametres}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}"></embed>
                        </xsl:when>
                        <xsl:otherwise>
                                <embed src="{./FICHIER/@chemin}" quality="high" pluginspage="http://www.macromedia.com/go/getflashplayer" type="application/x-shockwave-flash" width="{./TAILLE/@largeur}" height="{./TAILLE/@hauteur}"></embed>
                        </xsl:otherwise>
                    </xsl:choose>        
                </object>
            </xsl:when>
        </xsl:choose>
        </div>        
        <!-- LEGENDE et CREDITS -->
        <xsl:if test="./CREDITS">
               <xsl:apply-templates select="./CREDITS"  mode="media"/>
        </xsl:if>
        <xsl:if test="./LEGENDE">
               <xsl:apply-templates select="./LEGENDE"  mode="media"/>
        </xsl:if>
      </div>
    </xsl:template>   

<!-- ************************************************ -->
<!-- Traitement d'un bloc texte -->
<!--        
        <xs:element ref="LIEN"/>
        <xs:element ref="ALT"/>
        <xs:element ref="LIENWEB"/>
        <xs:element ref="LIENDOCUMENT"/>
        <xs:element ref="EQUAJAXE"/>
        <xs:element ref="EQUATEX"/>
        <xs:element ref="MOTDUGLOSSAIRE"/>
        <xs:element ref="REFERENCEBIBLIOGRAPHIQUE"/>
        <xs:element ref="REFERENCEWEBOGRAPHIQUE"/>
        <xs:group ref="styletexte"/>
    -->
<!-- ************************************************ -->
   <xsl:key name="biblio" match="REFERENCEBIBLIOGRAPHIQUE" use="@labelReference"/>
   <xsl:key name="webo" match="REFERENCEWEBOGRAPHIQUE" use="@labelAdress"/>
    
    <xsl:template match="LIENWEB">
      <a href="{./@url}" title="{.}" target="_blank">
         <xsl:choose>
		     <xsl:when test="FICHIER">
                  <img src="{./FICHIER/@chemin}" />
             </xsl:when>
             <xsl:otherwise>
                 <xsl:value-of select="." />
             </xsl:otherwise>
         </xsl:choose>
      </a>
    </xsl:template>

	<xsl:template match="LIENDOCUMENT">
      <a href="{./@url}" title="{.}" target="_blank">
         <xsl:choose>
		     <xsl:when test="FICHIER">
                  <img src="{./FICHIER/@chemin}" />
             </xsl:when>
             <xsl:otherwise>
                 <xsl:value-of select="." />
             </xsl:otherwise>
         </xsl:choose>
      </a>
    </xsl:template>

    <xsl:template match="MOTDUGLOSSAIRE">
      <a href="#" title="{.}" onclick="return false" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
         <xsl:value-of select="./@mot" />
      </a>
    </xsl:template>
   
    <xsl:template match="LIENMOTDUGLOSSAIRE">      
      <a href="#" title="{.}" onclick="return false" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
         <xsl:value-of select="./@mot" />
      </a>
    </xsl:template>   

    <xsl:template match="REFERENCEBIBLIOGRAPHIQUE">
      <xsl:variable name="desc" select="normalize-space(./OUVRAGE)"/>
      <a href="#" title="{$desc}" onclick="return false" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id(.)}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="../medias/navigation/cours/reference.png" alt="{$desc}" /></a>
    </xsl:template>
   
    <xsl:template match="LIENREFERENCEBIBLIOGRAPHIQUE">
             <xsl:variable name="ref" select="@labelReference" />
             <xsl:variable name="idRefLien" select="generate-id(.)" />
             <xsl:for-each select="//REFERENCEBIBLIOGRAPHIQUE">
             <xsl:variable name="idRef" select="generate-id(key('biblio',$ref)[1])"/> 
             <xsl:if test="generate-id(.)=$idRef">
             <xsl:variable name="desc" select="normalize-space(./OUVRAGE)"/>
                 <a href="#" title="{$desc}" onclick="return false" onmouseover="CIRM.utils.ToolTip.show('tip-l{$idRefLien}', event)" onmouseout="CIRM.utils.ToolTip.hide()">
                     <img src="../medias/navigation/cours/reference.png" alt="{$desc}" />
                  </a>
             </xsl:if> 
             </xsl:for-each>
             
    </xsl:template>

    <xsl:template match="REFERENCEWEBOGRAPHIQUE">
      <xsl:variable name="desc" select="normalize-space(./DESCRIPTION)"/>
      <a href="{./@URL}" title="{$desc}" target="_blank" onmouseover="CIRM.utils.ToolTip.show('tip-{generate-id()}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="../medias/navigation/cours/internet.png" alt="{$desc}"/></a>
    </xsl:template>
   
    <xsl:template match="LIENREFERENCEWEBOGRAPHIQUE">
             <xsl:variable name="ref" select="@labelReference" />
             <xsl:variable name="idRefLien" select="generate-id(.)" />
		     <xsl:for-each select="//REFERENCEWEBOGRAPHIQUE">
                 <xsl:variable name="idRef" select="generate-id(key('webo',$ref)[1])" /> 
                 <xsl:if test="generate-id()=$idRef">
                 <xsl:variable name="desc" select="normalize-space(./DESCRIPTION)"/> 
                 <a href="{./@URL}" title="{$desc}" target="_blank" onmouseover="CIRM.utils.ToolTip.show('tip-l{$idRefLien}', event)" onmouseout="CIRM.utils.ToolTip.hide()"><img src="../medias/navigation/cours/internet.png" alt="{$desc}" /></a>
                  </xsl:if>
             </xsl:for-each>
    </xsl:template>
   
    <xsl:template match="EQUAJAXE">
        <img class="jaxe" src="{./@image}" alt="{./@texte}" longdesc="{./@texte}" />
    </xsl:template>
    
    <xsl:template match="EQUATEX">
        <img class="equatex" src="{./@image}" alt="{./@texte}" longdesc="{./@texte}" />
    </xsl:template>
    
    <xsl:template match="ALT">
		<a href="javascript:CIRM.utils.Window.openCenterWindow('{./@label}.html',800,600,'{./@label}')">
			<xsl:choose>
				<xsl:when test="FICHIER">
					<img src="{./FICHIER/@chemin}" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="ALTSURMOT" />
				</xsl:otherwise>
			</xsl:choose>
		</a>
    </xsl:template>

<!-- ************************************************ -->
<!-- Traitement particulier div hors content          -->
<!-- ************************************************ -->
   <xsl:key name="mots" match="MOTDUGLOSSAIRE" use="@mot"/>
    
   <xsl:template match="MOTDUGLOSSAIRE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
            <h6><xsl:value-of select="'Dfinition'" /></h6>
            <p><xsl:apply-templates /></p>
        </div>
   </xsl:template>  
  
   <xsl:template match="LIENMOTDUGLOSSAIRE" mode="div">
        <div id="tip-{generate-id(.)}" class="tooltip">
             <h6><xsl:value-of select="'Dfinition'" /></h6>
             <xsl:variable name="ref" select="@labelReference" />
             <xsl:for-each select="//MOTDUGLOSSAIRE">
             <xsl:variable name="idRef" select="generate-id(key('mots',$ref)[1])"/> 
             <xsl:if test="generate-id(.)=$idRef">
                 <p><xsl:apply-templates /></p>
             </xsl:if>    
             </xsl:for-each>
        </div>
   </xsl:template> 

   <xsl:template match="REFERENCEBIBLIOGRAPHIQUE" mode="div">
           <div id="tip-{generate-id(.)}" class="tooltip">
             <h6><xsl:value-of select="'Rfrence bibliographique'" /></h6>
             <p>
               <b><xsl:value-of select="@nomAuteur" /></b> - <xsl:value-of select="OUVRAGE" />
             </p>
        </div>
   </xsl:template>
  
   <xsl:template match="LIENREFERENCEBIBLIOGRAPHIQUE" mode="div">
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
             
           <xsl:for-each select="//REFERENCEBIBLIOGRAPHIQUE">
             <xsl:variable name="idRef" select="generate-id(key('biblio',$ref)[1])"/> 
             <xsl:if test="generate-id(.)=$idRef">
             <div id="tip-l{$idRefLien}" class="tooltip">
               <h6><xsl:value-of select="'Rfrence bibliographique'" /></h6>
               <p>
                 <b><xsl:value-of select="@nomAuteur" /></b> - <xsl:value-of select="OUVRAGE" />
               </p>
              </div>
             </xsl:if> 
        </xsl:for-each>        
        
   </xsl:template> 
   
   <xsl:template match="REFERENCEWEBOGRAPHIQUE" mode="div">
          <div id="tip-{generate-id(.)}" class="tooltip">
             <h6><xsl:value-of select="'Rfrence webographique'" /></h6>
             <p><xsl:value-of select="DESCRIPTION" /></p>
        </div>
   </xsl:template>
   
   <xsl:template match="LIENREFERENCEWEBOGRAPHIQUE" mode="div">
        <xsl:variable name="ref" select="@labelReference" />
        <xsl:variable name="idRefLien" select="generate-id(.)" />
             
           <xsl:for-each select="//REFERENCEWEBOGRAPHIQUE">
             <xsl:variable name="idRef" select="generate-id(key('webo',$ref)[1])"/> 
             <xsl:if test="generate-id(.)=$idRef">
             <div id="tip-l{$idRefLien}" class="tooltip">
                <h6><xsl:value-of select="'Rfrence webographique'" /></h6>
                <p><xsl:value-of select="DESCRIPTION" /></p>
             </div>
             </xsl:if>
        </xsl:for-each>        
        
   </xsl:template>

</xsl:stylesheet>

