<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!-- ************************************************ -->
    <!-- creation du glossaire les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->

 
    <xsl:template name="UVED_GLOSSAIRE">
    <xsl:variable name="alphabetcomplet">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>

        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'glossaire.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource" />
                    <body>
                        <xsl:call-template name="bodyheaderRessource" />
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-section">
                                <h3>Ressources</h3>
                                <h4>Glossaire</h4>
                            </div>
    
                            <!-- creation de la liste des ressources accessibles -->
                            <xsl:call-template name="glossaireSelectressources" />
    
                            <!-- creation des lien vers les ancres-->
                            <div class="navigation">
                                <xsl:call-template name="glossaireLigneancres">
                                    <xsl:with-param name="alphabet"
                                        select="$alphabetcomplet" />
                                </xsl:call-template>
                            </div>
    
                            <!-- affichage des mots du glossaire-->
                            <xsl:call-template name="ligneglossaire">
                                <xsl:with-param name="alphabet"
                                    select="$alphabetcomplet" />
                            </xsl:call-template>
    
                        </div>
                    <xsl:call-template name="footerRessource">
                        <xsl:with-param name="pageActive">glossaire</xsl:with-param>
                    </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>


    <!-- creation des liens vers les ancres-->
    <xsl:template name="glossaireLigneancres">
        <xsl:param name="alphabet" />

        <xsl:variable name="unelettre" select="substring($alphabet,1,1)" />
        <xsl:variable name="suitealphabet" select="substring-after($alphabet, $unelettre)" />

        <!-- creation des liens vers les ancres-->
        <xsl:call-template name="lienancres">
            <xsl:with-param name="majuscule" select="$unelettre" />
        </xsl:call-template>

        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="glossaireLigneancres">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation d'un lien vers les ancres-->
    <!-- ************************************************ -->
    <xsl:template name="lienancres">
        <xsl:param name="majuscule" />
        <xsl:if
            test="count(UVED//MOTDUGLOSSAIRE[translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$majuscule])>0">
            <a href="#{$majuscule}">
                <xsl:value-of select="$majuscule" />
            </a>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation des ancres et insertion des mots-->
    <!-- ************************************************ -->
    <xsl:template name="ligneglossaire">
        <xsl:param name="alphabet" />

        <xsl:variable name="unelettre"
            select="substring($alphabet,1,1)" />
        <xsl:variable name="suitealphabet"
            select="substring-after($alphabet, $unelettre)" />



        <xsl:if
            test="count(UVED//MOTDUGLOSSAIRE[translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre])>0">
            <h4 class="lettre">
                <a name="{$unelettre}">
                    <xsl:value-of select="$unelettre" />
                </a>
            </h4>
        </xsl:if>


        <xsl:for-each
            select="UVED//MOTDUGLOSSAIRE[translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre]">
            <xsl:sort order="ascending" select="@mot" />
            <xsl:if test="not(preceding::MOTDUGLOSSAIRE/.=.)">
                <xsl:if test=".!=''">
                    <div class="bloc-definition">
                        <h5>
                            <xsl:value-of select="@mot" />
                        </h5>
                        <p>
                            <xsl:value-of select="." />
                        </p>
                    </div>
                </xsl:if>
            </xsl:if>
        </xsl:for-each>

        <xsl:if
            test="count(UVED//MOTDUGLOSSAIRE[translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre])>0">
            <div class="haut-page">
                <a href="#top">
                    <span>haut de page</span>
                </a>
            </div>
        </xsl:if>
        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="ligneglossaire">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>


    <!-- ************************************************ -->
    <!-- creation liste des ressources-->
    <!-- ************************************************ -->
    <xsl:template name="glossaireSelectressources">
        <div class="selection">
            <fieldset>
                <form action="">
                    <select
                        onchange="location=this.options[this.selectedIndex].value;">
                        <option>Voir une autre ressource...</option>

                        <xsl:if
                            test="count(UVED//REFERENCEBIBLIOGRAPHIQUE)>0">
                            <option value="bibliographie.html">
                                - Bibliographie
                            </option>
                        </xsl:if>

                        <xsl:if
                            test="count(UVED//REFERENCEWEBOGRAPHIQUE)>0">
                            <option value="webographie.html">
                                - Webographie
                            </option>
                        </xsl:if>
                    </select>
                </form>
            </fieldset>
        </div>
    </xsl:template>

</xsl:stylesheet>
