<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet
version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:uved="http://www.uved.fr/schema/2.0"
xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
xmlns:lomfr="http://www.lom-fr.fr/xsd/LOMFR"
xmlns:interunt="http://www2.educnet.education.fr/sections/superieur/unt/inter/chaine-editoria"
exclude-result-prefixes="uved">

<xsl:param name="traitementRecursif" select="'true'"/>

<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>



<!--########################--> 
<!--## mtadonnes - lom  ##-->
<!--########################-->

<xsl:template match="uved:METADONNEES">
    <interunt:metadonnees>
        <interunt:schemaOrigine>
            <interunt:nom>UVED</interunt:nom>
            <interunt:version>2.0</interunt:version>
            <interunt:espaceNom>http://www.uved.fr/schema/2.0</interunt:espaceNom>
        </interunt:schemaOrigine>
        <lom:lom>
            <lom:general uniqueElementName="general">
                <lom:title uniqueElementName="title">
                    <lom:string language="{uved:LANGUE}">
                        <xsl:value-of select="following-sibling::*/@titre"/>
                    </lom:string>
                </lom:title>
                <xsl:for-each select=".">
                    <xsl:apply-templates select="uved:LANGUE"/>
                    <xsl:apply-templates select="uved:MOTSCLE"/>
                </xsl:for-each>
            </lom:general>
<!--            <lom:relation>
                <lom:kind uniqueElementName="kind">
                    <lom:source uniqueElementName="source">LOMv1.0</lom:source>
                    <lom:value uniqueElementName="value">isformatof</lom:value>
                </lom:kind>
            </lom:relation>
-->
            <xsl:if test="uved:NIVEAULMD">
                <lom:educational>
                    <xsl:apply-templates select="uved:NIVEAULMD"/>
                </lom:educational>
            </xsl:if>
            <lom:lifeCycle uniqueElementName="lifeCycle">
                <xsl:for-each select=".">
                    <xsl:apply-templates select="uved:DATECRE"/>
                    <xsl:apply-templates select="uved:DATEMAJ"/>
                    <xsl:apply-templates select="uved:AUTEURS"/>
                    <xsl:apply-templates select="uved:VERSION"/>
                    <xsl:apply-templates select="uved:ETAT"/>
                </xsl:for-each>
            </lom:lifeCycle>
            <lom:metaMetadata uniqueElementName="metaMetadata">
                <lom:metadataSchema>LOMFRv1.0</lom:metadataSchema>
            </lom:metaMetadata>
            <xsl:if test="uved:LOCALISATION">
                <lom:technical uniqueElementName="technical">
                    <xsl:apply-templates select="uved:LOCALISATION"/>
                </lom:technical>
            </xsl:if>
        </lom:lom>
    </interunt:metadonnees>
</xsl:template>

<xsl:template match="uved:LANGUE">
    <lom:language>
        <xsl:apply-templates/>
    </lom:language>
</xsl:template>

<xsl:template match="uved:NIVEAULMD">
    <lom:context>
        <lom:source uniqueElementName="source">LOMFRv1.0</lom:source>
        <lom:value uniqueElementName="value">
            <xsl:variable name="niveau" select="."/>
            <xsl:choose>
                <xsl:when test="$niveau='L'">licence</xsl:when>
                <xsl:when test="$niveau='M'">mastere</xsl:when>
                <xsl:when test="$niveau='D'">doctorat</xsl:when>
                <xsl:otherwise>autres</xsl:otherwise>
            </xsl:choose>
        </lom:value>
    </lom:context>
</xsl:template>

<xsl:template match="uved:LOCALISATION">
      <lom:location><xsl:value-of select="."/></lom:location>
</xsl:template>

<xsl:template match="uved:MOTSCLE">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="uved:MOTCLE">
    <lom:keyword>
        <lom:string language="{../../uved:LANGUE}"><xsl:apply-templates/></lom:string>
    </lom:keyword>
</xsl:template>

<xsl:template match="uved:DATECRE">
    <xsl:variable name="anne" select="substring-after(substring-after(.,'/'),'/')"/>
    <xsl:variable name="mois" select="substring-before(substring-after(.,'/'),'/')"/>
    <xsl:variable name="mois-format"><xsl:choose>
        <xsl:when test="string-length($mois)=1"><xsl:value-of select="concat('0',$mois)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$mois"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <xsl:variable name="jour" select="substring-before(.,'/')"/>
    <xsl:variable name="jour-format"><xsl:choose>
        <xsl:when test="string-length($jour)=1"><xsl:value-of select="concat('0',$jour)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$jour"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <lom:contribute>
        <lom:entity>Date de cration</lom:entity>
        <lom:date uniqueElementName="date">
            <lom:dateTime uniqueElementName="dateTime"><xsl:value-of select="concat($anne,'-',$mois-format,'-',$jour-format)"/>
            </lom:dateTime>
        </lom:date>
    </lom:contribute>
</xsl:template>

<xsl:template match="uved:DATEMAJ">
    <xsl:variable name="anne" select="substring-after(substring-after(.,'/'),'/')"/>
    <xsl:variable name="mois" select="substring-before(substring-after(.,'/'),'/')"/>
    <xsl:variable name="mois-format"><xsl:choose>
        <xsl:when test="string-length($mois)=1"><xsl:value-of select="concat('0',$mois)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$mois"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <xsl:variable name="jour" select="substring-before(.,'/')"/>
    <xsl:variable name="jour-format"><xsl:choose>
        <xsl:when test="string-length($jour)=1"><xsl:value-of select="concat('0',$jour)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="$jour"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    <lom:contribute>
        <lom:entity>Date de mise  jour</lom:entity>
        <lom:date uniqueElementName="date">
            <lom:dateTime uniqueElementName="dateTime"><xsl:value-of select="concat($anne,'-',$mois-format,'-',$jour-format)"/>
            </lom:dateTime>
        </lom:date>
    </lom:contribute>
</xsl:template>

<xsl:template match="uved:AUTEURS">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="uved:AUTEUR">
    <lom:contribute>
        <lom:role uniqueElementName="role">
            <lom:source uniqueElementName="source">LOMv1.0</lom:source>
            <lom:value uniqueElementName="value">author</lom:value>
        </lom:role>
        <lom:entity>
            BEGIN:VCARD
            VERSION:3.0
            N:<xsl:value-of select="@nom"/>;<xsl:value-of select="@prenom"/>
            FN:<xsl:value-of select="concat(@prenom,' ')"/><xsl:value-of select="@nom"/>
            ROLE:<xsl:value-of select="@fonction"/>
            ORG:<xsl:value-of select="@organisme"/>
            END:VCARD
        </lom:entity>
    </lom:contribute>
</xsl:template>

<xsl:template match="uved:VERSION">
    <lom:version uniqueElementName="version">
        <lom:string language="{../uved:LANGUE}"><xsl:apply-templates/></lom:string>
    </lom:version>
</xsl:template>

<xsl:template match="uved:ETAT">
    <lom:status uniqueElementName="status">
        <xsl:choose>
            <xsl:when test=".='document de travail'">
                <lom:value uniqueElementName="value">draft</lom:value>
            </xsl:when>
            <xsl:when test=".='final'">
                <lom:value uniqueElementName="value">final</lom:value>
            </xsl:when>
            <xsl:when test=".='rvis'">
                <lom:value uniqueElementName="value">revised</lom:value>
            </xsl:when>
            <xsl:otherwise>
                <lom:value uniqueElementName="value">unavailable</lom:value>
            </xsl:otherwise>
        </xsl:choose>
    </lom:status>
</xsl:template>

<!--###########################-->
<!--## fin mtadonnes - lom ##-->
<!--###########################-->


<xsl:template match="uved:UVED">
    <interunt:docInterUnt>
        <xsl:apply-templates select="uved:CONTENUS | uved:SECTION" mode="sans-balises"/>
        <!--xsl:apply-templates select="uved:SECTION" mode="sans-balises"/-->
    </interunt:docInterUnt>
</xsl:template>

<xsl:template match="uved:MEDIA">
    <xsl:choose>
        <xsl:when test="parent::uved:GRAIN">
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <xsl:if test="@titre!=''">
                    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                </xsl:if>
                <interunt:media>
                    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                    <interunt:typeMIME>
                        <xsl:call-template name="formatfichier"><xsl:with-param name="nom" select="./uved:FICHIER/@chemin"/></xsl:call-template>
                    </interunt:typeMIME>
                    <interunt:titre><xsl:value-of select="titre"/></interunt:titre>
                    <xsl:apply-templates select="uved:FICHIER"/>
                    <xsl:apply-templates select="uved:CREDITS"/>
                    <xsl:apply-templates select="uved:LEGENDE"/>
                    <xsl:apply-templates select="uved:PARAMETRES"/>
                    <xsl:apply-templates select="uved:TAILLE"/>
                </interunt:media>
            </interunt:blocExpositif>
        </xsl:when>
        <xsl:otherwise>
            <interunt:media>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:typeMIME>
                    <xsl:call-template name="formatfichier"><xsl:with-param name="nom" select="./uved:FICHIER/@chemin"/></xsl:call-template>
                </interunt:typeMIME>
                <interunt:titre><xsl:value-of select="titre"/></interunt:titre>
                <xsl:apply-templates select="uved:FICHIER"/>
                <xsl:apply-templates select="uved:CREDITS"/>
                <xsl:apply-templates select="uved:LEGENDE"/>
                <xsl:apply-templates select="uved:PARAMETRES"/>
                <xsl:apply-templates select="uved:TAILLE"/>
            </interunt:media>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:REFSECTION">
    <xsl:choose>
        <xsl:when test="$traitementRecursif='true'">
            <xsl:variable name="labelsection" select="@label"/>
            <xsl:for-each select="document(concat($labelsection,'/',$labelsection,'.xml'), .)/uved:UVED">
                <xsl:apply-templates select="uved:SECTION[@label=$labelsection]"/>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <interunt:refDocInterUnt>
                <xsl:variable name="labelsection" select="@label"/>
                <interunt:fichier><xsl:value-of select="concat($labelsection,'/',$labelsection,'.xml')"/></interunt:fichier>
            </interunt:refDocInterUnt>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:PARAMETRES">
    <xsl:apply-templates select="uved:PARAMETRE"/>
</xsl:template>

<!-- perte des lments 'NBSP' et 'BR' ainsi que le formatage du texte et des refrences de fichiers -->
<xsl:template match="uved:CREDITS">
    <interunt:credits>
        <xsl:value-of select="."/>
    </interunt:credits>
</xsl:template>

<!-- perte des attributs 'type' et 'label'-->
<xsl:template match="uved:LIEN">
    <interunt:refSection><interunt:label><xsl:apply-templates mode="sans_balises"/></interunt:label><interunt:refId><xsl:value-of select="concat(@type,'-',@label)"/></interunt:refId></interunt:refSection>
</xsl:template>

<xsl:template match="uved:SECTION">
    <interunt:section>
        <interunt:id><xsl:value-of select="concat('section-',@label)"/></interunt:id>
        <interunt:type>section</interunt:type>
        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
        <xsl:if test="preceding-sibling::uved:METADONNEES">
            <xsl:apply-templates select="preceding-sibling::uved:METADONNEES"/>
        </xsl:if>
        <xsl:apply-templates/>
        <xsl:if test="not(parent::uved:SECTION)">
            <xsl:if test=".//uved:REFERENCEWEBOGRAPHIQUE">
                <interunt:webographie>
                    <xsl:apply-templates select=".//uved:REFERENCEWEBOGRAPHIQUE" mode="webographie"/>
                </interunt:webographie>
            </xsl:if>
        </xsl:if>
        <xsl:if test="not(parent::uved:SECTION)">
            <xsl:if test=".//uved:REFERENCEBIBLIOGRAPHIQUE ">
                <interunt:bibliographie>
                    <xsl:apply-templates select=".//uved:REFERENCEBIBLIOGRAPHIQUE" mode="bibliographie"/>
                </interunt:bibliographie>
            </xsl:if>
        </xsl:if>
        <xsl:if test="not(parent::uved:SECTION)">
            <xsl:if test=".//uved:MOTDUGLOSSAIRE">
                <interunt:glossaire>
                    <xsl:apply-templates select=".//uved:MOTDUGLOSSAIRE" mode="glossaire"/>
                </interunt:glossaire>
            </xsl:if>
        </xsl:if>
    </interunt:section>
</xsl:template>

<xsl:template match="uved:SECTION" mode="sans-balises">
    <interunt:id><xsl:value-of select="concat('section-',@label)"/></interunt:id>
    <interunt:type>section</interunt:type>
    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
    <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
    <xsl:if test="preceding-sibling::uved:METADONNEES">
        <xsl:apply-templates select="preceding-sibling::uved:METADONNEES"/>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:if test="not(parent::uved:SECTION)">
        <xsl:if test=".//uved:REFERENCEBIBLIOGRAPHIQUE ">
            <interunt:bibliographie>
                <xsl:apply-templates select=".//uved:REFERENCEBIBLIOGRAPHIQUE" mode="bibliographie"/>
            </interunt:bibliographie>
        </xsl:if>
    </xsl:if>
    <xsl:if test="not(parent::uved:SECTION)">
        <xsl:if test=".//uved:REFERENCEWEBOGRAPHIQUE">
            <interunt:webographie>
                <xsl:apply-templates select=".//uved:REFERENCEWEBOGRAPHIQUE" mode="webographie"/>
            </interunt:webographie>
        </xsl:if>
    </xsl:if>
    <xsl:if test="not(parent::uved:SECTION)">
        <xsl:if test=".//uved:MOTDUGLOSSAIRE">
            <interunt:glossaire>
                <xsl:apply-templates select=".//uved:MOTDUGLOSSAIRE" mode="glossaire"/>
            </interunt:glossaire>
        </xsl:if>
    </xsl:if>
</xsl:template>

<xsl:template match="uved:GRAIN">
    <interunt:section>
        <interunt:id><xsl:value-of select="concat('grain-',@label)"/></interunt:id>
        <interunt:type>grain</interunt:type>
        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
        <interunt:contenu>
            <xsl:apply-templates/>
        </interunt:contenu>
    </interunt:section>
</xsl:template>

<xsl:template match="uved:PARAGRAPHE">
    <xsl:choose>
        <xsl:when test="parent::uved:GRAIN|parent::uved:PRESENTATION">
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:paragraphe>
                    <xsl:apply-templates/>
                </interunt:paragraphe>
            </interunt:blocExpositif>
        </xsl:when>
        <xsl:otherwise>
            <interunt:paragraphe>
                <xsl:apply-templates/>
            </interunt:paragraphe>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- perte de certains symboles -->
<xsl:template match="uved:SYMBOLE">
    <xsl:variable name="nomlettre" select="substring-after(substring-after(@nom, '/'), '/')"/>
    <xsl:variable name="nomsansext" select="substring-before($nomlettre,'.')"/>
    <xsl:choose>

        <!-- pour chaque symbole on donne l'quivalent sous forme de caractre UNICODE -->
        <xsl:when test="$nomsansext='Alpha'">&#x391;</xsl:when>
        <xsl:when test="$nomsansext='Beta'">&#x392;</xsl:when>
        <xsl:when test="$nomsansext='Gamma'">&#x393;</xsl:when>
        <xsl:when test="$nomsansext='Delta'">&#x394;</xsl:when>
        <xsl:when test="$nomsansext='Epsilon'">&#x395;</xsl:when>
        <xsl:when test="$nomsansext='Zeta'">&#x396;</xsl:when>
        <xsl:when test="$nomsansext='Eta'">&#x397;</xsl:when>
        <xsl:when test="$nomsansext='Theta'">&#x398;</xsl:when>
        <xsl:when test="$nomsansext='Iota'">&#x399;</xsl:when>
        <xsl:when test="$nomsansext='Kappa'">&#x39A;</xsl:when>
        <xsl:when test="$nomsansext='Lambda'">&#x39B;</xsl:when>
        <xsl:when test="$nomsansext='Mu'">&#x39C;</xsl:when>
        <xsl:when test="$nomsansext='Nu'">&#x39D;</xsl:when>
        <xsl:when test="$nomsansext='Xi'">&#x39E;</xsl:when>
        <xsl:when test="$nomsansext='Omicron'">&#x39F;</xsl:when>
        <xsl:when test="$nomsansext='Pi'">&#x3A0;</xsl:when>
        <xsl:when test="$nomsansext='Rho'">&#x3A1;</xsl:when>
        <xsl:when test="$nomsansext='Sigma'">&#x3A3;</xsl:when>
        <xsl:when test="$nomsansext='Tau'">&#x3A4;</xsl:when>
        <xsl:when test="$nomsansext='Upsilon'">&#x3A5;</xsl:when>
        <xsl:when test="$nomsansext='Phi'">&#x3A6;</xsl:when>
        <xsl:when test="$nomsansext='Chi'">&#x3A7;</xsl:when>
        <xsl:when test="$nomsansext='Psi'">&#x3A8;</xsl:when>
        <xsl:when test="$nomsansext='Omega'">&#x3A9;</xsl:when>
        <xsl:when test="$nomsansext='alpha'">&#x3B1;</xsl:when>
        <xsl:when test="$nomsansext='beta'">&#x3B2;</xsl:when>
        <xsl:when test="$nomsansext='gamma'">&#x3B3;</xsl:when>
        <xsl:when test="$nomsansext='delta'">&#x3B4;</xsl:when>
        <xsl:when test="$nomsansext='epsilon'">&#x3B5;</xsl:when>
        <xsl:when test="$nomsansext='zeta'">&#x3B6;</xsl:when>
        <xsl:when test="$nomsansext='eta'">&#x3B7;</xsl:when>
        <xsl:when test="$nomsansext='theta'">&#x3B8;</xsl:when>
        <xsl:when test="$nomsansext='iota'">&#x3B9;</xsl:when>
        <xsl:when test="$nomsansext='kappa'">&#x3BA;</xsl:when>
        <xsl:when test="$nomsansext='lambda'">&#x3BB;</xsl:when>
        <xsl:when test="$nomsansext='mu'">&#x3BC;</xsl:when>
        <xsl:when test="$nomsansext='nu'">&#x3BD;</xsl:when>
        <xsl:when test="$nomsansext='xi'">&#x3BE;</xsl:when>
        <xsl:when test="$nomsansext='omicron'">&#x3BF;</xsl:when>
        <xsl:when test="$nomsansext='pi'">&#x3C0;</xsl:when>
        <xsl:when test="$nomsansext='rho'">&#x3C1;</xsl:when>
        <!--<xsl:when test="$nomsansext='sigmaf'">&#x3C2;</xsl:when> pas toujours bien affich -->
        <xsl:when test="$nomsansext='sigma'">&#x3C3;</xsl:when>
        <xsl:when test="$nomsansext='tau'">&#x3C4;</xsl:when>
        <xsl:when test="$nomsansext='upsilon'">&#x3C5;</xsl:when>
        <!--<xsl:when test="$nomsansext='phi'">&#x3C6;</xsl:when> phi = unicode 03A6 != 03D5, invers dans Safari -->
        <xsl:when test="$nomsansext='chi'">&#x3C7;</xsl:when>
        <xsl:when test="$nomsansext='psi'">&#x3C8;</xsl:when>
        <xsl:when test="$nomsansext='omega'">&#x3C9;</xsl:when>
        <xsl:when test="$nomsansext='asymp'">&#x2248;</xsl:when>
        <xsl:when test="$nomsansext='cap'">&#x2229;</xsl:when>
        <xsl:when test="$nomsansext='cup'">&#x222A;</xsl:when>
        <xsl:when test="$nomsansext='exist'">&#x2203;</xsl:when>
        <xsl:when test="$nomsansext='forall'">&#x2200;</xsl:when>
        <xsl:when test="$nomsansext='ge'">&#x2265;</xsl:when>
        <xsl:when test="$nomsansext='harr'">&#x2194;</xsl:when>
        <xsl:when test="$nomsansext='hdarr'">&#x21D4;</xsl:when>
        <xsl:when test="$nomsansext='infin'">&#x221E;</xsl:when>
        <xsl:when test="$nomsansext='isin'">&#x2208;</xsl:when>
        <xsl:when test="$nomsansext='larr'">&#x2190;</xsl:when>
        <!--<xsl:when test="$nomsansext='thetasym'">&#x3D1;</xsl:when> pas toujours bien affich -->
        <!--<xsl:when test="$nomsansext='upsih'">&#x3D2;</xsl:when> pas toujours bien affich -->
        <!--<xsl:when test="$nomsansext='piv'">&#x3D6;</xsl:when> pas toujours bien affich -->
        <!-- ldarr = symbole HTML lArr ne s'affiche pas avec IE 6 -->
        <xsl:when test="$nomsansext='le'">&#x2264;</xsl:when>
        <xsl:when test="$nomsansext='nabla'">&#x2207;</xsl:when>
        <xsl:when test="$nomsansext='ne'">&#x2260;</xsl:when>
        <xsl:when test="$nomsansext='not'">&#xAC;</xsl:when>
        <xsl:when test="$nomsansext='part'">&#x2202;</xsl:when>
        <xsl:when test="$nomsansext='plusmn'">&#xB1;</xsl:when>
        <xsl:when test="$nomsansext='rarr'">&#x2192;</xsl:when>
        <xsl:when test="$nomsansext='rdarr'">&#x21D2;</xsl:when>
        <!-- sim ne s'affiche pas avec IE 6 -->
        <xsl:when test="$nomsansext='sub'">&#x2282;</xsl:when> 
        <xsl:otherwise>
            <xsl:message terminate="no">
                symbole non reconnu, attribut <xsl:value-of select="@nom"/>.
            </xsl:message>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:EQUAJAXE">
    <interunt:equation>
        <interunt:type>equajaxe</interunt:type>
        <interunt:media>
            <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
            <interunt:typeMIME>
                <xsl:call-template name="formatfichier"><xsl:with-param name="nom" select="@image"/></xsl:call-template>
            </interunt:typeMIME>
            <interunt:fichier><xsl:value-of select="@image"/></interunt:fichier>
        </interunt:media>
        <interunt:texte>
            <xsl:value-of select="@texte"/>
        </interunt:texte>
    </interunt:equation>
</xsl:template>

<xsl:template match="uved:EQUATEX">
    <interunt:equation>
        <interunt:type>equatex</interunt:type>
        <interunt:media>
            <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
            <interunt:typeMIME>
                <xsl:call-template name="formatfichier"><xsl:with-param name="nom" select="@image"/></xsl:call-template>
            </interunt:typeMIME>
            <interunt:fichier>
                <xsl:value-of select="@image"/>
            </interunt:fichier>
        </interunt:media>
        <interunt:texte>
            <xsl:value-of select="@texte"/>
        </interunt:texte>
    </interunt:equation>
</xsl:template>

<xsl:template match="uved:LISTE">
    <xsl:choose>
        <xsl:when test="parent::uved:GRAIN">
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:liste>
                    <interunt:type><xsl:value-of select="@type"/></interunt:type>
                    <xsl:if test="@titre!=''">
                        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                    </xsl:if>
                    <xsl:apply-templates/>
                </interunt:liste>
            </interunt:blocExpositif>
        </xsl:when>
        <xsl:when test="parent::uved:ITEM">
            <interunt:liste>
                <interunt:type><xsl:value-of select="@type"/></interunt:type>
                <xsl:if test="@titre!=''">
                    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                </xsl:if>
                <xsl:apply-templates/>
            </interunt:liste>
        </xsl:when>
        <xsl:otherwise>
            <interunt:liste>
                <interunt:type><xsl:value-of select="@type"/></interunt:type>
                <xsl:if test="@titre!=''">
                    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                </xsl:if>
                <xsl:apply-templates/>
            </interunt:liste>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:ITEM">
    <interunt:item>
    <xsl:choose>
        <xsl:when test="uved:PARAGRAPHE|uved:LISTE">
            <xsl:if test="(uved:PARAGRAPHE|uved:LISTE)[1]/preceding-sibling::node()">
                <interunt:paragraphe>
                    <xsl:apply-templates select="(uved:PARAGRAPHE|uved:LISTE)[1]/preceding-sibling::node()"/>
                </interunt:paragraphe>
            </xsl:if>
            <xsl:for-each select="*[self::uved:PARAGRAPHE|self::uved:LISTE]">
                <xsl:apply-templates select="."/>
                <xsl:choose >
                    <xsl:when test="following-sibling::*[self::uved:PARAGRAPHE|self::uved:LISTE]">
                        <xsl:variable name="suivant" select="generate-id(following-sibling::*[self::uved:PARAGRAPHE|self::uved:LISTE][1])"/>
                        <interunt:paragraphe>
                            <xsl:apply-templates select="following-sibling::node()[generate-id(following-sibling::*[self::uved:PARAGRAPHE|self::uved:LISTE][1])=$suivant]"/>
                        </interunt:paragraphe>
                    </xsl:when>
                    <xsl:when test="following-sibling::node()[normalize-space(.)!='']">
                        <interunt:paragraphe>
                            <xsl:apply-templates select="following-sibling::node()"/>
                        </interunt:paragraphe>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <interunt:paragraphe>
                <xsl:apply-templates/>
            </interunt:paragraphe>
        </xsl:otherwise>
    </xsl:choose>
    </interunt:item>
</xsl:template>

<xsl:template match="uved:ZONETABLE">
    <xsl:choose>
        <xsl:when test="parent::uved:GRAIN">
            <interunt:blocExpositif>
            <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:tableau>
                    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                        <xsl:if test="@titre!=''">
                            <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                        </xsl:if>
                    <xsl:apply-templates select="uved:LEGENDE"/>
                    <xsl:apply-templates select="uved:TABLE"/>
                </interunt:tableau>
            </interunt:blocExpositif>
        </xsl:when>
        <xsl:otherwise>
            <interunt:tableau>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <xsl:if test="@titre!=''">
                    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
                </xsl:if>
            <xsl:apply-templates select="uved:LEGENDE"/>
            <xsl:apply-templates select="uved:TABLE"/>
            </interunt:tableau>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:TABLE">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="uved:TR">
    <interunt:tr>
        <xsl:apply-templates/>
    </interunt:tr>
</xsl:template>

<xsl:template match="uved:TD">
    <interunt:td>
        <xsl:if test="@colspan"><interunt:colspan><xsl:value-of select="@colspan"/></interunt:colspan>
        </xsl:if>
        <xsl:if test="@rowspan"><interunt:rowspan><xsl:value-of select="@rowspan"/></interunt:rowspan>
        </xsl:if>
        <xsl:value-of select="."/>
    </interunt:td>
</xsl:template>

<xsl:template match="uved:TH">
    <interunt:th>
        <xsl:if test="@colspan"><interunt:colspan><xsl:value-of select="@colspan"/></interunt:colspan>
        </xsl:if>
        <xsl:if test="@rowspan"><interunt:rowspan><xsl:value-of select="@rowspan"/></interunt:rowspan>
        </xsl:if>
        <xsl:value-of select="."/>
    </interunt:th>
</xsl:template>

<xsl:template match="uved:DEFINITION">
    <xsl:call-template name="style-definition"><xsl:with-param name="nom" select="'definition'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:METHODE">
    <xsl:call-template name="style-definition"><xsl:with-param name="nom" select="'methode'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:RAPPEL">
    <xsl:call-template name="style-definition"><xsl:with-param name="nom" select="'rappel'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:ATTENTION">
    <xsl:call-template name="style-definition"><xsl:with-param name="nom" select="'attention'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:REMARQUE">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'remarque'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:EXEMPLE">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'exemple'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:COMPLEMENT">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'complement'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:ENSAVOIRPLUS">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'ensavoirplus'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:SYNTAXE">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'syntaxe'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:EXPLICATION">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'explication'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:CONFERE">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'confere'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:ACTIVITE">
    <xsl:call-template name="style-remarque"><xsl:with-param name="nom" select="'activite'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:CONSEIL">
    <xsl:choose>
        <xsl:when test="parent::uved:GRAIN|parent::uved:ANNEXE">
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:type>conseil</interunt:type>
                <xsl:apply-templates/>
            </interunt:blocExpositif>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:CITATION">
    <xsl:choose>
        <xsl:when test="parent::uved:SECTION">
            <interunt:contenu>
                <interunt:blocExpositif>
                    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                    <interunt:type>citation</interunt:type>
                    <xsl:apply-templates/>
                </interunt:blocExpositif>
            </interunt:contenu>
        </xsl:when>
        <xsl:otherwise>
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:type>citation</interunt:type>
                <xsl:apply-templates/>
            </interunt:blocExpositif>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="uved:INTRODUCTION">
    <xsl:call-template name="style-introduction"><xsl:with-param name="nom" select="'introduction'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:PREREQUIS">
    <xsl:call-template name="style-introduction"><xsl:with-param name="nom" select="'prerequis'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:OBJECTIFS">
    <xsl:call-template name="style-introduction"><xsl:with-param name="nom" select="'objectifs'"/></xsl:call-template>
</xsl:template>

<xsl:template match="uved:COMMENTAIRE">
    <interunt:blocInformation>
        <interunt:type>commentaire</interunt:type>
        <interunt:texte>
            <xsl:value-of select="."/>
        </interunt:texte>
    </interunt:blocInformation>
</xsl:template>

<xsl:template match="uved:CONTENUS">
    <interunt:section>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>contenus</interunt:type>
        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
        <xsl:if test="preceding-sibling::uved:METADONNEES">
            <xsl:apply-templates select="preceding-sibling::uved:METADONNEES"/>
        </xsl:if>
        <xsl:apply-templates/>
    </interunt:section>
</xsl:template>

<xsl:template match="uved:CONTENUS" mode="sans-balises">
    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
    <interunt:type>contenus</interunt:type>
    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
    <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
    <xsl:if test="preceding-sibling::uved:METADONNEES">
        <xsl:apply-templates select="preceding-sibling::uved:METADONNEES"/>
    </xsl:if>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="uved:PRESENTATION">
    <interunt:section>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>presentation</interunt:type>
        <interunt:titre>Prsentation</interunt:titre>
        <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
        <interunt:contenu><xsl:apply-templates/></interunt:contenu> 
    </interunt:section>
</xsl:template>

<xsl:template match="uved:CARACTERISTIQUE">
    <interunt:blocExpositif>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>caracteristique</interunt:type>
        <xsl:apply-templates/>
    </interunt:blocExpositif>
</xsl:template>

<xsl:template match="uved:FINALITE">
    <interunt:blocExpositif>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>finalite</interunt:type>
        <xsl:apply-templates/>
    </interunt:blocExpositif>
</xsl:template>

<xsl:template match="uved:CONTENU">
    <interunt:blocExpositif>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>contenu</interunt:type>
        <xsl:apply-templates/>
    </interunt:blocExpositif>
</xsl:template>

<xsl:template match="uved:ANNEXES">
    <interunt:section>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>annexes</interunt:type>
        <interunt:titre>Annexes</interunt:titre>
        <interunt:niveau><xsl:value-of select="count(ancestor::*)"/></interunt:niveau>
        <interunt:annexes>
            <xsl:apply-templates/>
        </interunt:annexes>
    </interunt:section>
</xsl:template>

<xsl:template match="uved:ANNEXE">
    <interunt:itemAnnexe>
        <interunt:id><xsl:value-of select="concat('annexe-',@label)"/></interunt:id>
        <interunt:label><xsl:value-of select="@label"/></interunt:label>
        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>

        <xsl:for-each select="*">
            <xsl:choose>
                <xsl:when test="not(self::uved:PARAGRAPHE|self::uved:LISTE|self::uved:ZONETABLE|self::uved:MEDIA)">
                    <xsl:apply-templates select="."/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="not(preceding-sibling::*[1][self::uved:PARAGRAPHE|self::uved:LISTE|self::uved:ZONETABLE|self::uved:MEDIA])">
                        <xsl:variable name="ensemble-1" select=".|following-sibling::*"/>
                        <xsl:variable name="ensemble-2" select="(following-sibling::*[not(self::uved:PARAGRAPHE|self::uved:LISTE|self::uved:ZONETABLE|self::uved:MEDIA)][1])/preceding-sibling::*"/>
                        <interunt:blocExpositif>
                            <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                            <xsl:choose>
                                <xsl:when test="not($ensemble-2)">
                                    <xsl:apply-templates select="$ensemble-1"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:apply-templates select="$ensemble-1[count(.|$ensemble-2) = count($ensemble-2)]"/>
                                </xsl:otherwise>
                            </xsl:choose>
                        </interunt:blocExpositif>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>

    </interunt:itemAnnexe>
</xsl:template>

<xsl:template match="uved:REFERENCEWEBOGRAPHIQUE">
    <interunt:refWebo>
        <interunt:label><xsl:value-of select="@labelAdress"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('REFERENCEWEBOGRAPHIQUE-',@labelAdress)"/></interunt:refId>
    </interunt:refWebo>
</xsl:template>

<xsl:template match="uved:REFERENCEWEBOGRAPHIQUE" mode="webographie">
    <interunt:itemWebographie>
        <interunt:id><xsl:value-of select="concat('REFERENCEWEBOGRAPHIQUE-',@labelAdress)"/></interunt:id>
        <interunt:label><xsl:value-of select="@labelAdress"/></interunt:label>
        <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        <interunt:url><xsl:value-of select="@URL"/></interunt:url>
    </interunt:itemWebographie>
</xsl:template>

<xsl:template match="uved:LIENREFERENCEWEBOGRAPHIQUE">
    <interunt:refWebo>
        <interunt:label><xsl:value-of select="@labelReference"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('REFERENCEWEBOGRAPHIQUE-',@labelReference)"/></interunt:refId>
    </interunt:refWebo>
</xsl:template>

<xsl:template match="uved:DESCRIPTION">
    <interunt:blocExpositif>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:paragraphe>
            <xsl:value-of select="."/>
        </interunt:paragraphe>
    </interunt:blocExpositif>
</xsl:template>

<xsl:template match="uved:REFERENCEBIBLIOGRAPHIQUE">
    <interunt:refBiblio>
        <interunt:label><xsl:value-of select="@labelReference"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('LIENREFERENCEBIBLIOGRAPHIQUE-',@labelReference)"/></interunt:refId>
    </interunt:refBiblio>
</xsl:template>

<xsl:template match="uved:REFERENCEBIBLIOGRAPHIQUE" mode="bibliographie">
    <interunt:itemBibliographie>
        <xsl:apply-templates/>
    </interunt:itemBibliographie>
</xsl:template>

<xsl:template match="uved:LIENREFERENCEBIBLIOGRAPHIQUE">
    <interunt:refBiblio>
        <interunt:label><xsl:value-of select="@labelReference"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('LIENREFERENCEBIBLIOGRAPHIQUE-',@labelReference)"/></interunt:refId>
    </interunt:refBiblio>
</xsl:template>

<!-- pas de format a priori pour autresAuteurs -->
<xsl:template match="uved:REFOUVRAGE">
    <interunt:id><xsl:value-of select="concat('LIENREFERENCEBIBLIOGRAPHIQUE-',../@labelReference)"/></interunt:id>
    <interunt:label><xsl:value-of select="../@labelReference"/></interunt:label>
    <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
    <interunt:auteur><xsl:value-of select="@premierAuteur"/></interunt:auteur>
    <!-- gestion par defaut car absence de format a priori pour autresAuteurs -->
    <xsl:if test="@autresAuteurs!=''">
        <interunt:auteur><xsl:value-of select="@autresAuteurs"/></interunt:auteur>
    </xsl:if>
</xsl:template>

<xsl:template match="uved:LIENMOTDUGLOSSAIRE">
    <interunt:refGlossaire>
        <interunt:label><xsl:value-of select="@labelReference"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('MOTDUGLOSSAIRE-',@mot)"/></interunt:refId>
    </interunt:refGlossaire>
</xsl:template>

<xsl:template match="uved:MOTDUGLOSSAIRE">
    <interunt:refGlossaire>
        <interunt:label><xsl:value-of select="@mot"/></interunt:label>
        <interunt:refId><xsl:value-of select="concat('MOTDUGLOSSAIRE-',@mot)"/></interunt:refId>
    </interunt:refGlossaire>
</xsl:template>

<xsl:template match="uved:MOTDUGLOSSAIRE" mode="glossaire">
    <interunt:itemGlossaire>
        <interunt:id><xsl:value-of select="concat('MOTDUGLOSSAIRE-',@mot)"/></interunt:id>
        <interunt:label><xsl:value-of select="@mot"/></interunt:label>
        <interunt:titre><xsl:value-of select="@mot"/></interunt:titre>
        <interunt:paragraphe>
            <xsl:apply-templates/>
        </interunt:paragraphe>
    </interunt:itemGlossaire>
</xsl:template>

<xsl:template match="uved:LIENDOCUMENT">
    <interunt:refDocument>
        <interunt:url><xsl:value-of select="@url"/></interunt:url>
        <interunt:label><xsl:value-of select="@url"/></interunt:label>
    </interunt:refDocument>
</xsl:template>

<xsl:template match="uved:LIENWEB">
    <interunt:adresseWeb>
        <interunt:url><xsl:value-of select="@url"/></interunt:url>
        <interunt:label><xsl:value-of select="."/></interunt:label>
    </interunt:adresseWeb>
</xsl:template>

<xsl:template match="uved:EXERCICE">
    <interunt:exercice>
    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <xsl:if test="@titre!=''">
            <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        </xsl:if>
        <xsl:apply-templates/>
    </interunt:exercice>
</xsl:template>

<xsl:template match="uved:ENONCE">
    <interunt:enonce>
        <xsl:apply-templates/>
    </interunt:enonce>
</xsl:template>

<xsl:template match="uved:DIFFICULTE">
    <interunt:difficulte>
        <xsl:value-of select="."/>
    </interunt:difficulte>
</xsl:template>

<xsl:template match="uved:TEMPS">
    <interunt:temps>
        <xsl:value-of select="."/>
    </interunt:temps>
</xsl:template>

<xsl:template match="uved:QUESTION">
    <interunt:question>
        <xsl:apply-templates/>
    </interunt:question>
</xsl:template>

<xsl:template match="uved:AIDE">
    <interunt:aide>
        <xsl:apply-templates/>
    </interunt:aide>
</xsl:template>

<xsl:template match="uved:SOLUTION">
    <interunt:solution>
        <xsl:apply-templates/>
    </interunt:solution>
</xsl:template>

<xsl:template match="uved:POINTS">
    <interunt:points>
        <xsl:value-of select="."/>
    </interunt:points>
</xsl:template>

<xsl:template match="uved:QCM">
    <interunt:exercice>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type>qcm</interunt:type>
        <xsl:if test="@titre!=''">
            <interunt:titre><xsl:value-of select="@titre"/></interunt:titre>
        </xsl:if>
        <xsl:apply-templates/>
    </interunt:exercice>
</xsl:template>

<xsl:template match="uved:QUESTIONQCM">
    <interunt:questionQCM>
        <xsl:apply-templates/>
    </interunt:questionQCM>
</xsl:template>

<xsl:template match="uved:ENONCEQCM">
    <interunt:enonce>
        <interunt:paragraphe>
            <xsl:apply-templates/>
        </interunt:paragraphe>
    </interunt:enonce>
</xsl:template>

<xsl:template match="uved:REPONSEQCM">
    <interunt:reponseQCM>
        <interunt:bonne><xsl:value-of select="@bonne"/></interunt:bonne>
        <xsl:apply-templates/>
    </interunt:reponseQCM>
</xsl:template>

<xsl:template match="uved:TEXTEREP">
    <interunt:propositionRep>
        <interunt:paragraphe>
            <xsl:apply-templates/>
        </interunt:paragraphe>
    </interunt:propositionRep>
</xsl:template>

<xsl:template match="uved:COMMENTAIREREP">
    <interunt:commentaireRep>
        <interunt:paragraphe>
            <xsl:value-of select="."/>
        </interunt:paragraphe>
    </interunt:commentaireRep>
</xsl:template>

<!-- perte de l'attribut 'format'-->
<xsl:template match="uved:FICHIER" mode="sans_balises">
        <xsl:value-of select="@chemin"/>
</xsl:template>

<!-- perte de l'attribut 'format'-->
<xsl:template match="uved:FICHIER">
    <interunt:fichier>
        <xsl:value-of select="@chemin"/>
    </interunt:fichier>
</xsl:template>

<xsl:template match="uved:LEGENDE">
    <interunt:legende>
        <xsl:value-of select="."/>
    </interunt:legende>
</xsl:template>

<xsl:template match="uved:TAILLE">
    <interunt:largeur>
        <xsl:value-of select="@largeur"/>
    </interunt:largeur>
    <interunt:hauteur>
        <xsl:value-of select="@hauteur"/>
    </interunt:hauteur>
</xsl:template>

<xsl:template match="uved:PARAMETRE">
    <interunt:parametre>
        <interunt:clef>
            <xsl:value-of select="@nom"/>
        </interunt:clef>
        <interunt:valeur>
            <xsl:value-of select="@valeur"/>
        </interunt:valeur>
    </interunt:parametre>
</xsl:template>

<xsl:template match="uved:EM" mode="sans_balises">
    <interunt:emphase>
        <xsl:value-of select="."/>
    </interunt:emphase>
</xsl:template>

<xsl:template match="uved:I" mode="sans_balises">
    <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="uved:B" mode="sans_balises">
    <xsl:value-of select="."/>
</xsl:template>

<xsl:template match="uved:SUP" mode="sans_balises">
    <interunt:exposant>
        <xsl:value-of select="."/>
    </interunt:exposant>
</xsl:template>

<xsl:template match="uved:SUB" mode="sans_balises">
    <interunt:indice>
        <xsl:value-of select="."/>
    </interunt:indice>
</xsl:template>


<!--#######################-->
<!--## fonctions annexes ##-->
<!--#######################-->

<!-- renvoit l'extension d'un fichier  partir de son nom -->
<xsl:template name="extensionfichier">
    <xsl:param name="nom"/>
    <xsl:choose>
        <xsl:when test="contains($nom,'.')">
            <xsl:call-template name="extensionfichier"><xsl:with-param name="nom" select="substring-after($nom,'.')"/></xsl:call-template>
        </xsl:when>
        <xsl:otherwise><xsl:value-of select="$nom"/></xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="formatfichier">
<!-- renvoit le format suppos d'un fichier d'image/animation  partir de son nom, en utilisant l'extension -->
<!-- formats reconnus: PNG, JPEG, GIF, MPEG, MNG, HTML, TEXTE -->
<!-- renvoit '?' si le format n'est pas reconnu -->
    <xsl:param name="nom"/>
    <xsl:variable name="ext"><xsl:call-template name="extensionfichier"><xsl:with-param name="nom" select="$nom"/></xsl:call-template></xsl:variable>
    <xsl:variable name="extmin" select="translate($ext, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
    <xsl:choose>
        <xsl:when test="$extmin='png'">image/png</xsl:when>
        <xsl:when test="$extmin='jpg' or $extmin='jpeg'">image/jpeg</xsl:when>
        <xsl:when test="$extmin='gif'">image/gif</xsl:when>
        <xsl:when test="$extmin='swf'">application/x-shockwave-flash</xsl:when>
        <xsl:when test="$extmin='mpg' or $extmin='mpeg'">video/mpeg</xsl:when>
        <xsl:when test="$extmin='m4a'">audio/mp4</xsl:when>
        <xsl:when test="$extmin='mp4'">video/mp4</xsl:when>
        <xsl:when test="$extmin='class'">application/octet-stream</xsl:when>
        <xsl:when test="$extmin='jar'">application/java-archive</xsl:when>
        <xsl:otherwise>
            <xsl:message terminate="no">
                type MIME non reconnu.
            </xsl:message>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="style-remarque">
    <xsl:param name="nom"/>
    <interunt:blocExpositif>
        <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
        <interunt:type><xsl:value-of select="$nom"/></interunt:type>
        <xsl:apply-templates/>
    </interunt:blocExpositif>
</xsl:template>

<xsl:template name="style-definition">
    <xsl:param name="nom"/>
    <xsl:choose>
        <xsl:when test="parent::uved:SECTION">
            <interunt:contenu>
                <interunt:blocExpositif>
                    <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                    <interunt:type><xsl:value-of select="$nom"/></interunt:type>
                    <xsl:apply-templates/>
                </interunt:blocExpositif>
            </interunt:contenu>
        </xsl:when>
        <xsl:otherwise>
            <interunt:blocExpositif>
                <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
                <interunt:type><xsl:value-of select="$nom"/></interunt:type>
                <xsl:apply-templates/>
            </interunt:blocExpositif>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="style-introduction">
    <xsl:param name="nom"/>
    <interunt:contenu>
        <interunt:blocExpositif>
            <interunt:id><xsl:value-of select="generate-id()"/></interunt:id>
            <interunt:type><xsl:value-of select="$nom"/></interunt:type>
            <xsl:apply-templates/>
        </interunt:blocExpositif>
    </interunt:contenu>
</xsl:template>

</xsl:stylesheet>