<?xml version='1.0' encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    xmlns:imscp="http://www.imsglobal.org/xsd/imscp_v1p1"
    xmlns:lom="http://ltsc.ieee.org/xsd/LOM"
    xmlns:adlcp="http://www.adlnet.org/xsd/adlcp_v1p3"
    xmlns:imsss="http://www.imsglobal.org/xsd/imsss"
    xmlns:adlnav="http://www.adlnet.org/xsd/adlnav_v1p3"
    exclude-result-prefixes="u">
    
    <!-- ************************************************ -->
    <!--
        Cration de fichiers SCORM
        Il est impossible de faire des redirections multiples avec XSLTC et Xalan avec des output method diffrentes,
        du coup on ne peut pas inclure cette feuille de style dans UVED_LANCEUR
        et on doit la lancer  ct.
        Avec Jaxe, on rsoud le problme avec les transformations successives UVED_FUSION | UVED_SCORM | UVED_LANCEUR
    -->
    <!-- ************************************************ -->
    
    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
    
    <xsl:include href="./UVED_OUTILS.xsl" />
    
    <!-- dclaration des variables globales -->
    <xsl:param name="chainEditPath"/>
    <xsl:param name="jaxe-fichier-xml"/>  <!-- chemin complet vers le fichier XML quand il est dit avec Jaxe -->

    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- chemin du rpertoire du fichier XML si jaxe-fichier-xml est utilis -->
    <xsl:variable name="chemin-jaxe-xml"><xsl:if test="$jaxe-fichier-xml!=''"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:if></xsl:variable>
    
    <xsl:variable name="racine"><xsl:choose>
        <xsl:when test="/u:UVED/u:CONTENUS">..</xsl:when>
        <xsl:otherwise>.</xsl:otherwise> <!-- dans le rpertoire courant s'il ne s'agit pas d'un site entier, contrairement  UVED 1.0 -->
    </xsl:choose></xsl:variable>
    <xsl:variable name="cheminSite"><xsl:choose>
        <xsl:when test="$jaxe-fichier-xml!=''"><xsl:value-of select="concat($chemin-jaxe-xml, $sep, translate($racine,'/',$sep), $sep, 'site', $sep, 'html', $sep)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="concat($chainEditPath, '../site/html/')"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    
    
    <xsl:template match="/">
        <xsl:call-template name="scorm-manifest"/>
        <xsl:apply-templates/>
    </xsl:template>
    
    <xsl:template match="@*|node()">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()">
               <xsl:with-param name="dossier" select="$dossier"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <!-- Cration du fichier imsmanifest.xml. Le noeud courant doit tre la racine du document cr par UVED_FUSION. -->
    <xsl:template name="scorm-manifest">
        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'imsmanifest.xml')"/>
            <xsl:with-param name="contenu">
                <imscp:manifest identifier="id-manifeste">
                    <imscp:metadata>
                        <imscp:schema>ADL SCORM</imscp:schema>
                        <imscp:schemaversion>2004 3rd Edition</imscp:schemaversion>
                        <xsl:call-template name="lom"/>
                    </imscp:metadata>
                    <xsl:choose>
                        <xsl:when test="/u:UVED/u:CONTENUS/@niveauxOrg!='' and /u:UVED/u:CONTENUS/@niveauxOrg!='0'">
                            <imscp:organizations default="contenus">
                                <xsl:for-each select="/u:UVED/u:CONTENUS/u:SECTION">
                                    <xsl:call-template name="scorm-organization"/>
                                </xsl:for-each>
                            </imscp:organizations>
                        </xsl:when>
                        <xsl:when test="/u:UVED/u:CONTENUS">
                            <imscp:organizations default="contenus">
                                <imscp:organization identifier="contenus" structure="hierarchical">
                                    <imscp:title><xsl:value-of select="/u:UVED/u:CONTENUS/@titre"/></imscp:title>
                                    <xsl:for-each select="/u:UVED/u:CONTENUS/u:SECTION">
                                        <xsl:call-template name="scorm-item"/>
                                    </xsl:for-each>
                                </imscp:organization>
                            </imscp:organizations>
                        </xsl:when>
                        <xsl:otherwise>
                            <imscp:organizations default="/u:UVED/u:SECTION/@label">
                                <imscp:organization identifier="/u:UVED/u:SECTION/@label" structure="hierarchical">
                                    <imscp:title><xsl:value-of select="/u:UVED/u:SECTION/@titre"/></imscp:title>
                                    <xsl:for-each select="/u:UVED/u:SECTION">
                                        <xsl:call-template name="scorm-item"/>
                                    </xsl:for-each>
                                </imscp:organization>
                            </imscp:organizations>
                        </xsl:otherwise>
                    </xsl:choose>
                    <xsl:call-template name="scorm-ressources"/>
                </imscp:manifest>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="lom">
        <xsl:variable name="langue"><xsl:value-of select="/u:UVED/u:METADONNEES/u:LANGUE"/></xsl:variable>
        <lom:lom>
            <lom:metaMetadata>
                <lom:metadataSchema>LOMFRv1.0</lom:metadataSchema>
            </lom:metaMetadata>
            <lom:general>
                <lom:title>
                    <lom:string>
                        <xsl:choose>
                            <xsl:when test="/u:UVED/u:CONTENUS">
                                <xsl:value-of select="/u:UVED/u:CONTENUS/@titre"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="/u:UVED/u:SECTION/@titre"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </lom:string>
                </lom:title>
                <xsl:if test="$langue != ''">
                    <!-- remarque : pb de compatibilit ici entre LOM, LOM-fr, UVED, ... -->
                    <lom:language><xsl:value-of select="substring($langue,1,2)"/></lom:language>
                </xsl:if>
                <xsl:for-each select="/u:UVED/u:METADONNEES/u:MOTSCLE/u:MOTCLE">
                    <lom:keyword>
                        <lom:string><xsl:value-of select="."/></lom:string>
                    </lom:keyword>
                </xsl:for-each>
            </lom:general>
            <xsl:if test="/u:UVED/u:METADONNEES/u:NIVEAULMD">
                <lom:educational>
                    <lom:context>
                        <lom:source>LOMFRv1.0</lom:source>
                        <lom:value>
                            <xsl:variable name="niveau" select="/u:UVED/u:METADONNEES/u:NIVEAULMD"/>
                            <xsl:choose>
                                <xsl:when test="$niveau='L'">licence</xsl:when>
                                <xsl:when test="$niveau='M'">mastere</xsl:when>
                                <xsl:when test="$niveau='D'">doctorat</xsl:when>
                                <xsl:otherwise>autre</xsl:otherwise>
                            </xsl:choose>
                        </lom:value>
                    </lom:context>
                </lom:educational>
            </xsl:if>
            <lom:lifeCycle>
                <xsl:if test="/u:UVED/u:METADONNEES/u:VERSION != ''">
                    <lom:version>
                        <lom:string><xsl:value-of select="/u:UVED/u:METADONNEES/u:VERSION"/></lom:string>
                    </lom:version>
                </xsl:if>
                <xsl:if test="/u:UVED/u:METADONNEES/u:ETAT != ''">
                    <lom:status>
                        <lom:string><xsl:value-of select="/u:UVED/u:METADONNEES/u:ETAT"/></lom:string>
                    </lom:status>
                </xsl:if>
                <xsl:for-each select="/u:UVED/u:METADONNEES/u:AUTEURS/u:AUTEUR">
                    <lom:contribute>
                        <lom:role>
                            <xsl:value-of select="@fonction"/>
                        </lom:role>
                        <lom:entity>
                            <xsl:value-of select="concat(@prenom,', ',@nom, ', ', @organisme)"/>
                        </lom:entity>
                        <xsl:if test="/u:UVED/u:METADONNEES/u:DATECRE">
                            <xsl:variable name="date" select="/u:UVED/u:METADONNEES/u:DATECRE"/>
                            <lom:date><xsl:value-of select="concat(substring-after(substring-after($date, '/'), '/'), '-', substring-before(substring-after($date, '/'), '/'), '-', substring-before($date, '/'))"/></lom:date>
                        </xsl:if>
                    </lom:contribute>
                </xsl:for-each>
            </lom:lifeCycle>
            <xsl:if test="/u:UVED/u:METADONNEES/u:LOCALISATION">
                <lom:technical>
                    <lom:location><xsl:value-of select="/u:UVED/u:METADONNEES/u:LOCALISATION"/></lom:location>
                </lom:technical>
            </xsl:if>
        </lom:lom>
    </xsl:template>
    
    <xsl:template name="scorm-organization">
        <imscp:organization identifier="{@label}" structure="hierarchical">
            <imscp:title><xsl:value-of select="@titre"/></imscp:title>
            <xsl:choose>
                <xsl:when test="count(ancestor::SECTION) &lt; /u:UVED/u:CONTENUS/@niveauxOrg - 1">
                    <xsl:for-each select="u:SECTION">
                        <xsl:call-template name="scorm-organization"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="u:SECTION">
                        <xsl:call-template name="scorm-item"/>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </imscp:organization>
    </xsl:template>
    
    <xsl:template name="scorm-item">
        <imscp:item identifier="{@label}" isvisible="true" identifierref="res-{@label}">
            <imscp:title><xsl:value-of select="@titre"/></imscp:title>
            <xsl:for-each select="*[self::u:SECTION or self::u:GRAIN]">
                <xsl:call-template name="scorm-item"/>
            </xsl:for-each>
        </imscp:item>
        <!--
        <imsss:sequencing>
            <imsss:controlMode flow="true"/>
        </imsss:sequencing>
        -->
    </xsl:template>
    
    <xsl:template name="scorm-ressources">
        <imscp:resources>
            <imscp:resource identifier="medias" type="webcontent" adlcp:scormType="asset">
                <imscp:file href="medias/html/aide.html"/>
                <imscp:file href="medias/html/mentions.html"/>
                <imscp:file href="medias/navigation/cours/activite.png"/>
                <imscp:file href="medias/navigation/cours/attention.png"/>
                <imscp:file href="medias/navigation/cours/citation.png"/>
                <imscp:file href="medias/navigation/cours/complement.png"/>
                <imscp:file href="medias/navigation/cours/conclusion.png"/>
                <imscp:file href="medias/navigation/cours/confere.png"/>
                <imscp:file href="medias/navigation/cours/conseil.png"/>
                <imscp:file href="medias/navigation/cours/definition.png"/>
                <imscp:file href="medias/navigation/cours/ensavoirplus.png"/>
                <imscp:file href="medias/navigation/cours/exemple.png"/>
                <imscp:file href="medias/navigation/cours/exercice.png"/>
                <imscp:file href="medias/navigation/cours/explication.png"/>
                <imscp:file href="medias/navigation/cours/internet.png"/>
                <imscp:file href="medias/navigation/cours/introduction.png"/>
                <imscp:file href="medias/navigation/cours/lien_interne.png"/>
                <imscp:file href="medias/navigation/cours/media.png"/>
                <imscp:file href="medias/navigation/cours/methode.png"/>
                <imscp:file href="medias/navigation/cours/note.png"/>
                <imscp:file href="medias/navigation/cours/objectifs.png"/>
                <imscp:file href="medias/navigation/cours/prerequis.png"/>
                <imscp:file href="medias/navigation/cours/qcm.png"/>
                <imscp:file href="medias/navigation/cours/rappel.png"/>
                <imscp:file href="medias/navigation/cours/reference.png"/>
                <imscp:file href="medias/navigation/cours/remarque.png"/>
                <imscp:file href="medias/navigation/cours/syntaxe.png"/>
                <imscp:file href="medias/navigation/icones/accueil.png"/>
                <imscp:file href="medias/navigation/icones/aide.png"/>
                <imscp:file href="medias/navigation/icones/credits.png"/>
                <imscp:file href="medias/navigation/icones/imprimer.png"/>
                <imscp:file href="medias/navigation/icones/pageprecedente_disabled.png"/>
                <imscp:file href="medias/navigation/icones/pageprecedente.png"/>
                <imscp:file href="medias/navigation/icones/pagesuivante_disabled.png"/>
                <imscp:file href="medias/navigation/icones/pagesuivante.png"/>
                <imscp:file href="medias/navigation/icones/plandusite.png"/>
                <imscp:file href="medias/navigation/icones/ressources.png"/>
                <imscp:file href="medias/navigation/interface/background_button.png"/>
                <imscp:file href="medias/navigation/interface/background_footer.png"/>
                <imscp:file href="medias/navigation/interface/background_header.gif"/>
                <imscp:file href="medias/navigation/interface/background_table_th.png"/>
                <imscp:file href="medias/navigation/interface/logo.png"/>
                <imscp:file href="medias/navigation/interface/photo_header.jpg"/>
                <imscp:file href="medias/navigation/puces/bullet_black.gif"/>
                <imscp:file href="medias/navigation/puces/bullet_toggle_minus.gif"/>
                <imscp:file href="medias/navigation/puces/bullet_toggle_plus.gif"/>
                <imscp:file href="medias/navigation/puces/puce_301.gif"/>
                <imscp:file href="medias/scripts/cirm.js"/>
                <imscp:file href="medias/scripts/event.js"/>
                <imscp:file href="medias/scripts/qcm.js"/>
                <imscp:file href="medias/scripts/swfobject.js"/>
                <imscp:file href="medias/scripts/yahoo.js"/>
                <imscp:file href="medias/styles/cirm/cirm-tooltip.css"/>
                <imscp:file href="medias/styles/cirm/cirm-treeview.css"/>
                <imscp:file href="medias/styles/module/aide.css"/>
                <imscp:file href="medias/styles/module/aideqcm.css"/>
                <imscp:file href="medias/styles/module/author.css"/>
                <imscp:file href="medias/styles/module/content-cours-blocs.css"/>
                <imscp:file href="medias/styles/module/content-cours-plan.css"/>
                <imscp:file href="medias/styles/module/content-cours-tooltip.css"/>
                <imscp:file href="medias/styles/module/content-cours.css"/>
                <imscp:file href="medias/styles/module/content-exercices.css"/>
                <imscp:file href="medias/styles/module/content-map.css"/>
                <imscp:file href="medias/styles/module/content-presentation.css"/>
                <imscp:file href="medias/styles/module/content-ressources.css"/>
                <imscp:file href="medias/styles/module/content-table.css"/>
                <imscp:file href="medias/styles/module/content.css"/>
                <imscp:file href="medias/styles/module/footer.css"/>
                <imscp:file href="medias/styles/module/header.css"/>
                <imscp:file href="medias/styles/module/mentions.css"/>
                <imscp:file href="medias/styles/module/print.css"/>
                <imscp:file href="medias/styles/module/style.css"/>
                <imscp:file href="medias/symboles/grec-majuscules/Delta.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Gamma.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Lambda.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Omega.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Phi.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Pi.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Psi.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Sigma.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/sigmaf.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Theta.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/thetasym.png"/>
                <imscp:file href="medias/symboles/grec-majuscules/Xi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/alpha.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/beta.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/chi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/delta.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/epsilon.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/eta.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/gamma.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/iota.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/kappa.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/lambda.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/mu.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/nu.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/omega.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/omicron.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/phi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/phi2.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/pi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/piv.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/psi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/rho.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/sigma.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/tau.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/theta.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/upsilon.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/xi.png"/>
                <imscp:file href="medias/symboles/grec-minuscules/zeta.png"/>
                <imscp:file href="medias/symboles/maths/asymp.png"/>
                <imscp:file href="medias/symboles/maths/cap.png"/>
                <imscp:file href="medias/symboles/maths/cup.png"/>
                <imscp:file href="medias/symboles/maths/exist.png"/>
                <imscp:file href="medias/symboles/maths/forall.png"/>
                <imscp:file href="medias/symboles/maths/ge.png"/>
                <imscp:file href="medias/symboles/maths/harr.png"/>
                <imscp:file href="medias/symboles/maths/hdarr.png"/>
                <imscp:file href="medias/symboles/maths/infin.png"/>
                <imscp:file href="medias/symboles/maths/isin.png"/>
                <imscp:file href="medias/symboles/maths/larr.png"/>
                <imscp:file href="medias/symboles/maths/ldarr.png"/>
                <imscp:file href="medias/symboles/maths/le.png"/>
                <imscp:file href="medias/symboles/maths/nabla.png"/>
                <imscp:file href="medias/symboles/maths/ne.png"/>
                <imscp:file href="medias/symboles/maths/not.png"/>
                <imscp:file href="medias/symboles/maths/part.png"/>
                <imscp:file href="medias/symboles/maths/plusmn.png"/>
                <imscp:file href="medias/symboles/maths/rarr.png"/>
                <imscp:file href="medias/symboles/maths/rdarr.png"/>
                <imscp:file href="medias/symboles/maths/sim.png"/>
                <imscp:file href="medias/symboles/maths/sub.png"/>
            </imscp:resource>
            <xsl:for-each select="//u:SECTION|//u:GRAIN">
                <xsl:variable name="chemin"><xsl:for-each select="(ancestor-or-self::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each>index.html</xsl:variable>
                <imscp:resource identifier="res-{@label}" type="webcontent" href="{$chemin}" adlcp:scormType="sco">
                    <imscp:file href="{$chemin}"/>
                    <imscp:dependency identifierref="medias"/>
                </imscp:resource>
            </xsl:for-each>
        </imscp:resources>
    </xsl:template>
</xsl:stylesheet>
