<?xml version='1.0' encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">
    
    <xsl:output method="xml" indent="yes" encoding="ISO-8859-1" />
    <!-- ************************************************ -->
    <!-- Fusion de tous les fichiers d'un cours UVED -->
    <!--  lancer sur le fichier XML contenant l'lment CONTENU sous UVED -->
    <!-- renvoit le XML correspondant  la fusion de tout le cours -->
    <!-- ************************************************ -->
    <!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->
    
    <!-- attention, cette feuille de style ne fonctionne qu'avec l'arborescence
        dossier_de_section/.../dossier_de_section
        et avec le fichier CONTENU au mme niveau que les dossiers des sections de plus haut niveau -->
    
    <xsl:param name="jaxe-fichier-xml"/>  <!-- chemin complet vers le fichier XML quand il est dit avec Jaxe -->
    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- chemin du rpertoire du fichier XML si jaxe-fichier-xml est utilis -->
    <xsl:variable name="chemin-jaxe-xml"><xsl:if test="$jaxe-fichier-xml!=''"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:if></xsl:variable>
    
    <xsl:template match="u:CONTENUS">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:copy>
            <xsl:attribute name="dossier"><xsl:value-of select="$dossier"/></xsl:attribute>
            <xsl:apply-templates select="@*|node()">
               <xsl:with-param name="dossier" select="$dossier"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="u:SECTION">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:copy>
            <xsl:attribute name="dossier"><xsl:value-of select="$dossier"/></xsl:attribute>
            <xsl:apply-templates select="@*|node()">
               <xsl:with-param name="dossier" select="$dossier"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="u:REFSECTION">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:variable name="labelsection" select="@label"/>
        <xsl:for-each select="document(concat($labelsection,$sep,$labelsection,'.xml'), .)/u:UVED">
            <xsl:copy-of select="u:METADONNEES"/>
            <xsl:for-each select="u:SECTION[@label=$labelsection]">
                <xsl:copy>
                    <xsl:variable name="nouveau_dossier"><xsl:choose>
                       <xsl:when test="$dossier!=''"><xsl:value-of select="concat($dossier,$sep,$labelsection)"/></xsl:when>
                       <xsl:otherwise><xsl:value-of select="$labelsection"/></xsl:otherwise>
                    </xsl:choose></xsl:variable>
                    <xsl:attribute name="dossier"><xsl:value-of select="$nouveau_dossier"/></xsl:attribute>
                    <xsl:apply-templates select="@*|node()">
                       <xsl:with-param name="dossier" select="$nouveau_dossier"/>
                    </xsl:apply-templates>
                </xsl:copy>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="@*|node()">
        <xsl:param name="dossier" select="$chemin-jaxe-xml"/>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()">
               <xsl:with-param name="dossier" select="$dossier"/>
            </xsl:apply-templates>
        </xsl:copy>
    </xsl:template>

<!-- ************************************************ -->
<!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet vers le fichier -->
<!-- ************************************************ -->
    <xsl:template name="repfichier">
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep) and contains(substring-after($chemin,$sep),$sep)">
                <xsl:value-of select="substring-before($chemin,$sep)"/><xsl:value-of select="$sep"/><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring-before($chemin,$sep)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>
