<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

    <!-- ************************************************ -->
    <!-- creation des fichiers HTML pour les exercices (aides et solutions) -->
    <!-- ************************************************ -->
    <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
    <!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->

    <xsl:template name="UVED_EXERCICES">
        
        <xsl:for-each select=".//u:AIDE |.//u:SOLUTION">
            
            <xsl:variable name="chemin-section"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
            
            <xsl:variable name="numaide">
                <xsl:number level="any" from="u:SECTION" count="u:AIDE | u:SOLUTION"/>
            </xsl:variable>
            
            <xsl:call-template name="ecrireDansFichier">
                <xsl:with-param name="fichier" select="concat($cheminSite,$chemin-section,'aide',$numaide,'.html')"/>
                <xsl:with-param name="contenu">
                    <html lang="fr">
                        <xsl:call-template name="headerAideExercice"/>
                        <body>
                            <h3><xsl:value-of select="name()"/></h3>
                            <div class="cours">
                                <xsl:apply-templates/>
                            </div>
                            <div id="close">
                                <a href="javascript:window.close();" title="">Fermer la fentre</a>
                            </div>
                        </body>
                    </html>
               </xsl:with-param>
            </xsl:call-template>
            
        </xsl:for-each>
        
    </xsl:template>
    
</xsl:stylesheet>
