<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

    <!-- ************************************************ -->
    <!-- creation de la bibliographie pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
    <!-- version 1.0 pour UVED 2.0 -  Damien Guillaume, Observatoire de Paris -->
    
    <xsl:template name="UVED_BIBLIOGRAPHIE">
        <xsl:variable name="alphabetcomplet">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>

        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'bibliographie.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource">
                        <xsl:with-param name="titre">UVED - Bibliographie</xsl:with-param>
                    </xsl:call-template>
                    <body>
                        <xsl:call-template name="bodyheaderRessource">
                            <xsl:with-param name="selection">ressources</xsl:with-param>
                        </xsl:call-template>
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-page">
                                <h3>Ressources</h3>
                                <h4>Bibliographie</h4>
                            </div>
    
                            <!-- creation de la liste des ressources accessibles -->
                            <xsl:call-template name="biblioSelectressources" />
    
                            <!-- creation des lien vers les ancres-->
                            <div class="navigation">
                                <xsl:call-template name="biblioLigneancres">
                                    <xsl:with-param name="alphabet" select="$alphabetcomplet"/>
                                </xsl:call-template>
                            </div>
    
                            <!-- affichage des ouvrages de la bibliographie-->
                            <xsl:call-template name="lignebibliographie">
                                <xsl:with-param name="alphabet" select="$alphabetcomplet"/>
                            </xsl:call-template>
    
                        </div>
                    <xsl:call-template name="footerRessource">
                        <!--<xsl:with-param name="pageActive">bibliographie</xsl:with-param>-->
                    </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>

    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation des liens vers les ancres-->
    <!-- ************************************************ -->
    <xsl:template name="biblioLigneancres">
        <xsl:param name="alphabet" />

        <xsl:variable name="unelettre" select="substring($alphabet,1,1)"/>
        <xsl:variable name="suitealphabet" select="substring-after($alphabet, $unelettre)"/>

        <!-- creation des liens vers les ancres-->
        <xsl:call-template name="biblioLienancres">
            <xsl:with-param name="majuscule" select="$unelettre" />
        </xsl:call-template>

        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="biblioLigneancres">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation d'un lien vers les ancres-->
    <!-- ************************************************ -->
    <xsl:template name="biblioLienancres">
        <xsl:param name="majuscule" />
        <xsl:variable name="minuscules">abcdefghijklmnopqrstuvwxyz</xsl:variable>
        <xsl:variable name="majuscules">AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ</xsl:variable>
        
        <xsl:if test="count(u:UVED//u:REFERENCEBIBLIOGRAPHIQUE[translate(substring(*/@premierAuteur,1,1),$minuscules,$majuscules)=$majuscule])>0">
            <a href="#{$majuscule}">
                <xsl:value-of select="$majuscule" />
            </a>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation des ancres et insertion des ouvrages-->
    <!-- ************************************************ -->
    <xsl:template name="lignebibliographie">
        <xsl:param name="alphabet" />
        <xsl:variable name="minuscules">abcdefghijklmnopqrstuvwxyz</xsl:variable>
        <xsl:variable name="majuscules">AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ</xsl:variable>

        <xsl:variable name="unelettre" select="substring($alphabet,1,1)"/>
        <xsl:variable name="suitealphabet" select="substring-after($alphabet, $unelettre)"/>

        <xsl:if test="count(u:UVED//u:REFERENCEBIBLIOGRAPHIQUE[translate(substring(*/@premierAuteur,1,1),$minuscules,$majuscules)=$unelettre])>0">
            <h4 class="lettre">
                <a name="{$unelettre}">
                    <xsl:value-of select="$unelettre" />
                </a>
            </h4>
        </xsl:if>

        <xsl:for-each select="u:UVED//u:REFERENCEBIBLIOGRAPHIQUE[translate(substring(*/@premierAuteur,1,1),$minuscules,$majuscules)=$unelettre]">
            <xsl:sort order="ascending" select="*/@premierAuteur" />
            <div class="bloc-definition">
                <a name="{@labelReference}"/>
                <h5>
                    <xsl:value-of select="*/@premierAuteur" />
                    <xsl:if test="@autresAuteurs">
                        ; <xsl:value-of select="@autresAuteurs"/>
                    </xsl:if>
                </h5>
                <xsl:apply-templates/>
            </div>
        </xsl:for-each>
        
        <xsl:if test="count(u:UVED//u:REFERENCEBIBLIOGRAPHIQUE[translate(substring(*/@premierAuteur,1,1),$minuscules,$majuscules)=$unelettre])>0">
        <div class="haut-page">
            <a href="#top">
               <span>haut de page</span>
            </a>
        </div>
         </xsl:if>
        
        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="lignebibliographie">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- Ouvrage -->
    <!-- ************************************************ -->
    <xsl:template match="u:REFOUVRAGE">
        <p>
            <!-- les auteurs sont dj affichs -->
            <b><i><xsl:value-of select="@titre"/></i></b>.
            <xsl:if test="@sous-titre">
                <xsl:value-of select="@sous-titre"/>.
            </xsl:if>
            <xsl:if test="@volume">
                <xsl:value-of select="@volume"/>.
            </xsl:if>
            <xsl:if test="@lieu">
                <xsl:value-of select="@lieu"/> :
            </xsl:if>
            <xsl:value-of select="@editeur"/>
            <xsl:if test="@annee">
                <xsl:text>, </xsl:text><xsl:value-of select="@annee"/>
            </xsl:if>
            <xsl:text>.</xsl:text>
            <xsl:if test="@pagination">
                <xsl:text> </xsl:text><xsl:value-of select="@pagination"/>.
            </xsl:if>
            <xsl:if test="@collection">
                coll. <xsl:value-of select="@collection"/>.
            </xsl:if>
            <xsl:if test="@isbn">
                ISBN <xsl:value-of select="@isbn"/>.
            </xsl:if>
            <xsl:if test="@url">
                <a href="{@url}"><xsl:value-of select="@url"/></a>
            </xsl:if>
            <xsl:if test="@autre">
                - <xsl:value-of select="@autre"/>
            </xsl:if>
        </p>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- Article -->
    <!-- ************************************************ -->
    <xsl:template match="u:REFARTICLE">
        <p>
            <!-- les auteurs sont dj affichs -->
            <xsl:value-of select="@titreArticle"/>.
            <b><i><xsl:value-of select="@titrePeriodique"/></i></b>,
            <xsl:value-of select="@annee"/>
            <xsl:if test="@volume">
                <xsl:text>, </xsl:text><xsl:value-of select="@volume"/>
            </xsl:if>
            <xsl:if test="@numero">
                <xsl:text>, n</xsl:text><xsl:value-of select="@numero"/>,
            </xsl:if>
            <xsl:if test="@pagination">
                <xsl:value-of select="@pagination"/>.
            </xsl:if>
            <xsl:if test="@url">
                <a href="{@url}"><xsl:value-of select="@url"/></a>
            </xsl:if>
            <xsl:if test="@autre">
                - <xsl:value-of select="@autre"/>
            </xsl:if>
        </p>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation liste des ressources-->
    <!-- ************************************************ -->
    <xsl:template name="biblioSelectressources">
        <div class="selection">
            <fieldset>
                <form action="">
                    <select onchange="location=this.options[this.selectedIndex].value;">
                        <option>Voir une autre ressource...</option>

                        <xsl:if test="count(u:UVED//u:MOTDUGLOSSAIRE)>0">
                            <option value="glossaire.html">
                                - Glossaire
                            </option>
                        </xsl:if>

                        <xsl:if test="count(u:UVED//u:REFERENCEWEBOGRAPHIQUE)>0">
                            <option value="webographie.html">
                                - Webographie
                            </option>
                        </xsl:if>
                    </select>
                </form>
            </fieldset>
        </div>
    </xsl:template>

</xsl:stylesheet>
