<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

<!-- ************************************************ -->
<!-- Gnration des annexes du cours UVED pour les ALT -->
<!-- ************************************************ -->
<!-- version 0.3 Romuald Lorthioir et Nadia Henry - CIRM - Universit de Rennes 1 -->
<!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->


<!-- ************************************************ -->
<!-- Traitement des pages d'annexes d'un cours UVED-->
<!-- ************************************************ -->
<xsl:template name="UVED_ANNEXE" >
    <xsl:for-each select="//u:ANNEXE">
        <xsl:call-template name="annexePage" >
            <xsl:with-param name="nomFichier" select="@label"/>
        </xsl:call-template>
    </xsl:for-each>
</xsl:template>


<!-- ************************************************ -->
<!-- Gnration d'une page d'annexe UVED-->
<!-- ************************************************ -->
<xsl:template name="annexePage">
    <xsl:param name="nomFichier"/>
     
    <!-- Prparation des variable pour les liens entre pages --> 
    <xsl:variable name="debut-chemin"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
    <xsl:variable name="cheminNomFichier" select="concat($cheminSite, $debut-chemin, $nomFichier,'.html')"/>
    
    <!-- Cration du fichier de la page -->
    <xsl:call-template name="ecrireDansFichier">
        <xsl:with-param name="fichier" select="$cheminNomFichier"/>
        <xsl:with-param name="contenu">
            <html lang="fr">
                <xsl:call-template name="headerPageAnnexe" />
                <body>
                    <xsl:call-template name="bodyheaderPageAnnexe" />
                    
                    <!-- CONTENU du Saut de page en cours au Saut ou SECTION suivant-->
                    <div id="content" class="cours">
                    
                        <!-- titre de l'annexe -->
                        <xsl:apply-templates select="."/>
                        
                        <!-- CONTENU -->
                        <xsl:call-template name="annexeContenuPage"/>
                    </div>
                    <!-- DIV en ALT -->
                    <xsl:call-template name="annexeDivInvisibles"/>
                    <!-- PIED de Page -->
                    <div id="close">
                        <a href="javascript:window.close();" title="">Fermer la fentre</a>
                    </div>
                </body>
            </html>
        </xsl:with-param>
    </xsl:call-template>

</xsl:template>


<!-- ************************************************ -->
<!-- Gnration du contenu des pages  en fontion de chaque Balise -->
<!-- ************************************************ -->
<xsl:template name="annexeContenuPage">
   <xsl:apply-templates select="*"/>
</xsl:template>


<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="annexeDivInvisibles">
    
    <xsl:for-each select=".//*">
        <xsl:if test="self::u:MOTDUGLOSSAIRE or self::u:LIENMOTDUGLOSSAIRE or self::u:REFERENCEBIBLIOGRAPHIQUE or self::u:LIENREFERENCEBIBLIOGRAPHIQUE or self::u:REFERENCEWEBOGRAPHIQUE or self::u:LIENREFERENCEWEBOGRAPHIQUE">
            <xsl:apply-templates select="." mode="div"/>
        </xsl:if>
    </xsl:for-each>
    
</xsl:template>

</xsl:stylesheet>
