/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jaxe.Config;
import jaxe.DialogueAideElement;
import jaxe.DialogueAttributs;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.SchemaW3C;
import jaxe.VerifTypeSimple;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AffichageFormulaire
implements DocumentListener,
ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(AffichageFormulaire.class);
    private static final Color couleurErreur = new Color(200, 0, 0);
    private static final Color couleurObligatoire = new Color(150, 0, 0);
    private static final Color couleurFacultatif = new Color(0, 100, 0);
    private static final ImageIcon iconeAttributs = new ImageIcon(ImageKeeper.loadImage("images/attributs.gif", true));
    private static final int profondeurMax = 10;
    private final Element refElement;
    private Element el;
    private final AffichageFormulaire affParent;
    private final JaxeDocument doc;
    private final Config cfg;
    private ArrayList<Element> enfants;
    private JComponent comp = null;
    private final VerifTypeSimple verif;
    private final ArrayList<Element> refEnfantsPossibles;
    private final String expreg;
    private final boolean avecSchema;
    private JLabel labelTitre = null;
    private JPanel panelElement = null;
    private JPanel panelEnfants = null;
    private JPanel panelGauche = null;
    private JPanel panelDroite = null;
    private int profondeur;
    private ArrayList<AffichageFormulaire> affEnfants = null;

    public AffichageFormulaire(Element element, Element element2, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument) {
        this.refElement = element;
        this.el = element2;
        this.affParent = affichageFormulaire;
        this.doc = jaxeDocument;
        this.cfg = jaxeDocument.cfg;
        this.profondeur = affichageFormulaire == null ? 0 : affichageFormulaire.getProfondeur() + 1;
        this.refEnfantsPossibles = this.cfg.listeSousElements(element);
        this.lireEnfants();
        this.verif = this.avecEnfants() ? null : this.cfg.getVerifTypeSimple(element);
        this.avecSchema = this.cfg.getSchema() instanceof SchemaW3C;
        this.expreg = this.avecSchema ? this.cfg.expressionReguliere(element) : null;
    }

    private void lireEnfants() {
        if (this.el == null) {
            this.enfants = null;
            return;
        }
        this.enfants = new ArrayList();
        NodeList nodeList = this.el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.enfants.add((Element)node);
        }
    }

    private boolean avecEnfants() {
        return this.refEnfantsPossibles.size() > 0;
    }

    public JPanel getPanel() {
        return this.getPanel(false);
    }

    private JPanel getPanel(boolean bl) {
        this.panelEnfants = new JPanel(new GridBagLayout());
        this.panelElement = new JPanel(new BorderLayout());
        if (this.affParent != null && this.affParent.enfantsMultiples(this.refElement)) {
            JButton jButton;
            JPanel jPanel = new JPanel(new BorderLayout());
            if (bl) {
                jButton = new JButton("+");
                jButton.setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                jPanel.add((Component)jButton, "West");
            }
            jButton = new JButton("-");
            jButton.setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            jPanel.add((Component)jButton, "East");
            this.panelElement.add((Component)jPanel, "East");
            this.panelElement.add((Component)this.panelEnfants, "Center");
        } else {
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        if (this.affParent != null) {
            this.panelElement.add((Component)this.getPanelTitre(), "North");
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.majPanel(null);
        if (this.affParent == null) {
            this.panelEnfants.setFocusCycleRoot(true);
            this.panelElement = new JPanel(new BorderLayout());
            this.panelElement.setOpaque(false);
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.panelEnfants.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.cfg.titreElement(this.refElement)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        return this.panelElement;
    }

    private JPanel getPanelTitre() {
        JComponent jComponent;
        JButton jButton = new JButton(new ActionAide(this.refElement));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.cfg.documentation(this.refElement);
        if (string != null) {
            string = "<html><body>" + string.replaceAll("\n", "<br>") + "</body></html>";
            jButton.setToolTipText(string);
        }
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        if (this.aDesAttributs()) {
            jComponent = new JButton(iconeAttributs);
            if (System.getProperty("os.name").startsWith("Mac OS") && "10.5".compareTo(System.getProperty("os.version")) > 0) {
                jComponent.putClientProperty("JButton.buttonType", "toolbar");
            } else {
                ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
            }
            ((AbstractButton)jComponent).addActionListener(this);
            ((AbstractButton)jComponent).setActionCommand("attributs");
            jPanel.add(jComponent);
        }
        jComponent = new JLabel(this.cfg.titreElement(this.refElement));
        Color color = this.affParent != null ? (this.affParent.elementObligatoire(this.refElement) ? couleurObligatoire : couleurFacultatif) : this.panelEnfants.getForeground();
        jComponent.setForeground(color);
        jPanel.add(jComponent);
        jPanel.setBorder(BorderFactory.createEtchedBorder(0));
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void majPanel(Element element) {
        this.lireEnfants();
        if (this.profondeur > 10) {
            return;
        }
        this.panelEnfants.removeAll();
        this.affEnfants = new ArrayList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        for (Element element2 : this.refEnfantsPossibles) {
            boolean bl = false;
            if (this.enfants != null) {
                int n2 = this.enfants.size();
                for (int i = 0; i < n2; ++i) {
                    Element element3 = this.enfants.get(i);
                    Element element4 = this.cfg.getElementRef(element3);
                    if (element4 != element2) continue;
                    AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element4, element3, this, this.doc);
                    this.affEnfants.add(affichageFormulaire);
                    boolean bl2 = element == null && (i + 1 >= n2 || this.cfg.getElementRef(this.enfants.get(i + 1)) != element4);
                    this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, bl2);
                    bl = true;
                }
            }
            if (bl && element2 != element) continue;
            AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, null, this, this.doc);
            this.affEnfants.add(affichageFormulaire);
            this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, true);
        }
    }

    private void placerAffichage(AffichageFormulaire affichageFormulaire, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, boolean bl) {
        if (affichageFormulaire.avecEnfants()) {
            JPanel jPanel2 = affichageFormulaire.getPanel(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel2, gridBagConstraints);
        } else {
            JPanel jPanel3 = affichageFormulaire.getPanelGauche();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            JPanel jPanel4 = affichageFormulaire.getPanelDroite(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        }
    }

    private String getStringLabelTitre() {
        ArrayList<String> arrayList;
        StringBuilder stringBuilder = new StringBuilder(this.cfg.titreElement(this.refElement));
        if (this.el != null && (arrayList = this.cfg.getParametresElement(this.refElement).get("titreAtt")) != null) {
            for (String string : arrayList) {
                String string2 = this.el.getAttribute(string);
                if ("".equals(string2)) continue;
                stringBuilder.append(" '").append(string2).append("'");
                break;
            }
        }
        return stringBuilder.toString();
    }

    private JPanel getPanelGauche() {
        this.panelGauche = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(new ActionAide(this.refElement));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            jButton.setText("?");
            if ("10.5".compareTo(System.getProperty("os.version")) <= 0) {
                jButton.putClientProperty("JButton.buttonType", "help");
            } else {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            }
        } else {
            jButton.setIcon(new ImageIcon(ImageKeeper.loadImage("images/aide.png")));
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jButton.setBorderPainted(false);
            jButton.setContentAreaFilled(false);
        }
        String string = this.cfg.documentation(this.refElement);
        if (string != null) {
            string = "<html><body>" + string.replaceAll("\n", "<br>") + "</body></html>";
            jButton.setToolTipText(string);
        }
        this.panelGauche.add(jButton);
        if (this.aDesAttributs()) {
            JButton jButton2 = new JButton(iconeAttributs);
            if (System.getProperty("os.name").startsWith("Mac OS") && "10.5".compareTo(System.getProperty("os.version")) > 0) {
                jButton2.putClientProperty("JButton.buttonType", "toolbar");
            } else {
                jButton2.setMargin(new Insets(0, 0, 0, 0));
            }
            jButton2.addActionListener(this);
            jButton2.setActionCommand("attributs");
            this.panelGauche.add(jButton2);
        }
        this.labelTitre = new JLabel(this.getStringLabelTitre());
        if (this.affParent != null) {
            if (this.affParent.elementObligatoire(this.refElement)) {
                this.labelTitre.setForeground(couleurObligatoire);
            } else {
                this.labelTitre.setForeground(couleurFacultatif);
            }
        }
        this.panelGauche.add(this.labelTitre);
        return this.panelGauche;
    }

    private JPanel getPanelDroite(boolean bl) {
        Serializable serializable;
        Object object;
        this.panelDroite = new JPanel(new BorderLayout());
        String string = "";
        if (this.el != null && (object = this.el.getFirstChild()) != null && object.getNodeType() == 3) {
            string = object.getNodeValue();
        }
        if (this.cfg.contientDuTexte(this.refElement)) {
            object = null;
            serializable = null;
            if (this.verif != null) {
                object = this.verif.getBaseType();
                serializable = this.verif.getEnumeration();
            }
            if ("boolean".equals(object)) {
                String string2 = this.cfg.titreElement(this.refElement);
                JCheckBox jCheckBox = new JCheckBox(string2);
                if ("true".equals(string.trim()) || "1".equals(string.trim())) {
                    jCheckBox.setSelected(true);
                }
                jCheckBox.addItemListener(this);
                this.comp = jCheckBox;
            } else if (serializable != null) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>((Collection<String>)((Object)serializable));
                if (!linkedHashSet.contains(string)) {
                    linkedHashSet = new LinkedHashSet<String>(linkedHashSet);
                    linkedHashSet.add(string);
                }
                if (!this.affParent.elementObligatoire(this.refElement) && !linkedHashSet.contains("")) {
                    linkedHashSet.add("");
                }
                ArrayList<String> arrayList = new ArrayList<String>(linkedHashSet.size());
                for (String string3 : linkedHashSet) {
                    arrayList.add(this.cfg.titreValeurElement(this.refElement, string3));
                }
                JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
                jComboBox.setSelectedItem(this.cfg.titreValeurElement(this.refElement, string));
                jComboBox.addItemListener(this);
                this.comp = jComboBox;
            } else {
                ArrayList<String> arrayList = this.doc.cfg.listeValeursSuggereesElement(this.refElement);
                if (arrayList != null && arrayList.size() > 0) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(arrayList);
                    if (!linkedHashSet.contains(string)) {
                        linkedHashSet = new LinkedHashSet<String>(linkedHashSet);
                        linkedHashSet.add(string);
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>(linkedHashSet.size());
                    for (String string4 : linkedHashSet) {
                        arrayList2.add(this.cfg.titreValeurElement(this.refElement, string4));
                    }
                    JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList2.toArray());
                    jComboBox.setEditable(true);
                    jComboBox.setSelectedItem(this.cfg.titreValeurElement(this.refElement, string));
                    jComboBox.addItemListener(this);
                    this.comp = jComboBox;
                } else {
                    JTextField jTextField = new JTextField(string);
                    jTextField.getDocument().addDocumentListener(this);
                    this.comp = jTextField;
                }
            }
            this.panelDroite.add((Component)this.comp, "Center");
            if (this.verif != null && !"".equals(string)) {
                this.setValidite(this.verif.estValide(string));
            }
        }
        if (this.affParent != null && this.affParent.enfantsMultiples(this.refElement)) {
            object = new JPanel(new FlowLayout(1, 0, 0));
            if (bl) {
                serializable = new JButton("+");
                ((AbstractButton)serializable).setAction(new AbstractAction("+"){

                    public void actionPerformed(ActionEvent actionEvent) {
                        AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                    }
                });
                ((Container)object).add((Component)serializable);
            }
            serializable = new JButton("-");
            ((AbstractButton)serializable).setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add((Component)serializable);
            this.panelDroite.add((Component)object, "East");
        }
        this.panelDroite.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        return this.panelDroite;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    private void enregistrerChangement() {
        String string = this.getValeur();
        if (string == null) {
            string = "";
        }
        this.doc.setModif(true);
        if (this.el == null && !"".equals(string)) {
            this.creerElement();
        } else if (this.el != null && "".equals(string) && this.affParent != null) {
            this.effacerElement();
            return;
        }
        if (this.el != null) {
            Node node = this.el.getFirstChild();
            if (node == null) {
                Text text = this.el.getOwnerDocument().createTextNode(string);
                this.el.appendChild(text);
            } else if (node.getNodeType() == 3) {
                node.setNodeValue(string);
            } else {
                LOG.error("AffichageFormulaire.enregistrerChangement : pas de noeud texte pour enregistrer le champ");
            }
        }
        if (this.verif != null) {
            this.setValidite("".equals(string) || this.verif.estValide(string));
        }
    }

    private String getValeur() {
        String string;
        if (this.comp instanceof JTextField) {
            Document document = ((JTextField)this.comp).getDocument();
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                LOG.error("lecture du champ texte", badLocationException);
                return null;
            }
        } else if (this.comp instanceof JCheckBox) {
            string = Boolean.toString(((JCheckBox)this.comp).isSelected());
        } else if (this.comp instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)this.comp;
            string = (String)jComboBox.getSelectedItem();
        } else {
            string = null;
        }
        return string;
    }

    private void setValidite(boolean bl) {
        if (this.comp == null) {
            LOG.error("AffichageFormulaire.setValidite : pas de champ ?");
        }
        if (bl) {
            this.comp.setForeground(Color.black);
        } else {
            this.comp.setForeground(couleurErreur);
        }
    }

    private Element getElement() {
        return this.el;
    }

    private Element getElementRef() {
        return this.refElement;
    }

    private int getProfondeur() {
        return this.profondeur;
    }

    private void creerElement() {
        this.el = JaxeElement.nouvelElementDOM(this.doc, this.refElement);
        Element element = this.affParent.getElement();
        if (element == null) {
            this.affParent.creerElement();
            element = this.affParent.getElement();
            element.appendChild(this.el.getOwnerDocument().createTextNode("\n"));
        }
        Element element2 = this.affParent.trouverSuivant(this.refElement);
        Text text = this.el.getOwnerDocument().createTextNode("\n");
        if (element2 == null) {
            element.appendChild(this.el);
            element.appendChild(text);
        } else {
            element.insertBefore(this.el, element2);
            element.insertBefore(text, element2);
        }
        this.affParent.lireEnfants();
        this.doc.textPane.miseAJourArbre();
    }

    private Element trouverSuivant(Element element) {
        int n = this.refEnfantsPossibles.indexOf(element);
        if (n == this.refEnfantsPossibles.size() - 1) {
            return null;
        }
        if (this.enfants == null) {
            return null;
        }
        for (Element element2 : this.enfants) {
            Element element3 = this.cfg.getElementRef(element2);
            int n2 = this.refEnfantsPossibles.indexOf(element3);
            if (n2 <= n) continue;
            return element2;
        }
        return null;
    }

    private void effacerElement() {
        Node node = this.el.getNextSibling();
        this.affParent.getElement().removeChild(this.el);
        if (node.getNodeType() == 3) {
            this.affParent.getElement().removeChild(node);
        }
        this.el = null;
        this.affParent.testEffacementParent();
        this.doc.textPane.miseAJourArbre();
    }

    private void testEffacementParent() {
        this.lireEnfants();
        if (this.enfants.size() == 0 && this.el != null && this.affParent != null) {
            this.effacerElement();
        }
    }

    private boolean enfantsMultiples(Element element) {
        if (!this.avecSchema) {
            return true;
        }
        if (this.expreg == null) {
            return false;
        }
        String string = this.cfg.titreElement(element);
        String string2 = "(" + this.cfg.titreElement(element) + ")";
        return this.expreg.indexOf(string + "+") != -1 || this.expreg.indexOf(string + "*") != -1 || this.expreg.indexOf(string2 + "+") != -1 || this.expreg.indexOf(string2 + "*") != -1;
    }

    private boolean elementObligatoire(Element element) {
        if (!this.avecSchema) {
            return false;
        }
        if (this.expreg == null) {
            return false;
        }
        String string = this.cfg.titreElement(element);
        String string2 = "(" + this.cfg.titreElement(element) + ")";
        return this.expreg.indexOf(string + "?") == -1 && this.expreg.indexOf(string + "*") == -1 && this.expreg.indexOf(string2 + "?") == -1 && this.expreg.indexOf(string2 + "*") == -1;
    }

    private boolean aDesAttributs() {
        ArrayList<Element> arrayList = this.cfg.listeAttributs(this.refElement);
        return arrayList != null && arrayList.size() > 0;
    }

    private void ajouterAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        this.majPanel(affichageFormulaire.getElementRef());
    }

    private void retirerAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        if (affichageFormulaire.getElement() != null) {
            affichageFormulaire.effacerElement();
        }
        this.majPanel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("attributs".equals(string)) {
            this.afficherDialogueAttributs();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enregistrerChangement();
    }

    public void afficherDialogueAttributs() {
        boolean bl;
        if (this.el == null) {
            this.creerElement();
            bl = true;
        } else {
            bl = false;
        }
        DialogueAttributs dialogueAttributs = new DialogueAttributs(this.doc.jframe, this.doc, this.cfg.titreElement(this.refElement), this.refElement, this.el);
        if (dialogueAttributs.afficher()) {
            dialogueAttributs.enregistrerReponses();
            if (this.labelTitre != null) {
                this.labelTitre.setText(this.getStringLabelTitre());
            }
        } else if (bl) {
            this.effacerElement();
        }
        dialogueAttributs.dispose();
    }

    public Point getPointEnfant(Element element) {
        if (this.el == element) {
            return this.getPoint();
        }
        if (this.affEnfants != null) {
            for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
                Point point = affichageFormulaire.getPointEnfant(element);
                if (point == null) continue;
                Point point2 = this.getPoint();
                if (point2 != null) {
                    point.translate(point2.x, point2.y);
                }
                return point;
            }
        }
        return null;
    }

    public Point getPoint() {
        if (this.panelElement != null) {
            return this.panelElement.getLocation();
        }
        if (this.panelGauche != null) {
            return this.panelGauche.getLocation();
        }
        return null;
    }

    public void selection(boolean bl) {
        if (bl) {
            this.panelEnfants.setBackground(JaxeElement.getMonBoutonCouleurs()[0][1]);
        } else {
            this.panelEnfants.setBackground(null);
        }
    }

    public void majAffichage() {
    }

    class ActionAide
    extends AbstractAction {
        Element refElement;

        ActionAide(Element element) {
            this.refElement = element;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DialogueAideElement dialogueAideElement = new DialogueAideElement(this.refElement, AffichageFormulaire.this.cfg.getRefConf(this.refElement), (JFrame)((AffichageFormulaire)AffichageFormulaire.this).doc.textPane.getTopLevelAncestor());
            dialogueAideElement.setVisible(true);
        }
    }
}

