/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import javax.xml.parsers.SAXParserFactory;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SVGUserAgent
extends UserAgentAdapter {
    private AffineTransform currentTransform = null;
    private float pixelUnitToMillimeter = 0.0f;
    private Log logger = LogFactory.getLog(SVGUserAgent.class);

    public SVGUserAgent(float pixelUnitToMM, AffineTransform at) {
        this.pixelUnitToMillimeter = pixelUnitToMM;
        this.currentTransform = at;
    }

    protected final Log getLogger() {
        return this.logger;
    }

    public void displayError(String message) {
        this.logger.error(message);
    }

    public void displayError(Exception ex) {
        this.logger.error("SVG Error" + ex.getMessage(), ex);
    }

    public void displayMessage(String message) {
        this.logger.info(message);
    }

    public void showAlert(String message) {
        this.logger.warn(message);
    }

    public float getPixelUnitToMillimeter() {
        return this.pixelUnitToMillimeter;
    }

    public String getLanguages() {
        return "en";
    }

    public String getMedia() {
        return "print";
    }

    public String getUserStyleSheetURI() {
        return null;
    }

    public String getXMLParserClassName() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            return factory.newSAXParser().getXMLReader().getClass().getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    public AffineTransform getTransform() {
        return this.currentTransform;
    }

    public Dimension2D getViewportSize() {
        return new Dimension(100, 100);
    }
}

