/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.ImageRawCCITTFaxAdapter;
import org.apache.fop.render.pdf.PDFImageHandler;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;

public class PDFImageHandlerRawCCITTFax
implements PDFImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_CCITTFAX};

    public PDFXObject generateImage(RendererContext context, Image image, Point origin, Rectangle pos) throws IOException {
        PDFRenderer renderer = (PDFRenderer)context.getRenderer();
        ImageRawCCITTFax ccitt = (ImageRawCCITTFax)image;
        PDFDocument pdfDoc = (PDFDocument)context.getProperty("pdfDoc");
        PDFResourceContext resContext = (PDFResourceContext)context.getProperty("pdfContext");
        ImageRawCCITTFaxAdapter pdfimage = new ImageRawCCITTFaxAdapter(ccitt, image.getInfo().getOriginalURI());
        PDFImageXObject xobj = pdfDoc.addImage(resContext, pdfimage);
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        renderer.placeImage(x, y, w, h, xobj);
        return xobj;
    }

    public int getPriority() {
        return 100;
    }

    public Class getSupportedImageClass() {
        return ImageRawCCITTFax.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }
}

