/*
 * Decompiled with CFR 0.152.
 */
package jaxeuved.fmsware;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jaxeuved.fmsware.LZWEncoder;
import jaxeuved.fmsware.NeuQuant;

public class AnimatedGifEncoder {
    protected int width;
    protected int height;
    protected Color transparent = null;
    protected int transIndex;
    protected int repeat = -1;
    protected int delay = 0;
    protected boolean started = false;
    protected OutputStream out;
    protected BufferedImage image;
    protected byte[] pixels;
    protected byte[] indexedPixels;
    protected int colorDepth;
    protected byte[] colorTab;
    protected boolean[] usedEntry = new boolean[256];
    protected int palSize = 7;
    protected int dispose = -1;
    protected boolean closeStream = false;
    protected boolean firstFrame = true;
    protected boolean sizeSet = false;
    protected int sample = 10;
    protected int[] position = null;
    protected byte[] gct;

    public void setDelay(int n) {
        this.delay = Math.round((float)n / 10.0f);
    }

    public void setDispose(int n) {
        if (n >= 0) {
            this.dispose = n;
        }
    }

    public void setRepeat(int n) {
        if (n >= 0) {
            this.repeat = n;
        }
    }

    public void setTransparent(Color color) {
        this.transparent = color;
    }

    public void setGct(byte[] byArray) {
        this.gct = byArray;
    }

    public void setTransparentIndex(int n) {
        this.transIndex = n;
    }

    public boolean addFrame(BufferedImage bufferedImage) {
        if (bufferedImage == null || !this.started) {
            return false;
        }
        boolean bl = true;
        try {
            if (!this.sizeSet) {
                this.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
            }
            this.image = bufferedImage;
            this.getImagePixels();
            this.analyzePixels();
            if (this.firstFrame) {
                this.writeLSD();
                this.writePalette();
                if (this.repeat >= 0) {
                    this.writeNetscapeExt();
                }
            }
            this.writeGraphicCtrlExt();
            this.writeImageDesc();
            if (!this.firstFrame && this.gct == null) {
                this.writePalette();
            }
            this.writePixels();
            this.firstFrame = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public boolean addFrame(BufferedImage bufferedImage, int[] nArray) {
        this.position = nArray;
        return this.addFrame(bufferedImage);
    }

    public boolean finish() {
        if (!this.started) {
            return false;
        }
        boolean bl = true;
        this.started = false;
        try {
            this.out.write(59);
            this.out.flush();
            if (this.closeStream) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.transIndex = 0;
        this.out = null;
        this.image = null;
        this.pixels = null;
        this.indexedPixels = null;
        this.colorTab = null;
        this.closeStream = false;
        this.firstFrame = true;
        return bl;
    }

    public void setFrameRate(float f) {
        if (f != 0.0f) {
            this.delay = Math.round(100.0f / f);
        }
    }

    public void setQuality(int n) {
        if (n < 1) {
            n = 1;
        }
        this.sample = n;
    }

    public void setSize(int n, int n2) {
        if (this.started && !this.firstFrame) {
            return;
        }
        this.width = n;
        this.height = n2;
        if (this.width < 1) {
            this.width = 320;
        }
        if (this.height < 1) {
            this.height = 240;
        }
        this.sizeSet = true;
    }

    public boolean start(OutputStream outputStream) {
        if (outputStream == null) {
            return false;
        }
        boolean bl = true;
        this.closeStream = false;
        this.out = outputStream;
        try {
            this.writeString("GIF89a");
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    public boolean start(String string) {
        boolean bl = true;
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(string));
            bl = this.start(this.out);
            this.closeStream = true;
        }
        catch (IOException iOException) {
            bl = false;
        }
        this.started = bl;
        return this.started;
    }

    protected void analyzePixels() {
        int n = this.pixels == null ? this.image.getWidth() * this.image.getHeight() * 3 : this.pixels.length;
        int n2 = n / 3;
        if (this.gct != null) {
            this.colorTab = this.gct;
            if (this.image.getColorModel() instanceof IndexColorModel) {
                this.indexedPixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
            } else {
                int[] nArray = this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), null, 0, this.image.getWidth());
                boolean bl = false;
                this.indexedPixels = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray[i];
                    int n4 = n3 >> 24 & 0xFF;
                    int n5 = n3 >> 16 & 0xFF;
                    int n6 = n3 >> 8 & 0xFF;
                    int n7 = n3 & 0xFF;
                    int n8 = this.findClosest(n4, n5, n6, n7);
                    this.indexedPixels[i] = (byte)n8;
                }
            }
        } else if (this.image.getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)this.image.getColorModel();
            int n9 = indexColorModel.getMapSize();
            byte[] byArray = new byte[n9];
            indexColorModel.getReds(byArray);
            byte[] byArray2 = new byte[n9];
            indexColorModel.getGreens(byArray2);
            byte[] byArray3 = new byte[n9];
            indexColorModel.getBlues(byArray3);
            this.colorTab = new byte[byArray.length * 3];
            int n10 = 0;
            for (int i = 0; i < byArray.length; ++i) {
                this.colorTab[n10++] = byArray[i];
                this.colorTab[n10++] = byArray2[i];
                this.colorTab[n10++] = byArray3[i];
            }
            this.indexedPixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        } else {
            int n11;
            int n12;
            this.indexedPixels = new byte[n2];
            NeuQuant neuQuant = new NeuQuant(this.pixels, n, this.sample);
            this.colorTab = neuQuant.process();
            for (n12 = 0; n12 < this.colorTab.length; n12 += 3) {
                n11 = this.colorTab[n12];
                this.colorTab[n12] = this.colorTab[n12 + 2];
                this.colorTab[n12 + 2] = n11;
                this.usedEntry[n12 / 3] = false;
            }
            n12 = 0;
            for (n11 = 0; n11 < n2; ++n11) {
                int n13 = neuQuant.map(this.pixels[n12++] & 0xFF, this.pixels[n12++] & 0xFF, this.pixels[n12++] & 0xFF);
                this.usedEntry[n13] = true;
                this.indexedPixels[n11] = (byte)n13;
            }
            if (this.transparent != null) {
                this.transIndex = this.findClosest(this.transparent);
            }
        }
        this.pixels = null;
        this.colorDepth = 8;
        this.palSize = 7;
    }

    protected int findClosest(int n, int n2, int n3, int n4) {
        if (this.colorTab == null) {
            return -1;
        }
        int n5 = 0;
        int n6 = 0x1000000;
        int n7 = this.colorTab.length;
        for (int i = 0; i < n7; ++i) {
            int n8 = n2 - (this.colorTab[i++] & 0xFF);
            int n9 = n3 - (this.colorTab[i++] & 0xFF);
            int n10 = n4 - (this.colorTab[i] & 0xFF);
            int n11 = n8 * n8 + n9 * n9 + n10 * n10;
            int n12 = i / 3;
            if (!(n == 0 && n12 == this.transIndex || n == 255 && n12 != this.transIndex) && (n == 0 || n == 255) || n11 >= n6) continue;
            n6 = n11;
            n5 = n12;
        }
        return n5;
    }

    protected int findClosest(Color color) {
        if (this.colorTab == null) {
            return -1;
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 0;
        int n5 = 0x1000000;
        int n6 = this.colorTab.length;
        for (int i = 0; i < n6; ++i) {
            int n7 = n - (this.colorTab[i++] & 0xFF);
            int n8 = n2 - (this.colorTab[i++] & 0xFF);
            int n9 = n3 - (this.colorTab[i] & 0xFF);
            int n10 = n7 * n7 + n8 * n8 + n9 * n9;
            int n11 = i / 3;
            if (!this.usedEntry[n11] || n10 >= n5) continue;
            n5 = n10;
            n4 = n11;
        }
        return n4;
    }

    protected void getImagePixels() {
        int n;
        int n2;
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        if (this.position == null) {
            n2 = this.width;
            n = this.height;
        } else {
            n2 = this.position[2];
            n = this.position[3];
        }
        int n5 = this.image.getType();
        if (this.gct != null || this.image.getColorModel() instanceof IndexColorModel) {
            this.pixels = null;
        } else {
            if (n3 != n2 || n4 != n || n5 != 5) {
                BufferedImage bufferedImage = new BufferedImage(n2, n, 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage((Image)this.image, 0, 0, null);
                this.image = bufferedImage;
            }
            this.pixels = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        }
    }

    protected void writeGraphicCtrlExt() throws IOException {
        int n;
        int n2;
        this.out.write(33);
        this.out.write(249);
        this.out.write(4);
        if (this.transparent == null) {
            n2 = 0;
            n = 0;
        } else {
            n2 = 1;
            n = 2;
        }
        if (this.dispose >= 0) {
            n = this.dispose & 7;
        }
        this.out.write(0 | (n <<= 2) | 0 | n2);
        this.writeShort(this.delay);
        this.out.write(this.transIndex);
        this.out.write(0);
    }

    protected void writeImageDesc() throws IOException {
        this.out.write(44);
        if (this.position == null) {
            this.writeShort(0);
            this.writeShort(0);
            this.writeShort(this.width);
            this.writeShort(this.height);
        } else {
            this.writeShort(this.position[0]);
            this.writeShort(this.position[1]);
            this.writeShort(this.position[2]);
            this.writeShort(this.position[3]);
        }
        if (this.firstFrame || this.gct != null) {
            this.out.write(0);
        } else {
            this.out.write(0x80 | this.palSize);
        }
    }

    protected void writeLSD() throws IOException {
        this.writeShort(this.width);
        this.writeShort(this.height);
        this.out.write(0xF0 | this.palSize);
        this.out.write(0);
        this.out.write(0);
    }

    protected void writeNetscapeExt() throws IOException {
        this.out.write(33);
        this.out.write(255);
        this.out.write(11);
        this.writeString("NETSCAPE2.0");
        this.out.write(3);
        this.out.write(1);
        this.writeShort(this.repeat);
        this.out.write(0);
    }

    protected void writePalette() throws IOException {
        this.out.write(this.colorTab, 0, this.colorTab.length);
        int n = 768 - this.colorTab.length;
        for (int i = 0; i < n; ++i) {
            this.out.write(0);
        }
    }

    protected void writePixels() throws IOException {
        int n;
        int n2;
        if (this.position == null) {
            n2 = this.width;
            n = this.height;
        } else {
            n2 = this.position[2];
            n = this.position[3];
        }
        LZWEncoder lZWEncoder = new LZWEncoder(n2, n, this.indexedPixels, this.colorDepth);
        lZWEncoder.encode(this.out);
    }

    protected void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
    }

    protected void writeString(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.out.write((byte)string.charAt(i));
        }
    }
}

