<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- ************************************************ -->
    <!-- creation de la page des ressources pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->

    <xsl:template name="UVED_RESSOURCES">
    
        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'ressources.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource" />
                    <body>
                        <xsl:call-template name="bodyheaderRessource" />
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-section">
                                <h3>Ressources</h3>
                            </div>
                            <div class="plan-chapitre">
                                <h4>Vous trouverez ici toutes les ressources du cours :</h4>
                                <ol>
                                    <xsl:if
                                        test="count(UVED//MOTDUGLOSSAIRE)>0">
                                        <li><a href="glossaire.html">Glossaire</a></li>
                                    </xsl:if>
    
                                    <xsl:if
                                        test="count(UVED//REFERENCEBIBLIOGRAPHIQUE)>0">
                                        <li><a href="bibliographie.html">Bibliographie</a></li>
                                    </xsl:if>
    
                                    <xsl:if
                                        test="count(UVED//REFERENCEWEBOGRAPHIQUE)>0">
                                        <li>
                                            <a href="webographie.html">
                                                Webographie
                                            </a>
                                        </li>
                                    </xsl:if>
    
                                </ol>
                            </div>
                        </div>
                        <xsl:call-template name="footerRessource">
                            <xsl:with-param name="pageActive">ressources</xsl:with-param>
                        </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
