<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- ************************************************ -->
<!-- creation de la prsentation (index) pour les cours UVED -->
<!-- ************************************************ -->
<!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->

<!-- dclaration des variables globales -->
<xsl:template name= "UVED_PRESENTATION">

    <xsl:call-template name="ecrireDansFichier">
        <xsl:with-param name="fichier" select="concat($cheminSite,'index.html')"/>
        <xsl:with-param name="contenu">
           <html lang="fr">
            
               <xsl:call-template name="headerPresentation" />
               <body>
               <xsl:call-template name="bodyheaderRessource" />
               
               <!-- CONTENT -->
            
                    
                <div id="content" class="presentation"> <a name="top"></a> 
                 <div class="titre-section"> 
                  <h3>Pr&#xe9;sentation</h3>
                 </div>
            
                 <xsl:call-template name="ligneancres" />
            
                 <xsl:for-each select="/UVED/CONTENUS/PRESENTATION/node()">
                     <xsl:choose>
                         <xsl:when test="name(current())='CARACTERISTIQUE'">
                             <xsl:call-template name="blocpresentation">
                                 <xsl:with-param name="titre" select="'Caract&#xe9;ristiques'"/>
                                 <xsl:with-param name="ancre" select="'A'"/>
                             </xsl:call-template>
                         </xsl:when>
                         <xsl:when test="name(current())='FINALITE'">
                             <xsl:call-template name="blocpresentation">
                                 <xsl:with-param name="titre" select="'Finalit&#xe9;s'"/>
                                 <xsl:with-param name="ancre" select="'B'"/>
                             </xsl:call-template>
                         </xsl:when>
                         <xsl:when test="name(current())='CONTENU'">
                             <xsl:call-template name="blocpresentation">
                                 <xsl:with-param name="titre" select="'Contenu'"/>
                                 <xsl:with-param name="ancre" select="'C'"/>
                             </xsl:call-template>
                         </xsl:when>
                         <xsl:when test="name(current())='PARAGRAPHE'">
                             <xsl:call-template name="blocpresentation">
                                 <xsl:with-param name="titre" select="@titre"/>
                                 <xsl:with-param name="ancre" select="''"/>
                             </xsl:call-template>
                         </xsl:when>
                     </xsl:choose>
                 </xsl:for-each>
                </div>
                <!-- DIV en ALT -->
                <xsl:variable name="idElement" select="generate-id(/UVED/CONTENUS/PRESENTATION)"/>
                <xsl:variable name="idElementSuivant" select="generate-id(/UVED/CONTENUS/CHAPITRE[1])"/>
                <xsl:call-template name="divInvisibles">
                   <xsl:with-param name="idElement" select="$idElement"/>
                   <xsl:with-param name="idElementSuivant" select="$idElementSuivant"/>
                </xsl:call-template>
                <xsl:call-template name="footerRessource" />
               </body>
            </html>
        </xsl:with-param>
    </xsl:call-template>
</xsl:template>

<!-- ************************************************ -->
<!-- Bloc Caracteristiques -->
<!-- ************************************************ -->
<xsl:template name="blocpresentation">
    <xsl:param name="titre"/>
    <xsl:param name="ancre"/>

  <div class="bloc-standard"> <a name="{$ancre}"><xsl:value-of select="''"/></a> 
    <h5><xsl:value-of select="$titre"/></h5>
    <p><xsl:apply-templates/></p>
  </div>
  <div class="haut-page"><a href="#top"><span>haut de page</span></a></div>
  
</xsl:template>

<!-- ************************************************ -->
<!-- creation des ancres-->
<!-- ************************************************ -->
<xsl:template name = "ligneancres">
  <div class="navigation"> 
    <ul>
        <xsl:if test="count(/UVED/CONTENUS/PRESENTATION/CARACTERISTIQUE)>0">
            <li><a href="#A">Caract&#xe9;ristiques</a></li>
        </xsl:if>
        <xsl:if test="count(/UVED/CONTENUS/PRESENTATION/FINALITE)>0">
            <li><a href="#B">Finalit&#xe9;s</a></li>
        </xsl:if>
        <xsl:if test="count(/UVED/CONTENUS/PRESENTATION/CONTENU)>0">
            <li><a href="#C">Contenu</a></li>
        </xsl:if>
    </ul>
  </div>

</xsl:template>

<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="divInvisibles">
   <xsl:param name="idElement"/>
   <xsl:param name="idElementSuivant"/>
   
   <!-- Position Element -->
   <xsl:variable name="positionElement"><xsl:call-template name="positionElement">
   <xsl:with-param name="idElement" select="$idElement"/>
   </xsl:call-template></xsl:variable>
   <!-- Position Element Suivant-->
   <xsl:variable name="positionElementSuivant"><xsl:call-template name="positionElement">
   <xsl:with-param name="idElement" select="$idElementSuivant"/>
   </xsl:call-template></xsl:variable>
   
   <!-- Prendre tous les nodes entre ces 2 positions -->
   <xsl:for-each select="//node()">
       <xsl:if test="position()>number($positionElement) and not(position()>number($positionElementSuivant))">
           <xsl:if test="name()='MOTDUGLOSSAIRE' or name()='LIENMOTDUGLOSSAIRE' or name()='REFERENCEBIBLIOGRAPHIQUE' or name()='LIENREFERENCEBIBLIOGRAPHIQUE' or name()='REFERENCEWEBOGRAPHIQUE' or name()='LIENREFERENCEWEBOGRAPHIQUE'">
               <xsl:apply-templates select="." mode="div"/>
           </xsl:if>
       </xsl:if>
   </xsl:for-each>
     
</xsl:template>

<xsl:template name="positionElement">
   <xsl:param name="idElement"/>
   <xsl:for-each select="//node()">
       <xsl:if test="generate-id(current())=$idElement">
               <xsl:value-of select="position()"/>
       </xsl:if>
   </xsl:for-each>   
</xsl:template>


</xsl:stylesheet>
