<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        version="2.0"
        xmlns:saxon="http://icl.com/saxon"
        xmlns:xalanredirect="http://xml.apache.org/xalan/redirect"
        xmlns:lxslt="http://xml.apache.org/xslt"
        xmlns:exsl="http://exslt.org/common"
        extension-element-prefixes="saxon xalanredirect lxslt exsl">

    <!-- ************************************************ -->
    <!-- templates outils pour le XSL -->
    <!-- ************************************************ -->
    <!-- version 0.1 Damien Guillaume - Observatoire de Paris -->

    <xsl:param name="output.encoding" select="'ISO-8859-1'"/>
    <xsl:param name="output.indent" select="'no'"/>

    <!-- Ecriture dans un fichier 
        paramtres:
            fichier: chemin relatif du fichier dans lequel on veut crire
            contenu: contenu  crire dans le fichier
    -->
    <xsl:template name="ecrireDansFichier">
        <xsl:param name="fichier"/>
        <xsl:param name="contenu"/>
        <xsl:param name="method"><xsl:choose>
            <xsl:when test="translate(substring($fichier, string-length($fichier)-4, 4), 'XML', 'xml') = '.xml'">xml</xsl:when>
            <xsl:otherwise>html</xsl:otherwise>
        </xsl:choose></xsl:param>
        <xsl:choose>
            <xsl:when test="element-available('xalanredirect:write')">
            <!-- Xalan gre les chemins relatifs mais pas XSLTC -->
                <xalanredirect:write file="{$fichier}">
                    <xsl:copy-of select="$contenu"/>
                </xalanredirect:write>
            </xsl:when>
            
            <xsl:when test="element-available('exsl:document')">
                <exsl:document href="{$fichier}"
                         method="{$method}"
                         encoding="{$output.encoding}"
                         indent="{$output.indent}">
                    <xsl:copy-of select="$contenu"/>
                </exsl:document>
            </xsl:when>
            
            <xsl:when test="element-available('saxon:output')">
                <saxon:output href="{$fichier}"
                        method="{$method}"
                        encoding="{$output.encoding}"
                        indent="{$output.indent}">
                    <xsl:copy-of select="$contenu"/>
                </saxon:output>
            </xsl:when>
            
            <xsl:when test="element-available('xsl:result-document')">
                <xsl:result-document href="{$fichier}"
                        method="{$method}">
                    <xsl:copy-of select="$contenu"/>
                </xsl:result-document>
            </xsl:when>

            <xsl:otherwise>
                <xsl:message terminate="yes">
                    <xsl:text>Impossible de crer un fichier avec le processeur XSLT </xsl:text>
                    <xsl:value-of select="system-property('xsl:vendor')"/>
                </xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>
