<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:copie="http://xml.apache.org/xalan/java/jaxeuved.CopieFichiers"
        exclude-result-prefixes="copie">
<xsl:output 
      method="html"
      encoding="ISO-8859-1"
      doctype-system="http://www.w3.org/TR/html4/strict.dtd"
      doctype-public="-//W3C//DTD HTML 4.01//EN" 
      indent="yes" />
      
 <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
 <!-- version 0.2 Damien Guillaume  - Observatoire de Paris -->
 
    <!-- include des lments HTML fixes -->
    <xsl:include href="./UVED_HTML.xsl" />
    <xsl:include href="./UVED_CREDITS.xsl" />
    <xsl:include href="./UVED_ANNEXE.xsl" />
    <xsl:include href="./UVED_BIBLIOGRAPHIE.xsl" />
    <xsl:include href="./UVED_COURS.xsl" />
    <xsl:include href="./UVED_GLOSSAIRE.xsl" />
    <xsl:include href="./UVED_PRESENTATION.xsl" />
    <xsl:include href="./UVED_RESSOURCES.xsl" />
    <xsl:include href="./UVED_SOMMAIRE.xsl" />
    <xsl:include href="./UVED_WEBOGRAPHIE.xsl" />
    <xsl:include href="./UVED_AIDEQCM.xsl" />

    <!-- dclaration des variables globales -->
    <xsl:param name="chainEditPath"/>
    <xsl:param name="jaxe-fichier-xml"/>  <!-- chemin complet vers le fichier XML quand il est dit avec Jaxe -->

    <!-- sparateur de chemins ( / ou \ ) -->
    <xsl:variable name="sep"><xsl:choose>
        <xsl:when test="contains($jaxe-fichier-xml, '\')">\</xsl:when>
        <xsl:otherwise>/</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <!-- chemin du rpertoire du fichier XML si jaxe-fichier-xml est utilis -->
    <xsl:variable name="chemin-jaxe-xml"><xsl:if test="$jaxe-fichier-xml!=''"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="$jaxe-fichier-xml"/></xsl:call-template></xsl:if></xsl:variable>
    
    <xsl:variable name="racine"><xsl:choose>
        <xsl:when test="/UVED/CONTENUS">..</xsl:when>
        <xsl:when test="/UVED/CHAPITRE">../..</xsl:when>
        <xsl:when test="/UVED/PARTIE">../../..</xsl:when>
        <xsl:when test="/UVED/SOUSPARTIE">../../..</xsl:when>
        <xsl:otherwise>.</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <xsl:variable name="cheminSite"><xsl:choose>
        <xsl:when test="$jaxe-fichier-xml!=''"><xsl:value-of select="concat($chemin-jaxe-xml, $sep, translate($racine,'/',$sep), $sep, 'site', $sep, 'html', $sep)"/></xsl:when>
        <xsl:otherwise><xsl:value-of select="concat($chainEditPath, '../site/html/')"/></xsl:otherwise>
    </xsl:choose></xsl:variable>

    <xsl:template match="/">

    <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page des crdits</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_CREDITS"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page des crdits</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page des ressources</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_RESSOURCES"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page des ressources</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page bibliographie</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_BIBLIOGRAPHIE"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page bibliographie</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page webographie</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_WEBOGRAPHIE"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page webographie</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page glossaire</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_GLOSSAIRE"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page glossaire</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page sommaire</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_SOMMAIRE"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page sommaire</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration de la page prsentation</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_PRESENTATION"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration de la page prsentation</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration des pages d'annexes</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_ANNEXE"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration  des pages d'annexes</xsl:text>
    </xsl:message>

   <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration des pages de cours</xsl:text>
    </xsl:message>
    <xsl:call-template name="UVED_COURS"/>
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration des pages de cours</xsl:text>
    </xsl:message>

    <xsl:message terminate="no">
         <xsl:text>UVED : Dbut de la cration des pages d'aide pour les QCMs</xsl:text>
    </xsl:message>
    <xsl:call-template name="fichiers-aide" /> 
    <xsl:message terminate="no">
         <xsl:text>UVED : Fin de la cration des pages d'aide pour les QCMs</xsl:text>
    </xsl:message>

    <xsl:if test="$jaxe-fichier-xml!='' and function-available('copie:copieFichier')">
        <xsl:message terminate="no">
             <xsl:text>UVED : Copie des fichiers de ressources</xsl:text>
        </xsl:message>
        <xsl:for-each select="//FICHIER">
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@chemin,'/',$sep), $cheminSite)"/>
        </xsl:for-each>
        <xsl:for-each select="//EQUAJAXE|//EQUATEX">
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@image,'/',$sep), $cheminSite)"/>
        </xsl:for-each>
        <xsl:for-each select="//LIENDOCUMENT[not(starts-with(@url,'http:')) and not(contains(@url,'..'))]">
            <xsl:value-of select="copie:copieFichier(ancestor::*[@dossier][1]/@dossier, translate(@url,'/',$sep), $cheminSite)"/>
        </xsl:for-each>
        <xsl:message terminate="no">
             <xsl:text>UVED : Fin de la copie des fichiers de ressources</xsl:text>
        </xsl:message>
    </xsl:if>

    <html>
    <head><title>Cours UVED</title></head>
    <body>
        <p><a href="{$racine}/site/html/index.html">Prsentation</a></p>
        <p><a href="{$racine}/site/html/{//CHAPITRE[1]/@label}.html">Cours</a></p>
    </body>
    </html>
    
   </xsl:template>

<!-- ************************************************ -->
<!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet vers le fichier -->
<!-- ************************************************ -->
    <xsl:template name="repfichier">
        <xsl:param name="chemin"/>
        <xsl:choose>
            <xsl:when test="contains($chemin,$sep) and contains(substring-after($chemin,$sep),$sep)">
                <xsl:value-of select="substring-before($chemin,$sep)"/><xsl:value-of select="$sep"/><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="substring-after($chemin,$sep)"/></xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="substring-before($chemin,$sep)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>