<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- ************************************************ -->
<!-- Gnration du cours UVED-->
<!-- ************************************************ -->
<!-- version 0.3 Romuald Lorthioir et Nadia Henry - CIRM - Universit de Rennes 1 -->

<!-- ************************************************ -->
<!-- Traitement des pages de cours UVED-->
<!-- ************************************************ -->
<xsl:template name="UVED_COURS">

   <xsl:variable name="plan"><xsl:call-template name="sommairePage"/></xsl:variable>
   <xsl:variable name="nbchapitres"><xsl:call-template name="nbchapitres"/></xsl:variable>
   
   <xsl:for-each select="UVED//CHAPITRE">
       <xsl:variable name="labelchapitre" select="./@label"/>
       <xsl:variable name="idElement" select="generate-id(current())"/>
       <!-- Precedent -->
       <xsl:variable name="labelprecedent" ><xsl:call-template name="precedentchapitre"/></xsl:variable>
       <!-- Suivant -->
       <xsl:variable name="labelsuivant" ><xsl:call-template name="suivantchapitre"/></xsl:variable>

       <xsl:call-template name="page" >
           <xsl:with-param name="idPage" select="''"/>
           <xsl:with-param name="nomFichier" select="$labelchapitre"/>
           <xsl:with-param name="pagePrecedente" select="$labelprecedent"/>
           <xsl:with-param name="pageSuivante" select="$labelsuivant"/>
           <xsl:with-param name="plan" select="$plan"/>
           <xsl:with-param name="idElement" select="$idElement"/>
       </xsl:call-template>
       
       <xsl:for-each select="./SAUTPAGEHTML">
       <xsl:variable name="idElement" select="generate-id(current())"/>
       <xsl:variable name="labelpage" select="concat(ancestor::CHAPITRE/@label,'_',position())"/>
           <!-- Precedent -->
       <xsl:variable name="labelprecedent" ><xsl:call-template name="precedent"/></xsl:variable>
           <!-- Suivant -->
       <xsl:variable name="labelsuivant" ><xsl:call-template name="suivant"/></xsl:variable>
       <xsl:variable name="idPage" ><xsl:call-template name="getIdPage">
       </xsl:call-template></xsl:variable>
       
           <xsl:call-template name="page" >
               <xsl:with-param name="idPage" select="$idPage"/>
               <xsl:with-param name="nomFichier" select="$labelpage"/>
               <xsl:with-param name="pagePrecedente" select="$labelprecedent"/>
               <xsl:with-param name="pageSuivante" select="$labelsuivant"/>
               <xsl:with-param name="plan" select="$plan"/>
               <xsl:with-param name="idElement" select="$idElement"/>
           </xsl:call-template>
       
       </xsl:for-each>
       <xsl:for-each select="./PARTIE">
           <xsl:for-each select="./SAUTPAGEHTML">
               <xsl:variable name="idElement" select="generate-id(current())"/>
               <xsl:variable name="labelpage" select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',position())"/>
               <!-- Precedent -->
               <xsl:variable name="labelprecedent" ><xsl:call-template name="precedent"/></xsl:variable>
               <!-- Suivant -->
               <xsl:variable name="labelsuivant" ><xsl:call-template name="suivant"/></xsl:variable>
               <xsl:variable name="idPage" ><xsl:call-template name="getIdPage">
               </xsl:call-template></xsl:variable>
       
               <xsl:call-template name="page" >
                  <xsl:with-param name="idPage" select="$idPage"/>
                  <xsl:with-param name="nomFichier" select="$labelpage"/>
                  <xsl:with-param name="pagePrecedente" select="$labelprecedent"/>
                  <xsl:with-param name="pageSuivante" select="$labelsuivant"/>
                  <xsl:with-param name="plan" select="$plan"/>
                  <xsl:with-param name="idElement" select="$idElement"/>
              </xsl:call-template>
           </xsl:for-each>

           <xsl:for-each select="./SOUSPARTIE">
               <xsl:for-each select="./SAUTPAGEHTML">
                   <xsl:variable name="idElement" select="generate-id(current())"/>
                   <xsl:variable name="labelpage" select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',ancestor::SOUSPARTIE/@label,'_',position())"/>
                   <!-- Precedent -->
                   <xsl:variable name="labelprecedent" ><xsl:call-template name="precedent"/></xsl:variable>
                   <!-- Suivant -->
                   <xsl:variable name="labelsuivant" ><xsl:call-template name="suivant"/></xsl:variable>
                   <xsl:variable name="idPage" ><xsl:call-template name="getIdPage"><xsl:with-param name="labelchapitre" select="ancestor::CHAPITRE/@label"/>
                   </xsl:call-template></xsl:variable>
       
                   <xsl:call-template name="page" >
                       <xsl:with-param name="idPage" select="$idPage"/>
                       <xsl:with-param name="nomFichier" select="$labelpage"/>
                       <xsl:with-param name="pagePrecedente" select="$labelprecedent"/>
                       <xsl:with-param name="pageSuivante" select="$labelsuivant"/>
                       <xsl:with-param name="plan" select="$plan"/>
                       <xsl:with-param name="idElement" select="$idElement"/>
                   </xsl:call-template>
               </xsl:for-each>
           </xsl:for-each>

       </xsl:for-each>
    </xsl:for-each>
   
</xsl:template>


<!-- ************************************************ -->
<!-- Gnration d'une page de cours UVED-->
<!-- ************************************************ -->
<xsl:template name="page">
    <xsl:param name="idPage"/>
    <xsl:param name="nomFichier"/>
    <xsl:param name="pagePrecedente"/>
    <xsl:param name="pageSuivante"/>
    <xsl:param name="plan"/>
    <xsl:param name="idElement"/>
     
    <!-- Prparation des variable pour les liens entre pages --> 
    <xsl:variable name="cheminNomFichier" select="concat($cheminSite,$nomFichier,'.html')"/>
    <xsl:variable name="cheminPagePrecedente" select="concat($pagePrecedente,'.html')"/>
    <xsl:variable name="cheminPageSuivante" select="concat($pageSuivante,'.html')"/>
    <xsl:variable name="idElementSuivant"><xsl:call-template name="getIdsuivant">
    <xsl:with-param name="idSautPageHtml" select="$idElement"/>
    </xsl:call-template></xsl:variable>
    
    <!-- Cration du fichier de la page -->
    <xsl:call-template name="ecrireDansFichier">
    <xsl:with-param name="fichier" select="$cheminNomFichier"/>
    <xsl:with-param name="contenu">
     <html lang="fr">
          <xsl:call-template name="headerPage" >
              <xsl:with-param name="idPage" select="$idPage"/>
          </xsl:call-template>
          <body>
              <xsl:call-template name="bodyheaderPage" />
              
              <!-- SOMMAIRE -->
              <div id="course-map">
                   <ul id="tree" class="tree-view">
                       <xsl:copy-of select="$plan"/>
                   </ul>
              </div>
      
              <!-- CONTENU du Saut de page en cours au Saut ou CHAPITRE suivant-->
              <div id="content" class="cours">
                <!-- Cas particulier du titre d'un chapitre -->
                <xsl:if test="name()='CHAPITRE'">
                  <xsl:apply-templates select="." mode="unique"/>
                </xsl:if>
                <xsl:if test="name()='SAUTPAGEHTML'">
                  <xsl:apply-templates select="." mode="unique"/>
                </xsl:if>
                  <!-- CONTENU -->
                <xsl:call-template name="contenuPage">
                   <xsl:with-param name="idElement" select="$idElement"/>
                   <xsl:with-param name="idElementSuivant" select="$idElementSuivant"/>
                </xsl:call-template>
                &#xA0;
              </div>
              <!-- DIV en ALT -->
              <xsl:call-template name="coursDivInvisibles">
                   <xsl:with-param name="idElement" select="$idElement"/>
                   <xsl:with-param name="idElementSuivant" select="$idElementSuivant"/>
              </xsl:call-template>
              <!-- PIED de Page -->
              <xsl:call-template name="footerPage">
                   <xsl:with-param name="pageActive" select="$idPage"/>
                   <xsl:with-param name="pagePrecedente" select="$cheminPagePrecedente"/>
                   <xsl:with-param name="pageSuivante" select="$cheminPageSuivante"/>
                   <xsl:with-param name="testPagePrecedente" select="$pagePrecedente"/>
                   <xsl:with-param name="testPageSuivante" select="$pageSuivante"/>
              </xsl:call-template>
          </body>
    </html>
</xsl:with-param>
</xsl:call-template>

</xsl:template>



<!-- ************************************************ -->
<!-- Parametres page precedente / suivante pour un CHAPITRE -->
<!-- ************************************************ -->
<xsl:template name="precedentchapitre">
<!-- le precedent soit un CHAPITRE, soit le dernier SAUTPAGEHTML du chapitre precedent -->
       <xsl:choose>
           <xsl:when test="position()>1">
               <xsl:choose>
                   <xsl:when test="count(preceding::CHAPITRE[1]//SAUTPAGEHTML)>0">
                       <!-- Trouver le dernier -->
                       <xsl:variable name="idDernierSautPageHTML" ><xsl:call-template name="getlastSautPageHtmlprecedentchapitre"/></xsl:variable>
                       <xsl:variable name="refSautPageHTML" ><xsl:call-template name="getParentSautPageHtmlprecedentchapitre">
                           <xsl:with-param name="idSautPageHtml" select="$idDernierSautPageHTML"/>
                       </xsl:call-template></xsl:variable>
                       <xsl:value-of select="$refSautPageHTML"/>
                   </xsl:when>
                   <xsl:otherwise>
                        <xsl:value-of select="preceding::CHAPITRE[1]/@label"/>
                   </xsl:otherwise>
                </xsl:choose> 
           </xsl:when>
           <xsl:otherwise>
               <xsl:value-of select="'vide'"/>
           </xsl:otherwise>
       </xsl:choose>
</xsl:template>
<xsl:template name="getlastSautPageHtmlprecedentchapitre">
    <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
        <xsl:value-of select="generate-id(current())"/>
    </xsl:for-each>
</xsl:template>
<xsl:template name="getParentSautPageHtmlprecedentchapitre">
    <xsl:param name="idSautPageHtml"/>
    <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
       <xsl:if test="generate-id(current())=$idSautPageHtml">
        <xsl:if test="name(..)='SOUSPARTIE'">
            <xsl:variable name="nbSauts" select="count(parent::SOUSPARTIE/SAUTPAGEHTML)"/>
            <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',parent::SOUSPARTIE/@label,'_',$nbSauts)"/>
        </xsl:if>
        <xsl:if test="name(..)='PARTIE'">
            <xsl:variable name="nbSauts" select="count(parent::PARTIE/SAUTPAGEHTML)"/>
            <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',parent::PARTIE/@label,'_',$nbSauts)"/>
        </xsl:if>
        <xsl:if test="name(..)='CHAPITRE'">
            <xsl:variable name="nbSauts" select="count(parent::CHAPITRE/SAUTPAGEHTML)"/>
            <xsl:value-of select="concat(parent::CHAPITRE/@label,'_',$nbSauts)"/> 
        </xsl:if>
        </xsl:if>
    </xsl:for-each>
</xsl:template>
<xsl:template name="suivantchapitre">
<!-- le suivant est soit un SAUTPAGEHTML, soit un CHAPITRE -->
    <xsl:choose>
        <xsl:when test="count(descendant::SAUTPAGEHTML)>0">
            <xsl:for-each select="descendant::SAUTPAGEHTML[1]">
            <xsl:choose>
                <xsl:when test="count(parent::CHAPITRE)>0">
                    <!-- Le noeud appartient au CHAPITRE -->
                    <xsl:value-of select="concat(parent::CHAPITRE/@label,'_','1')"/>
                </xsl:when>    
                <xsl:when test="count(parent::PARTIE)>0">
                    <!-- Le noeud appartient au CHAPITRE -->
                    <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',parent::PARTIE/@label,'_','1')"/>
                </xsl:when>    
                <xsl:when test="count(parent::SOUSPARTIE)>0">
                    <!-- Le noeud appartient au CHAPITRE -->
                    <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',parent::SOUSPARTIE/@label,'_','1')"/>
                </xsl:when>    
            </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="position()=last()">
                    <xsl:value-of select="'vide'"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="following::CHAPITRE[1]/@label"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- ************************************************ -->
<!-- Parametres page suivante / precedente pour une page -->
<!-- ************************************************ -->
<xsl:template name="suivant">
<!-- le suivant est soit un SAUTPAGEHTML, soit un CHAPITRE -->
   <xsl:variable name="idSautPageHtml" select="generate-id(current())"/>
   <xsl:variable name="labelChapitreSuiv" select="following::CHAPITRE[1]/@label"/>
   <xsl:variable name="idSautPageHtmlSuiv" select="generate-id(following::SAUTPAGEHTML[1])"/>
       <xsl:choose>
           <xsl:when test="$idSautPageHtmlSuiv!=''">
               <xsl:variable name="labelCHAPITREParent" select="ancestor::CHAPITRE/@label"/>
               <xsl:for-each select="following::SAUTPAGEHTML[generate-id() = $idSautPageHtmlSuiv]">
                   <xsl:choose>
                       <xsl:when test="ancestor::CHAPITRE/@label=$labelCHAPITREParent">
                           <xsl:if test="name(..)='SOUSPARTIE'">
                               <xsl:for-each select="parent::SOUSPARTIE/SAUTPAGEHTML">
                                  <xsl:if test="generate-id() = $idSautPageHtmlSuiv">
                                       <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',parent::SOUSPARTIE/@label,'_',position())"/>
                                  </xsl:if>
                               </xsl:for-each>
                           </xsl:if>
                           <xsl:if test="name(..)='PARTIE'">
                               <xsl:for-each select="parent::PARTIE/SAUTPAGEHTML">
                                   <xsl:if test="generate-id() = $idSautPageHtmlSuiv">
                                      <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',parent::PARTIE/@label,'_',position())"/>
                                   </xsl:if>
                               </xsl:for-each>
                           </xsl:if>
                           <xsl:if test="name(..)='CHAPITRE'">
                               <xsl:for-each select="parent::CHAPITRE/SAUTPAGEHTML">
                                   <xsl:if test="generate-id() = $idSautPageHtmlSuiv">
                                       <xsl:value-of select="concat(parent::CHAPITRE/@label,'_',position())"/>
                                   </xsl:if>
                               </xsl:for-each>
                           </xsl:if>
                       </xsl:when>
                       <xsl:otherwise>
                           <xsl:value-of select="$labelChapitreSuiv"/>
                       </xsl:otherwise>
                   </xsl:choose>
               </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
               <!-- CHAPITRE suivant ou rien -->
               <xsl:variable name="idCHAPITRE" select="generate-id(ancestor::CHAPITRE)"/>
               <xsl:variable name="labelCHAPITRESuiv"><xsl:call-template name="getLabelChapitreSuivant">
               <xsl:with-param name="idCHAPITRE" select="$idCHAPITRE"/>
                   </xsl:call-template></xsl:variable>
               <xsl:choose>
                   <xsl:when test="$labelCHAPITRESuiv!=''">
                       <xsl:value-of select="$labelCHAPITRESuiv"/>
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:value-of select="'vide'"/>
                   </xsl:otherwise>
               </xsl:choose>
           </xsl:otherwise>
       </xsl:choose>
</xsl:template>

<xsl:template name="getLabelChapitreSuivant">
    <xsl:param name="idCHAPITRE"/>
     <xsl:for-each select="//CHAPITRE">
        <xsl:choose>
            <xsl:when test="generate-id(current())=$idCHAPITRE">
                 <xsl:value-of select="following::CHAPITRE[1]/@label"/>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>

<xsl:template name="precedent">
<!-- le precedent est soit le SAUTPAGEHTML precedent,soit le CHAPITRE qui contient le SAUTPAGEHTML -->
   <xsl:variable name="idSautPageHtml" select="generate-id(current())"/>
   <xsl:variable name="idSautPageHtmlPrec" select="generate-id(preceding::SAUTPAGEHTML[1])"/>
   <xsl:variable name="idChapitrePrec" select="generate-id(ancestor::CHAPITRE)"/>
   <xsl:variable name="positionSautPageHtmlPrec"><xsl:call-template name="getPositionNode">
   <xsl:with-param name="idNode" select="$idSautPageHtmlPrec"/>
   </xsl:call-template></xsl:variable>
   <xsl:variable name="positionChapitrePrec"><xsl:call-template name="getPositionNode">
   <xsl:with-param name="idNode" select="$idChapitrePrec"/>
   </xsl:call-template></xsl:variable>
       <xsl:choose>
           <xsl:when test="$idSautPageHtmlPrec!=''">
               <xsl:choose>
                   <xsl:when test="number($positionSautPageHtmlPrec)>number($positionChapitrePrec)">
   <xsl:for-each select="preceding::SAUTPAGEHTML[generate-id() = $idSautPageHtmlPrec]">
       <xsl:if test="name(..)='SOUSPARTIE'">
           <xsl:for-each select="parent::SOUSPARTIE/SAUTPAGEHTML">
               <xsl:if test="generate-id() = $idSautPageHtmlPrec">
                   <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',parent::SOUSPARTIE/@label,'_',position())"/>
               </xsl:if>
           </xsl:for-each>
       </xsl:if>
       <xsl:if test="name(..)='PARTIE'">
           <xsl:for-each select="parent::PARTIE/SAUTPAGEHTML">
               <xsl:if test="generate-id() = $idSautPageHtmlPrec">
                   <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',parent::PARTIE/@label,'_',position())"/>
               </xsl:if>
           </xsl:for-each>
       </xsl:if>
       <xsl:if test="name(..)='CHAPITRE'">
           <xsl:for-each select="parent::CHAPITRE/SAUTPAGEHTML">
               <xsl:if test="generate-id() = $idSautPageHtmlPrec">
                   <xsl:value-of select="concat(parent::CHAPITRE/@label,'_',position())"/>
               </xsl:if>
           </xsl:for-each>
       </xsl:if>
   </xsl:for-each>
   </xsl:when>
           <xsl:otherwise>
               <xsl:value-of select="ancestor::CHAPITRE/@label"/>
           </xsl:otherwise>
   </xsl:choose>
           </xsl:when>
           <xsl:otherwise>
               <xsl:value-of select="ancestor::CHAPITRE/@label"/>
           </xsl:otherwise>
       </xsl:choose>

</xsl:template>

<!-- ************************************************ -->
<!-- idPage pour positionnement dans le menu hors CHAPITRE -->
<!-- ************************************************ -->
<xsl:template name="getIdPage">
    <xsl:param name="labelchapitre"/>
   <xsl:variable name="idSautPageHtml" select="generate-id(current())"/>
   <xsl:variable name="positionSautPageHtml"><xsl:call-template name="getPositionNode">
   <xsl:with-param name="idNode" select="$idSautPageHtml"/>
   </xsl:call-template></xsl:variable>
   <xsl:variable name="idSautPageHtmlSuiv" select="generate-id(following::SAUTPAGEHTML[1])"/>
   <xsl:variable name="positionSautPageHtmlSuiv"><xsl:call-template name="getPositionNode">
   <xsl:with-param name="idNode" select="$idSautPageHtmlSuiv"/>
   </xsl:call-template></xsl:variable>
   <xsl:variable name="idCHAPITRESuiv" select="generate-id(following::CHAPITRE[1])"/>
   <xsl:variable name="positionCHAPITRESuiv"><xsl:call-template name="getPositionNode">
   <xsl:with-param name="idNode" select="$idCHAPITRESuiv"/>
   </xsl:call-template></xsl:variable>
   <xsl:variable name="OK" select="'OK'"/>
   <!-- Il faut regarder si la page en cours contient une PARIE ou SOUS-PARTIE -->
   <xsl:choose>
       <xsl:when test="$positionSautPageHtmlSuiv='' and $positionCHAPITRESuiv=''">
           <!-- Il n'y a plus de page suivante, c'est la dernire -->
           <!-- Il faut aller jusqu'au dernier noeud du dernier chapitre -->
           <xsl:variable name="idDernierNoeud" select="generate-id(//CHAPITRE[last()]/node()[last()])"/>
           <xsl:variable name="positionDernierNoeud" ><xsl:call-template name="getPositionNode">
           <xsl:with-param name="idNode" select="$idDernierNoeud"/>
           </xsl:call-template></xsl:variable>
           <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
               <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
               <xsl:with-param name="coursPositionElementSuivant" select="$positionDernierNoeud"/>
           </xsl:call-template></xsl:variable>
           <xsl:choose>
               <xsl:when test="contains($contientPouSP,$OK)">
                   <xsl:value-of select="''"/>
               </xsl:when>
               <xsl:otherwise>
                   <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                   <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
	                   <xsl:with-param name="idNode" select="$idSautPageHtml"/>
	                   <xsl:with-param name="positionNode" select="$positionSautPageHtml"/>
                       <xsl:with-param name="chapitreLabel" select="$labelchapitre"/>
                   </xsl:call-template></xsl:variable>
                   <xsl:value-of select="$idSommaire"/>
               </xsl:otherwise>
           </xsl:choose>   
       </xsl:when> 
       <xsl:when test="$positionSautPageHtmlSuiv='' and $positionCHAPITRESuiv!=''">
           <!-- La page suivante est un Chapitre -->
           <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
               <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
               <xsl:with-param name="coursPositionElementSuivant" select="$positionCHAPITRESuiv"/>
           </xsl:call-template></xsl:variable>
           <xsl:choose>
               <xsl:when test="contains($contientPouSP,$OK)">
                   <xsl:value-of select="''"/>
               </xsl:when>
               <xsl:otherwise>
                   <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                   <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                       <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                       <xsl:with-param name="positionNode" select="$positionSautPageHtml"/>
                       <xsl:with-param name="chapitreLabel" select="$labelchapitre"/>
                   </xsl:call-template></xsl:variable>
                   <xsl:value-of select="$idSommaire"/>
               </xsl:otherwise>
           </xsl:choose>   
       </xsl:when> 
       <xsl:when test="$positionSautPageHtmlSuiv!='' and $positionCHAPITRESuiv=''">
           <!-- La page suivante est un SautPageHTML -->
           <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
              <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
              <xsl:with-param name="coursPositionElementSuivant" select="$positionSautPageHtmlSuiv"/>
           </xsl:call-template></xsl:variable>
           <xsl:choose>
               <xsl:when test="contains($contientPouSP,$OK)">
                   <xsl:value-of select="''"/>
               </xsl:when>
               <xsl:otherwise>
                   <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                   <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                       <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                       <xsl:with-param name="positionNode" select="$positionSautPageHtml"/>
                       <xsl:with-param name="chapitreLabel" select="$labelchapitre"/>
                   </xsl:call-template></xsl:variable>
                   <xsl:value-of select="$idSommaire"/>
               </xsl:otherwise>
           </xsl:choose>   
       </xsl:when> 
       <xsl:when test="number($positionCHAPITRESuiv)>number($positionSautPageHtmlSuiv)">
           <!-- La page suivante est un SautPageHTML du mme CHAPITRE-->
           <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
               <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
               <xsl:with-param name="coursPositionElementSuivant" select="$positionSautPageHtmlSuiv"/>
           </xsl:call-template></xsl:variable>
           <xsl:choose>
               <xsl:when test="contains($contientPouSP,$OK)">
                   <xsl:value-of select="''"/>
               </xsl:when>
               <xsl:otherwise>
                   <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                   <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                       <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                       <xsl:with-param name="positionNode" select="$positionSautPageHtml"/>
                       <xsl:with-param name="chapitreLabel" select="$labelchapitre"/>
                   </xsl:call-template></xsl:variable>
                   <xsl:value-of select="$idSommaire"/>
               </xsl:otherwise>
           </xsl:choose>   
       </xsl:when> 
       <xsl:when test="number($positionSautPageHtmlSuiv)>number($positionCHAPITRESuiv)">
           <!-- La page suivante est un CHAPITRE-->
           <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
               <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
               <xsl:with-param name="coursPositionElementSuivant" select="$positionCHAPITRESuiv"/>
           </xsl:call-template></xsl:variable>
           <xsl:choose>
               <xsl:when test="contains($contientPouSP,$OK)">
                   <xsl:value-of select="''"/>
               </xsl:when>
               <xsl:otherwise>
                   <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                   <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                       <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                       <xsl:with-param name="positionNode" select="$positionSautPageHtml"/>
                       <xsl:with-param name="chapitreLabel" select="$labelchapitre"/>
                   </xsl:call-template></xsl:variable>
                   <xsl:value-of select="$idSommaire"/>
               </xsl:otherwise>
           </xsl:choose>   
       </xsl:when> 
   </xsl:choose>   
</xsl:template>
<xsl:template name="getPositionNode">
    <xsl:param name="idNode"/>
     <xsl:for-each select="//node()">
        <xsl:choose>
            <xsl:when test="generate-id(current())=$idNode">
                <xsl:value-of select="position()"/>
            </xsl:when>
        </xsl:choose>
    </xsl:for-each>
</xsl:template>
<xsl:template name="testPARTIEouSOUSPARTIE">
    <xsl:param name="coursPositionElement"/>
    <xsl:param name="coursPositionElementSuivant"/>

    <xsl:for-each select="//node()">
       <xsl:if test="position()>number($coursPositionElement) and not(position()>number($coursPositionElementSuivant))">
           <xsl:if test="name()='PARTIE' or name()='SOUSPARTIE'">
               <xsl:value-of select="'OK'"/>
           </xsl:if>
       </xsl:if>
    </xsl:for-each>
</xsl:template>
<xsl:template name="getPARTIEouSOUSPARTIE">
    <xsl:param name="coursPositionElement"/>
    <xsl:param name="coursPositionElementSuivant"/>

    <xsl:for-each select="//node()">
       <xsl:if test="position()>number($coursPositionElement) and not(position()>number($coursPositionElementSuivant))">
           <xsl:if test="name()='PARTIE' or name()='SOUSPARTIE'">
               <xsl:value-of select="concat('#',./@label)"/>
           </xsl:if>
       </xsl:if>
    </xsl:for-each>
</xsl:template>
<xsl:template name="getLastPARTIEouSOUSPARTIE">
    <xsl:param name="listLabel"/>
    <xsl:choose>
        <xsl:when test="contains($listLabel, '#')">
            <xsl:call-template name="getLastPARTIEouSOUSPARTIE">
                <xsl:with-param name="listLabel" select="substring-after($listLabel,'#')" />
            </xsl:call-template>
            
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$listLabel" />
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template name="getIdSommairePrec">
  <xsl:param name="idNode"/>
  <xsl:param name="positionNode"/>
  <xsl:param name="chapitreLabel"/>
  <xsl:variable name="OK" select="'OK'"/>
  <xsl:choose>
      <xsl:when test="name(..)='CHAPITRE'">
          <xsl:value-of select="$chapitreLabel"/>
      </xsl:when>
      <xsl:when test="name(..)='PARTIE'">
        <xsl:choose>
            <xsl:when test="count(ancestor::CHAPITRE//SAUTPAGEHTML)>0">
                 <!-- Il faut le noeud SAUTPAGEHTML avant la partie  -->
                 <xsl:variable name="idSautPageHtml">
                 <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
	                 <xsl:choose>
		                 <xsl:when test="ancestor::CHAPITRE/@label!=$chapitreLabel">
			                 <xsl:value-of select="''"/>
		                 </xsl:when>
		                 <xsl:otherwise>
		    	             <xsl:value-of select="generate-id()"/>
		                 </xsl:otherwise>
	                 </xsl:choose>
                 </xsl:for-each>
                 </xsl:variable>
                 
                <xsl:choose>
                 <xsl:when test="$idSautPageHtml=''">
                   <xsl:value-of select="$chapitreLabel"/>
                 </xsl:when>
                 <xsl:when test="$idSautPageHtml=$idNode">
                   <xsl:value-of select="ancestor::CHAPITRE/@label"/>
                 </xsl:when>
                 <xsl:otherwise>
                 <xsl:variable name="positionSautPageHtml"><xsl:call-template name="getPositionNode">
                     <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                 </xsl:call-template></xsl:variable>
                 <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
                     <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
                     <xsl:with-param name="coursPositionElementSuivant" select="$positionNode"/>
                 </xsl:call-template></xsl:variable>
                 <xsl:choose>
                     <xsl:when test="contains($contientPouSP,$OK)">
                         <xsl:variable name="listLabel"><xsl:call-template name="getPARTIEouSOUSPARTIE">
                            <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
                            <xsl:with-param name="coursPositionElementSuivant" select="$positionNode"/>
                         </xsl:call-template></xsl:variable>
                         <xsl:variable name="labelRef"><xsl:call-template name="getLastPARTIEouSOUSPARTIE">
                            <xsl:with-param name="listLabel" select="$listLabel"/>
                         </xsl:call-template></xsl:variable>
                         <xsl:for-each select="//node()[generate-id()=$idSautPageHtml]">
                             <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommaire">
                                 <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                                <xsl:with-param name="labelRef" select="$labelRef"/>
                             </xsl:call-template></xsl:variable>
                             <xsl:value-of select="$idSommaire"/>
                       </xsl:for-each>
                     </xsl:when>
                     <xsl:otherwise>
                         <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                         <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
		                 <xsl:variable name="positionSautPageHtmlPrec"><xsl:call-template name="getPositionNode">
		                     <xsl:with-param name="idNode" select="generate-id()"/>
		                 </xsl:call-template></xsl:variable>
                         <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                             <xsl:with-param name="idNode" select="generate-id()"/>
                             <xsl:with-param name="positionNode" select="$positionSautPageHtmlPrec"/>
                       		 <xsl:with-param name="chapitreLabel" select="$chapitreLabel"/>
                         </xsl:call-template></xsl:variable>
                         <xsl:value-of select="$idSommaire"/>
                         </xsl:for-each>
                     </xsl:otherwise>
                 </xsl:choose>   
                 </xsl:otherwise>
                 </xsl:choose>   
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="ancestor::CHAPITRE/@label"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
    <xsl:when test="name(..)='SOUSPARTIE'">
        <xsl:choose>
            <xsl:when test="count(ancestor::CHAPITRE//SAUTPAGEHTML)>0">
                <!-- Il faut le noeud SAUTPAGEHTML avant la sous partie  -->
                 <xsl:variable name="idSautPageHtml">
                 <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
	                 <xsl:choose>
		                 <xsl:when test="ancestor::CHAPITRE/@label!=$chapitreLabel">
			                 <xsl:value-of select="''"/>
		                 </xsl:when>
		                 <xsl:otherwise>
		    	             <xsl:value-of select="generate-id()"/>
		                 </xsl:otherwise>
	                 </xsl:choose>
                 </xsl:for-each>
                 </xsl:variable>
                <xsl:choose>
                 <xsl:when test="$idSautPageHtml=''">
                   <xsl:value-of select="$chapitreLabel"/>
                 </xsl:when>
                 <xsl:when test="$idSautPageHtml=$idNode">
                   <xsl:value-of select="ancestor::CHAPITRE/@label"/>
                 </xsl:when>
                 <xsl:otherwise>
                  <xsl:variable name="positionSautPageHtml"><xsl:call-template name="getPositionNode">
                    <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                  </xsl:call-template></xsl:variable>
                  <xsl:variable name="contientPouSP"><xsl:call-template name="testPARTIEouSOUSPARTIE">
                    <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
                    <xsl:with-param name="coursPositionElementSuivant" select="$positionNode"/>
                  </xsl:call-template></xsl:variable>
                  <xsl:choose>
                    <xsl:when test="contains($contientPouSP,$OK)">
                        <xsl:variable name="listLabel"><xsl:call-template name="getPARTIEouSOUSPARTIE">
                            <xsl:with-param name="coursPositionElement" select="$positionSautPageHtml"/>
                            <xsl:with-param name="coursPositionElementSuivant" select="$positionNode"/>
                        </xsl:call-template></xsl:variable>
                        <xsl:variable name="labelRef"><xsl:call-template name="getLastPARTIEouSOUSPARTIE">
                            <xsl:with-param name="listLabel" select="$listLabel"/>
                        </xsl:call-template></xsl:variable>
                        <xsl:for-each select="//node()[generate-id()=$idSautPageHtml]">
                            <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommaire">
                                <xsl:with-param name="idNode" select="$idSautPageHtml"/>
                                <xsl:with-param name="labelRef" select="$labelRef"/>
                            </xsl:call-template></xsl:variable>
                            <xsl:value-of select="$idSommaire"/>
                       </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Il n'y a pas de PARTIE ou SOUS-PARTIE a suivre, il faut donc prendre le sautPageHTML prcdent qui en contient -->
                        <xsl:for-each select="preceding::SAUTPAGEHTML[1]">
		                 <xsl:variable name="positionSautPageHtmlPrec"><xsl:call-template name="getPositionNode">
		                     <xsl:with-param name="idNode" select="generate-id()"/>
		                 </xsl:call-template></xsl:variable>
                        <xsl:variable name="idSommaire"><xsl:call-template name="getIdSommairePrec">
                            <xsl:with-param name="idNode" select="generate-id()"/>
                            <xsl:with-param name="positionNode" select="$positionSautPageHtmlPrec"/>
                       		<xsl:with-param name="chapitreLabel" select="$chapitreLabel"/>
                        </xsl:call-template></xsl:variable>
                        <xsl:value-of select="$idSommaire"/>
                        </xsl:for-each>
                    </xsl:otherwise>
                  </xsl:choose>   
                 </xsl:otherwise>
                </xsl:choose>   
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="ancestor::CHAPITRE/@label"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
  </xsl:choose>
</xsl:template>

<xsl:template name="getIdSommaire">
    <xsl:param name="idNode"/>
    <xsl:param name="labelRef"/>
    <xsl:choose>
        <xsl:when test="name(..)='CHAPITRE'">
            <xsl:for-each select="ancestor::CHAPITRE/SAUTPAGEHTML">
              <xsl:if test="generate-id(current())=$idNode">
                  <xsl:variable name="numSautPageHtml" select="position()"/>
                  <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',$numSautPageHtml,'_',$labelRef)"/>
              </xsl:if>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="name(..)='PARTIE'">
            <xsl:for-each select="ancestor::PARTIE/SAUTPAGEHTML">
              <xsl:if test="generate-id(current())=$idNode">
                  <xsl:variable name="numSautPageHtml" select="position()"/>
                  <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',parent::PARTIE/@label,'_',$numSautPageHtml,'_',$labelRef)"/>
              </xsl:if>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="name(..)='SOUSPARTIE'">
            <xsl:for-each select="ancestor::SOUSPARTIE/SAUTPAGEHTML">
              <xsl:if test="generate-id(current())=$idNode">
                  <xsl:variable name="numSautPageHtml" select="position()"/>
                  <xsl:value-of select="concat(ancestor::CHAPITRE/@label,'_',ancestor::PARTIE/@label,'_',parent::SOUSPARTIE/@label,'_',$numSautPageHtml,'_',$labelRef)"/>
              </xsl:if>
            </xsl:for-each>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="getIdsuivant">
<!-- le suivant est soit un SAUTPAGEHTML, soit un CHAPITRE -->
   <xsl:param name="idSautPageHtml"/>
   <xsl:for-each select="//node()">
       <xsl:if test="generate-id(current())=$idSautPageHtml">
        <xsl:choose>
            <xsl:when test="name()='CHAPITRE'">
                <xsl:call-template name="getIdsuivantCHAPITRE">
                    <xsl:with-param name="idSautPageHtml" select="$idSautPageHtml"/>
                </xsl:call-template>                  
            </xsl:when>
           <xsl:otherwise>
                <xsl:call-template name="getIdsuivantSAUTPAGEHTML">
                    <xsl:with-param name="idSautPageHtml" select="$idSautPageHtml"/>
                </xsl:call-template>                  
           </xsl:otherwise>
        </xsl:choose>
       </xsl:if>
   </xsl:for-each>   
</xsl:template>

<xsl:template name="getIdsuivantCHAPITRE">
<!-- le suivant est soit un SAUTPAGEHTML, soit un CHAPITRE -->
   <xsl:param name="idSautPageHtml"/>
   <xsl:variable name="idSautPageHtmlSuiv" select="generate-id(descendant::SAUTPAGEHTML[1])"/>
       <xsl:choose>
           <xsl:when test="$idSautPageHtmlSuiv!=''">
               <xsl:value-of select="$idSautPageHtmlSuiv"/>
           </xsl:when>
           <xsl:otherwise>
               <!-- CHAPITRE suivant ou rien -->
               <xsl:variable name="idCHAPITREsuiv" select="generate-id(following-sibling::CHAPITRE[1])"/>
               <xsl:choose>
                   <xsl:when test="$idCHAPITREsuiv!=''">
                       <xsl:value-of select="$idCHAPITREsuiv"/>
                   </xsl:when>
                   <xsl:otherwise>
                     <xsl:value-of select="''"/>
                 </xsl:otherwise>
               </xsl:choose>
           </xsl:otherwise>
       </xsl:choose>
</xsl:template>

<xsl:template name="getIdsuivantSAUTPAGEHTML">
<!-- le suivant est soit un SAUTPAGEHTML, soit un CHAPITRE -->
   <xsl:param name="idSautPageHtml"/>
   <xsl:variable name="idSautPageHtmlSuiv" select="generate-id(following::SAUTPAGEHTML[1])"/>
   <xsl:variable name="idChapitreSuiv" select="generate-id(following::CHAPITRE[1])"/>
       <xsl:choose>
           <xsl:when test="$idSautPageHtmlSuiv!=''">
               <xsl:variable name="labelCHAPITREParent" select="ancestor-or-self::CHAPITRE/@label"/>
               <xsl:for-each select="following::SAUTPAGEHTML[generate-id() = $idSautPageHtmlSuiv]">
                   <xsl:choose>
                       <xsl:when test="ancestor-or-self::CHAPITRE/@label=$labelCHAPITREParent">
                           <xsl:value-of select="$idSautPageHtmlSuiv"/>
                       </xsl:when>
                       <xsl:otherwise>
                           <xsl:choose>
                               <xsl:when test="$idChapitreSuiv!=''">
                                   <xsl:value-of select="$idChapitreSuiv"/>
                               </xsl:when>
                               <xsl:otherwise>
                                   <xsl:variable name="idLastElement"><xsl:call-template name="getLastNodeChapitre"/></xsl:variable>
                                   <xsl:value-of select="$idLastElement"/>
                               </xsl:otherwise>
                           </xsl:choose>
                       </xsl:otherwise>
                   </xsl:choose>
               </xsl:for-each>
           </xsl:when>
           <xsl:otherwise>
               <!-- CHAPITRE suivant ou rien -->
               <xsl:variable name="idCHAPITRE" select="generate-id(ancestor-or-self::CHAPITRE)"/>
               <xsl:variable name="labelCHAPITRESuiv"><xsl:call-template name="getLabelChapitreSuivant">
                   <xsl:with-param name="idCHAPITRE" select="$idCHAPITRE"/>
               </xsl:call-template></xsl:variable>
               <xsl:choose>
                   <xsl:when test="$labelCHAPITRESuiv!=''">
                       <xsl:for-each select="//CHAPITRE">
                           <xsl:choose>
                               <xsl:when test="generate-id(current())=$idCHAPITRE">
                                   <xsl:value-of select="generate-id(following-sibling::CHAPITRE[1])"/>
                               </xsl:when>
                           </xsl:choose>
                       </xsl:for-each>
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:variable name="idLastElement"><xsl:call-template name="getLastNodeChapitre"/></xsl:variable>
                       <xsl:value-of select="$idLastElement"/>
                   </xsl:otherwise>
               </xsl:choose>
           </xsl:otherwise>
       </xsl:choose>
</xsl:template>

<xsl:template name="getLastNodeChapitre">
     <xsl:for-each select="//CHAPITRE[last()]">
         <xsl:value-of select="generate-id(./descendant::*[last()])"/>
     </xsl:for-each>
</xsl:template>

<xsl:template name="nbchapitres">
    <xsl:value-of select="count(UVED//CHAPITRE)"/>
</xsl:template>

<!-- ************************************************ -->
<!-- Gnration du contenu des pages  en fontion de chaque Balise -->
<!-- ************************************************ -->
<xsl:template name="contenuPage">
   <xsl:param name="idElement"/>
   <xsl:param name="idElementSuivant"/>
   
   <!-- Position Element -->
   <xsl:variable name="coursPositionElement"><xsl:call-template name="coursPositionElement">
   <xsl:with-param name="idElement" select="$idElement"/>
   </xsl:call-template></xsl:variable>
   <!-- Position Element Suivant-->
   <xsl:variable name="coursPositionElementSuivant"><xsl:call-template name="coursPositionElement">
   <xsl:with-param name="idElement" select="$idElementSuivant"/>
   </xsl:call-template></xsl:variable>
   
   <!-- Prendre tous les nodes entre ces 2 positions -->
   <xsl:for-each select="//node()">
       <xsl:if test="position()>number($coursPositionElement) and not(position()>number($coursPositionElementSuivant))">
           <xsl:if test="name()='PARAGRAPHE' or name()='REMARQUE' or name()='DEFINITION' or name()='INTRODUCTION' or name()='EXEMPLE' or name()='CONCLUSION' or name()='METHODE' or name()='RAPPEL' or name()='COMPLEMENT' or name()='ENSAVOIRPLUS' or name()='ATTENTION' or name()='SYNTAXE' or name()='EXPLICATION' or name()='CONSEIL' or name()='CONFERE' or name()='CITATION' or name()='ACTIVITE' or name()='MEDIA' or name()='QCM' or name()='LISTE' or name()='ZONETABLE' or name()='TABLE'">
                <xsl:if test="count(ancestor::BIBLIOGRAPHIE)=0 and count(ancestor::WEBOGRAPHIE)=0 and count(ancestor::GLOSSAIRE)=0 and count(ancestor::ANNEXE)=0 and name(..)!='INTRODUCTION' and name(..)!='CONCLUSION' and name(..)!='EXEMPLE' and name(..)!='COMPLEMENT' and name(..)!='ENSAVOIRPLUS' and name(..)!='EXPLICATION' and name(..)!='ACTIVITE' and name(..)!='SYNTAXE' and name(..)!='RAPPEL' and name(..)!='METHODE' and name(..)!='LISTE' and name(..)!='ITEM'"> 
                     <xsl:apply-templates select="." mode="unique"/>
                </xsl:if>
           </xsl:if>
           <xsl:if test="name()='PARTIE' or name()='SOUSPARTIE'">
               <xsl:apply-templates select="." mode="unique"/>
           </xsl:if>
       </xsl:if>
   </xsl:for-each>
     
</xsl:template>

<xsl:template name="coursPositionElement">
   <xsl:param name="idElement"/>
   <xsl:for-each select="//node()">
       <xsl:if test="generate-id(current())=$idElement">
               <xsl:value-of select="position()"/>
       </xsl:if>
   </xsl:for-each>   
</xsl:template>

<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="coursDivInvisibles">
   <xsl:param name="idElement"/>
   <xsl:param name="idElementSuivant"/>
   
   <!-- Position Element -->
   <xsl:variable name="coursPositionElement"><xsl:call-template name="coursPositionElement">
   <xsl:with-param name="idElement" select="$idElement"/>
   </xsl:call-template></xsl:variable>
   <!-- Position Element Suivant-->
   <xsl:variable name="coursPositionElementSuivant"><xsl:call-template name="coursPositionElement">
   <xsl:with-param name="idElement" select="$idElementSuivant"/>
   </xsl:call-template></xsl:variable>
   
   <!-- Prendre tous les nodes entre ces 2 positions -->
   <xsl:for-each select="//node()">
       <xsl:if test="position()>number($coursPositionElement) and not(position()>number($coursPositionElementSuivant))">
           <xsl:if test="name()='MOTDUGLOSSAIRE' or name()='LIENMOTDUGLOSSAIRE' or name()='REFERENCEBIBLIOGRAPHIQUE' or name()='LIENREFERENCEBIBLIOGRAPHIQUE' or name()='REFERENCEWEBOGRAPHIQUE' or name()='LIENREFERENCEWEBOGRAPHIQUE'">
               <xsl:if test="count(ancestor::BIBLIOGRAPHIE)=0 and count(ancestor::WEBOGRAPHIE)=0 and count(ancestor::GLOSSAIRE)=0 and count(ancestor::ANNEXE)=0"> 
                    <xsl:apply-templates select="." mode="div"/>
               </xsl:if>
           </xsl:if>
       </xsl:if>
   </xsl:for-each>
     
</xsl:template>

</xsl:stylesheet>
