<?xml version="1.0" encoding='ISO-8859-1' ?>
<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <!-- ************************************************ -->
    <!-- creation de la bibliographie pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->

    <xsl:template name="UVED_BIBLIOGRAPHIE">
    <xsl:variable name="alphabetcomplet">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>

        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'bibliographie.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerBiblio" />
                    <body>
                        <xsl:call-template name="bodyheaderRessource" />
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-section">
                                <h3>Ressources</h3>
                                <h4>Bibliographie</h4>
                            </div>
    
                            <!-- creation de la liste des ressources accessibles -->
                            <xsl:call-template name="biblioSelectressources" />
    
                            <!-- creation des lien vers les ancres-->
                            <div class="navigation">
                                <xsl:call-template name="biblioLigneancres">
                                    <xsl:with-param name="alphabet"
                                        select="$alphabetcomplet" />
                                </xsl:call-template>
                            </div>
    
                            <!-- affichage des ouvrages de la bibliographie-->
                            <xsl:call-template name="lignebibliographie">
                                <xsl:with-param name="alphabet"
                                    select="$alphabetcomplet" />
                            </xsl:call-template>
    
                        </div>
                    <xsl:call-template name="footerRessource">
                        <xsl:with-param name="pageActive">bibliographie</xsl:with-param>
                    </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>

    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation des liens vers les ancres-->
    <!-- ************************************************ -->
    <xsl:template name="biblioLigneancres">
        <xsl:param name="alphabet" />

        <xsl:variable name="unelettre"
            select="substring($alphabet,1,1)" />
        <xsl:variable name="suitealphabet"
            select="substring-after($alphabet, $unelettre)" />

        <!-- creation des liens vers les ancres-->
        <xsl:call-template name="biblioLienancres">
            <xsl:with-param name="majuscule" select="$unelettre" />
        </xsl:call-template>

        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="biblioLigneancres">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation d'un lien vers les ancres-->
    <!-- ************************************************ -->
    <xsl:template name="biblioLienancres">
        <xsl:param name="majuscule" />
        <xsl:if
            test="count(UVED//REFERENCEBIBLIOGRAPHIQUE[translate(substring(@nomAuteur,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$majuscule])>0">
            <a href="#{$majuscule}">
                <xsl:value-of select="$majuscule" />
            </a>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation des ancres et insertion des ouvrages-->
    <!-- ************************************************ -->
    <xsl:template name="lignebibliographie">
        <xsl:param name="alphabet" />

        <xsl:variable name="unelettre"
            select="substring($alphabet,1,1)" />
        <xsl:variable name="suitealphabet"
            select="substring-after($alphabet, $unelettre)" />

        <xsl:if

            test="count(UVED//REFERENCEBIBLIOGRAPHIQUE[translate(substring(@nomAuteur,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre])>0">
            <h4 class="lettre">
                <a name="{$unelettre}">
                    <xsl:value-of select="$unelettre" />
                </a>
            </h4>
        </xsl:if>

        <xsl:for-each
            select="UVED//REFERENCEBIBLIOGRAPHIQUE[translate(substring(@nomAuteur,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre]">
            <xsl:sort order="ascending" select="@nomAuteur" />
            <xsl:if test="not(preceding::OUVRAGE/.=OUVRAGE/.)">
                <xsl:if test="OUVRAGE">
                    <xsl:if test="OUVRAGE/.!=''">
                        <div class="bloc-definition">
                            <h5>
                                <xsl:value-of select="@nomAuteur" />
                            </h5>
                            <xsl:apply-templates select="OUVRAGE" />
                        </div>
                    </xsl:if>
                </xsl:if>
            </xsl:if>
        </xsl:for-each>
        <xsl:if

            test="count(UVED//REFERENCEBIBLIOGRAPHIQUE[translate(substring(@nomAuteur,1,1),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')=$unelettre])>0">
        <div class="haut-page">
            <a href="#top">
               <span>haut de page</span>
            </a>
        </div>
         </xsl:if>
        
        <xsl:if test="$suitealphabet!=''">
            <xsl:call-template name="lignebibliographie">
                <xsl:with-param name="alphabet" select="$suitealphabet" />
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- Ouvrage -->
    <!-- ************************************************ -->
    <xsl:template match="OUVRAGE">
        <p>
            <xsl:value-of select="." />
        </p>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- creation liste des ressources-->
    <!-- ************************************************ -->
    <xsl:template name="biblioSelectressources">
        <div class="selection">
            <fieldset>
                <form action="">
                    <select
                        onchange="location=this.options[this.selectedIndex].value;">
                        <option>Voir une autre ressource...</option>

                        <xsl:if test="count(UVED//MOTDUGLOSSAIRE)>0">
                            <option value="glossaire.html">
                                - Glossaire
                            </option>
                        </xsl:if>

                        <xsl:if
                            test="count(UVED//REFERENCEWEBOGRAPHIQUE)>0">
                            <option value="webographie.html">
                                - Webographie
                            </option>
                        </xsl:if>
                    </select>
                </form>
            </fieldset>
        </div>
    </xsl:template>

</xsl:stylesheet>
