<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet version="2.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

<!-- ************************************************ -->
<!-- Gnration des annexes du cours UVED pour les ALT -->
<!-- ************************************************ -->
<!-- version 0.3 Romuald Lorthioir et Nadia Henry - CIRM - Universit de Rennes 1 -->


<!-- ************************************************ -->
<!-- Traitement des pages d'annexes d'un cours UVED-->
<!-- ************************************************ -->
<xsl:template name="UVED_ANNEXE" >
<xsl:for-each select="//ANNEXE">
   
       <xsl:variable name="labelannexe" select="./@label"/>
       <xsl:variable name="idElement" select="generate-id(current())"/>
<!-- Si icne -->
       <xsl:call-template name="annexePage" >
           <xsl:with-param name="nomFichier" select="$labelannexe"/>
           <xsl:with-param name="idElement" select="$idElement"/>
       </xsl:call-template>
   
</xsl:for-each>
</xsl:template>


<!-- ************************************************ -->
<!-- Gnration d'une page d'annexe UVED-->
<!-- ************************************************ -->
<xsl:template name="annexePage">
    <xsl:param name="nomFichier"/>
    <xsl:param name="idElement"/>
     
    <!-- Prparation des variable pour les liens entre pages --> 
    <xsl:variable name="cheminNomFichier" select="concat($cheminSite,$nomFichier,'.html')"/>
    <xsl:variable name="idElementSuivant" select="generate-id(descendant::node()[last()])" />
    
    <!-- Cration du fichier de la page -->
    <xsl:call-template name="ecrireDansFichier">
        <xsl:with-param name="fichier" select="$cheminNomFichier"/>
        <xsl:with-param name="contenu">
            <html lang="fr">
                  <xsl:call-template name="headerPageAnnexe" />
                  <body >
                      <xsl:call-template name="bodyheaderPageAnnexe" />
                      
                       <!-- CONTENU du Saut de page en cours au Saut ou CHAPITRE suivant-->
                       <div id="content" class="cours">
                       
                          <!-- Cas particulier du titre d'un chapitre -->
                          <xsl:if test="name()='CHAPITRE'">
                               <xsl:apply-templates select="." mode="unique"/>
                          </xsl:if>
        
                          <!-- CONTENU -->
                          <xsl:call-template name="annexeContenuPage">
                               <xsl:with-param name="idElement" select="$idElement"/>
                               <xsl:with-param name="idElementSuivant" select="$idElementSuivant"/>
                          </xsl:call-template>
                      </div>
                      <!-- DIV en ALT -->
                      <xsl:call-template name="annexeDivInvisibles">
                           <xsl:with-param name="idElement" select="$idElement"/>
                           <xsl:with-param name="idElementSuivant" select="$idElementSuivant"/>
                      </xsl:call-template>
                      <!-- PIED de Page -->
                      <div id="close">
                           <a href="javascript:window.close();" title="">Fermer la fentre</a>
                      </div>
                  </body>
            </html>
        </xsl:with-param>
    </xsl:call-template>

</xsl:template>


<!-- ************************************************ -->
<!-- Gnration du contenu des pages  en fontion de chaque Balise -->
<!-- ************************************************ -->
<xsl:template name="annexeContenuPage">
   <xsl:param name="idElement"/>
   <xsl:param name="idElementSuivant"/>
   
   <!-- Position Element -->
   <xsl:variable name="positionElement"><xsl:call-template name="annexePositionElement">
       <xsl:with-param name="idElement" select="$idElement"/>
   </xsl:call-template></xsl:variable>
   <!-- Position Element Suivant-->
   <xsl:variable name="positionElementSuivant"><xsl:call-template name="annexePositionElement">
       <xsl:with-param name="idElement" select="$idElementSuivant"/>
   </xsl:call-template></xsl:variable>
   
   <!-- Prendre tous les nodes entre ces 2 positions -->
   <xsl:for-each select="//node()">
       <xsl:if test="position()>number($positionElement) and not(position()>number($positionElementSuivant))">
           <xsl:if test="name()='PARAGRAPHE' or name()='REMARQUE' or name()='DEFINITION' or name()='INTRODUCTION' or name()='EXEMPLE' or name()='CONCLUSION' or name()='METHODE' or name()='RAPPEL' or name()='COMPLEMENT' or name()='ENSAVOIRPLUS' or name()='ATTENTION' or name()='SYNTAXE' or name()='EXPLICATION' or name()='CONSEIL' or name()='CONFERE' or name()='CITATION' or name()='ACTIVITE' or name()='MEDIA' or name()='QCM' or name()='LISTE' or name()='ZONETABLE' or name()='TABLE' or name()='TR' or name()='TH' or name()='TD'">
               <xsl:if test="name(..)!='INTRODUCTION' and name(..)!='CONCLUSION' and name(..)!='EXEMPLE' and name(..)!='COMPLEMENT' and name(..)!='ENSAVOIRPLUS' and name(..)!='EXPLICATION' and name(..)!='ACTIVITE' "> 
                   <xsl:apply-templates select="." mode="unique"/>
               </xsl:if>
           </xsl:if>
       </xsl:if>
   </xsl:for-each>
     
</xsl:template>
<xsl:template name="annexePositionElement">
   <xsl:param name="idElement"/>
   <xsl:for-each select="//node()">
       <xsl:if test="generate-id(current())=$idElement">
               <xsl:value-of select="position()"/>
       </xsl:if>
   </xsl:for-each>   
</xsl:template>

<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="annexeDivInvisibles">
   <xsl:param name="idElement"/>
   <xsl:param name="idElementSuivant"/>
   
   <!-- Position Element -->
   <xsl:variable name="positionElement"><xsl:call-template name="annexePositionElement">
   <xsl:with-param name="idElement" select="$idElement"/>
   </xsl:call-template></xsl:variable>
   <!-- Position Element Suivant-->
   <xsl:variable name="positionElementSuivant"><xsl:call-template name="annexePositionElement">
   <xsl:with-param name="idElement" select="$idElementSuivant"/>
   </xsl:call-template></xsl:variable>
   
   <!-- Prendre tous les nodes entre ces 2 positions -->
   <xsl:for-each select="//node()">
       <xsl:if test="position()>number($positionElement) and not(position()>=number($positionElementSuivant))">
           <xsl:if test="name()='MOTDUGLOSSAIRE' or name()='LIENMOTDUGLOSSAIRE' or name()='REFERENCEBIBLIOGRAPHIQUE' or name()='LIENREFERENCEBIBLIOGRAPHIQUE' or name()='REFERENCEWEBOGRAPHIQUE' or name()='LIENREFERENCEWEBOGRAPHIQUE'">
               <xsl:apply-templates select="." mode="div"/>
           </xsl:if>
       </xsl:if>
   </xsl:for-each>
     
</xsl:template>
</xsl:stylesheet>
