<?xml version='1.0' encoding='ISO-8859-1'?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.uved.fr/schema/2.0">

<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
    
<xsl:template match="UVED">
    <UVED>
        <xsl:apply-templates/>
    </UVED>
</xsl:template>

<xsl:template match="METADONNEES">
    <METADONNEES>
        <xsl:apply-templates/>
    </METADONNEES>
</xsl:template>

<xsl:template match="AUTEURS">
    <AUTEURS>
        <xsl:apply-templates/>
    </AUTEURS>
</xsl:template>

<xsl:template match="AUTEUR">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="DATECRE">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="DATEMAJ">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="LANGUE">
    <LANGUE><xsl:choose>
        <xsl:when test=".='fr'">fra</xsl:when>
        <xsl:when test=".='en'">eng</xsl:when>
        <xsl:when test=".='de'">deu</xsl:when>
        <xsl:when test=".='es'">spa</xsl:when>
        <xsl:when test=".='ja'">jpn</xsl:when>
        <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise> <!-- invalide mais peu probable -->
    </xsl:choose></LANGUE>
</xsl:template>

<xsl:template match="VERSION">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="NIVEAULMD">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="MOTSCLE">
    <xsl:copy-of select="."/>
</xsl:template>


<xsl:template match="CONTENUS">
    <CONTENUS titre="{@titre}">
        <xsl:apply-templates/>
    </CONTENUS>
</xsl:template>

<xsl:template match="PRESENTATION">
    <PRESENTATION>
        <xsl:apply-templates/>
    </PRESENTATION>
</xsl:template>

<xsl:template match="CARACTERISTIQUE">
    <CARACTERISTIQUE>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </CARACTERISTIQUE>
</xsl:template>

<xsl:template match="FINALITE">
    <FINALITE>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </FINALITE>
</xsl:template>

<xsl:template match="CONTENU">
    <CONTENU>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </CONTENU>
</xsl:template>

<xsl:template match="ANNEXES">
    <ANNEXES>
        <xsl:apply-templates/>
    </ANNEXES>
</xsl:template>

<xsl:template match="ANNEXE">
    <ANNEXE label="{@label}" titre="{@titre}">
        <xsl:apply-templates/>
    </ANNEXE>
</xsl:template>

<xsl:template match="GLOSSAIRE">
    <GLOSSAIRE>
        <xsl:apply-templates/>
    </GLOSSAIRE>
</xsl:template>

<xsl:template match="MOTDUGLOSSAIRE">
    <MOTDUGLOSSAIRE mot="{@mot}"><xsl:apply-templates/></MOTDUGLOSSAIRE>
</xsl:template>

<xsl:template match="LIENMOTDUGLOSSAIRE">
    <LIENMOTDUGLOSSAIRE mot="{@mot}" labelReference="{@labelReference}"/>
</xsl:template>

<xsl:template match="BIBLIOGRAPHIE">
    <BIBLIOGRAPHIE>
        <xsl:apply-templates/>
    </BIBLIOGRAPHIE>
</xsl:template>

<xsl:template match="REFERENCEBIBLIOGRAPHIQUE">
    <REFERENCEBIBLIOGRAPHIQUE labelReference="{@labelReference}">
        <xsl:apply-templates/>
    </REFERENCEBIBLIOGRAPHIQUE>
</xsl:template>

<xsl:template match="LIENREFERENCEBIBLIOGRAPHIQUE">
    <LIENREFERENCEBIBLIOGRAPHIQUE labelReference="{@labelReference}"/>
</xsl:template>

<xsl:template match="OUVRAGE">
    <!-- impossible  convertir automatiquement -->
    <REFOUVRAGE autre="{.}">
        <xsl:if test="parent::REFERENCEBIBLIOGRAPHIQUE and ../@nomAuteur!=''">
            <xsl:attribute name="premierAuteur"><xsl:value-of select="../@nomAuteur"/></xsl:attribute>
        </xsl:if>
    </REFOUVRAGE>
</xsl:template>

<xsl:template match="WEBOGRAPHIE">
    <WEBOGRAPHIE>
        <xsl:apply-templates/>
    </WEBOGRAPHIE>
</xsl:template>

<xsl:template match="REFERENCEWEBOGRAPHIQUE">
    <REFERENCEWEBOGRAPHIQUE labelAdress="{@labelAdress}" URL="{@URL}">
        <xsl:apply-templates/>
    </REFERENCEWEBOGRAPHIQUE>
</xsl:template>

<xsl:template match="LIENREFERENCEWEBOGRAPHIQUE">
    <LIENREFERENCEWEBOGRAPHIQUE labelReference="{@labelReference}"/>
</xsl:template>

<xsl:template match="DESCRIPTION">
    <DESCRIPTION>
        <xsl:apply-templates/>
    </DESCRIPTION>
</xsl:template>


<xsl:template match="CHAPITRE">
    <xsl:call-template name="divisions"/>
</xsl:template>

<xsl:template match="REFCHAPITRE">
    <REFSECTION label="{@label}"/>
</xsl:template>

<xsl:template match="PARTIE">
    <xsl:call-template name="divisions"/>
</xsl:template>

<xsl:template match="REFPARTIE">
    <REFSECTION label="{@label}"/>
</xsl:template>

<xsl:template match="SOUSPARTIE">
    <xsl:call-template name="divisions"/>
</xsl:template>

<xsl:template match="REFSOUSPARTIE">
    <REFSECTION label="{@label}"/>
</xsl:template>

<xsl:template name="divisions">
    <!-- remarque : on prend le risque d'un conflit des labels entre chapitre/partie/sous-partie -->
    <xsl:choose>
        <xsl:when test="PARTIE|REFPARTIE|SOUSPARTIE|REFSOUSPARTIE">
            <SECTION label="{@label}" titre="{@titre}">
                <xsl:choose>
                    <xsl:when test="INTRODUCTION and count(*[self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE][1]/preceding-sibling::*[not(self::SAUTPAGEHTML or self::SAUTPAGEPDF)]) = 1">
                        <xsl:apply-templates select="INTRODUCTION"/>
                    </xsl:when>
                    <xsl:when test="count(*[self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE][1]/preceding-sibling::*) &gt; 1">
                        <GRAIN label="{concat(@label,'-intro')}" titre="Introduction">
                            <!-- pb : INTRODUCTION potentiellement sous GRAIN -->
                            <xsl:apply-templates select="*[self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE][1]/preceding-sibling::*"/>
                        </GRAIN>
                    </xsl:when>
                </xsl:choose>
                <xsl:for-each select="*[self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE][1]|*[self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE][1]/following-sibling::*">
                    <xsl:choose>
                        <xsl:when test="not(self::PARTIE or self::REFPARTIE or self::SOUSPARTIE or self::REFSOUSPARTIE or self::CONCLUSION or self::ANNEXES or self::GLOSSAIRE or self::BIBLIOGRAPHIE or self::WEBOGRAPHIE or self::SAUTPAGEHTML or self::SAUTPAGEPDF)">
                            <GRAIN label="{concat(@label,'-', position())}" titre="{name()}">
                                <xsl:apply-templates select="."/>
                            </GRAIN>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="."/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </SECTION>
        </xsl:when>
        <xsl:when test="count(*[self::SAUTPAGEHTML or self::ANNEXES or self::GLOSSAIRE or self::BIBLIOGRAPHIE or self::WEBOGRAPHIE]) = 0">
            <!-- coupures en grains avec les titres de paragraphes, quand il y en a -->
            <!-- les introductions seront dplaces au dbut, et les conclusions  la fin -->
            <xsl:choose>
                <xsl:when test="PARAGRAPHE[@titre!='']">
                    <SECTION label="{@label}" titre="{@titre}">
                        <xsl:apply-templates select="INTRODUCTION"/>
                        <xsl:if test="count(PARAGRAPHE[@titre!=''][1]/preceding-sibling::*[not(self::INTRODUCTION or self::CONCLUSION)]) &gt; 0">
                            <GRAIN label="{@label}-debut" titre="{@titre}">
                                <xsl:apply-templates select="PARAGRAPHE[@titre!=''][1]/preceding-sibling::*[not(self::INTRODUCTION or self::CONCLUSION)]"/>
                            </GRAIN>
                        </xsl:if>
                        <xsl:for-each select="PARAGRAPHE[@titre!='']">
                            <xsl:choose>
                                <xsl:when test="position()!=last()">
                                    <GRAIN label="{concat(../@label,'-',position())}" titre="{@titre}">
                                        <PARAGRAPHE>
                                            <xsl:apply-templates/>
                                        </PARAGRAPHE>
                                        <xsl:variable name="suivant" select="generate-id(following-sibling::PARAGRAPHE[@titre!=''][1])"/>
                                        <xsl:apply-templates select="following-sibling::*[generate-id(following-sibling::PARAGRAPHE[@titre!=''][1]) = $suivant][not(self::INTRODUCTION or self::CONCLUSION)]"/>
                                    </GRAIN>
                                </xsl:when>
                                <xsl:otherwise>
                                    <GRAIN label="{concat(../@label,'-',position())}" titre="{@titre}">
                                        <PARAGRAPHE>
                                            <xsl:apply-templates/>
                                        </PARAGRAPHE>
                                        <xsl:apply-templates select="following-sibling::*[not(self::INTRODUCTION or self::CONCLUSION)]"/>
                                    </GRAIN>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                        <xsl:apply-templates select="CONCLUSION"/>
                    </SECTION>
                </xsl:when>
                <xsl:when test="INTRODUCTION or CONCLUSION">
                    <SECTION label="{@label}" titre="{@titre}">
                        <xsl:apply-templates select="INTRODUCTION"/>
                        <GRAIN label="{@label}" titre="{@titre}">
                            <xsl:apply-templates select="*[not(self::INTRODUCTION or self::CONCLUSION)]"/>
                        </GRAIN>
                        <xsl:apply-templates select="CONCLUSION"/>
                    </SECTION>
                </xsl:when>
                <xsl:otherwise>
                    <GRAIN label="{@label}" titre="{@titre}">
                        <xsl:apply-templates select="*"/>
                    </GRAIN>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="count(SAUTPAGEHTML) = 0">
            <SECTION label="{@label}" titre="{@titre}">
                <xsl:apply-templates select="INTRODUCTION"/>
                <GRAIN label="{@label}-1" titre="{@titre}">
                    <xsl:apply-templates select="*[not(self::INTRODUCTION or self::CONCLUSION or self::ANNEXES or self::GLOSSAIRE or self::BIBLIOGRAPHIE or self::WEBOGRAPHIE)]"/>
                </GRAIN>
                <xsl:apply-templates select="CONCLUSION"/>
                <xsl:apply-templates select="ANNEXES|GLOSSAIRE|BIBLIOGRAPHIE|WEBOGRAPHIE"/>
            </SECTION>
        </xsl:when>
        <xsl:otherwise> <!-- coupure avec les sauts de page, on perd les titres de paragraphes -->
            <!-- les introductions seront dplaces au dbut, et les conclusions  la fin -->
            <SECTION label="{@label}" titre="{@titre}">
                <xsl:apply-templates select="INTRODUCTION"/>
                <xsl:if test="count(SAUTPAGEHTML[1]/preceding-sibling::*[not(self::INTRODUCTION or self::CONCLUSION)]) &gt; 0">
                    <GRAIN label="{@label}-debut" titre="{@titre}">
                        <xsl:apply-templates select="SAUTPAGEHTML[1]/preceding-sibling::*[not(self::INTRODUCTION or self::CONCLUSION)]"/>
                    </GRAIN>
                </xsl:if>
                <xsl:for-each select="SAUTPAGEHTML">
                    <xsl:choose>
                        <xsl:when test="position()!=last()">
                            <GRAIN label="{concat(../@label,'-',position())}" titre="{@titre}">
                                <xsl:variable name="suivant" select="generate-id(following-sibling::SAUTPAGEHTML[1])"/>
                                <xsl:apply-templates select="following-sibling::*[generate-id(following-sibling::SAUTPAGEHTML[1]) = $suivant][not(self::INTRODUCTION or self::CONCLUSION)]"/>
                            </GRAIN>
                        </xsl:when>
                        <xsl:when test="following-sibling::*[not(self::SAUTPAGEPDF or self::INTRODUCTION or self::CONCLUSION or self::ANNEXES or self::GLOSSAIRE or self::BIBLIOGRAPHIE or self::WEBOGRAPHIE)]">
                            <GRAIN label="{concat(../@label,'-',position())}" titre="{@titre}">
                                <xsl:apply-templates select="following-sibling::*[not(self::INTRODUCTION or self::CONCLUSION or self::ANNEXES or self::GLOSSAIRE or self::BIBLIOGRAPHIE or self::WEBOGRAPHIE)]"/>
                            </GRAIN>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
                <xsl:apply-templates select="CONCLUSION"/>
                <xsl:apply-templates select="ANNEXES|GLOSSAIRE|BIBLIOGRAPHIE|WEBOGRAPHIE"/>
            </SECTION>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template match="PARAGRAPHE"> <!-- pb du titre, pas toujours conserv (parfois le PARAGRAPHE est transform en GRAIN) -->
    <PARAGRAPHE><xsl:apply-templates/></PARAGRAPHE>
</xsl:template>

<xsl:template match="LISTE">
    <LISTE>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </LISTE>
</xsl:template>

<xsl:template match="ITEM">
    <ITEM><xsl:apply-templates/></ITEM>
</xsl:template>

<xsl:template match="ZONETABLE">
    <ZONETABLE>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </ZONETABLE>
</xsl:template>

<xsl:template match="TABLE">
    <TABLE>
        <xsl:apply-templates/>
    </TABLE>
</xsl:template>

<xsl:template match="TR">
    <TR>
        <xsl:apply-templates/>
    </TR>
</xsl:template>

<xsl:template match="TD">
    <TD>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </TD>
</xsl:template>

<xsl:template match="TH">
    <TH>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </TH>
</xsl:template>

<xsl:template match="MEDIA">
    <MEDIA>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </MEDIA>
</xsl:template>

<xsl:template match="FICHIER">
    <FICHIER format="{@format}" chemin="{@chemin}"/>
</xsl:template>

<xsl:template match="LEGENDE">
    <LEGENDE>
        <xsl:apply-templates/>
    </LEGENDE>
</xsl:template>

<xsl:template match="TAILLE">
    <TAILLE largeur="{@largeur}" hauteur="{@hauteur}"/>
</xsl:template>

<xsl:template match="CREDITS">
    <CREDITS>
        <xsl:apply-templates/>
    </CREDITS>
</xsl:template>

<xsl:template match="PARAMETRES">
    <PARAMETRES>
        <xsl:apply-templates/>
    </PARAMETRES>
</xsl:template>

<xsl:template match="PARAMETRE">
    <PARAMETRE nom="{@nom}" valeur="{@valeur}"/>
</xsl:template>

<xsl:template match="SAUTPAGEHTML"></xsl:template>

<xsl:template match="SAUTPAGEPDF"></xsl:template>

<xsl:template match="INTRODUCTION">
    <INTRODUCTION>
        <xsl:call-template name="blocs"/>
    </INTRODUCTION>
</xsl:template>

<xsl:template name="blocs">
    <xsl:choose>
        <xsl:when test="PARAGRAPHE or LISTE or MEDIA or BR">
            <xsl:if test="count(*[self::PARAGRAPHE or self::LISTE or self::MEDIA or self::BR][1]/preceding-sibling::node()[not(self::text()) or normalize-space(.)!='']) &gt; 0">
                <PARAGRAPHE>
                    <xsl:apply-templates select="*[self::PARAGRAPHE or self::LISTE or self::MEDIA or self::BR][1]/preceding-sibling::node()"/>
                </PARAGRAPHE>
            </xsl:if>
            <xsl:for-each select="PARAGRAPHE|LISTE|MEDIA|BR">
                <xsl:if test="not(self::BR)">
                    <xsl:apply-templates select="."/>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="position()!=last()">
                        <xsl:variable name="suivant" select="generate-id(following-sibling::*[self::PARAGRAPHE or self::LISTE or self::MEDIA or self::BR][1])"/>
                        <xsl:variable name="contenu"><xsl:apply-templates select="following-sibling::node()[generate-id(following-sibling::*[self::PARAGRAPHE or self::LISTE or self::MEDIA or self::BR][1]) = $suivant][not(self::text()) or normalize-space(.)!='']"/></xsl:variable>
                        <xsl:if test="$contenu!=''">
                            <PARAGRAPHE>
                                <xsl:value-of select="$contenu"/>
                            </PARAGRAPHE>
                        </xsl:if>
                    </xsl:when>
                    <xsl:when test="following-sibling::node()[not(self::text()) or normalize-space(.)!='']">
                        <PARAGRAPHE>
                            <xsl:apply-templates select="following-sibling::node()"/>
                        </PARAGRAPHE>
                    </xsl:when>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <PARAGRAPHE>
                <xsl:apply-templates/>
            </PARAGRAPHE>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="CONCLUSION">
    <CONCLUSION>
        <xsl:call-template name="blocs"/>
    </CONCLUSION>
</xsl:template>

<xsl:template match="DEFINITION">
    <DEFINITION>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </DEFINITION>
</xsl:template>

<xsl:template match="EXEMPLE">
    <EXEMPLE>
        <xsl:call-template name="blocs"/>
    </EXEMPLE>
</xsl:template>

<xsl:template match="REMARQUE">
    <REMARQUE>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </REMARQUE>
</xsl:template>

<xsl:template match="METHODE">
    <METHODE>
        <xsl:call-template name="blocs"/>
    </METHODE>
</xsl:template>

<xsl:template match="RAPPEL">
    <RAPPEL>
        <xsl:call-template name="blocs"/>
    </RAPPEL>
</xsl:template>

<xsl:template match="COMPLEMENT">
    <COMPLEMENT>
        <xsl:call-template name="blocs"/>
    </COMPLEMENT>
</xsl:template>

<xsl:template match="ENSAVOIRPLUS">
    <ENSAVOIRPLUS>
        <xsl:call-template name="blocs"/>
    </ENSAVOIRPLUS>
</xsl:template>

<xsl:template match="ATTENTION">
    <ATTENTION>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </ATTENTION>
</xsl:template>

<xsl:template match="SYNTAXE">
    <SYNTAXE>
        <xsl:call-template name="blocs"/>
    </SYNTAXE>
</xsl:template>

<xsl:template match="EXPLICATION">
    <EXPLICATION>
        <xsl:call-template name="blocs"/>
    </EXPLICATION>
</xsl:template>

<xsl:template match="CONSEIL">
    <CONSEIL>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </CONSEIL>
</xsl:template>

<xsl:template match="CONFERE">
    <CONFERE>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </CONFERE>
</xsl:template>

<xsl:template match="CITATION">
    <CITATION>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </CITATION>
</xsl:template>

<xsl:template match="ACTIVITE">
    <ACTIVITE>
        <!-- il n'y a plus d'attribut titre  cet lment, il n'tait de toutes faons pas gr par le XSLT -->
        <xsl:if test="@titre!=''">
            <PARAGRAPHE>
                <xsl:value-of select="@titre"/>
            </PARAGRAPHE>
        </xsl:if>
        <xsl:apply-templates/>
    </ACTIVITE>
</xsl:template>


<xsl:template match="QCM">
    <QCM>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </QCM>
</xsl:template>

<xsl:template match="AIDE">
    <AIDE>
        <PARAGRAPHE>
            <xsl:apply-templates/>
        </PARAGRAPHE>
    </AIDE>
</xsl:template>

<xsl:template match="QUESTIONQCM">
    <QUESTIONQCM>
        <xsl:apply-templates/>
    </QUESTIONQCM>
</xsl:template>

<xsl:template match="ENONCE">
    <ENONCEQCM>
        <xsl:apply-templates/>
    </ENONCEQCM>
</xsl:template>

<xsl:template match="REPONSE">
    <REPONSEQCM bonne="{@bonne}">
        <xsl:apply-templates select="TEXTEREP"/>
        <xsl:apply-templates select="COMMENTAIREREP"/>
    </REPONSEQCM>
</xsl:template>

<xsl:template match="TEXTEREP">
    <TEXTEREP>
        <xsl:apply-templates/>
    </TEXTEREP>
</xsl:template>

<xsl:template match="COMMENTAIREREP">
    <COMMENTAIREREP>
        <xsl:apply-templates/>
    </COMMENTAIREREP>
</xsl:template>


<xsl:template match="COMMENTAIRE">
    <COMMENTAIRE>
        <xsl:apply-templates/>
    </COMMENTAIRE>
</xsl:template>


<xsl:template match="LIEN">
    <LIEN type="{@type}" label="{@label}"><xsl:apply-templates/></LIEN>
</xsl:template>

<xsl:template match="ALTSURMOT">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="ALT">
    <LIEN type="annexe" label="@label">
        <xsl:apply-templates select="FICHIER|ALTSURMOT"/>
    </LIEN>
</xsl:template>

<xsl:template match="LIENWEB">
    <LIENWEB url="{@url}">
        <xsl:apply-templates/>
    </LIENWEB>
</xsl:template>

<xsl:template match="LIENDOCUMENT">
    <LIENDOCUMENT url="{@url}">
        <xsl:apply-templates/>
    </LIENDOCUMENT>
</xsl:template>

<xsl:template match="EQUAJAXE">
    <EQUAJAXE texte="{@texte}" image="{@image}"/>
</xsl:template>

<xsl:template match="EQUATEX">
    <EQUATEX texte="{@texte}" image="{@image}"/>
</xsl:template>


<xsl:template match="EM">
    <EM><xsl:apply-templates/></EM>
</xsl:template>

<xsl:template match="B">
    <B><xsl:apply-templates/></B>
</xsl:template>

<xsl:template match="I">
    <I><xsl:apply-templates/></I>
</xsl:template>

<xsl:template match="SUP">
    <SUP><xsl:apply-templates/></SUP>
</xsl:template>

<xsl:template match="SUB">
    <SUB><xsl:apply-templates/></SUB>
</xsl:template>

<xsl:template match="NBSP"><NBSP/></xsl:template>

<xsl:template match="BR">
    <BR/>
</xsl:template>

</xsl:stylesheet>
