<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">
    
    <!-- ************************************************ -->
    <!-- creation de la webographie pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.2 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
    <!-- version 1.0 pour UVED 2.0 -  Damien Guillaume, Observatoire de Paris -->

    <xsl:template name="UVED_WEBOGRAPHIE">

        <xsl:call-template name="ecrireDansFichier">
           <xsl:with-param name="fichier" select="concat($cheminSite,'webographie.html')"/>
           <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource">
                        <xsl:with-param name="titre">UVED - Webographie</xsl:with-param>
                    </xsl:call-template>
                    <body>
                        <xsl:call-template name="bodyheaderRessource">
                            <xsl:with-param name="selection">ressources</xsl:with-param>
                        </xsl:call-template>
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-page">
                                <h3>Ressources</h3>
                                <h4>Webographie</h4>
                            </div>
    
                            <!-- creation de la liste des ressources accessibles -->
                            <xsl:call-template name="selectressources" />
    
                            <table>
                                <thead>
                                    <tr>
                                        <th class="gras">
                                            Contenu du site
                                        </th>
                                        <th class="gras">URL</th>
                                    </tr>
                                </thead>
                                <tbody>
    
                                    <!-- affichage des adresses de la webographie-->
                                    <xsl:for-each select="u:UVED//u:REFERENCEWEBOGRAPHIQUE">
                                        <xsl:sort order="ascending" select="@URL" />
                                        <xsl:if test="not(preceding::u:REFERENCEWEBOGRAPHIQUE/@URL=@URL)">
                                            <tr>
                                                <td class="cellule-alternative">
                                                    <xsl:apply-templates select="." mode="webographie"/>
                                                </td>
                                                <td>
                                                    <a href="{@URL}" target="_blank">
                                                        <xsl:value-of select="@URL" />
                                                    </a>
                                                </td>
                                            </tr>
                                        </xsl:if>
                                    </xsl:for-each>
                                </tbody>
                            </table>
    
                        </div>
                    <xsl:call-template name="footerRessource">
                         <!--<xsl:with-param name="pageActive">webographie</xsl:with-param>-->
                    </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>


    <!-- ************************************************ -->
    <!-- creation liste des ressources-->
    <!-- ************************************************ -->
    <xsl:template name="selectressources">
        <div class="selection">
            <fieldset>
                <form action="">
                    <select onchange="location=this.options[this.selectedIndex].value;">
                        <option>Voir une autre ressource...</option>

                        <xsl:if test="count(u:UVED//u:MOTDUGLOSSAIRE)>0">
                            <option value="glossaire.html">
                                - Glossaire
                            </option>
                        </xsl:if>

                        <xsl:if test="count(u:UVED//u:REFERENCEBIBLIOGRAPHIQUE)>0">
                            <option value="bibliographie.html">
                                - Bibliographie
                            </option>
                        </xsl:if>
                    </select>
                </form>
            </fieldset>
        </div>
    </xsl:template>

    <!-- ************************************************ -->
    <!-- Rfrence webographique -->
    <!-- ************************************************ -->
    <xsl:template match="u:REFERENCEWEBOGRAPHIQUE" mode="webographie">
        <p>
            <b><xsl:value-of select="@auteurs"/></b>.
            <b><i><xsl:value-of select="@titre"/></i></b>.
            <xsl:if test="@titreSite">
                In <b><i><xsl:value-of select="@titreSite"/></i></b>.
            </xsl:if>
            [consult le <xsl:value-of select="@dateConsultation"/>].
        </p>
        <p>
            <xsl:value-of select="u:DESCRIPTION" />
        </p>
    </xsl:template>

</xsl:stylesheet>
