<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

    <!-- ************************************************ -->
    <!-- creation de la page des ressources pour les cours UVED -->
    <!-- ************************************************ -->
    <!-- version 0.1 Romuald Lorthioir - CIRM - Universit de Rennes 1 -->
    <!-- version 1.0 pour UVED 2.0 -  Damien Guillaume, Observatoire de Paris -->

    <xsl:template name="UVED_RESSOURCES">
    
        <xsl:call-template name="ecrireDansFichier">
            <xsl:with-param name="fichier" select="concat($cheminSite,'ressources.html')"/>
            <xsl:with-param name="contenu">
                <html lang="fr">
    
                    <xsl:call-template name="headerRessource">
                        <xsl:with-param name="titre">UVED - Ressources</xsl:with-param>
                    </xsl:call-template>
                    <body>
                        <xsl:call-template name="bodyheaderRessource">
                            <xsl:with-param name="selection">ressources</xsl:with-param>
                        </xsl:call-template>
                        <div id="content" class="ressources">
                            <a name="top"></a>
                            <div class="titre-page">
                                <h3>Ressources</h3>
                            </div>
                            <div class="liste-ressources">
                                <h4>Vous trouverez ici toutes les ressources du cours :</h4>
                                <ol>
                                    <xsl:if
                                        test="count(u:UVED//u:MOTDUGLOSSAIRE)>0">
                                        <li><a href="glossaire.html">Glossaire</a></li>
                                    </xsl:if>
    
                                    <xsl:if
                                        test="count(u:UVED//u:REFERENCEBIBLIOGRAPHIQUE)>0">
                                        <li><a href="bibliographie.html">Bibliographie</a></li>
                                    </xsl:if>
    
                                    <xsl:if
                                        test="count(u:UVED//u:REFERENCEWEBOGRAPHIQUE)>0">
                                        <li>
                                            <a href="webographie.html">
                                                Webographie
                                            </a>
                                        </li>
                                    </xsl:if>
    
                                </ol>
                            </div>
                        </div>
                        <xsl:call-template name="footerRessource">
                            <!--<xsl:with-param name="pageActive">ressources</xsl:with-param>-->
                        </xsl:call-template>
                    </body>
                </html>
            </xsl:with-param>
        </xsl:call-template>
    </xsl:template>

</xsl:stylesheet>
