<?xml version="1.0" encoding='ISO-8859-1'?>

<xsl:stylesheet version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:u="http://www.uved.fr/schema/2.0"
    exclude-result-prefixes="u">

<!-- ************************************************ -->
<!-- Gnration du cours UVED-->
<!-- ************************************************ -->
<!-- version 0.3 Romuald Lorthioir et Nadia Henry - CIRM - Universit de Rennes 1 -->
<!-- version 1.0 pour UVED 2.0 - Damien Guillaume, Observatoire de Paris -->

<!-- ************************************************ -->
<!-- Traitement des pages de cours UVED-->
<!-- ************************************************ -->
<xsl:template name="UVED_COURS">

    <xsl:for-each select="u:UVED//u:SECTION">
        
        <xsl:variable name="plan"><xsl:call-template name="sommairePage">
            <xsl:with-param name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each></xsl:with-param>
        </xsl:call-template></xsl:variable>
        
        <!-- page de la section quand il y en a une -->
        <xsl:if test="u:INTRODUCTION|u:PREREQUIS|u:OBJECTIFS|u:CITATION|u:RAPPEL|u:DEFINITION|u:METHODE|u:ATTENTION|u:CONSEIL">
            <xsl:call-template name="page">
                <xsl:with-param name="nomFichier"><xsl:call-template name="chemin-fichier"/></xsl:with-param>
                <xsl:with-param name="pageSuivante"><xsl:call-template name="chemin-page-suivante"/></xsl:with-param>
                <xsl:with-param name="pagePrecedente"><xsl:call-template name="chemin-page-precedente"/></xsl:with-param>
                <xsl:with-param name="plan" select="$plan"/>
            </xsl:call-template>
        </xsl:if>
        
        <xsl:for-each select="u:CONCLUSION"> <!-- pas ANNEXES ni les ressources -->
            <xsl:call-template name="page">
                <xsl:with-param name="nomFichier"><xsl:call-template name="chemin-fichier"/></xsl:with-param>
                <xsl:with-param name="pageSuivante"><xsl:call-template name="chemin-page-suivante"/></xsl:with-param>
                <xsl:with-param name="pagePrecedente"><xsl:call-template name="chemin-page-precedente"/></xsl:with-param>
                <xsl:with-param name="plan" select="$plan"/>
            </xsl:call-template>
        </xsl:for-each>
        
    </xsl:for-each>
    
    <!-- une page par grain -->
    <xsl:for-each select="u:UVED//u:GRAIN">
        
        <xsl:variable name="plan"><xsl:call-template name="sommairePage">
            <xsl:with-param name="prefixe"><xsl:for-each select="ancestor::u:SECTION">../</xsl:for-each></xsl:with-param>
        </xsl:call-template></xsl:variable>
        
        <xsl:call-template name="page">
            <xsl:with-param name="nomFichier"><xsl:call-template name="chemin-fichier"/></xsl:with-param>
            <xsl:with-param name="pageSuivante"><xsl:call-template name="chemin-page-suivante"/></xsl:with-param>
            <xsl:with-param name="pagePrecedente"><xsl:call-template name="chemin-page-precedente"/></xsl:with-param>
            <xsl:with-param name="plan" select="$plan"/>
        </xsl:call-template>
        
    </xsl:for-each>
    
    <!-- fichiers pour les medias en page ou icne -->
    <xsl:for-each select="u:UVED//u:MEDIA[@localisation='page' or @localisation='icne']">
        <xsl:call-template name="fichier-media"/>
    </xsl:for-each>
    
</xsl:template>


<!-- ************************************************ -->
<!-- Gnration d'une page de cours UVED-->
<!-- ************************************************ -->
<xsl:template name="page">
    <xsl:param name="nomFichier"/>
    <xsl:param name="pageSuivante"/>
    <xsl:param name="pagePrecedente"/>
    <xsl:param name="plan"/>
    
    <xsl:variable name="idPage"><xsl:call-template name="idPage"/></xsl:variable>
    
    <!-- Cration du fichier de la page -->
    <xsl:call-template name="ecrireDansFichier">
        <xsl:with-param name="fichier" select="$nomFichier"/>
        <xsl:with-param name="contenu">
            <html lang="fr">
                <xsl:call-template name="headerPage" >
                    <xsl:with-param name="idPage" select="$idPage"/>
                    <xsl:with-param name="pagePrecedente" select="$pagePrecedente"/>
                    <xsl:with-param name="pageSuivante" select="$pageSuivante"/>
                </xsl:call-template>
                <body>
                    <xsl:call-template name="bodyheaderPage" />
                    
                    <!-- SOMMAIRE -->
                    <div id="course-map">
                        <ul id="tree" class="tree-view">
                            <xsl:copy-of select="$plan"/>
                        </ul>
                    </div>
                    
                    <!-- contenu de la page -->
                    <div id="content" class="cours">
                        <!-- titre de la page -->
                        <xsl:if test="self::u:SECTION|self::u:GRAIN">
                            <xsl:apply-templates select="."/>
                        </xsl:if>
                        <!-- CONTENU -->
                        <xsl:call-template name="contenuPage"/>
                        &#xA0;
                    </div>
                    <!-- DIV en ALT -->
                    <xsl:call-template name="coursDivInvisibles"/>
                    <!-- PIED de Page -->
                    <xsl:call-template name="footerPage">
                        <xsl:with-param name="pagePrecedente" select="$pagePrecedente"/>
                        <xsl:with-param name="pageSuivante" select="$pageSuivante"/>
                    </xsl:call-template>
                </body>
            </html>
        </xsl:with-param>
</xsl:call-template>

</xsl:template>



<!-- ************************************************ -->
<!-- chemin du fichier de la page de l'lment courant -->
<!-- ************************************************ -->
<xsl:template name="chemin-fichier">
    <xsl:variable name="debut-chemin"><xsl:for-each select="(ancestor::u:SECTION)[self::u:SECTION]"><xsl:value-of select="concat(@label, $sep)"/></xsl:for-each></xsl:variable>
    <xsl:choose>
        <xsl:when test="self::u:GRAIN">
            <xsl:value-of select="concat($cheminSite,$debut-chemin,@label,'.html')"/>
        </xsl:when>
        <xsl:when test="self::u:SECTION">
            <xsl:value-of select="concat($cheminSite,$debut-chemin,@label,$sep,'index.html')"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="concat($cheminSite,$debut-chemin,name(),'.html')"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!-- ************************************************ -->
<!-- chemin de la page suivante par rapport  la page de l'lment courant, ou rien s'il n'y en a pas -->
<!-- ************************************************ -->
<xsl:template name="chemin-page-suivante">
    <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each></xsl:variable>
    <xsl:choose>
        <xsl:when test="self::u:SECTION">
            <xsl:for-each select="(descendant::*[self::u:GRAIN or self::u:CONCLUSION] | following::*[self::u:INTRODUCTION or self::u:PREREQUIS or self::u:OBJECTIFS or self::u:CITATION or self::u:RAPPEL or self::u:DEFINITION or self::u:METHODE or self::u:ATTENTION or self::u:CONSEIL or self::u:GRAIN or self::u:CONCLUSION])[1]">
                <xsl:call-template name="chemin-page">
                    <xsl:with-param name="prefixe" select="$prefixe"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="following::*[self::u:INTRODUCTION or self::u:PREREQUIS or self::u:OBJECTIFS or self::u:CITATION or self::u:RAPPEL or self::u:DEFINITION or self::u:METHODE or self::u:ATTENTION or self::u:CONSEIL or self::u:GRAIN or self::u:CONCLUSION][not(parent::u:ANNEXE)][1]">
                <xsl:call-template name="chemin-page">
                    <xsl:with-param name="prefixe" select="$prefixe"/>
                </xsl:call-template>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!-- ************************************************ -->
<!-- chemin de la page prcdente par rapport  la page de l'lment courant, ou rien s'il n'y en a pas -->
<!-- ************************************************ -->
<xsl:template name="chemin-page-precedente">
    <xsl:variable name="prefixe"><xsl:for-each select="ancestor-or-self::u:SECTION">../</xsl:for-each></xsl:variable>
    <xsl:for-each select="preceding::*[self::u:INTRODUCTION or self::u:PREREQUIS or self::u:OBJECTIFS or self::u:CITATION or self::u:RAPPEL or self::u:DEFINITION or self::u:METHODE or self::u:ATTENTION or self::u:CONSEIL or self::u:GRAIN or self::u:CONCLUSION][1]">
        <xsl:call-template name="chemin-page">
            <xsl:with-param name="prefixe" select="$prefixe"/>
        </xsl:call-template>
    </xsl:for-each>
</xsl:template>


<!-- ************************************************ -->
<!-- chemin de la page du noeud courant -->
<!-- ************************************************ -->
<xsl:template name="chemin-page">
    <xsl:param name="prefixe"/>
    
    <xsl:variable name="debut-chemin"><xsl:for-each select="ancestor::u:SECTION"><xsl:value-of select="@label"/>/</xsl:for-each></xsl:variable>
    <xsl:choose>
        <xsl:when test="self::u:GRAIN">
            <xsl:value-of select="concat($prefixe,$debut-chemin,@label,'.html')"/>
        </xsl:when>
        <xsl:when test="self::u:INTRODUCTION or self::u:PREREQUIS or self::u:OBJECTIFS or self::u:CITATION or self::u:RAPPEL or self::u:DEFINITION or self::u:METHODE or self::u:ATTENTION or self::u:CONSEIL">
            <xsl:value-of select="concat($prefixe,$debut-chemin,'index.html')"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="concat($prefixe,$debut-chemin,name(),'.html')"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!-- ************************************************ -->
<!-- Gnration du contenu des pages -->
<!-- ************************************************ -->
<xsl:template name="contenuPage">
   
    <xsl:choose>
        <xsl:when test="self::u:SECTION">
            <xsl:apply-templates select="u:INTRODUCTION|u:PREREQUIS|u:OBJECTIFS|u:CITATION|u:RAPPEL|u:DEFINITION|u:METHODE|u:ATTENTION|u:CONSEIL"/>
        </xsl:when>
        <xsl:when test="self::u:GRAIN">
            <xsl:apply-templates select="*"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select="."/>
        </xsl:otherwise>
    </xsl:choose>
    
</xsl:template>


<!-- ************************************************ -->
<!-- Cas particulier des alts BIBLIO et WEBO          -->
<!-- ************************************************ -->
<xsl:template name="coursDivInvisibles">
   
    <xsl:choose>
        <xsl:when test="self::u:SECTION">
            <xsl:for-each select="u:INTRODUCTION|u:PREREQUIS|u:OBJECTIFS|u:CITATION|u:RAPPEL|u:DEFINITION|u:METHODE|u:ATTENTION|u:CONSEIL">
                <xsl:apply-templates select=".//*[self::u:NOTE | self::u:MOTDUGLOSSAIRE | self::u:LIENMOTDUGLOSSAIRE | self::u:REFERENCEBIBLIOGRAPHIQUE | self::u:LIENREFERENCEBIBLIOGRAPHIQUE | self::u:REFERENCEWEBOGRAPHIQUE | self::u:LIENREFERENCEWEBOGRAPHIQUE]" mode="div"/>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select=".//*[self::u:MOTDUGLOSSAIRE or self::u:LIENMOTDUGLOSSAIRE or self::u:REFERENCEBIBLIOGRAPHIQUE or self::u:LIENREFERENCEBIBLIOGRAPHIQUE or self::u:REFERENCEWEBOGRAPHIQUE or self::u:LIENREFERENCEWEBOGRAPHIQUE]">
                <xsl:if test="count(ancestor::u:BIBLIOGRAPHIE)=0 and count(ancestor::u:WEBOGRAPHIE)=0 and count(ancestor::u:GLOSSAIRE)=0 and count(ancestor::u:ANNEXE)=0"> 
                    <xsl:apply-templates select="." mode="div"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
     
</xsl:template>

</xsl:stylesheet>
