/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.bitmap.TIFFRenderer;

public class TIFFRendererConfigurator
extends PrintRendererConfigurator {
    public TIFFRendererConfigurator(FOUserAgent userAgent) {
        super(userAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration cfg = super.getRendererConfig(renderer);
        if (cfg != null) {
            TIFFRenderer tiffRenderer = (TIFFRenderer)renderer;
            String name = cfg.getChild("compression").getValue("PackBits");
            if (name.equalsIgnoreCase("CCITT T.6")) {
                tiffRenderer.setBufferedImageType(12);
            } else if (name.equalsIgnoreCase("CCITT T.4")) {
                tiffRenderer.setBufferedImageType(12);
            } else {
                tiffRenderer.setBufferedImageType(2);
            }
            if (!"NONE".equalsIgnoreCase(name)) {
                tiffRenderer.getWriterParams().setCompressionMethod(name);
            }
            if (log.isInfoEnabled()) {
                log.info("TIFF compression set to " + name);
            }
        }
        super.configure(renderer);
    }
}

