/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.render.afp.modca.AbstractAFPObject;
import org.apache.fop.render.afp.modca.MaximumSizeExceededException;
import org.apache.fop.render.afp.tools.BinaryUtils;

public class MapPageOverlay
extends AbstractAFPObject {
    private List overLays = new ArrayList();

    public void addOverlay(String name) throws MaximumSizeExceededException {
        if (this.overLays.size() > 253) {
            throw new MaximumSizeExceededException();
        }
        if (name.length() != 8) {
            throw new IllegalArgumentException("The name of overlay " + name + " must be 8 characters");
        }
        if (log.isDebugEnabled()) {
            log.debug("addOverlay():: adding overlay " + name);
        }
        try {
            byte[] data = name.getBytes("Cp1146");
            this.overLays.add(data);
        }
        catch (UnsupportedEncodingException usee) {
            log.error("addOverlay():: UnsupportedEncodingException translating the name " + name);
        }
    }

    public void writeDataStream(OutputStream os) throws IOException {
        int oLayCount = this.overLays.size();
        int recordlength = oLayCount * 18;
        byte[] data = new byte[recordlength + 9];
        data[0] = 90;
        byte[] rl1 = BinaryUtils.convert(recordlength + 8, 2);
        data[1] = rl1[0];
        data[2] = rl1[1];
        data[3] = -45;
        data[4] = -85;
        data[5] = -40;
        data[6] = 0;
        data[7] = 0;
        data[8] = 0;
        int pos = 8;
        int olayref = 0;
        for (int i = 0; i < oLayCount; ++i) {
            olayref = (byte)(olayref + 1);
            data[++pos] = 0;
            data[++pos] = 18;
            data[++pos] = 12;
            data[++pos] = 2;
            data[++pos] = -124;
            data[++pos] = 0;
            byte[] name = (byte[])this.overLays.get(i);
            for (int j = 0; j < name.length; ++j) {
                data[++pos] = name[j];
            }
            data[++pos] = 4;
            data[++pos] = 36;
            data[++pos] = 2;
            data[++pos] = olayref;
        }
        os.write(data);
    }
}

