/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFWritable;

public class PDFReference
implements PDFWritable {
    private String indirectReference;
    private Reference objReference;

    public PDFReference(PDFObject obj) {
        this.indirectReference = obj.referencePDF();
        this.objReference = new SoftReference<PDFObject>(obj);
    }

    public PDFReference(String ref) {
        if (ref == null) {
            throw new NullPointerException("ref must not be null");
        }
        this.indirectReference = ref;
    }

    public PDFObject getObject() {
        if (this.objReference != null) {
            PDFObject obj = (PDFObject)this.objReference.get();
            if (obj == null) {
                this.objReference = null;
            }
            return obj;
        }
        return null;
    }

    public String toString() {
        return this.indirectReference;
    }

    public void outputInline(OutputStream out, Writer writer) throws IOException {
        writer.write(this.toString());
    }
}

