/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.layoutmgr.AbstractBaseLayoutManager;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Page;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public abstract class AbstractLayoutManager
extends AbstractBaseLayoutManager
implements Constants {
    private static Log log = LogFactory.getLog(AbstractLayoutManager.class);
    protected LayoutManager parentLM = null;
    protected List childLMs = null;
    protected ListIterator fobjIter = null;
    private Map markers = null;
    private boolean bFinished = false;
    protected LayoutManager curChildLM = null;
    protected ListIterator childLMiter = null;
    private int lastGeneratedPosition = -1;
    private int smallestPosNumberChecked = Integer.MAX_VALUE;

    public AbstractLayoutManager() {
    }

    public AbstractLayoutManager(FObj fo) {
        super(fo);
        if (fo == null) {
            throw new IllegalStateException("Null formatting object found.");
        }
        this.markers = fo.getMarkers();
        this.fobjIter = fo.getChildNodes();
        this.childLMiter = new LMiter(this);
    }

    public void setParent(LayoutManager lm) {
        this.parentLM = lm;
    }

    public LayoutManager getParent() {
        return this.parentLM;
    }

    public void initialize() {
    }

    protected LayoutManager getChildLM() {
        if (this.curChildLM != null && !this.curChildLM.isFinished()) {
            return this.curChildLM;
        }
        if (this.childLMiter.hasNext()) {
            this.curChildLM = (LayoutManager)this.childLMiter.next();
            this.curChildLM.initialize();
            return this.curChildLM;
        }
        return null;
    }

    protected boolean hasNextChildLM() {
        return this.childLMiter.hasNext();
    }

    public boolean isFinished() {
        return this.bFinished;
    }

    public void setFinished(boolean fin) {
        this.bFinished = fin;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        log.warn("null implementation of getNextKnuthElements() called!");
        this.setFinished(true);
        return null;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        log.warn("null implementation of getChangeKnuthElement() called!");
        return null;
    }

    public Area getParentArea(Area childArea) {
        return null;
    }

    public void addChildArea(Area childArea) {
    }

    protected List createChildLMs(int size) {
        if (this.fobjIter == null) {
            return null;
        }
        ArrayList newLMs = new ArrayList(size);
        while (this.fobjIter.hasNext() && newLMs.size() < size) {
            Object theobj = this.fobjIter.next();
            if (!(theobj instanceof FONode)) continue;
            FONode foNode = (FONode)theobj;
            if (foNode instanceof RetrieveMarker) {
                foNode = this.getPSLM().resolveRetrieveMarker((RetrieveMarker)foNode);
            }
            if (foNode == null) continue;
            this.getPSLM().getLayoutManagerMaker().makeLayoutManagers(foNode, newLMs);
        }
        return newLMs;
    }

    public PageSequenceLayoutManager getPSLM() {
        return this.parentLM.getPSLM();
    }

    public Page getCurrentPage() {
        return this.getPSLM().getCurrentPage();
    }

    public PageViewport getCurrentPV() {
        return this.getPSLM().getCurrentPage().getPageViewport();
    }

    public boolean createNextChildLMs(int pos) {
        List newLMs = this.createChildLMs(pos + 1 - this.childLMs.size());
        this.addChildLMs(newLMs);
        return pos < this.childLMs.size();
    }

    public List getChildLMs() {
        if (this.childLMs == null) {
            this.childLMs = new ArrayList(10);
        }
        return this.childLMs;
    }

    public void addChildLM(LayoutManager lm) {
        if (lm == null) {
            return;
        }
        lm.setParent(this);
        if (this.childLMs == null) {
            this.childLMs = new ArrayList(10);
        }
        this.childLMs.add(lm);
        log.trace(this.getClass().getName() + ": Adding child LM " + lm.getClass().getName());
    }

    public void addChildLMs(List newLMs) {
        if (newLMs == null || newLMs.size() == 0) {
            return;
        }
        ListIterator iter = newLMs.listIterator();
        while (iter.hasNext()) {
            LayoutManager lm = (LayoutManager)iter.next();
            this.addChildLM(lm);
        }
    }

    public Position notifyPos(Position pos) {
        if (pos.getIndex() >= 0) {
            throw new IllegalStateException("Position already got its index");
        }
        ++this.lastGeneratedPosition;
        pos.setIndex(this.lastGeneratedPosition);
        return pos;
    }

    public boolean isFirst(Position pos) {
        if (pos == null || pos.getIndex() < 0) {
            throw new IllegalArgumentException("Only non-null Positions with an index can be checked");
        }
        if (pos.getIndex() == this.smallestPosNumberChecked) {
            return true;
        }
        if (pos.getIndex() < this.smallestPosNumberChecked) {
            this.smallestPosNumberChecked = pos.getIndex();
            return true;
        }
        return false;
    }

    public boolean isLast(Position pos) {
        if (pos == null || pos.getIndex() < 0) {
            throw new IllegalArgumentException("Only non-null Positions with an index can be checked");
        }
        return pos.getIndex() == this.lastGeneratedPosition && this.isFinished();
    }

    protected void transferForeignAttributes(Area targetArea) {
        Map atts = this.getFObj().getForeignAttributes();
        targetArea.setForeignAttributes(atts);
    }

    protected void addMarkersToPage(boolean isStarting, boolean isFirst, boolean isLast) {
        if (this.markers != null) {
            this.getCurrentPV().addMarkers(this.markers, isStarting, isFirst, isLast);
        }
    }

    public String toString() {
        return super.toString() + (this.fobj != null ? "[fobj=" + this.fobj.toString() + "]" : "");
    }
}

