/*
 * Decompiled with CFR 0.152.
 */
package xpages;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.Position;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeResourceBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import xpages.DecodeurBase64;
import xpages.DialogueEquaTeX;
import xpages.EncodeurBase64;

public class JEEquaTeXMemoire
extends JaxeElement {
    JLabel label = null;
    private String serveur = null;
    static final float alignementY = 0.7f;

    public JEEquaTeXMemoire(JaxeDocument jaxeDocument) {
        this.doc = jaxeDocument;
    }

    public void init(Position position, Node node) {
        Object object;
        BufferedImage bufferedImage;
        Element element = (Element)node;
        Element element2 = this.doc.cfg.getElementRef(element);
        this.serveur = this.doc.cfg.valeurParametreElement(element2, "serveur", null);
        String string = null;
        Node node2 = element.getFirstChild();
        if (node2 != null && node2 instanceof Text) {
            string = node2.getNodeValue();
        }
        if ((bufferedImage = string == null || "".equals(string) ? null : this.lireImage(string)) == null) {
            this.label = new JLabel(this.getString("erreur.AffichageImage"));
            this.label.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        } else {
            object = bufferedImage != null ? new ImageIcon(bufferedImage) : null;
            if (object == null || ((ImageIcon)object).getImageLoadStatus() == 2 || ((ImageIcon)object).getImageLoadStatus() == 4) {
                this.label = new JLabel(this.getString("erreur.AffichageImage"));
                this.label.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            } else {
                this.label = new JLabel((Icon)object);
            }
        }
        this.label.setAlignmentY(0.7f);
        this.label.addMouseListener(new EcouteSouris(this, this.doc.jframe));
        object = this.insertComponent(position, this.label);
    }

    protected BufferedImage lireImage(String string) {
        try {
            return ImageIO.read(new DecodeurBase64(new StringReader(string)));
        }
        catch (IOException iOException) {
            System.err.println("lireImage(String): IOException: " + iOException.getMessage());
            return null;
        }
    }

    public Node nouvelElement(Element element) {
        this.serveur = this.doc.cfg.valeurParametreElement(element, "serveur", null);
        String string = this.doc.cfg.valeurParametreElement(element, "texteAtt", null);
        String string2 = this.doc.cfg.valeurParametreElement(element, "labelAtt", null);
        Element element2 = JEEquaTeXMemoire.nouvelElementDOM((JaxeDocument)this.doc, (Element)element);
        DialogueEquaTeX dialogueEquaTeX = new DialogueEquaTeX(this.doc, this.serveur, "", string2, null);
        if (!dialogueEquaTeX.afficher()) {
            return null;
        }
        String string3 = dialogueEquaTeX.getTexte();
        this.enregistrerImage(element2, DialogueEquaTeX.creerImage((Component)this.doc.textPane, this.serveur, string3, this.doc));
        String string4 = dialogueEquaTeX.getLabel();
        try {
            element2.setAttributeNS(this.doc.cfg.espaceAttribut(string), string, string3);
            if (string2 != null && string4 != null && !"".equals(string4)) {
                element2.setAttributeNS(this.doc.cfg.espaceAttribut(string2), string2, string4);
            }
        }
        catch (DOMException dOMException) {
            System.err.println("nouvelElement(Element): DOMException: " + dOMException.getMessage());
            return null;
        }
        return element2;
    }

    public void afficherDialogue(JFrame jFrame) {
        String string;
        Element element = (Element)this.noeud;
        Element element2 = this.doc.cfg.getElementRef(element);
        String string2 = this.doc.cfg.valeurParametreElement(element2, "texteAtt", null);
        String string3 = this.doc.cfg.valeurParametreElement(element2, "labelAtt", null);
        String string4 = element.getAttribute(string2);
        DialogueEquaTeX dialogueEquaTeX = new DialogueEquaTeX(this.doc, this.serveur, string4, string3, string = string3 != null ? element.getAttribute(string3) : null);
        if (!dialogueEquaTeX.afficher()) {
            return;
        }
        string4 = dialogueEquaTeX.getTexte();
        this.enregistrerImage(element, DialogueEquaTeX.creerImage((Component)this.doc.textPane, this.serveur, string4, this.doc));
        String string5 = dialogueEquaTeX.getLabel();
        try {
            element.setAttributeNS(this.doc.cfg.espaceAttribut(string2), string2, string4);
            if (string3 != null) {
                if (string != null && "".equals(string5)) {
                    element.removeAttribute(string3);
                } else {
                    element.setAttributeNS(this.doc.cfg.espaceAttribut(string3), string3, string5);
                }
            }
        }
        catch (DOMException dOMException) {
            System.err.println("afficherDialogue(JFrame): DOMException: " + dOMException.getMessage());
            return;
        }
        this.doc.modif = true;
        this.majAffichage();
    }

    public void majAffichage() {
        String string = null;
        Element element = (Element)this.noeud;
        Node node = element.getFirstChild();
        if (node != null && node instanceof Text) {
            string = node.getNodeValue();
        }
        if (string != null && !"".equals(string)) {
            BufferedImage bufferedImage = this.lireImage(string);
            boolean bl = false;
            if (bufferedImage == null) {
                bl = true;
            }
            if (!bl) {
                ImageIcon imageIcon = new ImageIcon(bufferedImage);
                this.label.setIcon(imageIcon);
                this.label.setText(null);
                this.label.setBorder(null);
            } else {
                this.label.setIcon(null);
                this.label.setText(this.getString("erreur.AffichageImage"));
                this.label.setBorder(BorderFactory.createLineBorder(Color.darkGray));
            }
        } else {
            this.label.setText(this.getString("erreur.FichierNonTrouve"));
            this.label.setIcon(null);
            this.label.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        }
        this.doc.imageChanged((JComponent)this.label);
    }

    protected void enregistrerImage(Element element, BufferedImage bufferedImage) {
        try {
            StringWriter stringWriter = new StringWriter();
            EncodeurBase64 encodeurBase64 = new EncodeurBase64(stringWriter);
            DialogueEquaTeX.enregistrerImage(bufferedImage, encodeurBase64);
            encodeurBase64.close();
            Node node = element.getFirstChild();
            if (node == null) {
                node = this.doc.DOMdoc.createTextNode(stringWriter.toString());
                element.appendChild(node);
            } else {
                node.setNodeValue(stringWriter.toString());
            }
        }
        catch (IOException iOException) {
            System.err.println("enregistrerImage(Element, BufferedImage): IOException: " + iOException.getMessage());
            JOptionPane.showMessageDialog(this.doc.jframe, JaxeResourceBundle.getRB().getString("erreur.Enregistrement") + ": " + iOException.getMessage(), JaxeResourceBundle.getRB().getString("erreur.Erreur"), 0);
        }
    }

    public void selection(boolean bl) {
        super.selection(bl);
        this.label.setEnabled(!bl);
    }

    class EcouteSouris
    extends MouseAdapter {
        JEEquaTeXMemoire jei;
        JFrame jframe;

        public EcouteSouris(JEEquaTeXMemoire jEEquaTeXMemoire2, JFrame jFrame) {
            this.jei = jEEquaTeXMemoire2;
            this.jframe = jFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.jei.afficherDialogue(this.jframe);
        }
    }
}

