/*
 * Decompiled with CFR 0.152.
 */
package conversioninterunt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Convert {
    private InputStream fichier_xslt;
    Transformer transform;
    JFrame fenetre = new JFrame("Gestion erreurs");

    Convert(InputStream inputStream) {
        this.fichier_xslt = inputStream;
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transform = transformerFactory.newTransformer(streamSource);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("Transformer Factory error");
            System.out.println("   " + transformerConfigurationException.getMessage());
            Throwable throwable = transformerConfigurationException;
            if (transformerConfigurationException.getException() != null) {
                throwable = transformerConfigurationException.getException();
            }
            ((Throwable)throwable).printStackTrace();
            JOptionPane.showMessageDialog(this.fenetre, "Transformer Factory error", "Avertissement", 2);
            System.exit(0);
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformation error");
            System.out.println("   " + transformerException.getMessage());
            Throwable throwable = transformerException;
            if (transformerException.getException() != null) {
                throwable = transformerException.getException();
            }
            ((Throwable)throwable).printStackTrace();
            JOptionPane.showMessageDialog(this.fenetre, "Transformation error", "Avertissement", 2);
            System.exit(0);
        }
    }

    public void parse_UVED_vers_interunt(File file) {
        try {
            String[] stringArray = new String[]{file.toString(), file.toString()};
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("REFSECTION");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string = nodeList.item(i).getAttributes().getNamedItem("label").getNodeValue();
                this.parse_UVED_vers_interunt(new File(new StringBuffer(new File(file.toURL().getPath()).getParent()).append(File.separatorChar).append(string).append(File.separatorChar).append(string).append(".xml").toString()));
            }
            this.transformer(stringArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Erreur de configuration du parseur DOM");
            System.out.println("lors de l'appel \u00e0 fabrique.newDocumentBuilder();");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur de configuration du parseur DOM", "Avertissement", 2);
            System.exit(0);
        }
        catch (SAXException sAXException) {
            System.out.println("Erreur lors du parsing du document");
            System.out.println("lors de l'appel \u00e0 construteur.parse(xml)");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur lors du parsing du document", "Avertissement", 2);
            System.exit(0);
        }
        catch (IOException iOException) {
            System.out.println("Erreur d'entr\u00e9e/sortie");
            System.out.println("lors de l'appel \u00e0 construteur.parse(xml)");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur d'entr\u00e9e/sortie", "Avertissement", 2);
            System.exit(0);
        }
    }

    public void parse_interunt_vers_UVED(File file) {
        try {
            String[] stringArray = new String[]{file.toString(), file.toString()};
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            NodeList nodeList = document.getElementsByTagName("interunt:refDocInterUnt");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ArrayList<Node> arrayList = this.getGivenNode(nodeList.item(i), "interunt:fichier");
                for (int j = 0; j < arrayList.size(); ++j) {
                    this.parse_interunt_vers_UVED(new File(new StringBuffer(new File(file.toURL().getPath()).getParent()).append(File.separatorChar).append(arrayList.get(j).getTextContent()).toString()));
                }
            }
            this.transformer(stringArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Erreur de configuration du parseur DOM");
            System.out.println("lors de l'appel \u00e0 fabrique.newDocumentBuilder();");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur de configuration du parseur DOM", "Avertissement", 2);
            System.exit(0);
        }
        catch (SAXException sAXException) {
            System.out.println("Erreur lors du parsing du document");
            System.out.println("lors de l'appel \u00e0 construteur.parse(xml)");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur lors du parsing du document", "Avertissement", 2);
            System.exit(0);
        }
        catch (IOException iOException) {
            System.out.println("Erreur d'entr\u00e9e/sortie");
            System.out.println("lors de l'appel \u00e0 construteur.parse(xml)");
            JOptionPane.showMessageDialog(this.fenetre, "Erreur d'entr\u00e9e/sortie", "Avertissement", 2);
            System.exit(0);
        }
    }

    private ArrayList<Node> getGivenNode(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName() == null || !nodeList.item(i).getNodeName().equals(string)) continue;
            arrayList.add(nodeList.item(i));
        }
        return arrayList;
    }

    private void transformer(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: java Transform filesource fileout");
            System.exit(1);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(stringArray[0]));
            DOMSource dOMSource = new DOMSource(document);
            File file = new File(stringArray[1]);
            StreamResult streamResult = new StreamResult(file);
            this.transform.transform(dOMSource, streamResult);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.fenetre, "SAXException", "Avertissement", 2);
            System.exit(0);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            JOptionPane.showMessageDialog(this.fenetre, "ParserConfigurationException", "Avertissement", 2);
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Exception error");
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.fenetre, "Transformer exception", "Avertissement", 2);
            System.exit(0);
        }
    }
}

