/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.transform.TransformerException;
import jaxe.DialogueXpath;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DialogueRechercher
extends JDialog
implements ActionListener,
ItemListener {
    private static ResourceBundle rb = JaxeResourceBundle.getRB();
    private JaxeTextPane textPane;
    private StyledDocument doc;
    private JPanel bpane;
    private JPanel cpane;
    JTextField tfRechercher;
    private JTextField tfRemplacer;
    private JLabel textRech = new JLabel(rb.getString("rechercher.Rechercher"));
    private JLabel textRemp = new JLabel(rb.getString("rechercher.RemplacerPar"));
    private JButton bXpath;
    private JButton btout;
    private JButton bremplacer;
    private JButton bremplrech;
    JRadioButton bfichier;
    JRadioButton bsel;
    private JCheckBox typeXpath;
    private JCheckBox chkmaj;
    private boolean dansSelection = false;
    private boolean ignorerCasse = false;
    public boolean RechXpath = false;
    static String texteRecherche = null;
    static String texteXpathRecherche = null;
    public JaxeDocument Jdoc;

    public DialogueRechercher(JaxeDocument jaxeDocument, JaxeTextPane jaxeTextPane, JFrame jFrame) {
        super(jFrame, rb.getString("rechercher.Rechercher"), false);
        this.textPane = jaxeTextPane;
        this.Jdoc = jaxeDocument;
        this.doc = jaxeTextPane.getStyledDocument();
        if (jaxeTextPane.getSelectionEnd() != jaxeTextPane.getSelectionStart()) {
            this.dansSelection = true;
        }
        this.cpane = new JPanel();
        this.cpane.setLayout(new BoxLayout(this.cpane, 1));
        this.setContentPane(this.cpane);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(this.textRech);
        jPanel2.add(this.textRemp);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        this.tfRechercher = new JTextField("", 40);
        if (texteRecherche != null) {
            this.tfRechercher.setText(texteRecherche);
        }
        this.tfRechercher.selectAll();
        jPanel3.add(this.tfRechercher);
        this.tfRemplacer = new JTextField("", 40);
        jPanel3.add(this.tfRemplacer);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        this.cpane.add(jPanel);
        JPanel jPanel4 = new JPanel(new FlowLayout());
        this.bfichier = new JRadioButton(rb.getString("rechercher.FichierEntier"));
        this.bfichier.setActionCommand("fichier");
        this.bfichier.setSelected(!this.dansSelection);
        this.bsel = new JRadioButton(rb.getString("rechercher.Selection"));
        this.bsel.setActionCommand("selection");
        this.bsel.setSelected(this.dansSelection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.bfichier);
        buttonGroup.add(this.bsel);
        this.bfichier.addActionListener(this);
        this.bsel.addActionListener(this);
        jPanel4.add(this.bfichier);
        jPanel4.add(this.bsel);
        this.chkmaj = new JCheckBox(rb.getString("rechercher.IgnorerCasse"));
        this.chkmaj.addItemListener(this);
        jPanel4.add(this.chkmaj);
        this.cpane.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout());
        this.btout = new JButton(rb.getString("rechercher.ToutRemplacer"));
        this.btout.setActionCommand("tout");
        this.btout.addActionListener(this);
        jPanel5.add(this.btout);
        this.bremplacer = new JButton(rb.getString("rechercher.Remplacer"));
        this.bremplacer.setActionCommand("remplacer");
        this.bremplacer.addActionListener(this);
        jPanel5.add(this.bremplacer);
        this.bremplrech = new JButton(rb.getString("rechercher.RemplRech"));
        this.bremplrech.setActionCommand("remplrech");
        this.bremplrech.addActionListener(this);
        jPanel5.add(this.bremplrech);
        JButton jButton = new JButton(rb.getString("rechercher.Precedent"));
        jButton.setActionCommand("precedent");
        jButton.addActionListener(this);
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(rb.getString("rechercher.Suivant"));
        jButton2.setActionCommand("suivant");
        jButton2.addActionListener(this);
        jPanel5.add(jButton2);
        this.cpane.add(jPanel5);
        this.getRootPane().setDefaultButton(jButton2);
        this.addWindowListener(new WindowAdapter(){
            boolean gotFocus = false;

            public void windowActivated(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    DialogueRechercher.this.tfRechercher.requestFocus();
                    this.gotFocus = true;
                }
            }
        });
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 3, (dimension.height - this.getSize().height) / 3);
        this.setVisible(true);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("suivant".equals(string)) {
            if (!this.RechXpath) {
                this.suivant();
            } else {
                this.suivantXpath();
            }
        } else if ("precedent".equals(string)) {
            if (!this.RechXpath) {
                this.precedent();
            } else {
                this.precedentXpath();
            }
        } else if ("remplacer".equals(string)) {
            this.remplacer();
        } else if ("tout".equals(string)) {
            this.toutRemplacer();
        } else if ("remplrech".equals(string)) {
            this.remplRech();
        } else if ("fichier".equals(string)) {
            this.dansSelection = false;
        } else if ("selection".equals(string)) {
            this.dansSelection = true;
        } else if ("xpath".equals(string)) {
            this.setVisible(false);
            if (this.Jdoc.cfg != null) {
                DialogueXpath dialogueXpath = new DialogueXpath(this, this.Jdoc);
            } else {
                JOptionPane.showMessageDialog(this, rb.getString("rechercher.ErrConfig"), rb.getString("rechercher.ExprXpath"), 1);
                this.setVisible(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.chkmaj) {
            this.ignorerCasse = itemEvent.getStateChange() == 1;
        }
    }

    public void enableButton(boolean bl) {
        this.btout.setEnabled(bl);
        this.bremplacer.setEnabled(bl);
        this.bremplrech.setEnabled(bl);
        this.tfRemplacer.setEditable(bl);
        this.bfichier.setEnabled(bl);
        this.bsel.setEnabled(bl);
        this.chkmaj.setEnabled(bl);
        if (bl) {
            this.tfRechercher.setText(texteRecherche);
        } else {
            this.tfRechercher.setText(texteXpathRecherche);
        }
    }

    public void rechercher() {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n = texteRecherche.length();
        int n2 = -1;
        try {
            for (int i = 0; i < this.doc.getLength() - n; ++i) {
                String string = this.doc.getText(i, n);
                if (!string.equals(texteRecherche)) continue;
                n2 = i;
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n2 != -1) {
            this.textPane.setCaretPosition(n2);
            this.textPane.moveCaretPosition(n2 + n);
        } else {
            this.getToolkit().beep();
        }
    }

    public void suivantXpath() {
        this.suivantXpath(this.textPane.getCaretPosition());
    }

    public void suivantXpath(int n) {
        String string = "";
        int n2 = n;
        texteXpathRecherche = this.tfRechercher.getText();
        if (texteXpathRecherche == null || texteXpathRecherche.length() == 0) {
            return;
        }
        NodeList nodeList = this.getXpathNodeList(this.tfRechercher.getText());
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                int n3 = this.Jdoc.getElementForNode((Node)nodeList.item((int)i)).debut.getOffset();
                if (n3 <= n) continue;
                n2 = n3;
                string = DialogueRechercher.replace(rb.getString("rechercher.nbXpath"), "NUMRESULT", Integer.toString(i + 1), true);
                string = DialogueRechercher.replace(string, "NBTOTAL", Integer.toString(nodeList.getLength()), true);
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                break;
            }
            if (nodeList.getLength() > 0 && n2 == n) {
                string = DialogueRechercher.replace(rb.getString("rechercher.nbXpath"), "NUMRESULT", "1", true);
                string = DialogueRechercher.replace(string, "NBTOTAL", Integer.toString(nodeList.getLength()), true);
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                n2 = this.Jdoc.getElementForNode((Node)nodeList.item((int)0)).debut.getOffset();
            }
            if (nodeList.getLength() != 0) {
                try {
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(this.doc.getLength()));
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(n2));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
                this.textPane.setCaretPosition(n2);
            } else {
                this.getToolkit().beep();
                this.setTitle(rb.getString("rechercher.Rechercher"));
            }
        }
        this.toFront();
    }

    public void precedentXpath() {
        this.precedentXpath(this.textPane.getCaretPosition());
    }

    public void precedentXpath(int n) {
        String string = "";
        int n2 = n;
        texteXpathRecherche = this.tfRechercher.getText();
        if (texteXpathRecherche == null || texteXpathRecherche.length() == 0) {
            return;
        }
        NodeList nodeList = this.getXpathNodeList(this.tfRechercher.getText());
        if (nodeList != null) {
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                int n3 = this.Jdoc.getElementForNode((Node)nodeList.item((int)i)).debut.getOffset();
                if (n3 >= n) continue;
                n2 = n3;
                string = DialogueRechercher.replace(rb.getString("rechercher.nbXpath"), "NUMRESULT", Integer.toString(i + 1), true);
                string = DialogueRechercher.replace(string, "NBTOTAL", Integer.toString(nodeList.getLength()), true);
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                break;
            }
            if (nodeList.getLength() > 0 && n2 == n) {
                string = DialogueRechercher.replace(rb.getString("rechercher.nbXpath"), "NUMRESULT", Integer.toString(nodeList.getLength()), true);
                string = DialogueRechercher.replace(string, "NBTOTAL", Integer.toString(nodeList.getLength()), true);
                this.setTitle(rb.getString("rechercher.Rechercher") + " " + string);
                n2 = this.Jdoc.getElementForNode((Node)nodeList.item((int)(nodeList.getLength() - 1))).debut.getOffset();
            }
            if (nodeList.getLength() != 0) {
                try {
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(this.doc.getLength()));
                    this.textPane.scrollRectToVisible(this.textPane.modelToView(n2));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return;
                }
                this.textPane.setCaretPosition(n2);
            } else {
                this.getToolkit().beep();
                this.setTitle(rb.getString("rechercher.Rechercher"));
            }
        }
    }

    public NodeList getXpathNodeList(String string) {
        Element element = this.Jdoc.DOMdoc.getDocumentElement();
        try {
            return XPathAPI.selectNodeList((Node)element, (String)string);
        }
        catch (TransformerException transformerException) {
            JOptionPane.showMessageDialog(this, transformerException.getLocalizedMessage(), rb.getString("rechercher.ErrXpath"), 1);
            return null;
        }
    }

    public void suivant() {
        this.suivant(this.textPane.getSelectionStart());
    }

    public void suivant(int n) {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n2 = texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        if (n + n2 > this.doc.getLength()) {
            n = 0;
        }
        int n3 = -1;
        try {
            if (this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == n2 && (!this.ignorerCasse && this.doc.getText(n, n2).equals(texteRecherche) || this.ignorerCasse && this.doc.getText(n, n2).equalsIgnoreCase(texteRecherche))) {
                ++n;
            }
            for (int i = n; i < this.doc.getLength() - n2; ++i) {
                if (this.includeComponent(i, n2) == -1) {
                    String string = this.doc.getText(i, n2);
                    if ((this.ignorerCasse || !string.equals(texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(texteRecherche))) continue;
                    n3 = i;
                    break;
                }
                i = this.includeComponent(i, n2);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != 0) {
            this.suivant(0);
        } else {
            this.getToolkit().beep();
        }
        this.toFront();
    }

    public void precedent() {
        this.precedent(this.textPane.getSelectionStart());
    }

    public void precedent(int n) {
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        int n2 = texteRecherche.length();
        if (n2 >= this.doc.getLength()) {
            this.getToolkit().beep();
            return;
        }
        int n3 = -1;
        if (n + n2 > this.doc.getLength()) {
            n = this.doc.getLength() - n2;
        }
        if (n < 0) {
            n = 0;
        }
        try {
            if (this.textPane.getSelectionEnd() - this.textPane.getSelectionStart() == n2 && (!this.ignorerCasse && this.doc.getText(n, n2).equals(texteRecherche) || this.ignorerCasse && this.doc.getText(n, n2).equalsIgnoreCase(texteRecherche))) {
                --n;
            }
            for (int i = n; i >= 0; --i) {
                if (this.includeComponent(i, n2) == -1) {
                    String string = this.doc.getText(i, n2);
                    if ((this.ignorerCasse || !string.equals(texteRecherche)) && (!this.ignorerCasse || !string.equalsIgnoreCase(texteRecherche))) continue;
                    n3 = i;
                    break;
                }
                i = this.includeComponent(i, n2) - n2 + 1;
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
        if (n3 != -1) {
            this.textPane.setCaretPosition(n3);
            this.textPane.moveCaretPosition(n3 + n2);
        } else if (n != this.doc.getLength() - n2) {
            this.precedent(this.doc.getLength() - n2);
        } else {
            this.getToolkit().beep();
        }
        this.toFront();
    }

    public void remplacer() {
        String string = this.tfRechercher.getText();
        String string2 = this.tfRemplacer.getText();
        if (this.textPane.getSelectionStart() == this.textPane.getSelectionEnd()) {
            return;
        }
        int n = this.textPane.getSelectionStart();
        int n2 = this.textPane.getSelectionEnd();
        try {
            if (!string.equals("")) {
                this.textPane.setSelectionStart(0);
                this.textPane.setSelectionEnd(0);
                int n3 = string.length();
                int n4 = string2.length();
                int n5 = n2 - n3 + 1;
                for (int i = n; i < n5; ++i) {
                    if ((this.ignorerCasse || !string.equals(this.doc.getText(i, n3))) && (!this.ignorerCasse || !string.equalsIgnoreCase(this.doc.getText(i, n3)))) continue;
                    if (this.includeComponent(i, n3) == -1) {
                        this.doc.remove(i, n3);
                        this.doc.insertString(i, string2, null);
                        n5 = n5 - n3 + n4;
                        i += n4 - 1;
                        continue;
                    }
                    i = this.includeComponent(i, n3);
                }
                this.textPane.setSelectionStart(n);
                this.textPane.setSelectionEnd(n5 + n3 - 1);
            } else {
                if (n != n2) {
                    this.doc.remove(n, n2 - n);
                }
                this.doc.insertString(n, string2, null);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return;
        }
    }

    public void toutRemplacer() {
        if (this.dansSelection) {
            this.remplacer();
            return;
        }
        texteRecherche = this.tfRechercher.getText();
        if (texteRecherche == null || texteRecherche.length() == 0) {
            return;
        }
        String string = this.tfRemplacer.getText();
        this.textPane.setSelectionStart(0);
        this.textPane.setSelectionEnd(0);
        this.textPane.debutEditionSpeciale(rb.getString("rechercher.Remplacer"), false);
        int n = texteRecherche.length();
        int n2 = -1;
        int n3 = 0;
        int n4 = this.doc.getLength() - n;
        try {
            for (int i = n3; i < n4; ++i) {
                if (this.includeComponent(i, n) == -1) {
                    String string2 = this.doc.getText(i, n);
                    if ((this.ignorerCasse || !string2.equals(texteRecherche)) && (!this.ignorerCasse || !string2.equalsIgnoreCase(texteRecherche))) continue;
                    n2 = i;
                    this.doc.remove(i, n);
                    this.doc.insertString(i, string, null);
                    n4 = this.doc.getLength() - n;
                    continue;
                }
                i = this.includeComponent(i, n);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            this.textPane.finEditionSpeciale();
            return;
        }
        if (n2 == -1) {
            this.getToolkit().beep();
        }
        this.textPane.finEditionSpeciale();
    }

    public void remplRech() {
        this.remplacer();
        this.suivant();
    }

    public String getTexteRecherche() {
        return this.tfRechercher.getText();
    }

    private int includeComponent(int n, int n2) {
        int n3 = -1;
        for (int i = n; i < n2 + n; ++i) {
            javax.swing.text.Element element = null;
            Component component = null;
            Icon icon = null;
            element = this.doc.getCharacterElement(i);
            component = StyleConstants.getComponent(element.getAttributes());
            icon = StyleConstants.getIcon(element.getAttributes());
            if (component == null && icon == null) continue;
            n3 = i;
        }
        return n3;
    }

    public static String replace(String string, String string2, String string3, boolean bl) {
        if (string == null || string2 == null || string2.length() == 0 || string3 == null) {
            throw new IllegalArgumentException("pas d'arguments.");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n + string2.length() <= stringBuffer.length()) {
            if (stringBuffer.substring(n, n + string2.length()).equals(string2)) {
                stringBuffer.replace(n, n + string2.length(), string3);
                if (!bl) break;
                n += string3.length();
                continue;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

