/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import jaxe.Config;
import jaxe.JEFactory;
import jaxe.JaxeDocument;
import jaxe.JaxeResourceBundle;
import jaxe.elements.JEInconnu;
import jaxe.elements.JESauf;
import jaxe.elements.JEStyle;
import jaxe.elements.JESwing;
import jaxe.elements.JETableTexte;
import jaxe.elements.JETexte;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JaxeElement {
    public static final String kNormal = "NORMAL";
    public static final String kGras = "GRAS";
    public static final String kItalique = "ITALIQUE";
    public static final String kExposant = "EXPOSANT";
    public static final String kCouleur = "PCOULEUR";
    public static final String kCouleurDeFond = "FCOULEUR";
    public static final String kIndice = "INDICE";
    public static final String kSouligne = "SOULIGNE";
    public static final String kBarre = "BARRE";
    public static final Map styleMapper = new HashMap(){};
    private static Perl5Compiler perlComp = new Perl5Compiler();
    private Perl5Matcher matcher = new Perl5Matcher();
    public Position debut = null;
    public Position fin = null;
    public Node noeud;
    public JaxeDocument doc;
    public ArrayList jcomps = new ArrayList();
    public ArrayList compos = new ArrayList();
    private boolean effacementAutorise = true;
    private boolean editionAutorisee = true;
    static Font boutonFont = (Font)UIManager.getDefaults().get("Button.font");
    static final Color jauneLeger = new Color(255, 255, 150);
    static final Color rougeFonce = new Color(150, 0, 0);
    static final Color orange = new Color(255, 200, 150);
    static final Color bleuClair = new Color(210, 230, 255);
    static final Color violet = new Color(210, 200, 255);
    static Color[][] couleursButtons = new Color[][]{{jauneLeger, rougeFonce, orange}, {bleuClair, rougeFonce, violet}};
    static Border boutonBorder = BorderFactory.createRaisedBevelBorder();

    public abstract void init(Position var1, Node var2);

    public void creer(Position position, Node node) {
        this.noeud = node;
        this.doc.dom2JaxeElement.put(node, this);
        Element element = null;
        if (this.doc.cfg != null) {
            if (node.getNodeType() == 1) {
                element = this.doc.cfg.getElementDef((Element)node);
            }
            if (node.getNodeType() == 7) {
                element = this.doc.cfg.getProcessingDef((ProcessingInstruction)node);
            }
            if (element != null) {
                String string = this.doc.cfg.getParamFromDefinition(element, "effacementAutorise", null);
                String string2 = this.doc.cfg.getParamFromDefinition(element, "editionAutorisee", null);
                this.effacementAutorise = !"false".equals(string);
                this.editionAutorisee = !"false".equals(string2);
            }
        }
        this.init(position, node);
    }

    public abstract Node nouvelElement(Element var1);

    public void afficherDialogue(JFrame jFrame) {
    }

    public void majAffichage() {
    }

    public void majValidite() {
    }

    public ArrayList getComponents() {
        return this.jcomps;
    }

    public ArrayList getComponentPositions() {
        return this.compos;
    }

    public Position insertText(Position position, String string, AttributeSet attributeSet) {
        try {
            int n = position.getOffset();
            this.doc.insertString(position.getOffset(), string, attributeSet);
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        return position;
    }

    public Position insertText(Position position, String string) {
        Node node;
        SimpleAttributeSet simpleAttributeSet = null;
        JaxeElement jaxeElement = this.debut == null ? ((node = this.noeud.getParentNode()) != null ? this.doc.getElementForNode(node) : null) : this;
        if (jaxeElement != null) {
            if (jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
                jaxeElement = jaxeElement.getParent();
            }
            if (jaxeElement != null) {
                simpleAttributeSet = jaxeElement.attStyle(null);
            }
        }
        return this.insertText(position, string, simpleAttributeSet);
    }

    public Position insertComponent(Position position, JComponent jComponent) {
        int n = position.getOffset();
        Style style = this.doc.textPane.addStyle(null, null);
        StyleConstants.setComponent(style, jComponent);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            this.jcomps.add(jComponent);
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            this.doc.fixbug(jComponent);
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        return position;
    }

    public Position insertIcon(Position position, Icon icon) {
        int n = position.getOffset();
        Style style = this.doc.textPane.addStyle(null, null);
        StyleConstants.setIcon(style, icon);
        try {
            this.doc.insertString(position.getOffset(), "*", style, false);
            this.jcomps.add(icon);
            this.compos.add(this.doc.createPosition(position.getOffset() - 1));
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            this.fin = this.doc.createPosition(n);
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        return position;
    }

    public JaxeElement elementA(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            JaxeElement jaxeElement2;
            if (node.getNodeType() != 1 && node.getNodeType() != 3 && node.getNodeType() != 7 || (jaxeElement2 = this.doc.getElementForNode(node)) == null || (jaxeElement = jaxeElement2.elementA(n)) == null) continue;
            return jaxeElement;
        }
        return this;
    }

    public ArrayList elementsDans(int n, int n2) {
        ArrayList<JaxeElement> arrayList = new ArrayList<JaxeElement>();
        if (this.debut == null || this.fin == null) {
            return arrayList;
        }
        if (this.debut.getOffset() > n2 || this.fin.getOffset() < n) {
            return arrayList;
        }
        if (this.debut.getOffset() >= n && (this.fin.getOffset() <= n2 || this instanceof JESwing && this.fin.getOffset() == n2 + 1)) {
            arrayList.add(this);
        } else {
            for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
                JaxeElement jaxeElement;
                if (node.getNodeType() != 1 && node.getNodeType() != 3 && node.getNodeType() != 7 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
                arrayList.addAll(jaxeElement.elementsDans(n, n2));
            }
        }
        return arrayList;
    }

    public int nombreXPath() {
        JaxeElement jaxeElement = this.getParent();
        if (jaxeElement == null) {
            return 0;
        }
        int n = 0;
        String string = this.noeud.getNodeName();
        for (Node node = jaxeElement.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (string.equals(node.getNodeName())) {
                ++n;
            }
            if (node == this.noeud) break;
        }
        return n;
    }

    public String cheminA(int n) {
        Object object;
        Object object2;
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        if (this.noeud.getNodeType() == 3) {
            return "texte";
        }
        if (this.noeud.getNodeType() != 1 && this.noeud.getNodeType() != 7) {
            return null;
        }
        Element element = (Element)this.noeud;
        String string = element.getTagName();
        if (this.getParent() != null) {
            string = string + "[" + this.nombreXPath() + "]";
        }
        if (this instanceof JEStyle) {
            object2 = ((JEStyle)this)._styles.iterator();
            string = "";
            while (object2.hasNext()) {
                object = (Node)object2.next();
                if (this.getParent() != null) {
                    string = string + object.getNodeName() + "[" + this.nombreXPath() + "]";
                }
                if (object2.hasNext()) {
                    string = string + "/";
                    continue;
                }
                element = (Element)object;
            }
        }
        for (object2 = element.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
            String string2;
            if (object2.getNodeType() != 1 && object2.getNodeType() != 3 && object2.getNodeType() != 7 || (object = this.doc.getElementForNode((Node)object2)) == null || (string2 = ((JaxeElement)object).cheminA(n)) == null) continue;
            return string + "/" + string2;
        }
        return string;
    }

    public JaxeElement enfantApres(int n) {
        if (this.debut == null || this.fin == null) {
            return null;
        }
        if (this.debut.getOffset() > n || this.fin.getOffset() < n) {
            return null;
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            JaxeElement jaxeElement;
            if (node.getNodeType() != 1 && node.getNodeType() != 3 && node.getNodeType() != 7 || (jaxeElement = this.doc.getElementForNode(node)) == null) continue;
            if (jaxeElement.debut.getOffset() == n) {
                return jaxeElement;
            }
            JaxeElement jaxeElement2 = jaxeElement.elementA(n);
            if (jaxeElement2 == null || node.getNextSibling() == null) continue;
            return this.doc.getElementForNode(node.getNextSibling());
        }
        return null;
    }

    public void effacer() {
        JaxeElement jaxeElement;
        Object object;
        for (object = this.noeud.getFirstChild(); object != null; object = object.getNextSibling()) {
            if (object.getNodeType() != 1 && object.getNodeType() != 3 && object.getNodeType() != 7 || (jaxeElement = this.doc.getElementForNode((Node)object)) == null) continue;
            jaxeElement.effacer();
        }
        object = this.jcomps.iterator();
        while (object.hasNext()) {
            jaxeElement = object.next();
            if (!(jaxeElement instanceof JComponent) || ((JComponent)((Object)jaxeElement)).getParent() == null) continue;
            JComponent jComponent = (JComponent)((Object)jaxeElement);
            jComponent.getParent().remove(jComponent);
        }
        this.jcomps = new ArrayList();
        this.compos = new ArrayList();
    }

    public void mettreAJourDOM() {
        if (this.debut == null || this.fin == null) {
            return;
        }
        try {
            if (this.noeud.getNodeType() == 3 || this instanceof JEStyle) {
                Object object;
                Node node = this.noeud.getNextSibling();
                if (node != null && (object = this.doc.getElementForNode(node)) != null && ((JaxeElement)object).debut.getOffset() > this.fin.getOffset() + 1) {
                    this.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                }
                if ((object = this.doc.getText(this.debut.getOffset(), this.fin.getOffset() - this.debut.getOffset() + 1)) == null || "".equals(object)) {
                    this.getParent().supprimerEnfant(this);
                } else if (this.noeud.getNodeType() == 3) {
                    this.noeud.setNodeValue((String)object);
                } else {
                    Node node2;
                    for (node2 = this.noeud; node2 != null && node2.getNodeType() != 3; node2 = node2.getFirstChild()) {
                    }
                    if (node2 != null) {
                        node2.setNodeValue((String)object);
                    }
                }
            } else {
                JaxeElement jaxeElement;
                Object object;
                Object object2;
                int n = this.debut.getOffset();
                int n2 = this instanceof JESwing ? n : n + 1;
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    if (n2 < ((JaxeElement)object).debut.getOffset()) {
                        jaxeElement = null;
                        if (object2.getPreviousSibling() != null) {
                            jaxeElement = this.doc.getElementForNode(object2.getPreviousSibling());
                        }
                        if (jaxeElement != null && (jaxeElement instanceof JEStyle || jaxeElement instanceof JETexte)) {
                            jaxeElement.fin = this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1);
                        } else if (object instanceof JETexte) {
                            ((JaxeElement)object).debut = this.doc.createPosition(n2);
                        } else {
                            String string = this.doc.getText(n2, ((JaxeElement)object).debut.getOffset() - n2);
                            JETexte jETexte = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(((JaxeElement)object).debut.getOffset() - 1), string);
                            this.noeud.insertBefore(jETexte.noeud, (Node)object2);
                        }
                    }
                    n = ((JaxeElement)object).fin.getOffset();
                    n2 = n + 1;
                }
                if (n2 < this.fin.getOffset()) {
                    object2 = null;
                    if (this.noeud.getLastChild() != null) {
                        object2 = this.doc.getElementForNode(this.noeud.getLastChild());
                    }
                    if (object2 instanceof JEStyle || object2 instanceof JETexte) {
                        ((JaxeElement)object2).fin = this.doc.createPosition(this.fin.getOffset() - 1);
                    } else {
                        object = this.doc.getText(n2, this.fin.getOffset() - n2);
                        jaxeElement = JETexte.nouveau(this.doc, this.doc.createPosition(n2), this.doc.createPosition(this.fin.getOffset() - 1), (String)object);
                        this.noeud.appendChild(((JETexte)jaxeElement).noeud);
                    }
                }
                for (object2 = this.noeud.getFirstChild(); object2 != null; object2 = object2.getNextSibling()) {
                    object = this.doc.getElementForNode((Node)object2);
                    if (object == null) continue;
                    ((JaxeElement)object).mettreAJourDOM();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            System.err.println("mettreAJourDOM: BadLocationException: " + badLocationException.getMessage());
        }
    }

    public static Node nouvelElementDOM(JaxeDocument jaxeDocument, String string, String string2) {
        Node node;
        if (string.equals("instruction")) {
            node = jaxeDocument.DOMdoc.createProcessingInstruction(string2, "");
        } else if (jaxeDocument.cfg.namespace() == null) {
            node = jaxeDocument.DOMdoc.createElement(string2);
        } else {
            Config config = jaxeDocument.cfg.getBaliseConf(string2);
            if (config == null) {
                config = jaxeDocument.cfg;
            }
            if (config.prefixe() != null) {
                string2 = config.prefixe() + ":" + string2;
            }
            node = jaxeDocument.DOMdoc.createElementNS(config.namespace(), string2);
        }
        return node;
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, Element element) {
        Element element2;
        String string = jaxeDocument.cfg.nomBalise(element);
        Config config = jaxeDocument.cfg.getDefConf(element);
        if (config == null) {
            config = jaxeDocument.cfg;
        }
        if (config.namespace() == null) {
            element2 = jaxeDocument.DOMdoc.createElement(string);
        } else {
            if (config.prefixe() != null) {
                string = config.prefixe() + ":" + string;
            }
            element2 = jaxeDocument.DOMdoc.createElementNS(config.namespace(), string);
        }
        return element2;
    }

    public static Element nouvelElementDOM(JaxeDocument jaxeDocument, String string, Element element) {
        String string2 = element.getNamespaceURI();
        String string3 = element.getPrefix();
        String string4 = string3 != null ? string3 + ':' + string : string;
        return jaxeDocument.DOMdoc.createElementNS(string2, string4);
    }

    public void inserer(Position position, Node node) {
        this.doc.textPane.debutIgnorerEdition();
        this.insererDOM(position, node);
        this.creer(position, node);
        this.doc.textPane.finIgnorerEdition();
        JaxeElement jaxeElement = this.getParent();
        while (jaxeElement instanceof JESwing && jaxeElement.debut.getOffset() > this.debut.getOffset()) {
            jaxeElement.debut = this.debut;
            jaxeElement = jaxeElement.getParent();
        }
    }

    public void insererDOM(Position position, Node node) {
        JaxeElement jaxeElement = this.doc.rootJE.elementA(position.getOffset());
        if (jaxeElement.debut.getOffset() == position.getOffset() && !(jaxeElement instanceof JESwing)) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement instanceof JETexte) {
            int n = position.getOffset() - jaxeElement.debut.getOffset();
            if (n > 0) {
                JaxeElement jaxeElement2 = jaxeElement.couper(position);
                Node node2 = jaxeElement.noeud.getParentNode();
                node2.insertBefore(node, jaxeElement2.noeud);
            } else {
                Node node3 = jaxeElement.noeud.getParentNode();
                node3.insertBefore(node, jaxeElement.noeud);
            }
        } else {
            JaxeElement jaxeElement3 = jaxeElement.enfantApres(position.getOffset());
            if (jaxeElement3 == null) {
                jaxeElement.noeud.appendChild(node);
            } else {
                jaxeElement.noeud.insertBefore(node, jaxeElement3.noeud);
            }
        }
    }

    public void creerEnfants(Position position) {
        Element element = (Element)this.noeud;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            node = this.creerEnfant(position, node);
        }
    }

    public Node creerEnfant(Position position, Node node) {
        Object object;
        int n = position.getOffset();
        if (node.getNodeType() == 1) {
            object = null;
            if (this.doc.cfg != null) {
                object = this.doc.cfg.getElementDef((Element)node);
            }
            if (object == null) {
                JEInconnu jEInconnu = new JEInconnu(this.doc);
                jEInconnu.creer(position, (Element)node);
            } else {
                String string = object.getAttribute("type");
                if (!string.equals("style") || this.hasText(node) || this.hasProcessing(node)) {
                    if (string.equals("style") && this.hasProcessing(node)) {
                        Node node2 = node.getPreviousSibling();
                        Node node3 = node.getParentNode();
                        ProcessingInstruction processingInstruction = this.getProcessing(node);
                        node.getParentNode().replaceChild(processingInstruction, node);
                        node = node2 == null ? node3.getFirstChild() : node2.getNextSibling();
                        if (this.doc.cfg != null) {
                            object = this.doc.cfg.getProcessingDef((ProcessingInstruction)node);
                        }
                        if (object == null) {
                            JESauf jESauf = new JESauf(this.doc);
                            jESauf.creer(position, (ProcessingInstruction)node);
                        } else {
                            JaxeElement jaxeElement;
                            String string2 = object.getAttribute("type");
                            JaxeElement jaxeElement2 = this.doc.getElementForNode(node);
                            if (jaxeElement2 != null) {
                                jaxeElement = jaxeElement2;
                                jaxeElement.debut = null;
                                jaxeElement.fin = null;
                                jaxeElement.jcomps = new ArrayList();
                                jaxeElement.compos = new ArrayList();
                            } else {
                                jaxeElement = JEFactory.createJE(string2, this.doc, (Element)object, (ProcessingInstruction)node);
                            }
                            jaxeElement.creer(position, (ProcessingInstruction)node);
                        }
                    } else {
                        JaxeElement jaxeElement;
                        JaxeElement jaxeElement3 = this.doc.getElementForNode(node);
                        if (jaxeElement3 != null) {
                            jaxeElement = jaxeElement3;
                            jaxeElement.debut = null;
                            jaxeElement.fin = null;
                            jaxeElement.jcomps = new ArrayList();
                            jaxeElement.compos = new ArrayList();
                        } else {
                            jaxeElement = JEFactory.createJE(string, this.doc, (Element)object, (Element)node);
                        }
                        jaxeElement.creer(position, (Element)node);
                    }
                }
            }
        } else if (node.getNodeType() == 3) {
            object = new JETexte(this.doc);
            ((JaxeElement)object).creer(position, node);
        } else if (node.getNodeType() == 7) {
            object = null;
            if (this.doc.cfg != null) {
                object = this.doc.cfg.getProcessingDef((ProcessingInstruction)node);
            }
            if (object == null) {
                JESauf jESauf = new JESauf(this.doc);
                jESauf.creer(position, (ProcessingInstruction)node);
            } else {
                JaxeElement jaxeElement;
                String string = object.getAttribute("type");
                JaxeElement jaxeElement4 = this.doc.getElementForNode(node);
                if (jaxeElement4 != null) {
                    jaxeElement = jaxeElement4;
                    jaxeElement.debut = null;
                    jaxeElement.fin = null;
                    jaxeElement.jcomps = new ArrayList();
                    jaxeElement.compos = new ArrayList();
                } else {
                    jaxeElement = JEFactory.createJE(string, this.doc, (Element)object, (ProcessingInstruction)node);
                }
                jaxeElement.creer(position, (ProcessingInstruction)node);
            }
        }
        try {
            if (this.debut == null) {
                this.debut = this.doc.createPosition(n);
            }
            if (position.getOffset() == 0) {
                position = this.doc.createPosition(1);
            }
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        return node;
    }

    public Position insPosition() {
        try {
            Position position = this.doc.createPosition(this.fin.getOffset() + 1);
            return position;
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
            return this.debut;
        }
    }

    public boolean hasText(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 3 ? true : this.hasText(node2);
        }
        return bl;
    }

    public boolean hasProcessing(Node node) {
        boolean bl = false;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            bl = node2.getNodeType() == 7 ? true : this.hasProcessing(node2);
        }
        return bl;
    }

    public ProcessingInstruction getProcessing(Node node) {
        ProcessingInstruction processingInstruction = null;
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            processingInstruction = node2.getNodeType() == 7 ? (ProcessingInstruction)node2 : this.getProcessing(node2);
        }
        return processingInstruction;
    }

    public JaxeElement getParent() {
        Node node = this.noeud.getParentNode();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getFirstChild() {
        Node node = this.noeud.getFirstChild();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public JaxeElement getNextSibling() {
        Node node = this.noeud.getNextSibling();
        if (node == null) {
            return null;
        }
        return this.doc.getElementForNode(node);
    }

    public void supprimerEnfant(JaxeElement jaxeElement) {
        this.supprimerEnfantDOM(jaxeElement);
        try {
            int n = jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1;
            int n2 = jaxeElement.debut.getOffset();
            this.doc.remove(n2, n, false);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
    }

    public void supprimerEnfantDOM(JaxeElement jaxeElement) {
        try {
            this.noeud.removeChild(jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            System.err.println("DOMException: " + dOMException.getMessage());
        }
    }

    public void remplacerEnfant(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        try {
            this.doc.remove(jaxeElement.debut.getOffset(), jaxeElement.fin.getOffset() - jaxeElement.debut.getOffset() + 1);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        jaxeElement2.creer(jaxeElement2.debut, jaxeElement2.noeud);
        this.remplacerEnfantDOM(jaxeElement, jaxeElement2);
    }

    public void remplacerEnfantDOM(JaxeElement jaxeElement, JaxeElement jaxeElement2) {
        Node node = jaxeElement.noeud.getParentNode();
        if (node == null) {
            System.err.println("remplacerEnfantDOM: parent null !");
        }
        try {
            node.replaceChild(jaxeElement2.noeud, jaxeElement.noeud);
        }
        catch (DOMException dOMException) {
            System.err.println("DOMException: " + dOMException.getMessage());
        }
    }

    public boolean avecIndentation() {
        return false;
    }

    public int indentations() {
        JaxeElement jaxeElement;
        JaxeElement jaxeElement2 = this.getParent();
        if (jaxeElement2 != null && (jaxeElement = jaxeElement2.getParent()) != null && (jaxeElement = jaxeElement.getParent()) instanceof JETableTexte) {
            return 0;
        }
        if (jaxeElement2 == null) {
            return 0;
        }
        if (this.avecIndentation()) {
            return jaxeElement2.indentations() + 1;
        }
        return jaxeElement2.indentations();
    }

    public JaxeElement couper(Position position) {
        String string = this.noeud.getNodeValue();
        String string2 = string.substring(0, position.getOffset() - this.debut.getOffset());
        String string3 = string.substring(position.getOffset() - this.debut.getOffset());
        this.noeud.setNodeValue(string2);
        Text text = this.doc.DOMdoc.createTextNode(string3);
        Node node = this.noeud.getNextSibling();
        JaxeElement jaxeElement = this.getParent();
        if (node == null) {
            jaxeElement.noeud.appendChild(text);
        } else {
            jaxeElement.noeud.insertBefore(text, node);
        }
        JETexte jETexte = new JETexte(this.doc);
        jETexte.noeud = text;
        jETexte.doc = jaxeElement.doc;
        try {
            jETexte.debut = this.doc.createPosition(position.getOffset());
            jETexte.fin = this.fin;
            this.fin = this.doc.createPosition(position.getOffset() - 1);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("BadLocationException: " + badLocationException.getMessage());
        }
        this.doc.dom2JaxeElement.put(jETexte.noeud, jETexte);
        return jETexte;
    }

    public void fusionner(JaxeElement jaxeElement) {
        if (!(this instanceof JETexte) || !(jaxeElement instanceof JETexte)) {
            return;
        }
        if (this.noeud.getNextSibling() == jaxeElement.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(this.noeud.getNodeValue() + string);
            this.fin = jaxeElement.fin;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        } else if (jaxeElement.noeud.getNextSibling() == this.noeud) {
            String string = jaxeElement.noeud.getNodeValue();
            this.noeud.setNodeValue(string + this.noeud.getNodeValue());
            this.debut = jaxeElement.debut;
            jaxeElement.getParent().supprimerEnfantDOM(jaxeElement);
        }
    }

    public void regrouperTextes() {
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            while (node.getNodeType() == 3 && node.getNextSibling() != null && node.getNextSibling().getNodeType() == 3) {
                JaxeElement jaxeElement = this.doc.getElementForNode(node);
                JaxeElement jaxeElement2 = this.doc.getElementForNode(node.getNextSibling());
                jaxeElement.fusionner(jaxeElement2);
            }
        }
    }

    public void setEffacementAutorise(boolean bl) {
        this.effacementAutorise = bl;
    }

    public boolean getEffacementAutorise() {
        return this.effacementAutorise;
    }

    public void setEditionAutorisee(boolean bl) {
        this.editionAutorisee = bl;
    }

    public boolean getEditionAutorisee() {
        return this.editionAutorisee;
    }

    public void selection(boolean bl) {
        Object object;
        for (int i = 0; i < this.jcomps.size(); ++i) {
            object = this.jcomps.get(i);
            if (!(object instanceof MonBouton)) continue;
            ((MonBouton)object).selection(bl);
        }
        for (Node node = this.noeud.getFirstChild(); node != null; node = node.getNextSibling()) {
            object = this.doc.getElementForNode(node);
            if (object == null) continue;
            ((JaxeElement)object).selection(bl);
        }
    }

    public static void setMonBoutonCouleurs(Color[][] colorArray) {
        couleursButtons = colorArray;
    }

    public static Color[][] getMonBoutonCouleurs() {
        return couleursButtons;
    }

    public static void setMonBoutonBorder(Border border) {
        boutonBorder = border;
    }

    public static Border getMonBoutonBorder() {
        return boutonBorder;
    }

    public static Font getMonBoutonFont() {
        return boutonFont;
    }

    public static void setMonBoutonFont(Font font) {
        boutonFont = font;
    }

    protected String getString(String string) {
        return JaxeResourceBundle.getRB().getString(string);
    }

    public void changerStyle(String string, int n, int n2) {
        if (string != null) {
            String[] stringArray = this.splitString(string);
            Style style = this.doc.textPane.addStyle(null, null);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(kExposant) > -1) {
                    StyleConstants.setSuperscript(style, true);
                }
                if (stringArray[i].indexOf(kIndice) > -1) {
                    StyleConstants.setSubscript(style, true);
                }
                if (stringArray[i].indexOf(kCouleur) > -1) {
                    StyleConstants.setForeground(style, this.obtenezCouleur(stringArray[i], Color.red));
                }
                if (stringArray[i].indexOf(kCouleurDeFond) > -1) {
                    StyleConstants.setBackground(style, this.obtenezCouleur(stringArray[i], Color.green));
                }
                if (stringArray[i].indexOf(kItalique) > -1) {
                    StyleConstants.setItalic(style, true);
                }
                if (stringArray[i].indexOf(kGras) > -1) {
                    StyleConstants.setBold(style, true);
                }
                if (stringArray[i].indexOf(kSouligne) > -1) {
                    StyleConstants.setUnderline(style, true);
                }
                if (stringArray[i].indexOf(kBarre) > -1) {
                    StyleConstants.setStrikeThrough(style, true);
                }
                if (stringArray[i].equals("")) continue;
                this.doc.setCharacterAttributes(n, n2, style, false);
            }
        }
    }

    private Color obtenezCouleur(String string, Color color) {
        int n;
        Object object;
        Pattern pattern = null;
        try {
            pattern = perlComp.compile("^.*\\[(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3}),(x[0-9a-fA-F]{2}|[0-9]{1,3})\\]$");
        }
        catch (MalformedPatternException malformedPatternException) {
            return color;
        }
        String string2 = string;
        if (string.indexOf(";") > 0) {
            object = this.splitString(string);
            for (n = 0; n < ((String[])object).length; ++n) {
                if (object[n].indexOf(kCouleur) <= -1) continue;
                string2 = object[n];
            }
        }
        if (this.matcher.matches(string2, pattern)) {
            object = this.matcher.getMatch();
            n = 0;
            int[] nArray = new int[3];
            for (int i = 0; i < 3; ++i) {
                String string3 = object.group(i + 1);
                try {
                    if (string3.startsWith("x")) {
                        nArray[i] = Integer.parseInt(string3, 16);
                        continue;
                    }
                    nArray[i] = Integer.parseInt(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    nArray[i] = 0;
                    n = 1;
                }
            }
            Color color2 = new Color(nArray[0], nArray[1], nArray[2]);
            if (!color2.equals(Color.black) || n == 0) {
                color = color2;
            }
        }
        return color;
    }

    private String[] splitString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.indexOf(59) > -1) {
            int n = string.indexOf(59);
            arrayList.add(string.substring(0, n));
            string = string.substring(n + 1, string.length());
        }
        arrayList.add(string);
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public SimpleAttributeSet attStyle(SimpleAttributeSet simpleAttributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet2 = simpleAttributeSet;
        for (Element element = this.noeud.getNodeType() == 3 || this.noeud.getNodeType() == 7 ? (Element)this.getParent().noeud : (Element)this.noeud; element != null && element.getParentNode() instanceof Element; element = (Element)element.getParentNode()) {
            int n;
            Object object2;
            object = null;
            if (this.doc.cfg != null) {
                object = this.doc.cfg.getElementDef(element);
            }
            if (object == null) {
                return simpleAttributeSet2;
            }
            String string = this.doc.cfg.getParamFromDefinition((Element)object, "style", null);
            if (this instanceof JEStyle) {
                string = ((JEStyle)this).ceStyle;
            }
            if (string != null) {
                if (simpleAttributeSet2 == null) {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                }
                object2 = this.splitString(string);
                for (n = 0; n < ((String[])object2).length; ++n) {
                    if (object2[n].indexOf(kExposant) > -1) {
                        StyleConstants.setSuperscript(simpleAttributeSet2, true);
                    }
                    if (object2[n].indexOf(kIndice) > -1) {
                        StyleConstants.setSubscript(simpleAttributeSet2, true);
                    }
                    if (object2[n].indexOf(kCouleur) > -1) {
                        StyleConstants.setForeground(simpleAttributeSet2, this.obtenezCouleur(object2[n], Color.red));
                    }
                    if (object2[n].indexOf(kCouleurDeFond) > -1) {
                        StyleConstants.setBackground(simpleAttributeSet2, this.obtenezCouleur(object2[n], Color.green));
                    }
                    if (object2[n].indexOf(kItalique) > -1) {
                        StyleConstants.setItalic(simpleAttributeSet2, true);
                    }
                    if (object2[n].indexOf(kGras) > -1) {
                        StyleConstants.setBold(simpleAttributeSet2, true);
                    }
                    if (object2[n].indexOf(kSouligne) > -1) {
                        StyleConstants.setUnderline(simpleAttributeSet2, true);
                    }
                    if (object2[n].indexOf(kBarre) <= -1) continue;
                    StyleConstants.setStrikeThrough(simpleAttributeSet2, true);
                }
            }
            if (!(simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontFamily) || (object2 = this.doc.cfg.getParamFromDefinition((Element)object, "police", null)) == null)) {
                if (simpleAttributeSet2 == null) {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                }
                StyleConstants.setFontFamily(simpleAttributeSet2, (String)object2);
            }
            if (simpleAttributeSet2 != null && simpleAttributeSet2.isDefined(StyleConstants.FontSize) || (object2 = this.doc.cfg.getParamFromDefinition((Element)object, "taille", null)) == null) continue;
            try {
                n = Integer.parseInt((String)object2);
                if (simpleAttributeSet2 == null) {
                    simpleAttributeSet2 = new SimpleAttributeSet();
                }
                StyleConstants.setFontSize(simpleAttributeSet2, n);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getClass().getName() + ": " + numberFormatException.getMessage());
            }
        }
        object = this.getParent();
        if (object != null) {
            return ((JaxeElement)object).attStyle(simpleAttributeSet2);
        }
        return simpleAttributeSet2;
    }

    public class MonBouton
    extends JComponent {
        JLabel label;
        boolean valide = true;
        boolean selectionne = false;
        int noens = 0;
        boolean division;

        public MonBouton(String string, boolean bl) {
            this.division = bl;
            if (bl) {
                this.setLayout(new BorderLayout());
            } else {
                this.setLayout(new FlowLayout(1, 0, 0));
            }
            this.label = new JLabel(string);
            this.label.setForeground(this.getForeground());
            this.label.setBackground(this.getBackground());
            this.label.setOpaque(true);
            this.label.setBorder(boutonBorder);
            this.label.setFont(boutonFont);
            if (bl) {
                this.add((Component)this.label, "Center");
            } else {
                this.add(this.label);
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.label.addMouseListener(new MyMouseListener(JaxeElement.this, JaxeElement.this.doc.textPane.jframe));
            this.setAlignmentY(0.6f);
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public void setValidite(boolean bl) {
            this.valide = bl;
            this.label.setBackground(this.getBackground());
        }

        public Color getBackground() {
            if (this.selectionne) {
                return couleursButtons[this.noens][1];
            }
            if (this.valide) {
                return couleursButtons[this.noens][0];
            }
            return couleursButtons[this.noens][2];
        }

        public Color getForeground() {
            if (this.selectionne) {
                return couleursButtons[this.noens][0];
            }
            return couleursButtons[this.noens][1];
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.label.getMinimumSize();
            dimension.width += 6;
            return dimension;
        }

        public Dimension getMaximumSize() {
            if (this.division) {
                return super.getMaximumSize();
            }
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.division) {
                return super.getMinimumSize();
            }
            return this.getPreferredSize();
        }

        public void selection(boolean bl) {
            this.selectionne = bl;
            this.label.setForeground(this.getForeground());
            this.label.setBackground(this.getBackground());
        }

        public void setEnsembleCouleurs(int n) {
            this.noens = n - n / couleursButtons.length * couleursButtons.length;
            this.label.setForeground(this.getForeground());
            this.label.setBackground(this.getBackground());
        }
    }

    public class MyMouseListener
    extends MouseAdapter {
        JaxeElement jei;
        JFrame jframe;

        public MyMouseListener(JaxeElement jaxeElement2, JFrame jFrame) {
            this.jei = jaxeElement2;
            this.jframe = jFrame;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (JaxeElement.this.doc.textPane.isEditable() && this.jei.getEditionAutorisee()) {
                this.jei.afficherDialogue(this.jframe);
            }
        }
    }
}

