/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jaxe.ActionInsertionBalise;
import jaxe.Config;
import jaxe.EcouteurMAJ;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.JaxeTextPane;
import jaxe.elements.JESwing;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxeSPIPApplet
extends JApplet
implements EcouteurMAJ {
    private JaxeTextPane textPane = null;
    private String initTexte = null;
    private JaxeDocument jaxeDoc = null;
    private URL urlCfg = null;
    private boolean initfait = false;
    private CaretListenerLabel caretListenerLabel;
    private JMenuBar barreBalises;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public void init() {
        if (this.initTexte != null) {
            this.initialisation();
        } else {
            this.initfait = true;
        }
    }

    public String getTexte() {
        if (this.jaxeDoc == null) {
            return null;
        }
        return JaxeSPIPApplet.DOMVersSPIP(this.jaxeDoc.DOMdoc);
    }

    public void setTexte(String string) {
        this.initTexte = string;
        if (this.initfait) {
            this.initialisation();
        }
    }

    private void initialisation() {
        Document document;
        this.initTexte = this.initTexte.replaceAll("\\r", "");
        String string = JaxeSPIPApplet.SPIPVersXML(this.initTexte, true);
        try {
            document = JaxeSPIPApplet.XMLVersDOM(string);
        }
        catch (SAXException sAXException) {
            this.getContentPane().add(new JLabel("Erreur: le document n'est pas valide: " + sAXException.getMessage()));
            System.err.println("Erreur: le document n'est pas valide: " + sAXException.getMessage());
            System.err.println(string);
            this.validate();
            return;
        }
        try {
            this.urlCfg = new URL(this.getDocumentBase(), "SPIP_Jaxe_cfg.xml");
            this.jaxeDoc = new JaxeDocument();
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("MalformedURLException: " + malformedURLException.getMessage());
            this.jaxeDoc = null;
        }
        this.textPane = new JaxeTextPane(this.jaxeDoc, this);
        this.jaxeDoc.setDOMDoc(document, this.urlCfg.toExternalForm());
        this.initTexte = null;
        this.getContentPane().setLayout(new BorderLayout());
        this.barreBalises = this.jaxeDoc.cfg.makeMenus(this.jaxeDoc);
        JMenu jMenu = new JMenu("Edition");
        this.undoAction = new UndoAction();
        JMenuItem jMenuItem = jMenu.add(this.undoAction);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.redoAction = new RedoAction();
        JMenuItem jMenuItem2 = jMenu.add(this.redoAction);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(82, n));
        jMenu.addSeparator();
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = jMenu.add(new ActionCouper());
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(88, n));
        JMenuItem jMenuItem4 = jMenu.add(new ActionCopier());
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(67, n));
        JMenuItem jMenuItem5 = jMenu.add(new ActionColler());
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(86, n));
        JMenuItem jMenuItem6 = jMenu.add(new ActionToutSelectionner());
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(65, n));
        jMenu.addSeparator();
        JMenuItem jMenuItem7 = jMenu.add(new ActionRechercher());
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(70, n));
        JMenuItem jMenuItem8 = jMenu.add(new ActionSuivant());
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(71, n));
        this.barreBalises.add(jMenu);
        if (this.barreBalises != null) {
            this.getContentPane().add((Component)this.barreBalises, "North");
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        this.caretListenerLabel = new CaretListenerLabel(" ", this.jaxeDoc);
        jPanel.add(this.caretListenerLabel);
        this.getContentPane().add((Component)jPanel, "South");
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.textPane.addCaretListener(this.caretListenerLabel);
        this.textPane.ajouterEcouteurAnnulation(this);
        this.validate();
    }

    public static Document XMLVersDOM(String string) throws SAXException {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("XMLVersDOM: ParserConfigurationException: " + parserConfigurationException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println("XMLVersDOM: IOException: " + iOException.getMessage());
        }
        return document;
    }

    public static String SPIPVersXML(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("<SPIP>\n");
        }
        int n = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        int n2 = 0;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        Object var28_20 = null;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            String string2;
            char c = string.charAt(i);
            String string3 = i < n - 1 ? string.substring(i, i + 2) : null;
            String string4 = i < n - 2 ? string.substring(i, i + 3) : null;
            String string5 = i < n - 3 ? string.substring(i, i + 4) : null;
            String string6 = i < n - 4 ? string.substring(i, i + 5) : null;
            String string7 = i < n - 5 ? string.substring(i, i + 6) : null;
            String string8 = i < n - 6 ? string.substring(i, i + 7) : null;
            String string9 = i < n - 7 ? string.substring(i, i + 8) : null;
            if ("{{{".equals(string4)) {
                bl2 = true;
                stringBuffer.append("<INTERTITRE>");
                i += 2;
                continue;
            }
            if ("{{".equals(string3)) {
                bl3 = true;
                stringBuffer.append("<B>");
                ++i;
                continue;
            }
            if ('{' == c) {
                bl4 = true;
                stringBuffer.append("<I>");
                continue;
            }
            if ("[[".equals(string3)) {
                bl5 = true;
                if (i < n - 3 && string.charAt(i + 2) == '<') {
                    int n4;
                    for (n4 = i + 3; n4 < n - 2 && string.charAt(n4) != '>' && string.charAt(n4) != ']'; ++n4) {
                    }
                    if (n4 == n - 2 || string.charAt(n4) == ']') {
                        stringBuffer.append("<NOTE>");
                        ++i;
                        continue;
                    }
                    stringBuffer.append("<NOTE mention=\"" + string.substring(i + 3, n4) + "\">");
                    i = n4;
                    continue;
                }
                stringBuffer.append("<NOTE>");
                ++i;
                continue;
            }
            if ("[?".equals(string3)) {
                bl16 = true;
                stringBuffer.append("<GLOSSAIRE>");
                ++i;
                continue;
            }
            if ("<IMG".equalsIgnoreCase(string5)) {
                bl13 = true;
                n3 = i;
                i += 3;
                continue;
            }
            if ("<EMB".equalsIgnoreCase(string5)) {
                bl14 = true;
                n3 = i;
                i += 3;
                continue;
            }
            if ("<DOC".equalsIgnoreCase(string5)) {
                bl15 = true;
                n3 = i;
                i += 3;
                continue;
            }
            if ('[' == c) {
                int n5;
                for (n5 = i + 1; n5 < n - 2 && string.charAt(n5) != ']' && !"->".equals(string.substring(n5, n5 + 2)) && !"<-".equals(string.substring(n5, n5 + 2)); ++n5) {
                }
                if (n5 == n - 2) {
                    stringBuffer.append("[");
                    continue;
                }
                if ("->".equals(string.substring(n5, n5 + 2))) {
                    String string10;
                    String string11;
                    int n6;
                    for (n6 = n5 + 2; n6 < n && string.charAt(n6) != ']'; ++n6) {
                    }
                    if (n6 == n) {
                        stringBuffer.append("[");
                        continue;
                    }
                    string2 = string.substring(n5 + 2, n6);
                    if (string2.startsWith("rubrique")) {
                        string11 = "rubrique";
                        string10 = string2.substring(8);
                    } else if (string2.startsWith("rub")) {
                        string11 = "rubrique";
                        string10 = string2.substring(3);
                    } else if (string2.startsWith("br\u00e8ve")) {
                        string11 = "br\u00e8ve";
                        string10 = string2.substring(5);
                    } else if (string2.startsWith("br")) {
                        string11 = "br\u00e8ve";
                        string10 = string2.substring(2);
                    } else if (string2.startsWith("image")) {
                        string11 = "image";
                        string10 = string2.substring(5);
                    } else if (string2.startsWith("img")) {
                        string11 = "image";
                        string10 = string2.substring(3);
                    } else if (string2.startsWith("document")) {
                        string11 = "document";
                        string10 = string2.substring(8);
                    } else if (string2.startsWith("doc")) {
                        string11 = "document";
                        string10 = string2.substring(3);
                    } else if (string2.startsWith("#")) {
                        string11 = "ancre";
                        string10 = string2.substring(1);
                    } else if (string2.startsWith("http")) {
                        string11 = "externe";
                        string10 = string2;
                    } else if (string2.startsWith("mot")) {
                        string11 = "mot-cl\u00e9";
                        string10 = string2.substring(3);
                    } else if (string2.startsWith("auteur")) {
                        string11 = "auteur";
                        string10 = string2.substring(6);
                    } else if (string2.startsWith("aut")) {
                        string11 = "auteur";
                        string10 = string2.substring(3);
                    } else if (string2.startsWith("site")) {
                        string11 = "site-syndiqu\u00e9";
                        string10 = string2.substring(4);
                    } else {
                        string11 = "article";
                        string10 = string2.startsWith("article") ? string2.substring(7) : (string2.startsWith("art") ? string2.substring(3) : string2);
                    }
                    if (string10 != null) {
                        string10 = string10.trim();
                    }
                    stringBuffer.append("<LIEN type=\"" + string11 + "\" num\u00e9ro=\"" + string10 + "\">");
                    bl6 = true;
                    bl7 = false;
                    continue;
                }
                if ("<-".equals(string.substring(n5, n5 + 2))) {
                    stringBuffer.append("<ANCRE nom=\"" + string.substring(i + 1, n5) + "\"/>");
                    bl6 = true;
                    bl7 = true;
                    bl8 = true;
                    continue;
                }
                stringBuffer.append("[");
                continue;
            }
            if ("----".equals(string5)) {
                stringBuffer.append("<SEPARATION/>");
                i += 3;
                continue;
            }
            if ("<quote>".equalsIgnoreCase(string8)) {
                stringBuffer.append("<CITATION>");
                i += 6;
                continue;
            }
            if ("<math>".equalsIgnoreCase(string7)) {
                stringBuffer.append("<MATH>");
                i += 5;
                continue;
            }
            if ("<sup>".equalsIgnoreCase(string6)) {
                stringBuffer.append("<SUP>");
                i += 4;
                continue;
            }
            if ("<sub>".equalsIgnoreCase(string6)) {
                stringBuffer.append("<SUB>");
                i += 4;
                continue;
            }
            if ("<cadre>".equalsIgnoreCase(string8) || "<frame>".equalsIgnoreCase(string8)) {
                int n7;
                for (n7 = i + 7; n7 < n - 7 && !"</cadre>".equalsIgnoreCase(string.substring(n7, n7 + 8)) && !"</frame>".equalsIgnoreCase(string.substring(n7, n7 + 8)); ++n7) {
                }
                stringBuffer.append("<CADRE>");
                String string12 = string.substring(i + 7, n7);
                string12 = string12.replaceAll("&", "&amp;");
                string12 = string12.replaceAll("<", "&lt;");
                string12 = string12.replaceAll(">", "&gt;");
                string12 = string12.replaceAll("\"", "&quot;");
                stringBuffer.append(string12);
                stringBuffer.append("</CADRE>");
                i = n7 + 7;
                continue;
            }
            if ("<code>".equalsIgnoreCase(string7)) {
                int n8;
                for (n8 = i + 6; n8 < n - 6 && !"</code>".equalsIgnoreCase(string.substring(n8, n8 + 7)); ++n8) {
                }
                stringBuffer.append("<CODE>");
                String string13 = string.substring(i + 6, n8);
                string13 = string13.replaceAll("&", "&amp;");
                string13 = string13.replaceAll("<", "&lt;");
                string13 = string13.replaceAll(">", "&gt;");
                string13 = string13.replaceAll("\"", "&quot;");
                stringBuffer.append(string13);
                stringBuffer.append("</CODE>");
                i = n8 + 6;
                continue;
            }
            if ("<poesie>".equalsIgnoreCase(string9) || "<poetry>".equalsIgnoreCase(string9)) {
                stringBuffer.append("<POESIE>");
                i += 7;
                continue;
            }
            if ("<table".equalsIgnoreCase(string7)) {
                int n9;
                String string14 = null;
                for (n9 = i + 6; n9 < n - 10 && !"summary=\"".equalsIgnoreCase(string.substring(n9, n9 + 9)) && !"</table>".equalsIgnoreCase(string.substring(n9, n9 + 8)); ++n9) {
                }
                if (n9 < n - 10 && "summary=\"".equalsIgnoreCase(string.substring(n9, n9 + 9))) {
                    int n10;
                    for (n10 = n9 + 9; n10 < n - 9 && '\"' != string.charAt(n10) && !"</table>".equalsIgnoreCase(string.substring(n10, n10 + 8)); ++n10) {
                    }
                    if ('\"' == string.charAt(n10)) {
                        string14 = string.substring(n9 + 9, n10);
                    }
                }
                boolean bl17 = false;
                for (n9 = i + 6; n9 < n - 17 && !"<caption>".equalsIgnoreCase(string.substring(n9, n9 + 9)) && !"</table>".equalsIgnoreCase(string.substring(n9, n9 + 8)); ++n9) {
                }
                if (n9 < n - 17 && "<caption>".equalsIgnoreCase(string.substring(n9, n9 + 9))) {
                    int n11;
                    for (n11 = n9 + 9; n11 < n - 9 && !"</caption>".equalsIgnoreCase(string.substring(n11, n11 + 10)) && !"</table>".equalsIgnoreCase(string.substring(n11, n11 + 8)); ++n11) {
                    }
                    if (n11 < n - 9 && "</caption>".equalsIgnoreCase(string.substring(n11, n11 + 10))) {
                        String string15 = string.substring(n9 + 9, n11);
                        if (string14 != null) {
                            stringBuffer.append("<TABLE titre=\"" + string15 + "\" r\u00e9sum\u00e9=\"" + string14 + "\">");
                        } else {
                            stringBuffer.append("<TABLE titre=\"" + string15 + "\">");
                        }
                        i = n11 + 9;
                        bl17 = true;
                    }
                }
                if (bl17) continue;
                if (string14 != null) {
                    stringBuffer.append("<TABLE r\u00e9sum\u00e9=\"" + string14 + "\">");
                } else {
                    stringBuffer.append("<TABLE>");
                }
                for (n9 = i + 6; n9 < n && string.charAt(n9) != '>'; ++n9) {
                }
                i = n9;
                continue;
            }
            if ("<tr".equalsIgnoreCase(string4)) {
                int n12;
                stringBuffer.append("<TR>");
                for (n12 = i + 3; n12 < n && string.charAt(n12) != '>'; ++n12) {
                }
                i = n12;
                continue;
            }
            if ("<td".equalsIgnoreCase(string4)) {
                int n13;
                if (i >= n - 3) {
                    i += 2;
                    continue;
                }
                if ('>' == string.charAt(i + 3)) {
                    stringBuffer.append("<TD>");
                    i += 3;
                    continue;
                }
                if (' ' != string.charAt(i + 3)) continue;
                for (n13 = i; n13 < n && string.charAt(n13) != '>'; ++n13) {
                }
                stringBuffer.append("<TD" + string.substring(i + 3, n13 + 1));
                i = n13;
                continue;
            }
            if ("<th".equalsIgnoreCase(string4)) {
                int n14;
                if (i >= n - 3) {
                    i += 2;
                    continue;
                }
                if ('>' == string.charAt(i + 3)) {
                    stringBuffer.append("<TH>");
                    i += 3;
                    continue;
                }
                if (' ' != string.charAt(i + 3)) continue;
                for (n14 = i; n14 < n && string.charAt(n14) != '>'; ++n14) {
                }
                stringBuffer.append("<TH" + string.substring(i + 3, n14 + 1));
                i = n14;
                continue;
            }
            if ((i == 0 || string.charAt(i - 1) == '\n') && "-#".equals(string3)) {
                if (!bl11) {
                    int n15;
                    bl11 = true;
                    bl12 = true;
                    stringBuffer.append("<LISTENUM>\n<EL>");
                    for (n15 = i + 2; n15 < n && string.charAt(n15) == '#'; ++n15) {
                    }
                    int n16 = n15 - (i + 2);
                    while (n16 > n2) {
                        ++n2;
                        stringBuffer.append("<LISTENUM>\n<EL>");
                    }
                    if (string.length() > (i += n16) + 2 && string.charAt(i + 2) == ' ') {
                        ++i;
                    }
                }
                ++i;
                continue;
            }
            if ((i == 0 || string.charAt(i - 1) == '\n') && '-' == c) {
                int n17;
                if (bl11) continue;
                bl11 = true;
                bl12 = false;
                stringBuffer.append("<LISTE>\n<EL>");
                for (n17 = i + 1; n17 < n && string.charAt(n17) == '*'; ++n17) {
                }
                int n18 = n17 - (i + 1);
                while (n18 > n2) {
                    ++n2;
                    stringBuffer.append("<LISTE>\n<EL>");
                }
                if (string.length() <= (i += n18) + 2 || string.charAt(i + 1) != ' ') continue;
                ++i;
                continue;
            }
            if (bl11 && ('\n' == c || i == n - 1)) {
                int n19;
                char c2;
                String string16;
                String string17;
                if (i == n - 1) {
                    stringBuffer.append(c);
                }
                if (bl12) {
                    string17 = "LISTENUM";
                    string16 = "-#";
                    c2 = '#';
                } else {
                    string17 = "LISTE";
                    string16 = "-";
                    c2 = '*';
                }
                if (i >= n - string16.length() || !string16.equals(string.substring(i + 1, i + 1 + string16.length()))) {
                    while (n2 > 0) {
                        stringBuffer.append("</EL>\n</" + string17 + ">");
                        --n2;
                    }
                    stringBuffer.append("</EL>\n</" + string17 + ">");
                    bl11 = false;
                    continue;
                }
                for (n19 = i + 1 + string16.length(); n19 < n && string.charAt(n19) == c2; ++n19) {
                }
                int n20 = n19 - (i + 1 + string16.length());
                if (n20 > n2) {
                    while (n20 > n2) {
                        ++n2;
                        stringBuffer.append("<" + string17 + ">\n<EL>");
                    }
                } else if (n20 < n2) {
                    stringBuffer.append("</EL>\n");
                    while (n20 < n2) {
                        --n2;
                        stringBuffer.append("</" + string17 + "></EL>\n");
                    }
                    stringBuffer.append("<EL>");
                } else {
                    stringBuffer.append("</EL>\n<EL>");
                }
                i = i + string16.length() + n20;
                if (string.length() <= i + 1 || string.charAt(i + 1) != ' ') continue;
                ++i;
                continue;
            }
            if (!(bl13 || bl15 || bl14 || '|' != c)) {
                int n21;
                Object object;
                int n22;
                int n23;
                String string18 = null;
                String string19 = null;
                if (i < n - 2 && '|' == string.charAt(i + 1)) {
                    int n24;
                    for (n24 = i + 2; n24 < n - 2 && '\n' != string.charAt(n24) && '|' != string.charAt(n24); ++n24) {
                    }
                    if (n24 < n - 2 && '|' == string.charAt(n24)) {
                        string18 = string.substring(i + 2, n24);
                        if ('|' == string.charAt(n24 + 1)) {
                            i = n24 + 3;
                        } else {
                            int n25;
                            for (n25 = n24 + 1; n25 < n - 1 && '\n' != string.charAt(n25) && !"||".equalsIgnoreCase(string.substring(n25, n25 + 2)); ++n25) {
                            }
                            string19 = string.substring(n24 + 1, n25);
                            i = n25 + 3;
                        }
                    }
                }
                ArrayList arrayList = new ArrayList();
                int n26 = i;
                while (string.length() > n26 && string.charAt(n26) == '|') {
                    int n27 = string.substring(n26).indexOf(10);
                    if (n27 != -1) {
                        n27 += n26;
                    }
                    while (n27 != -1 && string.length() > n27 + 3 && "_ ".equals(string.substring(n27 + 1, n27 + 3))) {
                        int n28 = n27 + 3;
                        if ((n27 = string.substring(n28).indexOf(10)) == -1) continue;
                        n27 += n28;
                    }
                    String string20 = n27 == -1 ? string.substring(n26) : string.substring(n26, n27);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    n23 = 1;
                    while (string20.length() > n23) {
                        int n29 = string20.substring(n23).indexOf(124);
                        String string21 = n29 == -1 ? string20.substring(n23) : string20.substring(n23, n29 += n23);
                        if (n29 != -1) {
                            arrayList2.add(string21);
                        }
                        if (n29 != -1) {
                            n23 = n29 + 1;
                            continue;
                        }
                        n23 = string20.length();
                    }
                    arrayList.add(arrayList2);
                    if (n27 != -1) {
                        n26 = n27 + 1;
                        continue;
                    }
                    n26 = string.length();
                }
                i = n26 - 1;
                boolean bl18 = false;
                int n30 = arrayList.size();
                int n31 = n30 == 0 ? 0 : ((ArrayList)arrayList.get(0)).size();
                for (n23 = 1; n23 < n30; ++n23) {
                    ArrayList arrayList3 = (ArrayList)arrayList.get(n23);
                    if (arrayList3.size() == n31) continue;
                    System.err.println("JaxeSPIPApplet: erreur: nombre de cellules incorrect \u00e0 la ligne " + (n23 + 1) + " du tableau");
                    bl18 = true;
                }
                int[][] nArray = new int[n30][n31];
                int[][] nArray2 = new int[n30][n31];
                if (!bl18) {
                    for (int j = 0; j < n30; ++j) {
                        for (int k = 0; k < n31; ++k) {
                            String string22;
                            String string23;
                            int n32;
                            n22 = 1;
                            object = (ArrayList)arrayList.get(j);
                            for (n32 = k + 1; n32 < n31 && "<".equals(string23 = (String)((ArrayList)object).get(n32)); ++n32) {
                                ++n22;
                            }
                            nArray[j][k] = n22;
                            n32 = 1;
                            for (n21 = j + 1; n21 < n30 && "^".equals(string22 = (String)((ArrayList)arrayList.get(n21)).get(k)); ++n21) {
                                ++n32;
                            }
                            nArray2[j][k] = n32;
                        }
                    }
                }
                if (string18 != null && string19 != null) {
                    stringBuffer.append("<TABLE titre=\"" + string18 + "\" r\u00e9sum\u00e9=\"" + string19 + "\">\n");
                } else if (string18 != null) {
                    stringBuffer.append("<TABLE titre=\"" + string18 + "\">\n");
                } else {
                    stringBuffer.append("<TABLE>\n");
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    ArrayList arrayList4 = (ArrayList)arrayList.get(j);
                    stringBuffer.append("<TR>");
                    for (n22 = 0; n22 < arrayList4.size(); ++n22) {
                        object = (String)arrayList4.get(n22);
                        if (!bl18 && ("<".equals(object) || "^".equals(object))) continue;
                        String string24 = ((String)object).trim();
                        int n33 = n21 = j == 0 && string24.startsWith("{{") && string24.endsWith("}}") ? 1 : 0;
                        if (n21 != 0) {
                            object = string24.substring(2, string24.length() - 2);
                        }
                        if (n21 != 0) {
                            stringBuffer.append("<TH");
                        } else {
                            stringBuffer.append("<TD");
                        }
                        if (!bl18 && nArray2[j][n22] > 1) {
                            stringBuffer.append(" rowspan=\"" + nArray2[j][n22] + "\"");
                        }
                        if (!bl18 && nArray[j][n22] > 1) {
                            stringBuffer.append(" colspan=\"" + nArray[j][n22] + "\"");
                        }
                        stringBuffer.append(">");
                        stringBuffer.append(JaxeSPIPApplet.SPIPVersXML((String)object, false));
                        if (n21 != 0) {
                            stringBuffer.append("</TH>");
                            continue;
                        }
                        stringBuffer.append("</TD>");
                    }
                    stringBuffer.append("</TR>\n");
                }
                stringBuffer.append("</TABLE>");
                continue;
            }
            if ("_ ".equals(string3)) {
                stringBuffer.append("<BR/>");
                ++i;
                continue;
            }
            if ((bl13 || bl14 || bl15) && '>' == c) {
                String string25;
                String string26 = string.substring(n3 + 4, i);
                int n34 = string26.indexOf(124);
                string2 = n34 != -1 ? string26.substring(0, n34) : string26;
                if (n34 != -1) {
                    string25 = string26.substring(n34 + 1);
                    if ("left".equals(string25)) {
                        string25 = "gauche";
                    } else if ("center".equals(string25)) {
                        string25 = "milieu";
                    } else if ("right".equals(string25)) {
                        string25 = "droite";
                    }
                } else {
                    string25 = "danstexte";
                }
                if (bl13) {
                    stringBuffer.append("<IMAGE num\u00e9ro=\"" + string2 + "\" position=\"" + string25 + "\"/>");
                    bl13 = false;
                    continue;
                }
                if (bl15) {
                    stringBuffer.append("<DOCUMENT num\u00e9ro=\"" + string2 + "\" position=\"" + string25 + "\"/>");
                    bl15 = false;
                    continue;
                }
                stringBuffer.append("<EMBED num\u00e9ro=\"" + string2 + "\" position=\"" + string25 + "\"/>");
                bl14 = false;
                continue;
            }
            if (bl2 && "}}}".equals(string4)) {
                bl2 = false;
                stringBuffer.append("</INTERTITRE>");
                i += 2;
                continue;
            }
            if (bl3 && "}}".equals(string3)) {
                bl3 = false;
                stringBuffer.append("</B>");
                ++i;
                continue;
            }
            if (bl4 && '}' == c) {
                bl4 = false;
                stringBuffer.append("</I>");
                continue;
            }
            if (bl5 && "]]".equals(string3)) {
                bl5 = false;
                stringBuffer.append("</NOTE>");
                ++i;
                continue;
            }
            if (bl16 && ']' == c) {
                bl16 = false;
                stringBuffer.append("</GLOSSAIRE>");
                continue;
            }
            if (bl6 && ']' == c) {
                if (!bl8) {
                    stringBuffer.append("</LIEN>");
                }
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (bl6 && "->".equals(string3)) {
                bl8 = false;
                bl7 = true;
                ++i;
                continue;
            }
            if (bl6 && "<-".equals(string3)) {
                bl8 = true;
                bl7 = true;
                ++i;
                continue;
            }
            if ("</quote>".equalsIgnoreCase(string9)) {
                stringBuffer.append("</CITATION>");
                i += 7;
                continue;
            }
            if ("</math>".equalsIgnoreCase(string8)) {
                stringBuffer.append("</MATH>");
                i += 6;
                continue;
            }
            if ("</sup>".equalsIgnoreCase(string7)) {
                stringBuffer.append("</SUP>");
                i += 5;
                continue;
            }
            if ("</sub>".equalsIgnoreCase(string7)) {
                stringBuffer.append("</SUB>");
                i += 5;
                continue;
            }
            if (i < n - 8 && ("</poesie>".equalsIgnoreCase(string.substring(i, i + 9)) || "</poetry>".equalsIgnoreCase(string.substring(i, i + 9)))) {
                stringBuffer.append("</POESIE>");
                i += 8;
                continue;
            }
            if ("</table>".equalsIgnoreCase(string9)) {
                stringBuffer.append("</TABLE>");
                i += 7;
                continue;
            }
            if ("</tr>".equalsIgnoreCase(string6)) {
                stringBuffer.append("</TR>");
                i += 4;
                continue;
            }
            if ("</td>".equalsIgnoreCase(string6)) {
                stringBuffer.append("</TD>");
                i += 4;
                continue;
            }
            if ("</th>".equalsIgnoreCase(string6)) {
                stringBuffer.append("</TH>");
                i += 4;
                continue;
            }
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            if (bl7 || bl13 || bl15 || bl14) continue;
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append("\n</SPIP>");
        }
        return stringBuffer.toString();
    }

    private static void transfo(Element element, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        int n;
        int n2;
        String string;
        String string2 = element.getNodeName();
        if ("INTERTITRE".equals(string2)) {
            stringBuffer.append("{{{");
        } else if ("B".equals(string2)) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '{') {
                stringBuffer.append(' ');
            }
            stringBuffer.append("{{");
        } else if ("I".equals(string2)) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '{') {
                stringBuffer.append(' ');
            }
            stringBuffer.append('{');
        } else if ("LIEN".equals(string2)) {
            stringBuffer.append('[');
        } else if ("ANCRE".equals(string2)) {
            stringBuffer.append('[');
        } else if ("EL".equals(string2)) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            Node node = element.getFirstChild();
            Element element2 = (Element)element.getParentNode();
            string = element2.getNodeName();
            if (node == null || !string.equals(node.getNodeName())) {
                stringBuffer.append('-');
                int n3 = 0;
                if ("LISTENUM".equals(string)) {
                    n2 = 35;
                    n3 = 1;
                } else {
                    n2 = 42;
                }
                while (element2 != null) {
                    if (string.equals(element2.getNodeName())) {
                        ++n3;
                    }
                    if (element2.getParentNode() instanceof Element) {
                        element2 = (Element)element2.getParentNode();
                        continue;
                    }
                    element2 = null;
                }
                for (n = 0; n < n3 - 1; ++n) {
                    stringBuffer.append((char)n2);
                }
                stringBuffer.append(' ');
            }
        } else if ("NOTE".equals(string2)) {
            if ("".equals(element.getAttribute("mention"))) {
                stringBuffer.append("[[");
            } else {
                stringBuffer.append("[[<" + element.getAttribute("mention") + ">");
            }
        } else if ("IMAGE".equals(string2)) {
            String string3 = element.getAttribute("num\u00e9ro");
            String string4 = element.getAttribute("position");
            if ("".equals(string4) || "gauche".equals(string4)) {
                string4 = "left";
            } else if ("milieu".equals(string4)) {
                string4 = "center";
            } else if ("droite".equals(string4)) {
                string4 = "right";
            }
            if ("danstexte".equals(string4)) {
                stringBuffer.append("<IMG" + string3 + ">");
            } else {
                stringBuffer.append("<IMG" + string3 + "|" + string4 + ">");
            }
        } else if ("DOCUMENT".equals(string2)) {
            String string5 = element.getAttribute("num\u00e9ro");
            String string6 = element.getAttribute("position");
            if ("".equals(string6) || "gauche".equals(string6)) {
                string6 = "left";
            } else if ("milieu".equals(string6)) {
                string6 = "center";
            } else if ("droite".equals(string6)) {
                string6 = "right";
            }
            if ("danstexte".equals(string6)) {
                stringBuffer.append("<DOC" + string5 + ">");
            } else {
                stringBuffer.append("<DOC" + string5 + "|" + string6 + ">");
            }
        } else if ("EMBED".equals(string2)) {
            String string7 = element.getAttribute("num\u00e9ro");
            String string8 = element.getAttribute("position");
            if ("".equals(string8) || "gauche".equals(string8)) {
                string8 = "left";
            } else if ("milieu".equals(string8)) {
                string8 = "center";
            } else if ("droite".equals(string8)) {
                string8 = "right";
            }
            if ("danstexte".equals(string8)) {
                stringBuffer.append("<EMB" + string7 + ">");
            } else {
                stringBuffer.append("<EMB" + string7 + "|" + string8 + ">");
            }
        } else if ("TABLE".equals(string2)) {
            Object object;
            Node node;
            Element element3;
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            bl2 = false;
            for (Node node2 = element.getFirstChild(); node2 != null && !bl2; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !"TR".equals(node2.getNodeName())) continue;
                element3 = (Element)node2;
                for (node = element3.getFirstChild(); node != null && !bl2; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !"TD".equals(node.getNodeName()) && !"TH".equals(node.getNodeName()) || "".equals((object = (Element)node).getAttribute("align"))) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                if ("".equals(element.getAttribute("r\u00e9sum\u00e9"))) {
                    stringBuffer.append("<table class=\"spip\">\n");
                } else {
                    stringBuffer.append("<table class=\"spip\" summary=\"" + element.getAttribute("r\u00e9sum\u00e9") + "\">\n");
                }
                if (!"".equals(element.getAttribute("titre"))) {
                    stringBuffer.append("<caption>" + element.getAttribute("titre") + "</caption>\n");
                }
            } else {
                if (!"".equals(element.getAttribute("titre"))) {
                    if ("".equals(element.getAttribute("r\u00e9sum\u00e9"))) {
                        stringBuffer.append("||" + element.getAttribute("titre") + "||\n");
                    } else {
                        stringBuffer.append("||" + element.getAttribute("titre") + "|" + element.getAttribute("r\u00e9sum\u00e9") + "||\n");
                    }
                }
                int n4 = 0;
                element3 = null;
                for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !"TR".equals(node.getNodeName())) continue;
                    if (element3 == null) {
                        element3 = (Element)node;
                    }
                    ++n4;
                }
                int n5 = 0;
                for (object = element3.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() != 1 || !"TD".equals(object.getNodeName()) && !"TH".equals(object.getNodeName())) continue;
                    Element element4 = (Element)object;
                    if (!"".equals(element4.getAttribute("colspan"))) {
                        try {
                            n5 += Integer.parseInt(element4.getAttribute("colspan"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            ++n5;
                        }
                        continue;
                    }
                    ++n5;
                }
                object = new Object[n4][n5];
                for (n2 = 0; n2 < n4; ++n2) {
                    for (int i = 0; i < n5; ++i) {
                        object[n2][i] = null;
                    }
                }
                n2 = 0;
                for (Node node3 = element.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    if (node3.getNodeType() != 1 || !"TR".equals(node3.getNodeName())) continue;
                    Element element5 = (Element)node3;
                    int n6 = 0;
                    for (Node node4 = element5.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                        int n7;
                        if (node4.getNodeType() != 1 || !"TD".equals(node4.getNodeName()) && !"TH".equals(node4.getNodeName())) continue;
                        Element element6 = (Element)node4;
                        while (n6 < n5 && object[n2][n6] != null) {
                            ++n6;
                        }
                        object[n2][n6] = element6;
                        int n8 = 1;
                        if (!"".equals(element6.getAttribute("colspan"))) {
                            try {
                                n8 = Integer.parseInt(element6.getAttribute("colspan"));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        int n9 = 1;
                        if (!"".equals(element6.getAttribute("rowspan"))) {
                            try {
                                n9 = Integer.parseInt(element6.getAttribute("rowspan"));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        for (n7 = 1; n7 < n8; ++n7) {
                            object[n2][n6 + n7] = "<";
                        }
                        for (n7 = 1; n7 < n9; ++n7) {
                            for (int i = 0; i < n8; ++i) {
                                object[n2 + n7][n6 + i] = "^";
                            }
                        }
                        n6 += n8;
                    }
                    ++n2;
                }
                for (n = 0; n < n4; ++n) {
                    stringBuffer.append('|');
                    for (int i = 0; i < n5; ++i) {
                        if (object[n][i] instanceof String) {
                            stringBuffer.append((String)object[n][i] + "|");
                            continue;
                        }
                        if (!(object[n][i] instanceof Element)) continue;
                        JaxeSPIPApplet.transfo((Element)object[n][i], stringBuffer, bl, bl2);
                    }
                    stringBuffer.append('\n');
                }
            }
        } else if ("TR".equals(string2)) {
            if (bl2) {
                boolean bl3 = false;
                for (Node node = element.getFirstChild(); node != null && !bl3; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !"TH".equals(node.getNodeName())) continue;
                    bl3 = true;
                }
                if (bl3) {
                    stringBuffer.append("<tr class=\"row_first\">");
                } else {
                    boolean bl4 = false;
                    Node node = element;
                    while (node != null) {
                        for (node = node.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
                        }
                        bl3 = false;
                        if (node != null) {
                            for (Node node5 = node.getFirstChild(); node5 != null && !bl3; node5 = node5.getNextSibling()) {
                                if (node5.getNodeType() != 1 || !"TH".equals(node5.getNodeName())) continue;
                                bl3 = true;
                            }
                        }
                        if (bl3) continue;
                        bl4 = !bl4;
                    }
                    if (bl4) {
                        stringBuffer.append("<tr class=\"row_even\">");
                    } else {
                        stringBuffer.append("<tr class=\"row_odd\">");
                    }
                }
            } else {
                stringBuffer.append('|');
            }
        } else if ("TD".equals(string2)) {
            if (bl2) {
                stringBuffer.append("<td");
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node = namedNodeMap.item(i);
                    stringBuffer.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                }
                stringBuffer.append('>');
            } else {
                bl = true;
            }
        } else if ("TH".equals(string2)) {
            if (bl2) {
                stringBuffer.append("<th");
                NamedNodeMap namedNodeMap = element.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node = namedNodeMap.item(i);
                    stringBuffer.append(" " + node.getNodeName() + "=\"" + node.getNodeValue() + "\"");
                }
                stringBuffer.append('>');
            } else {
                if (stringBuffer.length() > 1 && !"{{".equals(stringBuffer.substring(stringBuffer.length() - 2))) {
                    stringBuffer.append("{{");
                }
                bl = true;
            }
        } else if ("BR".equals(string2)) {
            if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                stringBuffer.append('\n');
            }
            stringBuffer.append("_ ");
        } else if ("SEPARATION".equals(string2)) {
            stringBuffer.append("----");
        } else if ("CITATION".equals(string2)) {
            stringBuffer.append("<quote>");
        } else if ("MATH".equals(string2)) {
            stringBuffer.append("<math>");
        } else if ("SUP".equals(string2)) {
            stringBuffer.append("<sup>");
        } else if ("SUB".equals(string2)) {
            stringBuffer.append("<sub>");
        } else if ("GLOSSAIRE".equals(string2)) {
            stringBuffer.append("[?");
        } else if ("CADRE".equals(string2)) {
            stringBuffer.append("<cadre>");
        } else if ("CODE".equals(string2)) {
            stringBuffer.append("<code>");
        } else if ("POESIE".equals(string2)) {
            stringBuffer.append("<poesie>");
        }
        if (!"TABLE".equals(string2) || bl2) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 1) {
                    JaxeSPIPApplet.transfo((Element)node, stringBuffer, bl, bl2);
                    continue;
                }
                if (node.getNodeType() != 3 || "TABLE".equals(string2) || "LISTE".equals(string2) || "LISTENUM".equals(string2)) continue;
                String string9 = node.getNodeValue();
                if (bl) {
                    string9 = string9.replace('\n', ' ');
                }
                stringBuffer.append(string9);
            }
        }
        if ("INTERTITRE".equals(string2)) {
            stringBuffer.append("}}}");
        } else if ("B".equals(string2)) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '}') {
                stringBuffer.append(' ');
            }
            stringBuffer.append("}}");
        } else if ("I".equals(string2)) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '}') {
                stringBuffer.append(' ');
            }
            stringBuffer.append('}');
        } else if ("LIEN".equals(string2)) {
            String string10 = "";
            String string11 = element.getAttribute("type");
            if ("".equals(string11) || "article".equals(string11)) {
                string10 = "art";
            } else if ("rubrique".equals(string11)) {
                string10 = "rub";
            } else if ("br\u00e8ve".equals(string11)) {
                string10 = "br";
            } else if ("image".equals(string11)) {
                string10 = "img";
            } else if ("document".equals(string11)) {
                string10 = "doc";
            } else if ("ancre".equals(string11)) {
                string10 = "#";
            } else if ("externe".equals(string11)) {
                string10 = "";
            } else if ("mot-cl\u00e9".equals(string11)) {
                string10 = "mot";
            } else if ("auteur".equals(string11)) {
                string10 = "aut";
            } else if ("site-syndiqu\u00e9".equals(string11)) {
                string10 = "site";
            }
            string = element.getAttribute("num\u00e9ro");
            string10 = string10 + string;
            stringBuffer.append("->" + string10 + "]");
        } else if ("ANCRE".equals(string2)) {
            String string12 = element.getAttribute("nom");
            stringBuffer.append(string12 + "<-]");
        } else if ("NOTE".equals(string2)) {
            stringBuffer.append("]]");
        } else if ("TABLE".equals(string2)) {
            if (bl2) {
                stringBuffer.append("</table>");
            }
        } else if ("TR".equals(string2)) {
            if (bl2) {
                stringBuffer.append("</tr>");
            }
            stringBuffer.append("\n");
        } else if ("LISTE".equals(string2) || "LISTENUM".equals(string2)) {
            Element element7 = (Element)element.getParentNode();
            if (!"EL".equals(element7.getNodeName())) {
                stringBuffer.append("\n");
            }
        } else if ("TD".equals(string2)) {
            if (bl2) {
                stringBuffer.append("</td>");
            } else {
                stringBuffer.append('|');
            }
        } else if ("TH".equals(string2)) {
            if (bl2) {
                stringBuffer.append("</th>");
            } else {
                if (stringBuffer.length() > 1 && !"}}".equals(stringBuffer.substring(stringBuffer.length() - 2))) {
                    stringBuffer.append("}}");
                }
                stringBuffer.append('|');
            }
        } else if ("CITATION".equals(string2)) {
            stringBuffer.append("</quote>");
        } else if ("MATH".equals(string2)) {
            stringBuffer.append("</math>");
        } else if ("SUP".equals(string2)) {
            stringBuffer.append("</sup>");
        } else if ("SUB".equals(string2)) {
            stringBuffer.append("</sub>");
        } else if ("GLOSSAIRE".equals(string2)) {
            stringBuffer.append("]");
        } else if ("CADRE".equals(string2)) {
            stringBuffer.append("</cadre>");
        } else if ("CODE".equals(string2)) {
            stringBuffer.append("</code>");
        } else if ("POESIE".equals(string2)) {
            stringBuffer.append("</poesie>");
        }
    }

    public static String DOMVersSPIP(Document document) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element = document.getDocumentElement();
        JaxeSPIPApplet.transfo(element, stringBuffer, false, false);
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public void majMenus(int n) {
        JaxeDocument jaxeDocument = this.jaxeDoc;
        if (jaxeDocument.cfg == null || this.barreBalises == null) {
            return;
        }
        JaxeElement jaxeElement = null;
        if (jaxeDocument.rootJE != null) {
            jaxeElement = jaxeDocument.rootJE.elementA(n);
        }
        if (jaxeElement != null && jaxeElement.debut.getOffset() == n && !(jaxeElement instanceof JESwing)) {
            jaxeElement = jaxeElement.getParent();
        }
        if (jaxeElement != null && jaxeElement.noeud.getNodeType() == 3) {
            jaxeElement = jaxeElement.getParent();
        }
        ArrayList arrayList = null;
        Config config = null;
        if (jaxeElement == null) {
            config = jaxeDocument.cfg;
            arrayList = jaxeDocument.cfg.listeRacines();
        } else {
            Element element = jaxeDocument.cfg.getElementDef((Element)jaxeElement.noeud);
            if (element == null) {
                return;
            }
            config = jaxeDocument.cfg.getDefConf(element);
            arrayList = config.listeSousbalises(element);
        }
        for (int i = 0; i < this.barreBalises.getMenuCount(); ++i) {
            JMenu jMenu = this.barreBalises.getMenu(i);
            if ("Edition".equals(jMenu.getText())) continue;
            this.majMenu(jMenu, config, arrayList);
        }
    }

    protected boolean majMenu(JMenu jMenu, Config config, ArrayList arrayList) {
        boolean bl = false;
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            Action action = jMenuItem.getAction();
            if (action instanceof ActionInsertionBalise) {
                Element element = ((ActionInsertionBalise)action).getDefbalise();
                if (element == null) continue;
                Config config2 = this.jaxeDoc.cfg.getDefConf(element);
                if (config2 == config) {
                    String string = config2.typeBalise(element);
                    String string2 = config2.nomBalise(element);
                    if (string.equals("style") && string2.equals("NORMAL")) continue;
                    boolean bl2 = false;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (!string2.equals((String)arrayList.get(j))) continue;
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    action.setEnabled(bl2);
                    continue;
                }
                action.setEnabled(true);
                continue;
            }
            if (!(jMenuItem instanceof JMenu)) continue;
            bl = this.majMenu((JMenu)jMenuItem, config, arrayList) || bl;
        }
        if (!jMenu.isTopLevelMenu()) {
            jMenu.setEnabled(bl);
        }
        return bl;
    }

    public void miseAJour() {
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    static class ActionToutSelectionner
    extends TextAction {
        public ActionToutSelectionner() {
            super("Tout s\u00e9lectionner");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).toutSelectionner();
            }
        }
    }

    protected class ActionColler
    extends TextAction {
        public ActionColler() {
            super("Coller");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).coller();
            }
        }
    }

    protected class ActionCopier
    extends TextAction {
        public ActionCopier() {
            super("Copier");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).copier();
            }
        }
    }

    protected class ActionCouper
    extends TextAction {
        public ActionCouper() {
            super("Couper");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).couper();
            }
        }
    }

    class ActionSuivant
    extends TextAction {
        public ActionSuivant() {
            super("Rechercher suivant");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeSPIPApplet.this.textPane.suivant();
        }
    }

    class ActionRechercher
    extends TextAction {
        public ActionRechercher() {
            super("Rechercher...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeSPIPApplet.this.textPane.rechercher();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("R\u00e9tablir");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UndoManager undoManager = JaxeSPIPApplet.this.textPane.getUndo();
            try {
                undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Impossible de r\u00e9tablir: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.updateRedoState();
            JaxeSPIPApplet.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            UndoManager undoManager = JaxeSPIPApplet.this.textPane.getUndo();
            if (undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "R\u00e9tablir");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Annuler");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeSPIPApplet.this.textPane.undo();
        }

        protected void updateUndoState() {
            UndoManager undoManager = JaxeSPIPApplet.this.textPane.getUndo();
            if (undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Annuler");
            }
        }
    }

    protected class CaretListenerLabel
    extends JLabel
    implements CaretListener {
        JaxeDocument doc;

        public CaretListenerLabel(String string, JaxeDocument jaxeDocument) {
            super(string);
            this.doc = jaxeDocument;
        }

        public void caretUpdate(CaretEvent caretEvent) {
            int n;
            int n2 = caretEvent.getDot();
            if (n2 == (n = caretEvent.getMark())) {
                this.setText(n2 + ": " + this.doc.getPathAsString(n2));
            }
            JaxeSPIPApplet.this.majMenus(n2);
        }
    }
}

