/*
    Copyright (C) 2004  Damien Guillaume
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package dispgrid;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

import xml.*;

/**
 * A canvas to display the grid (used by GridFrame)
 *
 * @version     2.0, 15/4/2004
 * @author      Damien Guillaume
 */

class FramedArea extends Canvas {
  int DIMX, DIMY;
  int XSPACE = 150;
  int YSPACE = 75;
  Image image;
  GridFrame app;
  XMLTree tree;

    public FramedArea(GridFrame appg) {
        super();
	image = null;
	app = appg;
	DIMX = 4;
	DIMY = 4;

        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
		x = x / XSPACE;
		y = y / YSPACE;
		if (x > DIMX-1)
		  x = DIMX - 1;
		if (y > DIMY-1)
		  y = DIMY - 1;
		app.modList(x,y);
                if (e.getClickCount() == 2) {
                 if ((app.selCluster != null) && (app.selCluster.first_child != null) && (app.selCluster.first_child.first_child != null))
	           app.changeGridClusters(app.selCluster);
                }
            }
        });
    }

    public Dimension getMinimumSize() {
      return(new Dimension(XSPACE*DIMX, YSPACE*DIMY));
    }

    public Dimension getPreferredSize() {
      return(new Dimension(XSPACE*DIMX, YSPACE*DIMY));
    }

    public int b2i(byte b) {
      if (b < 0)
	return(256+b);
      else
	return(b);
    }

    public Image makeImage() {
      byte[] pix;
      int x,y,k;
      int nbslaves;
      int maxslaves;
      IndexColorModel cm;
      byte[] red;
      byte[] green;
      byte[] blue;
      int i;
      int prevnbslaves;
      double init,slope;
      XMLTree ag;
      String sdim;

      if (app.bigFather == null)
        return(null);
      setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
      sdim = app.bigFather.getAttVal("dimx");
      if (sdim != null)
        DIMX = (Integer.valueOf(sdim)).intValue();
      else
	DIMX = 4;
      sdim = app.bigFather.getAttVal("dimy");
      if (sdim != null)
        DIMY = (Integer.valueOf(sdim)).intValue();
      else
	DIMY = 4;
      XSPACE = 600 / DIMX;
      YSPACE = 300 / DIMY;
      pix = new byte[DIMX*XSPACE * DIMY*YSPACE];
      maxslaves = 0;
      for (x=0; x<DIMX; x++)
	for (y=0; y<DIMY; y++)
	  if ((ag=app.getAgNodeAt(x,y)) != null)
	    if ((nbslaves = ag.getLeavesCount()) > maxslaves)
	      maxslaves = nbslaves;

      // create the colormap
      red = new byte[256];
      green = new byte[256];
      blue = new byte[256];
      for (i=0; i<256; i++) {
	red[i] = (byte)(255*Math.exp(-((float)i-255.0)*((float)i-255.0)/25500.0));
	green[i] = (byte)(255*Math.exp(-((float)i-127.5)*((float)i-127.5)/25500.0));
	blue[i] = (byte)(255*Math.exp(-((float)i-2.55)*((float)i-2.55)/51000.0));
	//System.out.println("Color "+i+": r="+red[i]+", g="+green[i]+", b="+blue[i]);
      }
      cm = new IndexColorModel(8,256,red,green,blue);

      // make some horizontal lines
      for (y=0; y<DIMY; y++) {
	prevnbslaves = 0;
	for (x=0; x<=DIMX; x++) {
	  if (x == DIMX)
	    nbslaves = 0;
	  else {
	    if ((ag=app.getAgNodeAt(x,y)) == null)
	      nbslaves = 0;
	    else
	      nbslaves = ag.getLeavesCount();
	  }
	  init = 255.0*prevnbslaves/maxslaves;
	  slope = 255.0*(nbslaves-prevnbslaves)/maxslaves/XSPACE;
	  for (k=0; k<XSPACE; k++) {
	    if (((x!=0) || (k>=XSPACE/2)) && ((x != DIMX) || (k<XSPACE/2)))
	      pix[(x*XSPACE+k)-XSPACE/2 + ((y+1)*YSPACE-YSPACE/2) *DIMX*XSPACE] = (byte)(init+slope*k);
	  }
	  prevnbslaves = nbslaves;
	}
      }

      // make vertical lines
      for (x=0; x<DIMX*XSPACE; x++) {
	for (y=0; y<=DIMY; y++) {
	  if (y == 0)
	    init = 0;
	  else
	    init = b2i(pix[x + (y*YSPACE-YSPACE/2) *DIMX*XSPACE]);
	  if (y == DIMY)
	    slope = 1.0*(-init)/YSPACE;
	  else
	    slope = 1.0*(b2i(pix[x + ((y+1)*YSPACE-YSPACE/2) *DIMX*XSPACE])-init)/YSPACE;
	  for (k=0; k<YSPACE; k++) {
	    if (((y!=0) || (k>=YSPACE/2)) && ((y != DIMY) || (k<YSPACE/2)))
	      pix[x + (y*YSPACE+k-YSPACE/2) *DIMX*XSPACE] = (byte)(init+slope*k);
	  }
	}
      }

      setCursor(Cursor.getDefaultCursor());
      return(createImage(new MemoryImageSource(DIMX*XSPACE, DIMY*YSPACE, cm, pix, 0, DIMX*XSPACE)));
    }

    public void paint(Graphics g) {
      update(g);
    }
    
    public void update(Graphics g) {
      int x,y,i,j,k;
      String s;
      XMLTree ag;
      Font boldFont,plainFont;
      boolean hasorig;
      XMLTree node1, node2;
      String satt;
      FontMetrics met;
      int textsize;
      Graphics im_g;
      Image off_img;

      tree = app.gridTree;
      //System.out.println("paint has been called !");
      if (tree != null) {
	//System.out.println("..and grid was != null !");
	//Dimension d = getSize();
	//System.out.println("d.width="+d.width+", d.height="+d.height);

	if (image == null)
	  image = makeImage();
	int imageWidth = image.getWidth(this);
	int imageHeight = image.getHeight(this);
        
        off_img = createImage(DIMX*XSPACE, DIMY*YSPACE);
        im_g = off_img.getGraphics();
        im_g.setColor(Color.black);
        
        im_g.drawImage(image, 0, 0, this);

        im_g.drawRect(0, 0, imageWidth - 1, imageHeight - 1);
        
        if (app.selCluster != null) {
          x = Integer.decode(app.selCluster.getAttVal("x")).intValue();
          y = Integer.decode(app.selCluster.getAttVal("y")).intValue();
          im_g.drawRect(x*XSPACE+1, y*YSPACE+1, XSPACE-3, YSPACE-3);
        }

        if (DIMX <= 4)
          textsize = 14;
        else if (DIMX <= 6)
          textsize = 12;
        else if (DIMX <= 8)
          textsize = 10;
        else
          textsize = 9;
        
	boldFont = new Font("Helvetica", Font.BOLD, textsize);
	plainFont = new Font("Helvetica", Font.PLAIN, textsize);

	for (x=0; x<DIMX; x++)
	  for (y=0; y<DIMY; y++)
	    if ((ag=app.getAgNodeAt(x,y)) != null) {
	      s = ag.getAttVal("title");
//	      if ((s == null) || (s.equals("")) || (s.length()>18))
	      if ((s == null) || (s.equals("")))
		s = app.oneName(ag.getAttVal("centerURL"));
	      for (hasorig=false, node1=ag.first_child; !hasorig && (node1!= null); node1=node1.next_brother)
                if (node1.first_child != null) {
	          for (node2=node1.first_child; !hasorig && (node2!= null); node2=node2.next_brother)
		    if (((satt = node2.getAttVal("orig"))!= null) && (satt.equals("1")))
		      hasorig = true;
                } else if ((satt = node1.getAttVal("orig"))!= null)
		  hasorig = true;
	      if (hasorig)
		im_g.setFont(boldFont);
	      else
		im_g.setFont(plainFont);
              met = im_g.getFontMetrics();
              if (met.stringWidth(s) < XSPACE - 5)
	        im_g.drawString(s,
                  x*XSPACE + (XSPACE - met.stringWidth(s))/2,
                  y*YSPACE + (YSPACE + met.getHeight())/2);
              else {
                String s1 = "";
                for (i=0,j=0; (met.stringWidth(s1) < XSPACE - 5)&&(i < s.length()); i++) {
                  if (s.charAt(i) == ' ')
                    j = i;
                  s1 = s1 + s.charAt(i);
                }
                if (j != 0)
                  s1 = s.substring(0,j);
                else {
                  if (s1.length() > 3)
                    s1 = s1.substring(0, s1.length()-3) + "...";
                  else
                    s1 = s1 + "...";
                  while ((j < s.length()) && (s.charAt(j) != ' '))
                    j++;
                }
                String s2 = "";
                for (i=j+1,k=0; (met.stringWidth(s2) < XSPACE - 5)&&(i < s.length()); i++) {
                  if (s.charAt(i) == ' ')
                    k = i;
                  s2 = s2 + s.charAt(i);
                }
                if (i == s.length())
                  s2 = s.substring(j+1);
                else if (k > j+1)
                  s2 = s.substring(j+1,k) + "...";
                else if ((i > 3) && (i-3 > j+1))
                  s2 = s.substring(j+1,i-3) + "...";
                else
                  s2 = "";
                if (s2.equals(""))
	          im_g.drawString(s1,
                    x*XSPACE + (XSPACE - met.stringWidth(s1))/2,
                    y*YSPACE + (YSPACE + met.getHeight())/2);
                else {
	          im_g.drawString(s1,
                    x*XSPACE + (XSPACE - met.stringWidth(s1))/2,
                    y*YSPACE + YSPACE/2);
	          im_g.drawString(s2,
                    x*XSPACE + (XSPACE - met.stringWidth(s2))/2,
                    y*YSPACE + YSPACE/2 + met.getHeight() + 3);
                }
              }
	    } // if ((ag=app.getAgNodeAt(x,y)) != null)

        g.drawImage(off_img, 0, 0, this);
      } // if (tree != null)
    } // public void paint(Graphics g)
}

