/*
    Copyright (C) 2004  Damien Guillaume
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package dispgrid;

import java.awt.*;
import java.awt.event.*;

public class ErrorDialog extends Dialog implements ActionListener {
  Frame parent;
  TextArea ta;

  public ErrorDialog(Frame dw, String errormsg) {
    super(dw, "Error", true);
    parent = dw;
    
    setLayout(new FlowLayout());

    ta = new TextArea(errormsg,3,70,TextArea.SCROLLBARS_NONE);
    ta.setEditable(false);
    add(ta);
    
    Button bok = new Button("OK");
    bok.addActionListener(this);
    bok.setActionCommand("OK");
    add(bok);
    
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
	e.getWindow().setVisible(false);
      }
    });
    
    //Initialize this dialog to its preferred size.
    pack();

    Point pt = parent.getLocation();
    setLocation(pt.x+40,pt.y+40);
    setVisible(true);
  }
  
  public void newMessage(String errormsg) {
    ta.setText(errormsg);
    ta.invalidate();
    pack();
    setVisible(true);
  }
  
  public void actionPerformed(ActionEvent event) {
    String command = event.getActionCommand();
    
    if (command.equals("OK"))
      setVisible(false);
  }
}
