/*
    Copyright (C) 2004  Damien Guillaume
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* An applet only to display a clustering grid
	initial version for AML documents, Damien Guillaume, 26/5/98
	new version for random documents, Damien Guillaume, 15/4/2004
*/

package dispgrid;

import java.applet.Applet;


/**
 * An applet to display a clustering grid.<br>
 * This applet is using a "GRID" file as input:
 * an XML file describing the clusters and their nodes.<br>
 * Usage:  (the url parameter is optional)<br>
 * <code>&lt;applet code="dispgrid.DispGrid" archive="DispGrid.jar" width="100" height="100"&gt;<br>
 * &lt;param name="url" value="http://server_to_define/grid.xml"&gt;<br>
 * &lt;/applet&gt;</code>
 *
 * @version     3.0, 15/4/2004
 * @author      Damien Guillaume
 * @see         GridFrame
 * @see         clustering.Clustering
 */

public class DispGrid extends Applet {

  public void init() {
    String surl;
    GridFrame gf;
    
    gf = new GridFrame(this);
    gf.init();
    surl = getParameter("url");
    if (surl != null)
      gf.letsgo(surl);
  }

}
