/*
    Copyright (C) 2004  Damien Guillaume
    
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package clustering;

import java.lang.*;
import java.util.Vector;

/**
 * A class representing a document, for the clustering.
 */
public class Node {
  String url;
  String title;
  String ident; // supposed to be a unique identifier
  Vector prelinks; //Vector of Node: the links before the clustering
  Vector preroles; //Vector of String: associated link-roles
  Vector links; //Vector of Node (other nodes in the same agent, just pointers)
  Vector roles; // in myPartitioning, Vector of String, related to the links Vector
                // in noisingPartitioning, it's a vector of MyFloat (weights)
  boolean mark;
  Cluster master; // for noisingPartitioning
  boolean fake; // true if it's a keyword node (the balance difference is ignored in NoisingPartitioning)

  public Node(String u) {
    url = u;
    title = "";
    ident = "";
    prelinks = new Vector();
    preroles = new Vector();
    links = new Vector();
    roles = new Vector();
    mark = false;
    master = null;
    fake = false;
  }

  public synchronized void addPrelinkrole(Node n, String r) {
    prelinks.addElement(n);
    preroles.addElement(r);
  }
  
  public Node clone2() {// vectors are not cloned
    Node n2;
    
    n2 = new Node(url);
    n2.title = new String(title);
    n2.ident = new String(ident);
    // vectors are not cloned
    n2.mark = mark;
    n2.master = master;
    n2.fake = fake;
    return(n2);
  }
}
