/*
 * Decompiled with CFR 0.152.
 */
package dispgrid;

import dispgrid.ErrorDialog;
import dispgrid.FramedArea;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import xml.Attribute;
import xml.Parser_XML;
import xml.XMLTree;

public class GridFrame
extends Frame
implements ActionListener,
ItemListener {
    boolean inited = false;
    FramedArea framedArea;
    List lsel;
    TextField gridurl_field;
    XMLTree gridTree = null;
    XMLTree bigFather = null;
    XMLTree currentCluster = null;
    Button bopendoc;
    Button bzoomp;
    Button bzoomm;
    TextField find_field;
    XMLTree selCluster = null;
    XMLTree oldselag = null;
    Vector selnodes = null;
    ErrorDialog errdlg = null;
    Applet myappl = null;
    static final String DEFAULT_GRID = "http://server_to_define/folder/grid";

    public GridFrame(Applet appl) {
        super("Clustering");
        this.myappl = appl;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)e.getWindow()).setVisible(false);
                e.getWindow().dispose();
            }
        });
    }

    private void error(String s) {
        if (this.inited) {
            System.err.println(s);
            if (this.errdlg == null) {
                this.errdlg = new ErrorDialog((Frame)this, s);
            } else {
                this.errdlg.newMessage(s);
            }
        } else {
            System.err.println(s);
        }
    }

    public void init() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridBag);
        this.setFont(new Font("Helvetica", 0, 14));
        Panel cp = new Panel();
        GridBagLayout cpgridBag = new GridBagLayout();
        GridBagConstraints cpc = new GridBagConstraints();
        cp.setLayout(cpgridBag);
        Label lab = new Label("Grid URL:", 1);
        cpgridBag.setConstraints(lab, cpc);
        cp.add(lab);
        this.gridurl_field = new TextField(DEFAULT_GRID, 40);
        this.gridurl_field.addActionListener(this);
        cpc.gridwidth = 1;
        cpgridBag.setConstraints(this.gridurl_field, cpc);
        cp.add(this.gridurl_field);
        Button bok = new Button("Open");
        cpgridBag.setConstraints(bok, cpc);
        cp.add(bok);
        bok.setActionCommand("OK");
        bok.addActionListener(this);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        gridBag.setConstraints(cp, c);
        this.add(cp);
        this.framedArea = new FramedArea(this);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        gridBag.setConstraints(this.framedArea, c);
        this.add(this.framedArea);
        this.lsel = new List(6);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 1;
        gridBag.setConstraints(this.lsel, c);
        this.lsel.addItemListener(this);
        this.lsel.addActionListener(this);
        this.add(this.lsel);
        Panel cpz = new Panel();
        this.bopendoc = new Button("Open selection");
        this.bopendoc.setEnabled(false);
        cpz.add(this.bopendoc);
        this.bopendoc.setActionCommand("opendoc");
        this.bopendoc.addActionListener(this);
        this.bzoomp = new Button("Zoom+");
        this.bzoomp.setEnabled(false);
        cpz.add(this.bzoomp);
        this.bzoomp.setActionCommand("zoomp");
        this.bzoomp.addActionListener(this);
        this.bzoomm = new Button("Zoom-");
        this.bzoomm.setEnabled(false);
        cpz.add(this.bzoomm);
        this.bzoomm.setActionCommand("zoomm");
        this.bzoomm.addActionListener(this);
        lab = new Label("Find:", 1);
        cpz.add(lab);
        this.find_field = new TextField("", 20);
        this.find_field.addActionListener(this);
        cpz.add(this.find_field);
        gridBag.setConstraints(cpz, c);
        this.add(cpz);
        this.pack();
        this.check_myframe_position();
        this.show();
        this.inited = true;
    }

    public void check_myframe_position() {
        Insets is = this.getInsets();
        Point pt = this.getLocation();
        if (pt.x < is.left) {
            pt.x = is.left;
        }
        if (pt.y < is.top) {
            pt.y = is.top;
        }
        Toolkit tool = this.getToolkit();
        Dimension dds = tool.getScreenSize();
        Dimension ddf = this.getSize();
        if (pt.x + ddf.width > dds.width) {
            pt.x = dds.width - ddf.width;
        }
        if (pt.y + ddf.height > dds.height) {
            pt.y = dds.height - ddf.height + is.top;
        }
        ((Component)this).setLocation(pt.x, pt.y);
    }

    public XMLTree getAgNodeAt(int x, int y) {
        if (this.gridTree == null) {
            return null;
        }
        String sx = Integer.toString(x);
        String sy = Integer.toString(y);
        boolean trouv = false;
        XMLTree nodefound = null;
        XMLTree node = this.gridTree.first_child;
        while (!trouv && node != null) {
            if (node.attr != null) {
                Attribute attx = (Attribute)node.attr.elementAt(0);
                Attribute atty = (Attribute)node.attr.elementAt(1);
                if (attx.val.equals(sx) && atty.val.equals(sy)) {
                    trouv = true;
                    nodefound = node;
                }
            }
            node = node.next_brother;
        }
        return nodefound;
    }

    public String decodeURL(String s) {
        String res = "";
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '+') {
                res = res + ' ';
                continue;
            }
            if (s.charAt(i) == '%') {
                Integer c = Integer.valueOf(s.substring(i + 1, i + 3), 16);
                res = res + (char)c.intValue();
                i += 2;
                continue;
            }
            res = res + s.charAt(i);
        }
        return res;
    }

    public String oneName(String sURL) {
        int j;
        if (sURL == null) {
            return "";
        }
        int i = sURL.lastIndexOf(47);
        if (i == -1) {
            return this.decodeURL(sURL);
        }
        int k = sURL.indexOf(61);
        if (k != -1) {
            i = k;
            j = sURL.indexOf(38);
            if (j == -1) {
                j = sURL.length();
            }
        } else {
            j = sURL.lastIndexOf(46);
        }
        if (i < j) {
            return this.decodeURL(sURL.substring(i + 1, j));
        }
        return this.decodeURL(sURL.substring(i + 1));
    }

    public void addNodesToList(XMLTree ag) {
        XMLTree n = ag.first_child;
        while (n != null) {
            if (n.tag.equals("SLAVE") || n.tag.equals("NODE")) {
                if (n.attr != null) {
                    String title = n.getAttVal("title");
                    String orig = n.getAttVal("orig");
                    String sinfo = orig != null ? (orig.equals("1") ? " ***" : (orig.equals("2") ? " **" : (orig.equals("3") ? " *" : ""))) : "";
                    if (title != null && !title.equals("")) {
                        this.lsel.add(title + sinfo);
                    } else {
                        this.lsel.add(this.oneName(n.getAttVal("url")) + sinfo);
                    }
                    this.selnodes.addElement(n);
                }
            } else if (n.tag.equals("CLUSTER")) {
                this.addNodesToList(n);
            }
            n = n.next_brother;
        }
    }

    public void modList(int x, int y) {
        if (this.lsel.getItemCount() > 0) {
            this.lsel.removeAll();
        }
        this.selnodes = new Vector();
        XMLTree ag = this.getAgNodeAt(x, y);
        if (ag != null) {
            this.selCluster = ag;
            if (ag.first_child == null || !ag.first_child.tag.equals("CLUSTER")) {
                this.bzoomp.setEnabled(false);
            } else {
                this.bzoomp.setEnabled(true);
            }
            if (ag.father == null || !ag.father.tag.equals("CLUSTER")) {
                this.bzoomm.setEnabled(false);
            } else {
                this.bzoomm.setEnabled(true);
            }
            this.addNodesToList(ag);
        }
        this.currentCluster = ag;
        this.bopendoc.setEnabled(false);
        this.lsel.repaint();
        this.framedArea.repaint();
    }

    public void changeGridClusters(XMLTree tree) {
        this.bigFather = this.gridTree = tree;
        while (this.bigFather.father != null) {
            this.bigFather = this.bigFather.father;
        }
        this.framedArea.image = null;
        this.framedArea.repaint();
        if (this.oldselag == null || this.oldselag.father != tree) {
            this.oldselag = this.selCluster;
            this.selCluster = this.getAgNodeAt(0, 0);
            this.modList(0, 0);
        } else {
            int oldx = Integer.decode(this.oldselag.getAttVal("x"));
            int oldy = Integer.decode(this.oldselag.getAttVal("y"));
            this.oldselag = this.selCluster;
            this.modList(oldx, oldy);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void letsgo(String gridurl) {
        XMLTree thisTree = null;
        if (!gridurl.equals("")) {
            void var3_6;
            Parser_XML p;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.gridurl_field.setText(gridurl);
            thisTree = new XMLTree(null, "", null, "");
            System.out.println("Reading GRID file: " + gridurl);
            if (gridurl.startsWith("http://")) {
                URL theURL;
                try {
                    theURL = new URL(gridurl);
                }
                catch (Exception e) {
                    this.error("Error in creating the URL connection");
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                p = new Parser_XML(theURL, (OutputStream)System.out, thisTree);
            } else {
                if (gridurl.startsWith("file://")) {
                    gridurl = gridurl.substring(7);
                }
                try {
                    p = new Parser_XML(new FileInputStream(gridurl), (OutputStream)System.out, thisTree);
                }
                catch (Exception e) {
                    this.error("Error in reading the grid file " + gridurl);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
            }
            var3_6.parse(0);
            if (thisTree == null || !thisTree.tag.equals("GRID")) {
                this.error("error reading GRID file");
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.changeGridClusters(thisTree);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public XMLTree find_in(String s, XMLTree tree, int[] levels) {
        XMLTree best_n = null;
        int best_level = 100;
        String s_up = s.toUpperCase();
        XMLTree n = tree.first_child;
        while (n != null) {
            String title_up = n.getAttVal("title").toUpperCase();
            if (title_up.indexOf(s_up) != -1) {
                levels[1] = levels[0];
                return n;
            }
            n = n.next_brother;
        }
        n = tree.first_child;
        while (n != null) {
            int[] levels2 = new int[2];
            levels2[0] = levels[0] + 1;
            XMLTree n_found = this.find_in(s, n, levels2);
            if (n_found != null && levels2[1] < best_level) {
                best_level = levels2[1];
                best_n = n_found;
            }
            n = n.next_brother;
        }
        if (best_n != null) {
            levels[1] = best_level;
            return best_n;
        }
        return null;
    }

    public void find(String s) {
        if (this.bigFather == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int[] levels = new int[2];
        levels[0] = 0;
        XMLTree n_found = this.find_in(s, this.bigFather, levels);
        if (n_found != null) {
            if (n_found.first_child != null && n_found.first_child.first_child != null) {
                this.changeGridClusters(n_found);
            } else if (n_found.father != null && n_found.first_child != null) {
                this.changeGridClusters(n_found.father);
                if (n_found.father.father != null) {
                    this.oldselag = n_found.father;
                }
                this.modList(Integer.decode(n_found.getAttVal("x")), Integer.decode(n_found.getAttVal("y")));
            } else if (n_found.father != null && n_found.father.father != null) {
                this.changeGridClusters(n_found.father.father);
                if (n_found.father.father.father != null) {
                    this.oldselag = n_found.father.father;
                }
                this.modList(Integer.decode(n_found.father.getAttVal("x")), Integer.decode(n_found.father.getAttVal("y")));
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (event.getSource() == this.gridurl_field) {
            command = "OK";
        } else if (event.getSource() == this.find_field) {
            command = "find";
        } else if (event.getSource() == this.lsel) {
            command = "opendoc";
        }
        if (command.equals("OK")) {
            this.letsgo(this.gridurl_field.getText());
        } else if (command.equals("zoomp") && this.selCluster != null) {
            if (this.selCluster.first_child != null) {
                this.changeGridClusters(this.selCluster);
            }
        } else if (command.equals("zoomm") && this.selCluster != null) {
            if (this.selCluster.father != null) {
                this.changeGridClusters(this.selCluster.father.father);
            }
        } else if (command.equals("opendoc")) {
            XMLTree n;
            int i = this.lsel.getSelectedIndex();
            if (i != -1 && this.currentCluster != null && (n = (XMLTree)this.selnodes.elementAt(i)) != null) {
                String surl = n.getAttVal("url");
                if (this.myappl != null && surl != null) {
                    try {
                        URL durl = new URL(surl);
                        this.myappl.getAppletContext().showDocument(durl, "docwindow");
                    }
                    catch (MalformedURLException ex) {
                        this.error("MalformedURLException: " + ex.getMessage());
                    }
                }
            }
        } else if (command.equals("find")) {
            this.find(this.find_field.getText());
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.bopendoc.setEnabled(true);
        }
    }

    public static void main(String[] args) {
        String surl;
        GridFrame gf = new GridFrame(null);
        gf.init();
        if (args.length > 0 && (surl = args[0]) != null) {
            gf.letsgo(surl);
        }
    }
}

