/*
 * Decompiled with CFR 0.152.
 */
package dispgrid;

import dispgrid.GridFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import xml.XMLTree;

class FramedArea
extends Canvas {
    int DIMX;
    int DIMY;
    int XSPACE = 150;
    int YSPACE = 75;
    Image image = null;
    GridFrame app;
    XMLTree tree;

    public FramedArea(GridFrame appg) {
        this.app = appg;
        this.DIMX = 4;
        this.DIMY = 4;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                y /= FramedArea.this.YSPACE;
                if ((x /= FramedArea.this.XSPACE) > FramedArea.this.DIMX - 1) {
                    x = FramedArea.this.DIMX - 1;
                }
                if (y > FramedArea.this.DIMY - 1) {
                    y = FramedArea.this.DIMY - 1;
                }
                FramedArea.this.app.modList(x, y);
                if (e.getClickCount() == 2 && FramedArea.this.app.selCluster != null && FramedArea.this.app.selCluster.first_child != null && FramedArea.this.app.selCluster.first_child.first_child != null) {
                    FramedArea.this.app.changeGridClusters(FramedArea.this.app.selCluster);
                }
            }
        });
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.XSPACE * this.DIMX, this.YSPACE * this.DIMY);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.XSPACE * this.DIMX, this.YSPACE * this.DIMY);
    }

    public int b2i(byte b) {
        if (b < 0) {
            return 256 + b;
        }
        return b;
    }

    public Image makeImage() {
        int k;
        double slope;
        double init;
        int nbslaves;
        XMLTree ag;
        int y;
        int x;
        if (this.app.bigFather == null) {
            return null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String sdim = this.app.bigFather.getAttVal("dimx");
        this.DIMX = sdim != null ? Integer.valueOf(sdim) : 4;
        sdim = this.app.bigFather.getAttVal("dimy");
        this.DIMY = sdim != null ? Integer.valueOf(sdim) : 4;
        this.XSPACE = 600 / this.DIMX;
        this.YSPACE = 300 / this.DIMY;
        byte[] pix = new byte[this.DIMX * this.XSPACE * this.DIMY * this.YSPACE];
        int maxslaves = 0;
        for (x = 0; x < this.DIMX; ++x) {
            for (y = 0; y < this.DIMY; ++y) {
                ag = this.app.getAgNodeAt(x, y);
                if (ag == null || (nbslaves = ag.getLeavesCount()) <= maxslaves) continue;
                maxslaves = nbslaves;
            }
        }
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        for (int i = 0; i < 256; ++i) {
            red[i] = (byte)(255.0 * Math.exp(-((double)i - 255.0) * ((double)i - 255.0) / 25500.0));
            green[i] = (byte)(255.0 * Math.exp(-((double)i - 127.5) * ((double)i - 127.5) / 25500.0));
            blue[i] = (byte)(255.0 * Math.exp(-((double)i - 2.55) * ((double)i - 2.55) / 51000.0));
        }
        IndexColorModel cm = new IndexColorModel(8, 256, red, green, blue);
        for (y = 0; y < this.DIMY; ++y) {
            int prevnbslaves = 0;
            for (x = 0; x <= this.DIMX; ++x) {
                nbslaves = x == this.DIMX ? 0 : ((ag = this.app.getAgNodeAt(x, y)) == null ? 0 : ag.getLeavesCount());
                init = 255.0 * (double)prevnbslaves / (double)maxslaves;
                slope = 255.0 * (double)(nbslaves - prevnbslaves) / (double)maxslaves / (double)this.XSPACE;
                for (k = 0; k < this.XSPACE; ++k) {
                    if (x == 0 && k < this.XSPACE / 2 || x == this.DIMX && k >= this.XSPACE / 2) continue;
                    pix[x * this.XSPACE + k - this.XSPACE / 2 + ((y + 1) * this.YSPACE - this.YSPACE / 2) * this.DIMX * this.XSPACE] = (byte)(init + slope * (double)k);
                }
                prevnbslaves = nbslaves;
            }
        }
        for (x = 0; x < this.DIMX * this.XSPACE; ++x) {
            for (y = 0; y <= this.DIMY; ++y) {
                init = y == 0 ? 0.0 : (double)this.b2i(pix[x + (y * this.YSPACE - this.YSPACE / 2) * this.DIMX * this.XSPACE]);
                slope = y == this.DIMY ? 1.0 * -init / (double)this.YSPACE : 1.0 * ((double)this.b2i(pix[x + ((y + 1) * this.YSPACE - this.YSPACE / 2) * this.DIMX * this.XSPACE]) - init) / (double)this.YSPACE;
                for (k = 0; k < this.YSPACE; ++k) {
                    if (y == 0 && k < this.YSPACE / 2 || y == this.DIMY && k >= this.YSPACE / 2) continue;
                    pix[x + (y * this.YSPACE + k - this.YSPACE / 2) * this.DIMX * this.XSPACE] = (byte)(init + slope * (double)k);
                }
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        return this.createImage(new MemoryImageSource(this.DIMX * this.XSPACE, this.DIMY * this.YSPACE, (ColorModel)cm, pix, 0, this.DIMX * this.XSPACE));
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void update(Graphics g) {
        this.tree = this.app.gridTree;
        if (this.tree != null) {
            int y;
            int x;
            if (this.image == null) {
                this.image = this.makeImage();
            }
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            Image off_img = this.createImage(this.DIMX * this.XSPACE, this.DIMY * this.YSPACE);
            Graphics im_g = off_img.getGraphics();
            im_g.setColor(Color.black);
            im_g.drawImage(this.image, 0, 0, this);
            im_g.drawRect(0, 0, imageWidth - 1, imageHeight - 1);
            if (this.app.selCluster != null) {
                x = Integer.decode(this.app.selCluster.getAttVal("x"));
                y = Integer.decode(this.app.selCluster.getAttVal("y"));
                im_g.drawRect(x * this.XSPACE + 1, y * this.YSPACE + 1, this.XSPACE - 3, this.YSPACE - 3);
            }
            int textsize = this.DIMX <= 4 ? 14 : (this.DIMX <= 6 ? 12 : (this.DIMX <= 8 ? 10 : 9));
            Font boldFont = new Font("Helvetica", 1, textsize);
            Font plainFont = new Font("Helvetica", 0, textsize);
            for (x = 0; x < this.DIMX; ++x) {
                for (y = 0; y < this.DIMY; ++y) {
                    int i;
                    XMLTree ag = this.app.getAgNodeAt(x, y);
                    if (ag == null) continue;
                    String s = ag.getAttVal("title");
                    if (s == null || s.equals("")) {
                        s = this.app.oneName(ag.getAttVal("centerURL"));
                    }
                    boolean hasorig = false;
                    XMLTree node1 = ag.first_child;
                    while (!hasorig && node1 != null) {
                        String satt;
                        if (node1.first_child != null) {
                            XMLTree node2 = node1.first_child;
                            while (!hasorig && node2 != null) {
                                satt = node2.getAttVal("orig");
                                if (satt != null && satt.equals("1")) {
                                    hasorig = true;
                                }
                                node2 = node2.next_brother;
                            }
                        } else {
                            satt = node1.getAttVal("orig");
                            if (satt != null) {
                                hasorig = true;
                            }
                        }
                        node1 = node1.next_brother;
                    }
                    if (hasorig) {
                        im_g.setFont(boldFont);
                    } else {
                        im_g.setFont(plainFont);
                    }
                    FontMetrics met = im_g.getFontMetrics();
                    if (met.stringWidth(s) < this.XSPACE - 5) {
                        im_g.drawString(s, x * this.XSPACE + (this.XSPACE - met.stringWidth(s)) / 2, y * this.YSPACE + (this.YSPACE + met.getHeight()) / 2);
                        continue;
                    }
                    String s1 = "";
                    int j = 0;
                    for (i = 0; met.stringWidth(s1) < this.XSPACE - 5 && i < s.length(); ++i) {
                        if (s.charAt(i) == ' ') {
                            j = i;
                        }
                        s1 = s1 + s.charAt(i);
                    }
                    if (j != 0) {
                        s1 = s.substring(0, j);
                    } else {
                        s1 = s1.length() > 3 ? s1.substring(0, s1.length() - 3) + "..." : s1 + "...";
                        while (j < s.length() && s.charAt(j) != ' ') {
                            ++j;
                        }
                    }
                    String s2 = "";
                    int k = 0;
                    for (i = j + 1; met.stringWidth(s2) < this.XSPACE - 5 && i < s.length(); ++i) {
                        if (s.charAt(i) == ' ') {
                            k = i;
                        }
                        s2 = s2 + s.charAt(i);
                    }
                    s2 = i == s.length() ? s.substring(j + 1) : (k > j + 1 ? s.substring(j + 1, k) + "..." : (i > 3 && i - 3 > j + 1 ? s.substring(j + 1, i - 3) + "..." : ""));
                    if (s2.equals("")) {
                        im_g.drawString(s1, x * this.XSPACE + (this.XSPACE - met.stringWidth(s1)) / 2, y * this.YSPACE + (this.YSPACE + met.getHeight()) / 2);
                        continue;
                    }
                    im_g.drawString(s1, x * this.XSPACE + (this.XSPACE - met.stringWidth(s1)) / 2, y * this.YSPACE + this.YSPACE / 2);
                    im_g.drawString(s2, x * this.XSPACE + (this.XSPACE - met.stringWidth(s2)) / 2, y * this.YSPACE + this.YSPACE / 2 + met.getHeight() + 3);
                }
            }
            g.drawImage(off_img, 0, 0, this);
        }
    }
}

