/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.Cluster;
import clustering.Clustering;
import clustering.MyFloat;
import clustering.Node;
import java.util.Random;
import java.util.Vector;

public class NoisingPartitioning
extends Thread {
    final int MAX_ZOOM = 3;
    final int DIMX = 4;
    final int DIMY = 4;
    final int MAX_NB_AGENTS = 16;
    boolean use_keywords = false;
    boolean use_exchanges = false;
    Clustering clusframe;
    int init_method;
    Vector init_nodes;
    Cluster[] init_clusters;
    float init_alpha;
    Random rand = new Random();

    public NoisingPartitioning(Clustering clusframe, int init_method, Vector init_nodes, Cluster[] init_clusters, float init_alpha, boolean use_keywords) {
        this.clusframe = clusframe;
        this.init_method = init_method;
        this.init_nodes = init_nodes;
        this.init_clusters = init_clusters;
        this.init_alpha = init_alpha;
        this.use_keywords = use_keywords;
    }

    public void run() {
        if (this.init_method == 2) {
            this.noisingPartitioning(this.init_nodes, this.init_clusters, this.init_alpha);
        } else {
            this.recursPartitioning(this.init_nodes, this.init_clusters, null, 1, this.init_alpha);
        }
        this.clusframe.endClustering();
    }

    private int randomIntBetween(int a, int b) {
        return (int)((long)a + ((long)this.rand.nextInt() - Integer.MIN_VALUE) / (0xFFFFFFFFL / (long)(b - a + 1)));
    }

    private float randomFloatBetween(float a, float b) {
        return a + (float)((long)this.rand.nextInt() - Integer.MIN_VALUE) / (4.2949673E9f / (b - a + 1.0f));
    }

    private static float balance_cost(int nb, float moyna) {
        return ((float)nb - moyna) * ((float)nb - moyna) / moyna;
    }

    private float calc_moyna(Vector allNodes, int nb_clusters) {
        float moyna = 0.0f;
        for (int i = 0; i < allNodes.size(); ++i) {
            Node iNode = (Node)allNodes.elementAt(i);
            if (iNode.fake) continue;
            moyna += 1.0f;
        }
        return moyna / (float)nb_clusters;
    }

    private void descent(Vector allNodes, Cluster[] clusters, int nb_clusters, float alpha) {
        int i;
        int nb_loops_for_bug = 0;
        float change_best_score = 0.0f;
        float[] tdimbalance2 = new float[nb_clusters];
        double[] tdcutlinks2 = new double[100];
        float moyna = this.use_keywords ? this.calc_moyna(allNodes, nb_clusters) : (float)allNodes.size() / (float)nb_clusters;
        for (i = 0; i < nb_clusters; ++i) {
            tdimbalance2[i] = this.use_keywords ? NoisingPartitioning.balance_cost(clusters[i].nbreal + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nbreal, moyna) : NoisingPartitioning.balance_cost(clusters[i].nodes.size() + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nodes.size(), moyna);
        }
        boolean change = true;
        while (change) {
            float temp_score;
            int dy1;
            int dx1;
            float linkweight;
            float dcutlinks;
            float dimbalance;
            int k;
            int dy2;
            int dx2;
            Node lNode;
            int l;
            float best_score;
            int best_k;
            Node jNode;
            int j;
            float dimbalance1;
            Cluster ag;
            change = false;
            for (i = 0; i < allNodes.size(); ++i) {
                ((Node)allNodes.elementAt((int)i)).mark = false;
            }
            for (i = 0; i < nb_clusters; ++i) {
                ag = clusters[i];
                dimbalance1 = this.use_keywords ? NoisingPartitioning.balance_cost(ag.nbreal - 1, moyna) - NoisingPartitioning.balance_cost(ag.nbreal, moyna) : NoisingPartitioning.balance_cost(ag.nodes.size() - 1, moyna) - NoisingPartitioning.balance_cost(ag.nodes.size(), moyna);
                for (j = 0; j < ag.nodes.size(); ++j) {
                    Node mNode;
                    jNode = (Node)ag.nodes.elementAt(j);
                    best_k = -1;
                    best_score = 1000.0f;
                    if (jNode.links.size() > tdcutlinks2.length) {
                        tdcutlinks2 = new double[jNode.links.size()];
                    }
                    for (l = 0; l < jNode.links.size(); ++l) {
                        lNode = (Node)jNode.links.elementAt(l);
                        dx2 = ag.x - lNode.master.x;
                        dy2 = ag.y - lNode.master.y;
                        tdcutlinks2[l] = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                    }
                    for (k = 0; k < nb_clusters; ++k) {
                        float f;
                        if (k == i) continue;
                        dimbalance = jNode.fake ? 0.0f : dimbalance1;
                        if (!jNode.fake) {
                            dimbalance += tdimbalance2[k];
                        }
                        dcutlinks = 0.0f;
                        for (l = 0; l < jNode.links.size(); ++l) {
                            lNode = (Node)jNode.links.elementAt(l);
                            linkweight = ((MyFloat)jNode.roles.elementAt((int)l)).val;
                            dx1 = lNode.master.x - clusters[k].x;
                            dy1 = lNode.master.y - clusters[k].y;
                            dcutlinks = (float)((double)dcutlinks + (double)linkweight * (Math.sqrt(dx1 * dx1 + dy1 * dy1) - tdcutlinks2[l]));
                        }
                        temp_score = dimbalance + alpha * dcutlinks;
                        if (!(f < best_score)) continue;
                        best_score = temp_score;
                        best_k = k;
                    }
                    if ((double)best_score < -1.0E-5) {
                        jNode.master = clusters[best_k];
                        clusters[best_k].nodes.addElement(jNode);
                        ag.nodes.removeElementAt(j);
                        if (!jNode.fake) {
                            ++clusters[best_k].nbreal;
                            --ag.nbreal;
                            dimbalance1 = this.use_keywords ? NoisingPartitioning.balance_cost(ag.nbreal - 1, moyna) - NoisingPartitioning.balance_cost(ag.nbreal, moyna) : NoisingPartitioning.balance_cost(ag.nodes.size() - 1, moyna) - NoisingPartitioning.balance_cost(ag.nodes.size(), moyna);
                            tdimbalance2[i] = this.use_keywords ? NoisingPartitioning.balance_cost(clusters[i].nbreal + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nbreal, moyna) : NoisingPartitioning.balance_cost(clusters[i].nodes.size() + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nodes.size(), moyna);
                            tdimbalance2[best_k] = this.use_keywords ? NoisingPartitioning.balance_cost(clusters[best_k].nbreal + 1, moyna) - NoisingPartitioning.balance_cost(clusters[best_k].nbreal, moyna) : NoisingPartitioning.balance_cost(clusters[best_k].nodes.size() + 1, moyna) - NoisingPartitioning.balance_cost(clusters[best_k].nodes.size(), moyna);
                        }
                        for (l = 0; l < jNode.links.size(); ++l) {
                            lNode = (Node)jNode.links.elementAt(l);
                            linkweight = ((MyFloat)jNode.roles.elementAt((int)l)).val;
                            if (lNode.master.y >= ag.y && (lNode.master.y != ag.y || lNode.master.x >= ag.x) || jNode.master == lNode.master || !((double)linkweight > (double)(lNode.links.size() - 1) / 20.0)) continue;
                            lNode.mark = true;
                        }
                        --j;
                        change = true;
                        change_best_score = best_score;
                        continue;
                    }
                    if (!this.use_exchanges || best_k == -1) continue;
                    k = best_k;
                    best_score = 0.0f;
                    int best_m = -1;
                    for (int m = 0; m < clusters[k].nodes.size(); ++m) {
                        float f;
                        mNode = (Node)clusters[k].nodes.elementAt(m);
                        if (mNode.fake != jNode.fake) continue;
                        dcutlinks = 0.0f;
                        for (l = 0; l < jNode.links.size(); ++l) {
                            lNode = (Node)jNode.links.elementAt(l);
                            if (lNode == mNode) continue;
                            linkweight = ((MyFloat)jNode.roles.elementAt((int)l)).val;
                            dx1 = lNode.master.x - clusters[k].x;
                            dy1 = lNode.master.y - clusters[k].y;
                            dcutlinks = (float)((double)dcutlinks + (double)linkweight * (Math.sqrt(dx1 * dx1 + dy1 * dy1) - tdcutlinks2[l]));
                        }
                        for (l = 0; l < mNode.links.size(); ++l) {
                            lNode = (Node)mNode.links.elementAt(l);
                            if (lNode == jNode) continue;
                            linkweight = ((MyFloat)mNode.roles.elementAt((int)l)).val;
                            dx1 = lNode.master.x - ag.x;
                            dy1 = lNode.master.y - ag.y;
                            dx2 = clusters[k].x - lNode.master.x;
                            dy2 = clusters[k].y - lNode.master.y;
                            dcutlinks = (float)((double)dcutlinks + (double)linkweight * (Math.sqrt(dx1 * dx1 + dy1 * dy1) - Math.sqrt(dx2 * dx2 + dy2 * dy2)));
                        }
                        temp_score = dcutlinks;
                        if (!(f < best_score)) continue;
                        best_score = temp_score;
                        best_m = m;
                    }
                    if (!((double)best_score < -1.0E-5)) continue;
                    mNode = (Node)clusters[best_k].nodes.elementAt(best_m);
                    ag.nodes.removeElementAt(j);
                    clusters[best_k].nodes.removeElementAt(best_m);
                    jNode.master = clusters[best_k];
                    clusters[best_k].nodes.insertElementAt(jNode, best_m);
                    mNode.master = ag;
                    ag.nodes.insertElementAt(mNode, j);
                    for (l = 0; l < jNode.links.size(); ++l) {
                        lNode = (Node)jNode.links.elementAt(l);
                        linkweight = ((MyFloat)jNode.roles.elementAt((int)l)).val;
                        if (lNode.master.y >= ag.y && (lNode.master.y != ag.y || lNode.master.x >= ag.x) || jNode.master == lNode.master || !((double)linkweight > (double)(lNode.links.size() - 1) / 20.0)) continue;
                        lNode.mark = true;
                    }
                    for (l = 0; l < mNode.links.size(); ++l) {
                        lNode = (Node)mNode.links.elementAt(l);
                        linkweight = ((MyFloat)mNode.roles.elementAt((int)l)).val;
                        if (lNode.master.y >= ag.y && (lNode.master.y != ag.y || lNode.master.x >= ag.x) || mNode.master == lNode.master || !((double)linkweight > (double)(lNode.links.size() - 1) / 20.0)) continue;
                        lNode.mark = true;
                    }
                    change = true;
                    change_best_score = best_score;
                }
            }
            if (change) {
                for (i = 0; i < nb_clusters; ++i) {
                    ag = clusters[i];
                    dimbalance1 = this.use_keywords ? NoisingPartitioning.balance_cost(ag.nbreal - 1, moyna) - NoisingPartitioning.balance_cost(ag.nbreal, moyna) : NoisingPartitioning.balance_cost(ag.nodes.size() - 1, moyna) - NoisingPartitioning.balance_cost(ag.nodes.size(), moyna);
                    for (j = 0; j < ag.nodes.size(); ++j) {
                        if (!((Node)ag.nodes.elementAt((int)j)).mark) continue;
                        jNode = (Node)ag.nodes.elementAt(j);
                        best_k = -1;
                        best_score = 0.0f;
                        if (jNode.links.size() > tdcutlinks2.length) {
                            tdcutlinks2 = new double[jNode.links.size()];
                        }
                        for (l = 0; l < jNode.links.size(); ++l) {
                            lNode = (Node)jNode.links.elementAt(l);
                            dx2 = ag.x - lNode.master.x;
                            dy2 = ag.y - lNode.master.y;
                            tdcutlinks2[l] = Math.sqrt(dx2 * dx2 + dy2 * dy2);
                        }
                        for (k = 0; k < nb_clusters; ++k) {
                            float f;
                            if (k == i) continue;
                            dimbalance = jNode.fake ? 0.0f : dimbalance1;
                            if (!jNode.fake) {
                                dimbalance += tdimbalance2[k];
                            }
                            dcutlinks = 0.0f;
                            for (l = 0; l < jNode.links.size(); ++l) {
                                lNode = (Node)jNode.links.elementAt(l);
                                linkweight = ((MyFloat)jNode.roles.elementAt((int)l)).val;
                                dx1 = lNode.master.x - clusters[k].x;
                                dy1 = lNode.master.y - clusters[k].y;
                                dcutlinks = (float)((double)dcutlinks + (double)linkweight * (Math.sqrt(dx1 * dx1 + dy1 * dy1) - tdcutlinks2[l]));
                            }
                            temp_score = dimbalance + alpha * dcutlinks;
                            if (!(f < best_score)) continue;
                            best_score = temp_score;
                            best_k = k;
                        }
                        if (!((double)best_score < -1.0E-5)) continue;
                        jNode.master = clusters[best_k];
                        clusters[best_k].nodes.addElement(jNode);
                        ag.nodes.removeElementAt(j);
                        if (!jNode.fake) {
                            ++clusters[best_k].nbreal;
                            --ag.nbreal;
                            dimbalance1 = this.use_keywords ? NoisingPartitioning.balance_cost(ag.nbreal - 1, moyna) - NoisingPartitioning.balance_cost(ag.nbreal, moyna) : NoisingPartitioning.balance_cost(ag.nodes.size() - 1, moyna) - NoisingPartitioning.balance_cost(ag.nodes.size(), moyna);
                            tdimbalance2[i] = this.use_keywords ? NoisingPartitioning.balance_cost(clusters[i].nbreal + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nbreal, moyna) : NoisingPartitioning.balance_cost(clusters[i].nodes.size() + 1, moyna) - NoisingPartitioning.balance_cost(clusters[i].nodes.size(), moyna);
                            tdimbalance2[best_k] = this.use_keywords ? NoisingPartitioning.balance_cost(clusters[best_k].nbreal + 1, moyna) - NoisingPartitioning.balance_cost(clusters[best_k].nbreal, moyna) : NoisingPartitioning.balance_cost(clusters[best_k].nodes.size() + 1, moyna) - NoisingPartitioning.balance_cost(clusters[best_k].nodes.size(), moyna);
                        }
                        --j;
                        change = true;
                        change_best_score = best_score;
                    }
                }
            }
            if (++nb_loops_for_bug <= 5000) continue;
            System.err.println("Too many loops in descent... is there a bug ?");
            System.err.println("best_score was: " + change_best_score);
            change = false;
        }
    }

    private float eval_cost(Vector allNodes, Cluster[] clusters, int nb_clusters, float alpha) {
        int i;
        float dimbalance;
        float moyna;
        if (this.use_keywords) {
            moyna = this.calc_moyna(allNodes, nb_clusters);
            dimbalance = 0.0f;
            for (i = 0; i < nb_clusters; ++i) {
                dimbalance += NoisingPartitioning.balance_cost(clusters[i].nbreal, moyna);
            }
        } else {
            moyna = (float)allNodes.size() / (float)nb_clusters;
            dimbalance = 0.0f;
            for (i = 0; i < nb_clusters; ++i) {
                dimbalance += NoisingPartitioning.balance_cost(clusters[i].nodes.size(), moyna);
            }
        }
        float dcutlinks = 0.0f;
        for (i = 0; i < allNodes.size(); ++i) {
            ((Node)allNodes.elementAt((int)i)).mark = false;
        }
        for (i = 0; i < allNodes.size(); ++i) {
            Node iNode = (Node)allNodes.elementAt(i);
            for (int j = 0; j < iNode.links.size(); ++j) {
                Node jNode = (Node)iNode.links.elementAt(j);
                if (jNode.mark || iNode.master == jNode.master) continue;
                float agdist = (float)Math.sqrt(Math.pow(iNode.master.x - jNode.master.x, 2.0) + Math.pow(iNode.master.y - jNode.master.y, 2.0));
                dcutlinks += ((MyFloat)iNode.roles.elementAt((int)j)).val * agdist;
            }
            iNode.mark = true;
        }
        return dimbalance + alpha * dcutlinks;
    }

    public void noisingPartitioning(Vector allNodes, Cluster[] clusters, float init_alpha) {
        Vector vr;
        int k;
        int ind;
        Node jNode;
        int j;
        Node iNode;
        int i;
        float MAX_RATE = 5.0f;
        float MIN_RATE = 1.1f;
        int MAX_ITER = 100;
        int STOP_COUNT = 15;
        float ALPHA = init_alpha != 0.0f ? init_alpha : (this.use_keywords ? 0.17f : 0.2f);
        System.out.println("noising partioning");
        int nb_clusters = 16;
        if (allNodes.size() < nb_clusters) {
            System.err.println("allNodes.size() < nb_clusters !!!");
            return;
        }
        for (i = 0; i < allNodes.size(); ++i) {
            iNode = (Node)allNodes.elementAt(i);
            for (j = 0; j < iNode.links.size(); ++j) {
                jNode = (Node)iNode.links.elementAt(j);
                if (jNode == null) {
                    System.err.println("Null link !!!");
                    iNode.links.removeElementAt(j);
                    --j;
                    continue;
                }
                if (allNodes.contains(jNode)) continue;
                System.err.println("Node " + jNode.ident + " not in allNodes!!!");
                iNode.links.removeElementAt(j);
                --j;
            }
        }
        System.out.println("creating clusters and place them randomly on the map");
        for (i = 0; i < allNodes.size(); ++i) {
            ((Node)allNodes.elementAt((int)i)).mark = false;
        }
        for (i = 0; i < nb_clusters; ++i) {
            ind = this.randomIntBetween(0, allNodes.size() - 1);
            while (((Node)allNodes.elementAt((int)ind)).mark) {
                ind = this.randomIntBetween(0, allNodes.size() - 1);
            }
            clusters[i] = new Cluster((Node)allNodes.elementAt(ind));
            clusters[i].x = Math.round(((float)i / 4.0f - (float)(i / 4)) * 4.0f);
            clusters[i].y = Math.round(i / 4);
        }
        System.out.println("linking randomly nodes and clusters");
        for (i = 0; i < allNodes.size(); ++i) {
            iNode = (Node)allNodes.elementAt(i);
            if (iNode.mark) continue;
            ind = this.randomIntBetween(0, nb_clusters - 1);
            iNode.mark = true;
            iNode.master = clusters[ind];
            clusters[ind].nodes.addElement(iNode);
        }
        if (this.use_keywords) {
            for (i = 0; i < nb_clusters; ++i) {
                clusters[i].calc_nbreal();
            }
        }
        System.out.println("checking links symetry");
        for (i = 0; i < allNodes.size(); ++i) {
            iNode = (Node)allNodes.elementAt(i);
            for (j = 0; j < iNode.links.size(); ++j) {
                jNode = (Node)iNode.links.elementAt(j);
                if (jNode == null) {
                    System.err.println("Null link !!!");
                    iNode.links.removeElementAt(j);
                    --j;
                    continue;
                }
                k = jNode.links.indexOf(iNode);
                if (k == -1) {
                    jNode.links.addElement(iNode);
                    jNode.roles.addElement(new MyFloat(((MyFloat)iNode.roles.elementAt((int)j)).val));
                    continue;
                }
                if (((MyFloat)iNode.roles.elementAt((int)j)).val == ((MyFloat)jNode.roles.elementAt((int)k)).val) continue;
                System.err.println("Links with different weight between " + jNode.ident + " and " + iNode.ident + " ...changing the weight...");
                ((MyFloat)jNode.roles.elementAt((int)k)).val = ((MyFloat)iNode.roles.elementAt((int)j)).val;
            }
        }
        System.out.println("checking links unicity");
        for (i = 0; i < allNodes.size(); ++i) {
            iNode = (Node)allNodes.elementAt(i);
            for (j = 0; j < iNode.links.size(); ++j) {
                jNode = (Node)iNode.links.elementAt(j);
                for (k = j + 1; k < iNode.links.size(); ++k) {
                    if (jNode != (Node)iNode.links.elementAt(k)) continue;
                    System.err.println("Link duplicated from " + iNode.ident + " to " + jNode.ident + " ...deleting one...");
                    iNode.links.removeElementAt(k);
                    iNode.roles.removeElementAt(k);
                    --k;
                }
            }
        }
        System.out.println("creating original data save");
        Vector[] orig_weights = new Vector[allNodes.size()];
        for (i = 0; i < allNodes.size(); ++i) {
            vr = ((Node)allNodes.elementAt((int)i)).roles;
            orig_weights[i] = new Vector();
            for (j = 0; j < vr.size(); ++j) {
                orig_weights[i].addElement(new MyFloat(((MyFloat)vr.elementAt((int)j)).val));
            }
        }
        float rate = MAX_RATE;
        float drate = (MAX_RATE - MIN_RATE) / (float)MAX_ITER;
        int counter = 0;
        this.descent(allNodes, clusters, nb_clusters, ALPHA);
        System.out.println("record the best solution");
        Cluster[] best_clusters = new Cluster[nb_clusters];
        for (i = 0; i < nb_clusters; ++i) {
            best_clusters[i] = new Cluster();
            best_clusters[i].centerURL = new String(clusters[i].centerURL);
            best_clusters[i].title = new String(clusters[i].title);
            best_clusters[i].nodes = (Vector)clusters[i].nodes.clone();
            best_clusters[i].nbreal = clusters[i].nbreal;
        }
        float best_cost = this.eval_cost(allNodes, clusters, nb_clusters, ALPHA);
        System.out.println("Current cost: " + best_cost);
        this.clusframe.progress("Current cost: " + best_cost);
        while (counter < STOP_COUNT && rate >= MIN_RATE) {
            for (i = 0; i < allNodes.size(); ++i) {
                ((Node)allNodes.elementAt((int)i)).mark = false;
            }
            for (i = 0; i < allNodes.size(); ++i) {
                iNode = (Node)allNodes.elementAt(i);
                vr = iNode.roles;
                for (j = 0; j < vr.size(); ++j) {
                    jNode = (Node)iNode.links.elementAt(j);
                    if (jNode.mark) continue;
                    float z = this.randomFloatBetween(1.0f, rate);
                    if (this.randomIntBetween(0, 1) == 0) {
                        z = 1.0f / z;
                    }
                    ((MyFloat)vr.elementAt((int)j)).val *= z;
                    k = jNode.links.indexOf(iNode);
                    if (k == -1) {
                        System.err.println("No link from " + jNode.url + " to " + iNode.url + ", but one in the other direction !!!");
                        return;
                    }
                    ((MyFloat)jNode.roles.elementAt((int)k)).val = ((MyFloat)vr.elementAt((int)j)).val;
                }
                iNode.mark = true;
            }
            if ((float)(counter / 2) == (float)counter / 2.0f) {
                for (i = 0; i < nb_clusters; ++i) {
                    clusters[i].centerURL = new String(best_clusters[i].centerURL);
                    clusters[i].title = new String(best_clusters[i].title);
                    clusters[i].nodes = (Vector)best_clusters[i].nodes.clone();
                    clusters[i].nbreal = best_clusters[i].nbreal;
                    for (j = 0; j < clusters[i].nodes.size(); ++j) {
                        ((Node)clusters[i].nodes.elementAt((int)j)).master = clusters[i];
                    }
                }
                this.descent(allNodes, clusters, nb_clusters, ALPHA);
            } else {
                this.descent(allNodes, clusters, nb_clusters, ALPHA);
            }
            for (i = 0; i < allNodes.size(); ++i) {
                vr = ((Node)allNodes.elementAt((int)i)).roles;
                for (j = 0; j < vr.size(); ++j) {
                    ((MyFloat)vr.elementAt((int)j)).val = ((MyFloat)orig_weights[i].elementAt((int)j)).val;
                }
            }
            this.descent(allNodes, clusters, nb_clusters, ALPHA);
            float current_cost = this.eval_cost(allNodes, clusters, nb_clusters, ALPHA);
            System.out.println("Current cost: " + current_cost);
            this.clusframe.progress("Current cost: " + current_cost);
            if (current_cost < best_cost) {
                System.out.println("This is an improvement !");
                best_cost = current_cost;
                for (i = 0; i < nb_clusters; ++i) {
                    best_clusters[i].centerURL = new String(clusters[i].centerURL);
                    best_clusters[i].title = new String(clusters[i].title);
                    best_clusters[i].nodes = (Vector)clusters[i].nodes.clone();
                    best_clusters[i].nbreal = clusters[i].nbreal;
                }
                counter = 0;
            } else {
                ++counter;
            }
            rate -= drate;
        }
        for (i = 0; i < nb_clusters; ++i) {
            clusters[i].centerURL = new String(best_clusters[i].centerURL);
            clusters[i].title = new String(best_clusters[i].title);
            clusters[i].nodes = (Vector)best_clusters[i].nodes.clone();
            clusters[i].nbreal = best_clusters[i].nbreal;
            for (j = 0; j < clusters[i].nodes.size(); ++j) {
                ((Node)clusters[i].nodes.elementAt((int)j)).master = clusters[i];
            }
        }
        System.out.println("Best cost: " + best_cost);
        this.clusframe.progress("Best cost: " + best_cost);
        System.out.println("");
        for (i = 0; i < allNodes.size(); ++i) {
            iNode = (Node)allNodes.elementAt(i);
            for (j = 0; j < iNode.links.size(); ++j) {
                jNode = (Node)iNode.links.elementAt(j);
                if (jNode.fake || iNode.fake || iNode.master == jNode.master) continue;
                iNode.links.removeElementAt(j);
                iNode.roles.removeElementAt(j);
                --j;
            }
        }
    }

    public void recursPartitioning(Vector nodes, Cluster[] clusters, Cluster[] precclusters, int zoom, float init_alpha) {
        int i;
        this.noisingPartitioning(nodes, clusters, init_alpha);
        for (i = 0; i < clusters.length; ++i) {
            clusters[i].precClusters = precclusters;
        }
        if (zoom < 3) {
            for (i = 0; i < clusters.length; ++i) {
                int j;
                Vector selectedNodes = new Vector();
                int nbreal = 0;
                for (j = 0; j < nodes.size(); ++j) {
                    if (((Node)nodes.elementAt((int)j)).master != clusters[i] || ((Node)nodes.elementAt((int)j)).fake) continue;
                    ++nbreal;
                    selectedNodes.addElement(nodes.elementAt(j));
                }
                if (nbreal <= 16) continue;
                if (this.use_keywords) {
                    for (j = 0; j < nodes.size(); ++j) {
                        int l;
                        Node kNode;
                        int k;
                        Node newNode;
                        Node jNode = (Node)nodes.elementAt(j);
                        if (jNode.fake && jNode.master == clusters[i]) {
                            newNode = jNode.clone2();
                            for (k = 0; k < jNode.links.size(); ++k) {
                                kNode = (Node)jNode.links.elementAt(k);
                                if (kNode.master != clusters[i]) continue;
                                newNode.links.addElement(kNode);
                                newNode.roles.addElement(jNode.roles.elementAt(k));
                                for (l = 0; l < kNode.links.size(); ++l) {
                                    if ((Node)kNode.links.elementAt(l) != jNode) continue;
                                    kNode.links.setElementAt(newNode, l);
                                }
                                jNode.links.removeElementAt(k);
                                jNode.roles.removeElementAt(k);
                                --k;
                            }
                            selectedNodes.addElement(newNode);
                            continue;
                        }
                        if (!jNode.fake || jNode.master == clusters[i]) continue;
                        boolean haslink = false;
                        for (k = 0; !haslink && k < jNode.links.size(); ++k) {
                            if (((Node)jNode.links.elementAt((int)k)).master != clusters[i]) continue;
                            haslink = true;
                        }
                        if (!haslink) continue;
                        newNode = jNode.clone2();
                        newNode.master = clusters[i];
                        for (k = 0; k < jNode.links.size(); ++k) {
                            kNode = (Node)jNode.links.elementAt(k);
                            if (kNode.master != clusters[i]) continue;
                            newNode.links.addElement(kNode);
                            newNode.roles.addElement(jNode.roles.elementAt(k));
                            for (l = 0; l < kNode.links.size(); ++l) {
                                if ((Node)kNode.links.elementAt(l) != jNode) continue;
                                kNode.links.setElementAt(newNode, l);
                            }
                            jNode.links.removeElementAt(k);
                            jNode.roles.removeElementAt(k);
                            --k;
                        }
                        selectedNodes.addElement(newNode);
                    }
                }
                clusters[i].subClusters = new Cluster[16];
                this.recursPartitioning(selectedNodes, clusters[i].subClusters, clusters, zoom + 1, init_alpha);
            }
        }
    }
}

