/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.Cluster;
import clustering.Node;
import clustering.ResiField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import xml.Parser_XML;
import xml.XMLTree;

public class GetNodes {
    int tmpi;
    int tmpj;
    boolean use_keywords;
    Vector terms;
    Vector term_nodes;
    Vector tkwds;
    Vector tkptr;

    private void error(String s) {
        System.err.println(s);
    }

    private void nvsegment(Vector v, int g, int d) {
        String p = ((Node)v.elementAt((int)((g + d) / 2))).url;
        this.tmpi = g;
        this.tmpj = d;
        while (this.tmpi <= this.tmpj) {
            while (((Node)v.elementAt((int)this.tmpi)).url.compareTo(p) < 0) {
                ++this.tmpi;
            }
            while (((Node)v.elementAt((int)this.tmpj)).url.compareTo(p) > 0) {
                --this.tmpj;
            }
            if (this.tmpi > this.tmpj) continue;
            Node n = (Node)v.elementAt(this.tmpi);
            v.setElementAt((Node)v.elementAt(this.tmpj), this.tmpi);
            v.setElementAt(n, this.tmpj);
            ++this.tmpi;
            --this.tmpj;
        }
    }

    private void nvquick2(Vector v, int m, int n) {
        if (m < n) {
            this.nvsegment(v, m, n);
            int i = this.tmpi;
            int j = this.tmpj;
            this.nvquick2(v, m, j);
            this.nvquick2(v, i, n);
        }
    }

    private void nvquicksort(Vector v) {
        this.nvquick2(v, 0, v.size() - 1);
    }

    private ResiField iFieldUni(Vector v, String s) {
        int r;
        int a = 0;
        int b = v.size() - 1;
        ResiField res = new ResiField();
        if (b == -1) {
            res.ind = 0;
            res.found = false;
            return res;
        }
        while (a + 1 < b) {
            int m = (a + b) / 2;
            r = ((Node)v.elementAt((int)m)).ident.compareTo(s);
            if (r < 0) {
                a = m;
                continue;
            }
            if (r > 0) {
                b = m;
                continue;
            }
            res.ind = m;
            res.found = true;
            return res;
        }
        r = ((Node)v.elementAt((int)a)).ident.compareTo(s);
        if (r == 0) {
            res.ind = a;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = a;
            res.found = false;
            return res;
        }
        r = ((Node)v.elementAt((int)b)).ident.compareTo(s);
        if (r == 0) {
            res.ind = b;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = b;
            res.found = false;
            return res;
        }
        res.ind = b + 1;
        res.found = false;
        return res;
    }

    private ResiField iVString(Vector v, String s) {
        int r;
        int a = 0;
        int b = v.size() - 1;
        ResiField res = new ResiField();
        if (b == -1) {
            res.ind = 0;
            res.found = false;
            return res;
        }
        while (a + 1 < b) {
            int m = (a + b) / 2;
            r = ((String)v.elementAt(m)).compareTo(s);
            if (r < 0) {
                a = m;
                continue;
            }
            if (r > 0) {
                b = m;
                continue;
            }
            res.ind = m;
            res.found = true;
            return res;
        }
        r = ((String)v.elementAt(a)).compareTo(s);
        if (r == 0) {
            res.ind = a;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = a;
            res.found = false;
            return res;
        }
        r = ((String)v.elementAt(b)).compareTo(s);
        if (r == 0) {
            res.ind = b;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = b;
            res.found = false;
            return res;
        }
        res.ind = b + 1;
        res.found = false;
        return res;
    }

    public synchronized void addTermNode(String term, Node node) {
        int noterm = -1;
        term = term.toUpperCase();
        ResiField res = this.iVString(this.terms, term);
        noterm = res.ind;
        if (res.found) {
            Vector vnodes = (Vector)this.term_nodes.elementAt(noterm);
            boolean found = false;
            for (int i = 0; i < vnodes.size() && !found; ++i) {
                if (node != (Node)vnodes.elementAt(i)) continue;
                found = true;
            }
            if (!found) {
                vnodes.addElement(node);
            }
        } else {
            this.terms.insertElementAt(term, noterm);
            Vector<Node> vnodes = new Vector<Node>();
            vnodes.addElement(node);
            this.term_nodes.insertElementAt(vnodes, noterm);
        }
        res = this.iVString(this.tkwds, term);
        if (!res.found) {
            this.tkwds.insertElementAt(term, res.ind);
            this.tkptr.insertElementAt(term, res.ind);
        }
    }

    public synchronized void addOtherTerms(String s, Node node) {
        String s_up = s.toUpperCase();
        for (int i = 0; i < this.tkwds.size(); ++i) {
            String term = (String)this.tkwds.elementAt(i);
            int ind = s_up.indexOf(term);
            if (ind == -1 || ind != 0 && Character.isLetter(s.charAt(ind - 1)) || ind + term.length() != s.length() && Character.isLetter(s.charAt(ind + term.length()))) continue;
            this.addTermNode(term, node);
        }
    }

    public synchronized void clusWait() {
        try {
            this.wait(400L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void getAllNodesFromDoclist(Vector allNodes, File doclistFile) {
        XMLTree xmltree = new XMLTree(null, "", null, "");
        FileInputStream is = null;
        try {
            is = new FileInputStream(doclistFile);
        }
        catch (FileNotFoundException ex) {
            this.error("FileNotFoundException: " + ex.getMessage());
            return;
        }
        Parser_XML p = new Parser_XML(is, (OutputStream)System.out, xmltree);
        p.parse(0);
        if (xmltree == null || !xmltree.tag.equals("DOCLIST")) {
            this.error("error reading DOCLIST file " + doclistFile.getPath());
            return;
        }
        Hashtable<Node, XMLTree> doctrees = new Hashtable<Node, XMLTree>();
        Hashtable<String, String> idurls = new Hashtable<String, String>();
        XMLTree doctree = xmltree.first_child;
        while (doctree != null) {
            XMLTree kwdTree;
            XMLTree fileNode;
            String docid = doctree.getAttVal("id");
            XMLTree titleNode = doctree.getNode("TITLE");
            String title = null;
            if (titleNode != null) {
                title = titleNode.val;
            }
            XMLTree urlNode = doctree.getNode("URL");
            String url = null;
            if (urlNode != null) {
                url = urlNode.val;
            }
            if ((fileNode = doctree.getNode("FILE")) != null) {
                if (url != null) {
                    System.err.println("Warning: URL and FILE are both defined for '" + title + "'");
                }
                url = "file://" + fileNode.val;
            }
            Node nn = new Node(url);
            nn.title = title;
            allNodes.addElement(nn);
            doctrees.put(nn, doctree);
            idurls.put(docid, url);
            if (this.use_keywords && (kwdTree = doctree.getNode("KEYWORDS")) != null) {
                XMLTree node1 = kwdTree.first_child;
                while (node1 != null) {
                    this.addTermNode(node1.val, nn);
                    node1 = node1.next_brother;
                }
            }
            doctree = doctree.next_brother;
        }
        this.nvquicksort(allNodes);
        for (int i = 0; i < allNodes.size(); ++i) {
            XMLTree kwdTree;
            Node nn = (Node)allNodes.elementAt(i);
            XMLTree doctree2 = (XMLTree)doctrees.get(nn);
            if (this.use_keywords && (kwdTree = doctree2.getNode("KEYWORDS")) != null) {
                XMLTree node1 = kwdTree.first_child;
                while (node1 != null) {
                    this.addOtherTerms(node1.val, nn);
                    node1 = node1.next_brother;
                }
            }
            this.addOtherTerms(nn.title, nn);
            XMLTree linksTree = doctree2.getNode("LINKS");
            if (linksTree == null) continue;
            XMLTree linkn = linksTree.first_child;
            while (linkn != null) {
                String toid = linkn.getAttVal("toid");
                String role = linkn.getAttVal("role");
                String tourl = (String)idurls.get(toid);
                ResiField res = Cluster.iField(allNodes, tourl);
                if (res.found) {
                    nn.prelinks.addElement((Node)allNodes.elementAt(res.ind));
                    nn.preroles.addElement(role);
                } else {
                    System.err.println("link target not found: " + toid);
                }
                linkn = linkn.next_brother;
            }
        }
    }
}

