/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.Cluster;
import clustering.GetNodes;
import clustering.MyFloat;
import clustering.Node;
import clustering.NoisingPartitioning;
import clustering.ResiField;
import dispgrid.GridFrame;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import xml.Attribute;
import xml.XMLTree;

public class Clustering
extends Frame
implements ActionListener {
    final int ALGO_PARTITIONING = 3;
    static final int DIMX = 4;
    static final int DIMY = 4;
    int nb_clusters;
    Cluster[] clusters;
    Vector allNodes;
    Cluster[][] grid = null;
    boolean inited = false;
    int tmpi;
    int tmpj;
    Choice keywords_choice;
    Choice delnodes_choice;
    TextField doclist_field;
    String doclist;
    boolean use_keywords;
    boolean del_nodes;
    int del_nb_links;
    Vector terms;
    Vector term_nodes;
    static final String KEYWORDS_URL = "http://server_to_define/dir/keywords_uni_3";
    Vector tkwds;
    Vector tkptr;
    boolean delfirst;
    Checkbox delfirst_chk;
    Vector keyword_nodes = null;
    Label progress_lab;
    Button bok;
    String gridFilename = "grid.xml";
    static final String OTHER_DATA = "other_data";
    static final String INCLUDES = "includes";
    static final String IS_INCLUDED_IN = "is_included_in";
    static final String IS_AN_IMAGE_OF = "is_an_image_of";
    static final String HAS_FOR_IMAGE = "has_for_image";
    static final String HAS_FOR_AUTHOR = "has_for_author";
    static final String IS_AUTHOR_OF = "is_author_of";
    static final String IS_STUDYING = "is_studying";
    static final String BEING_STUDIED_BY = "being_studied_by";
    static final String HAS_FOR_REF = "has_for_ref";
    static final String IS_REF_OF = "is_ref_of";
    static final String KEYWORD = "KEYWORD";

    private void error(String s) {
        if (this.inited) {
            System.err.println(s);
            this.add(new Label(s, 0));
            this.validate();
        } else {
            System.err.println(s);
        }
    }

    public void init() {
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        this.setLayout(gridBag);
        this.setFont(new Font("Helvetica", 0, 14));
        Panel cp = new Panel();
        cp.setLayout(new FlowLayout());
        Label lab = new Label("doclist file:", 1);
        cp.add(lab);
        this.doclist_field = new TextField("", 38);
        cp.add(this.doclist_field);
        Button bdoclist = new Button("Open...");
        cp.add(bdoclist);
        bdoclist.setActionCommand("open");
        bdoclist.addActionListener(this);
        gridBag.setConstraints(cp, c);
        this.add(cp);
        cp = new Panel();
        cp.setLayout(new FlowLayout());
        this.keywords_choice = new Choice();
        this.keywords_choice.add("use only the links");
        this.keywords_choice.add("use links and kwds");
        this.keywords_choice.select(1);
        cp.add(this.keywords_choice);
        this.delnodes_choice = new Choice();
        this.delnodes_choice.add("keep all nodes");
        this.delnodes_choice.add("del nodes with < 2 links");
        this.delnodes_choice.add("del nodes with < 3 links");
        cp.add(this.delnodes_choice);
        this.delfirst_chk = new Checkbox("Delete first doc");
        cp.add(this.delfirst_chk);
        this.bok = new Button("Go!");
        cp.add(this.bok);
        this.bok.setActionCommand("OK");
        this.bok.addActionListener(this);
        gridBag.setConstraints(cp, c);
        this.add(cp);
        this.progress_lab = new Label("-------------------------------------");
        gridBag.setConstraints(this.progress_lab, c);
        this.add(this.progress_lab);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((Component)e.getWindow()).setVisible(false);
                e.getWindow().dispose();
                System.exit(0);
            }
        });
        this.pack();
        this.inited = true;
    }

    public void progress(String s) {
        this.progress_lab.setText(s);
        this.repaint();
    }

    public static float strength(String role) {
        if (role == null) {
            return 1.0f;
        }
        if (role.equals(OTHER_DATA)) {
            return 5.0f;
        }
        if (role.equals(INCLUDES) || role.equals(IS_INCLUDED_IN)) {
            return 4.0f;
        }
        if (role.equals(IS_AN_IMAGE_OF) || role.equals(HAS_FOR_IMAGE)) {
            return 4.0f;
        }
        if (role.equals(HAS_FOR_AUTHOR) || role.equals(IS_AUTHOR_OF)) {
            return 3.0f;
        }
        if (role.equals(IS_STUDYING) || role.equals(BEING_STUDIED_BY)) {
            return 2.0f;
        }
        if (role.equals(HAS_FOR_REF) || role.equals(IS_REF_OF)) {
            return 2.0f;
        }
        if (role.startsWith(KEYWORD)) {
            return Float.valueOf(role.substring(7)).floatValue();
        }
        return 1.0f;
    }

    private ResiField iVString(Vector v, String s) {
        int r;
        int a = 0;
        int b = v.size() - 1;
        ResiField res = new ResiField();
        if (b == -1) {
            res.ind = 0;
            res.found = false;
            return res;
        }
        while (a + 1 < b) {
            int m = (a + b) / 2;
            r = ((String)v.elementAt(m)).compareTo(s);
            if (r < 0) {
                a = m;
                continue;
            }
            if (r > 0) {
                b = m;
                continue;
            }
            res.ind = m;
            res.found = true;
            return res;
        }
        r = ((String)v.elementAt(a)).compareTo(s);
        if (r == 0) {
            res.ind = a;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = a;
            res.found = false;
            return res;
        }
        r = ((String)v.elementAt(b)).compareTo(s);
        if (r == 0) {
            res.ind = b;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = b;
            res.found = false;
            return res;
        }
        res.ind = b + 1;
        res.found = false;
        return res;
    }

    private void putClusterInTree(Cluster ag, XMLTree tree) {
        block4: {
            if (ag == null) break block4;
            Vector<Attribute> attl = new Vector<Attribute>();
            Attribute att = new Attribute();
            att.name = "x";
            att.val = "" + ag.x;
            attl.addElement(att);
            att = new Attribute();
            att.name = "y";
            att.val = "" + ag.y;
            attl.addElement(att);
            att = new Attribute();
            att.name = "centerURL";
            att.val = ag.centerURL;
            attl.addElement(att);
            att = new Attribute();
            att.name = "title";
            att.val = ag.title;
            attl.addElement(att);
            XMLTree space = tree.addChild("CLUSTER", attl, "");
            if (ag.subClusters == null) {
                for (int i = 0; i < ag.nodes.size(); ++i) {
                    Node thisnode = (Node)ag.nodes.elementAt(i);
                    attl = new Vector();
                    att = new Attribute();
                    att.name = "url";
                    att.val = thisnode.url;
                    attl.addElement(att);
                    att = new Attribute();
                    att.name = "title";
                    att.val = thisnode.title;
                    attl.addElement(att);
                    space.addChild("NODE", attl, "");
                }
            } else {
                for (int i = 0; i < ag.subClusters.length; ++i) {
                    this.putClusterInTree(ag.subClusters[i], space);
                }
            }
        }
    }

    private void saveGrid() {
        int y;
        int x;
        this.grid = new Cluster[4][4];
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                this.grid[x][y] = null;
            }
        }
        for (int i = 0; i < this.clusters.length; ++i) {
            if (this.clusters[i] != null) {
                this.grid[this.clusters[i].x][this.clusters[i].y] = this.clusters[i];
                continue;
            }
            System.out.println("Cluster number " + i + " is null !");
        }
        Vector<Attribute> vatt = new Vector<Attribute>();
        vatt.addElement(new Attribute("dimx", String.valueOf(4)));
        vatt.addElement(new Attribute("dimy", String.valueOf(4)));
        XMLTree tree = new XMLTree(null, "GRID", vatt, "");
        for (x = 0; x < 4; ++x) {
            for (y = 0; y < 4; ++y) {
                Cluster ag = this.grid[x][y];
                this.putClusterInTree(ag, tree);
            }
        }
        System.out.println("Saving grid to " + this.gridFilename);
        try {
            FileOutputStream in = new FileOutputStream(this.gridFilename);
            PrintWriter bufin = new PrintWriter(new OutputStreamWriter(in));
            tree.writeTree(in, "GRID");
            bufin.close();
        }
        catch (Exception e) {
            System.err.println("exception: " + e.getMessage());
            e.printStackTrace();
        }
        GridFrame gf = new GridFrame(null);
        gf.init();
        gf.changeGridClusters(tree);
    }

    private double sqr(double x) {
        return x * x;
    }

    private void modifClusterCenters(Cluster[] clusters) {
        for (int i = 0; i < this.nb_clusters; ++i) {
            Cluster ag = clusters[i];
            if (ag.nodes.size() == 0) {
                ag.centerURL = "";
                ag.title = "";
            } else {
                int k;
                double links_ratio;
                Node aNode;
                int j;
                double fmaxlinks1 = -1.0;
                int nobest = -1;
                for (j = 0; j < ag.nodes.size(); ++j) {
                    aNode = (Node)ag.nodes.elementAt(j);
                    links_ratio = 0.0;
                    for (k = 0; k < aNode.links.size(); ++k) {
                        if (((Node)aNode.links.elementAt((int)k)).master != ag) continue;
                        links_ratio += (double)((MyFloat)aNode.roles.elementAt((int)k)).val;
                    }
                    if (!(links_ratio > fmaxlinks1)) continue;
                    fmaxlinks1 = links_ratio;
                    nobest = j;
                }
                aNode = nobest == -1 ? (Node)ag.nodes.elementAt(0) : (Node)ag.nodes.elementAt(nobest);
                ag.centerURL = aNode.url;
                ag.title = !aNode.title.equals("") ? aNode.title : aNode.ident;
                if (this.use_keywords) {
                    double fmaxlinks2 = 0.0;
                    nobest = -1;
                    for (j = 0; j < this.term_nodes.size(); ++j) {
                        int nblinks = 0;
                        Vector vnodes = (Vector)this.term_nodes.elementAt(j);
                        if (vnodes.size() <= 1) continue;
                        for (k = 0; k < ag.nodes.size(); ++k) {
                            if (!vnodes.contains(ag.nodes.elementAt(k))) continue;
                            ++nblinks;
                        }
                        if (nblinks <= true) continue;
                        links_ratio = (double)nblinks / (double)vnodes.size();
                        if (vnodes.size() < ag.nodes.size()) {
                            links_ratio *= 1.0 - this.sqr(vnodes.size() - ag.nodes.size()) / this.sqr(ag.nodes.size());
                        }
                        if (!(links_ratio > fmaxlinks2)) continue;
                        fmaxlinks2 = links_ratio;
                        nobest = j;
                    }
                    if (nobest != -1 && fmaxlinks2 * 2.0 > fmaxlinks1 / (double)ag.nodes.size()) {
                        ag.title = (String)this.terms.elementAt(nobest);
                        ag.centerURL = "";
                    }
                }
            }
            if (ag.subClusters == null) continue;
            this.modifClusterCenters(ag.subClusters);
        }
    }

    private void addKeywordLinks(Vector allNodes) {
        Node node1;
        ResiField res;
        int j;
        Vector vnodes;
        int i;
        for (i = 0; i < this.terms.size(); ++i) {
            vnodes = (Vector)this.term_nodes.elementAt(i);
            for (j = 0; j < vnodes.size(); ++j) {
                if (allNodes.contains((Node)vnodes.elementAt(j))) continue;
                System.err.println("Node " + ((Node)vnodes.elementAt((int)j)).ident + " in term_nodes but not in allNodes!!!");
                vnodes.removeElementAt(j);
                --j;
            }
            if (vnodes.size() != 0) continue;
            this.term_nodes.removeElementAt(i);
            this.terms.removeElementAt(i);
            --i;
        }
        for (i = 0; i < this.terms.size(); ++i) {
            String kwd1;
            String kwd = (String)this.terms.elementAt(i);
            res = this.iVString(this.tkwds, kwd);
            if (!res.found || kwd.equals(kwd1 = (String)this.tkptr.elementAt(res.ind))) continue;
            vnodes = (Vector)this.term_nodes.elementAt(i);
            this.terms.removeElementAt(i);
            this.term_nodes.removeElementAt(i);
            ResiField res1 = this.iVString(this.terms, kwd1);
            --i;
            if (res1.found) {
                Vector vnodes1 = (Vector)this.term_nodes.elementAt(res1.ind);
                for (j = 0; j < vnodes.size(); ++j) {
                    node1 = (Node)vnodes.elementAt(j);
                    if (vnodes1.contains(node1)) continue;
                    vnodes1.addElement(node1);
                }
            } else {
                this.terms.insertElementAt(kwd1, res1.ind);
                this.term_nodes.insertElementAt(vnodes, res1.ind);
                if (res1.ind < i) {
                    ++i;
                }
            }
            System.out.println(kwd + " changed to " + kwd1);
        }
        int nb_keywords = 0;
        System.out.println("Keywords: ");
        this.keyword_nodes = new Vector();
        for (i = 0; i < this.terms.size(); ++i) {
            vnodes = (Vector)this.term_nodes.elementAt(i);
            if (vnodes.size() <= 1) continue;
            System.out.print((String)this.terms.elementAt(i) + "(" + vnodes.size() + "); ");
            ++nb_keywords;
            Node n = new Node(KEYWORD + (String)this.terms.elementAt(i));
            n.title = n.url;
            n.fake = true;
            this.keyword_nodes.addElement(n);
            res = Cluster.iField(allNodes, n.url);
            if (res.found) continue;
            allNodes.insertElementAt(n, res.ind);
            for (j = 0; j < vnodes.size(); ++j) {
                node1 = (Node)vnodes.elementAt(j);
                if (vnodes.size() > allNodes.size()) {
                    System.err.println("Error: vnodes > allNodes");
                    continue;
                }
                String role = KEYWORD + String.valueOf(1.0 / (double)vnodes.size());
                node1.addPrelinkrole(n, role);
                n.addPrelinkrole(node1, role);
            }
        }
        System.out.println("\n" + nb_keywords + " keywords.");
    }

    private void checkLinksSymetry(Vector allNodes) {
        System.out.println("checking prelinks symetry");
        for (int i = 0; i < allNodes.size(); ++i) {
            Node iNode = (Node)allNodes.elementAt(i);
            for (int j = 0; j < iNode.prelinks.size(); ++j) {
                Node jNode = (Node)iNode.prelinks.elementAt(j);
                int k = jNode.prelinks.indexOf(iNode);
                if (k != -1) continue;
                jNode.prelinks.addElement(iNode);
                jNode.preroles.addElement(Cluster.inv_role((String)iNode.preroles.elementAt(j)));
            }
        }
    }

    private void clean_clusters(Cluster[] clusters) {
        for (int i = 0; i < this.nb_clusters; ++i) {
            Cluster ag = clusters[i];
            for (int j = 0; j < ag.nodes.size(); ++j) {
                if (!((Node)ag.nodes.elementAt((int)j)).fake) continue;
                ag.nodes.removeElementAt(j);
                --j;
            }
            if (ag.subClusters == null) continue;
            this.clean_clusters(ag.subClusters);
        }
    }

    private void del_keyword_nodes(Vector allNodes, Cluster[] clusters) {
        Node n;
        int i;
        for (i = 0; i < allNodes.size(); ++i) {
            n = (Node)allNodes.elementAt(i);
            for (int j = 0; j < n.links.size(); ++j) {
                Node n2 = (Node)n.links.elementAt(j);
                if (!n2.fake) continue;
                n.links.removeElementAt(j);
                n.roles.removeElementAt(j);
                --j;
            }
        }
        for (i = 0; i < allNodes.size(); ++i) {
            n = (Node)allNodes.elementAt(i);
            if (!n.fake) continue;
            allNodes.removeElementAt(i);
            --i;
        }
        this.clean_clusters(clusters);
    }

    private void deleteNodes(Vector allNodes) {
        Node n2;
        int j;
        Node n;
        int i;
        this.checkLinksSymetry(allNodes);
        for (i = 0; i < allNodes.size(); ++i) {
            ((Node)allNodes.elementAt((int)i)).mark = false;
        }
        if (this.del_nodes) {
            System.out.println("deleting nodes with less than " + this.del_nb_links + " links...");
            for (i = 0; i < allNodes.size(); ++i) {
                n = (Node)allNodes.elementAt(i);
                if (n.prelinks.size() >= this.del_nb_links) continue;
                n.mark = true;
            }
        }
        for (i = 0; i < allNodes.size(); ++i) {
            n = (Node)allNodes.elementAt(i);
            for (j = 0; j < n.prelinks.size(); ++j) {
                n2 = (Node)n.prelinks.elementAt(j);
                if (!n2.mark) continue;
                n.prelinks.removeElementAt(j);
                n.preroles.removeElementAt(j);
                --j;
            }
        }
        if (this.use_keywords) {
            for (i = 0; i < this.term_nodes.size(); ++i) {
                Vector vnodes = (Vector)this.term_nodes.elementAt(i);
                for (j = 0; j < vnodes.size(); ++j) {
                    if (!((Node)vnodes.elementAt((int)j)).mark) continue;
                    vnodes.removeElementAt(j);
                    --j;
                }
                if (vnodes.size() != 0) continue;
                this.terms.removeElementAt(i);
                this.term_nodes.removeElementAt(i);
                --i;
            }
        }
        for (i = 0; i < allNodes.size(); ++i) {
            n = (Node)allNodes.elementAt(i);
            if (!n.mark) continue;
            allNodes.removeElementAt(i);
            --i;
        }
        System.out.println("There are " + allNodes.size() + " documents left.");
        for (i = 0; i < allNodes.size(); ++i) {
            n = (Node)allNodes.elementAt(i);
            if (n.mark) {
                System.err.println("n.mark!!!");
            }
            for (j = 0; j < n.prelinks.size(); ++j) {
                n2 = (Node)n.prelinks.elementAt(j);
                if (n2.mark) {
                    System.err.println("n2.mark!!!");
                }
                if (allNodes.contains(n2)) continue;
                System.err.println("Node " + n2.ident + " in a link but not in allNodes!!!");
                n.prelinks.removeElementAt(j);
                n.preroles.removeElementAt(j);
                --j;
            }
        }
    }

    public void letsgo() {
        int j;
        Node iNode;
        int i;
        if (this.doclist == null || "".equals(this.doclist)) {
            return;
        }
        GetNodes gn = new GetNodes();
        this.setCursor(Cursor.getPredefinedCursor(3));
        gn.use_keywords = this.use_keywords;
        gn.terms = this.terms;
        gn.term_nodes = this.term_nodes;
        gn.tkwds = this.tkwds;
        gn.tkptr = this.tkptr;
        this.allNodes = new Vector();
        Vector unique = new Vector();
        Vector stopURL = new Vector();
        gn.getAllNodesFromDoclist(this.allNodes, new File(this.doclist));
        if (this.allNodes.size() == 0) {
            return;
        }
        unique = null;
        System.out.println("There are " + this.allNodes.size() + " documents.");
        if (this.allNodes.size() < 16) {
            System.err.println("allNodes.size() < nb_clusters !!!");
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (this.del_nodes) {
            this.deleteNodes(this.allNodes);
        }
        this.nb_clusters = 16;
        this.clusters = new Cluster[16];
        if (this.use_keywords) {
            this.addKeywordLinks(this.allNodes);
        }
        System.out.println("checking links unicity");
        for (i = 0; i < this.allNodes.size(); ++i) {
            iNode = (Node)this.allNodes.elementAt(i);
            if (iNode.prelinks == null) continue;
            for (j = 0; j < iNode.prelinks.size(); ++j) {
                Node jNode = (Node)iNode.prelinks.elementAt(j);
                for (int k = j + 1; k < iNode.prelinks.size(); ++k) {
                    if (jNode != (Node)iNode.prelinks.elementAt(k)) continue;
                    String role1 = (String)iNode.preroles.elementAt(j);
                    String role2 = (String)iNode.preroles.elementAt(k);
                    if (role1 != null && !role1.equals(role2)) {
                        String newrole = KEYWORD + String.valueOf(Clustering.strength(role1) + Clustering.strength(role2));
                        iNode.preroles.setElementAt(newrole, j);
                        System.out.println("merged 2 links between " + iNode.ident + " and " + jNode.ident);
                    }
                    iNode.prelinks.removeElementAt(k);
                    iNode.preroles.removeElementAt(k);
                    --k;
                }
            }
        }
        for (i = 0; i < this.allNodes.size(); ++i) {
            iNode = (Node)this.allNodes.elementAt(i);
            if (iNode.prelinks != null) {
                iNode.links = iNode.prelinks;
            }
            if (iNode.preroles != null) {
                for (j = 0; j < iNode.preroles.size(); ++j) {
                    iNode.roles.addElement(new MyFloat(Clustering.strength((String)iNode.preroles.elementAt(j))));
                }
            }
            iNode.prelinks = null;
            iNode.preroles = null;
        }
        float init_alpha = 2.0f;
        NoisingPartitioning np = new NoisingPartitioning(this, 3, this.allNodes, this.clusters, init_alpha, this.use_keywords);
        this.bok.setEnabled(false);
        np.start();
    }

    public void endClustering() {
        if (this.use_keywords && this.keyword_nodes != null) {
            this.del_keyword_nodes(this.allNodes, this.clusters);
        }
        this.modifClusterCenters(this.clusters);
        this.saveGrid();
        this.bok.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void openDlg() {
        FileDialog dlg = new FileDialog((Frame)this, "Open document list", 0);
        dlg.show();
        String sf = dlg.getFile();
        String sdir = dlg.getDirectory();
        if (sf != null) {
            File f = sdir != null ? new File(sdir, sf) : new File(sf);
            this.doclist_field.setText(f.getPath());
        }
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        System.out.println("command: " + command);
        if (command.equals("OK")) {
            if (this.keywords_choice.getSelectedIndex() == 0) {
                this.use_keywords = false;
            } else {
                this.use_keywords = true;
                this.terms = new Vector();
                this.term_nodes = new Vector();
                this.tkwds = new Vector();
                this.tkptr = new Vector();
            }
            if (this.delnodes_choice.getSelectedIndex() == 0) {
                this.del_nodes = false;
            } else {
                this.del_nodes = true;
                this.del_nb_links = this.delnodes_choice.getSelectedIndex() + 1;
            }
            this.doclist = this.doclist_field.getText();
            this.delfirst = this.delfirst_chk.getState();
            this.letsgo();
        } else if (command.equals("open")) {
            this.openDlg();
        }
    }

    public static void main(String[] args) {
        Clustering clus = new Clustering();
        clus.init();
        clus.show();
        if (args.length > 0) {
            clus.doclist = args[0];
            if (args.length > 1) {
                clus.gridFilename = args[1];
            }
            clus.use_keywords = true;
            clus.terms = new Vector();
            clus.term_nodes = new Vector();
            clus.tkwds = new Vector();
            clus.tkptr = new Vector();
            clus.del_nodes = false;
            clus.letsgo();
        }
    }
}

