/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.Node;
import clustering.ResiField;
import java.util.Vector;

public class Cluster {
    String centerURL;
    String title;
    Vector nodes;
    int x;
    int y;
    Cluster[] subClusters;
    Cluster[] precClusters;
    int nbreal;

    public Cluster() {
        this.centerURL = "";
        this.nodes = new Vector();
        this.x = -1;
        this.y = -1;
        this.title = "";
        this.subClusters = null;
        this.precClusters = null;
        this.nbreal = 0;
    }

    public Cluster(Node aNode) {
        this.centerURL = aNode.url;
        this.nodes = new Vector();
        this.nodes.addElement(aNode);
        this.x = -1;
        this.y = -1;
        aNode.mark = true;
        aNode.master = this;
        this.title = !aNode.title.equals("") ? aNode.title : aNode.ident;
    }

    public static ResiField iField(Vector v, String s) {
        int r;
        int a = 0;
        int b = v.size() - 1;
        ResiField res = new ResiField();
        if (b == -1) {
            res.ind = 0;
            res.found = false;
            return res;
        }
        while (a + 1 < b) {
            int m = (a + b) / 2;
            r = ((Node)v.elementAt((int)m)).url.compareTo(s);
            if (r < 0) {
                a = m;
                continue;
            }
            if (r > 0) {
                b = m;
                continue;
            }
            res.ind = m;
            res.found = true;
            return res;
        }
        r = ((Node)v.elementAt((int)a)).url.compareTo(s);
        if (r == 0) {
            res.ind = a;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = a;
            res.found = false;
            return res;
        }
        r = ((Node)v.elementAt((int)b)).url.compareTo(s);
        if (r == 0) {
            res.ind = b;
            res.found = true;
            return res;
        }
        if (r > 0) {
            res.ind = b;
            res.found = false;
            return res;
        }
        res.ind = b + 1;
        res.found = false;
        return res;
    }

    public static String inv_role(String role) {
        if (role.equals("has_for_ref")) {
            return "is_ref_of";
        }
        if (role.equals("is_ref_of")) {
            return "has_for_ref";
        }
        if (role.equals("being_studied_by")) {
            return "is_studying";
        }
        if (role.equals("is_studying")) {
            return "being_studied_by";
        }
        if (role.equals("is_included_in")) {
            return "includes";
        }
        if (role.equals("includes")) {
            return "is_included_in";
        }
        if (role.equals("other_data")) {
            return "other_data";
        }
        if (role.equals("has_for_author")) {
            return "is_author_of";
        }
        if (role.equals("is_author_of")) {
            return "has_for_author";
        }
        if (role.equals("is_an_image_of")) {
            return "has_for_image";
        }
        if (role.equals("has_for_image")) {
            return "is_an_image_of";
        }
        return "";
    }

    public void calc_nbreal() {
        int nb = 0;
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (((Node)this.nodes.elementAt((int)i)).fake) continue;
            ++nb;
        }
        this.nbreal = nb;
    }
}

