/**
 * ImageCarte.java
 
Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions
de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence.
Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ;
sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER.
Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ;
si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.

 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.image.*;
import java.io.*;
import java.net.*;
import java.util.Vector;

import xml.*;

public class ImageCarte extends Applet {

    ImageCanvas ic;
    TextArea lab;
    Zone[] zones;
    String dossier;
    
    public void init() {
        setLayout(new BorderLayout());
        String nomImage = getParameter("image");
        if (nomImage == null)
            System.err.println("erreur: ImageCarte utilise le paramtre image, qui n'a pas t dfini");
        dossier = (new File(nomImage)).getParent();
        // lecture de nomimage.carte
        XMLTree carte = new XMLTree(null, "", null, "");
        try {
            String fcarte = getParameter("fcarte");
            if (fcarte == null) {
                fcarte = nomImage;
                if (fcarte.indexOf('.') != -1)
                    fcarte = fcarte.substring(0, fcarte.lastIndexOf('.')) + ".carte";
            }
            URL urlcarte = new URL(getCodeBase(), fcarte);
            Parser_XML p2 = new Parser_XML(urlcarte.openStream(), System.out, carte);
            p2.parse(0);
        } catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
            return;
        }
        if (!"CARTE".equalsIgnoreCase(carte.tag)) {
            System.err.println("Mauvais fichier XML (la racine est " + carte.tag + " au lieu de CARTE)");
            return;
        }
        zones = new Zone[carte.getChildrenCount()];
        XMLTree ztree;
        int i=0;
        for (ztree=carte.first_child; ztree!=null; ztree=ztree.next_brother)
            zones[i++] = new Zone(ztree);
        Image im = getImage(getCodeBase(), nomImage);
        int initWidth = 300;
        int initHeight = 300;
        String sInitWidth = carte.getAttVal("largeur");
        String sInitHeight = carte.getAttVal("hauteur");
        if (sInitWidth != null && !"".equals(sInitWidth) &&
            sInitHeight != null && !"".equals(sInitHeight)) {
            try {
                initWidth = Integer.valueOf(sInitWidth).intValue();
                initHeight = Integer.valueOf(sInitHeight).intValue();
            } catch (NumberFormatException ex) {
                System.err.println("NumberFormatException: " + ex.getMessage());
            }
        }
        ic = new ImageCanvas(im, initWidth, initHeight);
        lab = new TextArea("", 2, 60, TextArea.SCROLLBARS_NONE);
        lab.setEditable(false);
        add(lab, BorderLayout.SOUTH);
        add(ic, BorderLayout.CENTER);
        /* pose problme parce-que certains navigateurs ne grent pas les dplacements de curseur
           sans un clic sur l'applet pour la slectionner au pralable
        ic.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                String grandeImage = getParameter("grandeimage");
                if (grandeImage != null) {
                    try {
                        getAppletContext().showDocument(new URL(getCodeBase(), grandeImage));
                    } catch (MalformedURLException ex) {
                        System.err.println("MalformedURLException: " + ex.getMessage());
                    }
                }
            }
        });
        */
        validate();
        (new Thread() {
            public void run() {
                ic.initialisation();
                ic.requestFocus();
            }
        }).start();
    }
    
    class ImageCanvas extends Canvas implements MouseMotionListener {
        Image image1;
        Image image;
        Dimension size;
        int zonesel=-1;
        
        public ImageCanvas(Image image, int initialWidth, int initialHeight) {
            image1 = image;
            size = new Dimension(initialWidth,initialHeight);
            image = null;
        }
        
        public void initialisation() {
            lab.setText("prparation de la carte...");
            // ajout du rectangle rouge sur l'image de dpart
            XMLTree arbreZoneRouge = new XMLTree(null, "ZONE", null, null);
            Vector attributs = new Vector();
            attributs.addElement(new Attribute("forme", "rectangle"));
            attributs.addElement(new Attribute("coords", "0,0,20,20"));
            XMLTree arbreSousZoneRouge = new XMLTree(null, "SOUSZONE", attributs, null);
            arbreZoneRouge.addChild(arbreSousZoneRouge);
            Zone zoneRouge = new Zone(arbreZoneRouge);
            ImageFilter filter = new HighlightFilter(zoneRouge, 0xff0000);
            ImageProducer producer = new FilteredImageSource(image1.getSource(), filter);
            image1 = createImage(producer);
            
            this.image = image1;
			prepareToutesImages(image1);
            addMouseMotionListener(this);
            lab.setText("Dplacer le curseur sur la carte pour activer certaines zones." +
                " Le coin rouge permet de voir toutes les zones.");
        }
        
        public Dimension getPreferredSize() {
            return getMinimumSize();
        }
        
        public Dimension getMinimumSize() {
            return size;
        }
    
        public void paint (Graphics g) {
            if (image != null)
                g.drawImage(image, 0, 0, this);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        
        public void update(Graphics g) {
            paint(g);
        }
        
        public void mouseMoved(MouseEvent e) {
            int x=e.getX();
            int y=e.getY();
            boolean trouve = false;
            for (int i=0; i<zones.length; i++)
                if (zones[i].contains(x,y)) {
                    if (zonesel != i) {
                        String st = zones[i].getTexte();
                        //if (st.length() > 60) {
                        //    int is = st.substring(0, 60).lastIndexOf(' ');
                        //    st = st.substring(0,is) + "\n" + st.substring(is+1);
                        //}
                        // 60 caractres est approximatif, on ne peut pas se baser dessus pour ajouter des \n,
                        // il fautdrait prendre en compte la largeur en pixels du texte, caractre par caractre
                        // mais peut-tre que le bug de la JVM (laquelle?) qui empchait les wrap a t corrig ?
                        lab.setText(st);
                        //changeImage(zones[i].getZeImage());
                        changeImage(zones[i].imageZone(image1));
                        zonesel = i;
                    }
                    trouve = true;
                    break;
                }
            if (!trouve && x < 20 && y < 20) {
                changeImage(imageToutesZones(image1));
                if (zonesel != -1) {
                    lab.setText("");
                    zonesel = -1;
                }
            } else if (!trouve && zonesel != -1) {
                lab.setText("");
                changeImage(image1);
                zonesel = -1;
            }
        }
        
        public void mouseDragged(MouseEvent e) {
        }
                
        /*public void dessinerZones(Graphics g) {
            for (int i=0; i<zones.length; i++)
                zones[i].dessinerZones(g);
        }*/
        
        public void changeImage(Image im) {
            image = im;
            repaint();
        }
        
        Image imageTout = null;
        public Image imageToutesZones(Image sourceImage) {
            if (imageTout != null)
                return(imageTout);
            Image resultImage = sourceImage;
            for (int i=0; i<zones.length; i++) {
                ImageFilter filter = new HighlightFilter(zones[i], 0x00ffff);
                ImageProducer producer = new FilteredImageSource(resultImage.getSource(), filter);
                resultImage = createImage(producer);
            }
            imageTout = resultImage;
            return(imageTout);
        }
		
		public void prepareToutesImages(Image sourceImage) {
			//long t1 = System.currentTimeMillis();
			MediaTracker tracker = new MediaTracker(this);
			for (int i=0; i<zones.length; i++)
				tracker.addImage(zones[i].imageZone(sourceImage), i);
			tracker.addImage(imageToutesZones(sourceImage), zones.length);
			try {
				tracker.waitForAll();
			} catch (InterruptedException ex) {
				System.err.println("InterruptedException: " + ex.getMessage());
			}
			//long t2 = System.currentTimeMillis();
			//System.out.println("tps: " + (t2 - t1));
		}
    }
    
    class Zone {
        SousZone[] souszones;
        String texte;
        Image image;
        
        public Zone(XMLTree zonetree) {
            texte = zonetree.getAttVal("texte");
            //if (texte == null)
            //    System.err.println("Erreur: aucun texte pour la zone");
            souszones = new SousZone[zonetree.getChildrenCount()];
            XMLTree sztree;
            int i=0;
            for (sztree=zonetree.first_child; sztree!=null; sztree=sztree.next_brother) {
                String forme = sztree.getAttVal("forme");
                String coords = sztree.getAttVal("coords");
                souszones[i++] = new SousZone(forme, coords);
            }
            image = null;
        }

        public boolean contains(int x, int y) {
            for (int i=0; i<souszones.length; i++)
                if (souszones[i].contains(x,y))
                    return(true);
            return(false);
        }
        
        public String getTexte() {
            return(texte);
        }
        
        /*public void dessinerZones(Graphics g) {
            for (int i=0; i<souszones.length; i++) {
                Rectangle r = souszones[i].getBounds();
                g.setXORMode(Color.white);
                g.draw3DRect(r.x, r.y, r.width, r.height, true);
            }
        }*/
        
        public Image imageZone(Image sourceImage) {
            if (image != null)
                return(image);
            ImageFilter filter = new HighlightFilter(this, 0x00ffff);
            ImageProducer producer = new FilteredImageSource(sourceImage.getSource(), filter);
            Image resultImage = createImage(producer);
            image = resultImage;
            return(resultImage);
        }
    }
    
    class SousZone {
        final static int FORME_INCONNUE = 0;
        final static int FORME_CERCLE = 1;
        final static int FORME_RECTANGLE = 2;
        final static int FORME_POLYGONE = 3;
        int forme;
        String coords;
        Polygon poly;
        Rectangle rect;
        Circle circ;
        
        public SousZone(String sforme, String coords) {
            this.coords = coords;
            poly = null;
            rect = null;
            circ = null;
            if ("polygone".equals(sforme))
                forme = FORME_POLYGONE;
            else if ("rectangle".equals(sforme))
                forme = FORME_RECTANGLE;
            else if ("cercle".equals(sforme))
                forme = FORME_CERCLE;
            else
                forme = FORME_INCONNUE;
            
            if (forme == FORME_POLYGONE) {
                poly = new Polygon();
                String sc = coords;
                while (sc.indexOf(',') != -1) {
                    int iv = sc.indexOf(',');
                    String sx = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                    String sy;
                    if (iv != -1) {
                    	sy = sc.substring(0,iv);
                        sc = sc.substring(iv+1);
                    } else {
                        sy = sc;
                        sc = "";
                    }
                    try {
                        int x = Integer.valueOf(sx).intValue();
                        int y = Integer.valueOf(sy).intValue();
                        poly.addPoint(x, y);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException: " + ex.getMessage());
                    }
                }
            } else if (forme == FORME_RECTANGLE) {
                String sc = coords;
                String sx1=null,sy1=null,sx2=null,sy2=null;
                int iv = sc.indexOf(',');
                if (iv != -1) {
                    sx1 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sy1 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sx2 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv == -1)
                    sy2 = sc;
                if (sx1 != null && sy1 != null && sx2 != null && sy2 != null) {
                    try {
                        int x1 = Integer.valueOf(sx1).intValue();
                        int y1 = Integer.valueOf(sy1).intValue();
                        int x2 = Integer.valueOf(sx2).intValue();
                        int y2 = Integer.valueOf(sy2).intValue();
                        rect = new Rectangle(x1, y1, x2-x1, y2-y1);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException " + ex.getMessage());
                    }
                }
            } else if (forme == FORME_CERCLE) {
                String sc = coords;
                String sx=null,sy=null,sr=null;
                int iv = sc.indexOf(',');
                if (iv != -1) {
                    sx = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sy = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv == -1)
                    sr = sc;
                if (sx != null && sy != null && sr != null) {
                    try {
                        int x = Integer.valueOf(sx).intValue();
                        int y = Integer.valueOf(sy).intValue();
                        int r = Integer.valueOf(sr).intValue();
                        circ = new Circle(x, y, r);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException " + ex.getMessage());
                    }
                }
            }
        }

        public boolean contains(int x, int y) {
            if (forme == FORME_POLYGONE)
                return(poly.contains(x, y));
            else if (forme == FORME_RECTANGLE)
                return(rect.contains(x, y));
            else if (forme == FORME_CERCLE)
                return(circ.contains(x, y));
            else
                return(false);
        }
        
        public Rectangle getBounds() {
            if (forme == FORME_POLYGONE)
                return(poly.getBounds());
            else if (forme == FORME_RECTANGLE)
                return(rect.getBounds());
            else if (forme == FORME_CERCLE)
                return(circ.getBounds());
            else
                return(null);
        }
    }
    
    class Circle {
        int cx,cy,cr;
        public Circle(int x, int y, int r) {
            cx = x;
            cy = y;
            cr = r;
        }
        public boolean contains(int x, int y) {
            int x2 = x - cx;
            int y2 = y - cy;
			// optimisation: on suppose que le cercle est petit et en gnral ne contient pas le point
			if ((x2 > 0 && x2 > cr) || (x2 < 0 && -x2 > cr) || (y2 > 0 && y2 > cr) || (y2 < 0 && -y2 > cr))
				return(false);
            double d = Math.sqrt(x2*x2 + y2*y2);
            return(d < cr);
        }
        public Rectangle getBounds() {
            Rectangle r = new Rectangle(cx-cr, cy-cr, cr*2, cr*2);
            return(r);
        }
    }

    class HighlightFilter extends RGBImageFilter {
        Zone zezone;
        final int opacite = 25; // en %
        int r2op;
        int g2op;
        int b2op;
    
        public HighlightFilter(Zone zezone, int rgbf) {
            canFilterIndexColorModel = false;
            this.zezone = zezone;
            int r2 = (rgbf >> 16) & 0xff;
            int g2 = (rgbf >> 8) & 0xff;
            int b2 = (rgbf >> 0) & 0xff;
            r2op = opacite*r2/100;
            g2op = opacite*g2/100;
            b2op = opacite*b2/100;
        }
    
        public int filterRGB(int x, int y, int rgb) {
            if (!zezone.contains(x,y))
                return(rgb);
            int r = (rgb >> 16) & 0xff;
            int g = (rgb >> 8) & 0xff;
            int b = (rgb >> 0) & 0xff;
            r = r2op + (100-opacite)*r/100;
            g = g2op + (100-opacite)*g/100;
            b = b2op + (100-opacite)*b/100;
            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;
            return (rgb & 0xff000000) | (r << 16) | (g << 8) | (b << 0);
        }
    }
}
