//
//  Cartographe.java
//  Outil de cration de cartes sur images
//

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.util.Vector;

import xml.*;

public class Cartographe extends Frame implements ActionListener, ItemListener {

    boolean bASM = false; // pour le projet ASM, les images sont limites  300x300
    int RECTANGLE = 1;
    int CERCLE = 2;
    int POLYGONE = 3;
    
    MenuBar mb;
    File fimage = null;
    Image image1;
    File fcarte;
    ImageCanvas ic;
    List lZones;
    List lFormes;
    Checkbox chkrect;
    Checkbox chkcercle;
    Checkbox chkpoly;
    CheckboxGroup cbg;
    TextArea taZone;
    XMLTree xcarte;
    int zsel = -1;
    int fsel = -1;
    Zone[] zones;
    
    public static void main(String[] args) {
        Cartographe carto = new Cartographe();
        carto.nouveau();
    }
    
    public void miseEnPage() {
        removeAll();
        mb = new MenuBar();
        Menu m_fichier = new Menu("Fichier");
        MenuItem m_nouveau = new MenuItem("Nouveau");
        m_nouveau.setShortcut(new MenuShortcut(KeyEvent.VK_N));
        m_nouveau.addActionListener(this);
        m_fichier.add(m_nouveau);
        MenuItem m_ouvrir = new MenuItem("Ouvrir");
        m_ouvrir.setShortcut(new MenuShortcut(KeyEvent.VK_O));
        m_ouvrir.addActionListener(this);
        m_fichier.add(m_ouvrir);
        MenuItem m_enregistrer = new MenuItem("Enregistrer");
        m_enregistrer.setShortcut(new MenuShortcut(KeyEvent.VK_S));
        m_enregistrer.addActionListener(this);
        m_fichier.add(m_enregistrer);
        MenuItem m_quitter = new MenuItem("Quitter");
        m_quitter.setShortcut(new MenuShortcut(KeyEvent.VK_Q));
        m_quitter.addActionListener(this);
        m_fichier.add(m_quitter);
        mb.add(m_fichier);
        setMenuBar(mb);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                quitter();
            }
        });

        /*
            +----------------------------------+
            |                   |              |
            |   imagePane       |  droitePane  |
            |                   |              |
            |                   |              |
            +-------------------+--------------+
            |                                  |
            |   basPane                        |
            |                                  |
            +----------------------------------+

            droitepane:
            +----------------------+
            |                      |
            |      zonesPane       |
            |                      |
            +----------------------+
            |                      |
            |      textePane       |
            |                      |
            +----------------------+

            basPane:
            +-----------------------------------+
            |                  |                |
            |    formesPane    |   nformePane   |
            |                  |                |
            +-----------------------------------+
        */
        setLayout(new BorderLayout());
        Panel imagePane = new Panel(new BorderLayout());
        add(imagePane, BorderLayout.CENTER);
        Panel droitePane = new Panel(new BorderLayout());
        add(droitePane, BorderLayout.EAST);
        Panel basPane = new Panel(new BorderLayout());
        add(basPane, BorderLayout.SOUTH);
        
        Panel zonesPane = new Panel(new BorderLayout());
        droitePane.add(zonesPane, BorderLayout.NORTH);
        Panel textePane = new Panel(new BorderLayout());
        droitePane.add(textePane, BorderLayout.CENTER);
        
        Panel formesPane = new Panel(new BorderLayout());
        basPane.add(formesPane, BorderLayout.CENTER);
        Panel nformePane = new Panel(new FlowLayout());
        basPane.add(nformePane, BorderLayout.EAST);
        
        if (fimage != null) {
            image1 = Toolkit.getDefaultToolkit().getImage(fimage.getAbsolutePath());
            if (image1 == null)
                System.err.println("erreur au chargement de l'image: " + fimage.getPath());
            else {
                ic = new ImageCanvas(image1, this, 300, 300);
                imagePane.add(ic, BorderLayout.CENTER);
            }
        }
        
        zonesPane.add(new Label("Zones:"), BorderLayout.NORTH);
        lZones = new List(6, false);
        lZones.addItemListener(this);
        zonesPane.add(lZones, BorderLayout.CENTER);
        Panel zbPane = new Panel(new FlowLayout());
        Button baz = new Button("ajouter");
        baz.setActionCommand("AjouterZone");
        baz.addActionListener(this);
        zbPane.add(baz);
        Button bsz = new Button("supprimer");
        bsz.setActionCommand("SupprimerZone");
        bsz.addActionListener(this);
        zbPane.add(bsz);
        zonesPane.add(zbPane, BorderLayout.SOUTH);
        
        formesPane.add(new Label("Formes de la zone:"), BorderLayout.NORTH);
        lFormes = new List(6, false);
        lFormes.addItemListener(this);
        formesPane.add(lFormes, BorderLayout.CENTER);
        Button bsf = new Button("supprimer");
        bsf.setActionCommand("SupprimerForme");
        bsf.addActionListener(this);
        formesPane.add(bsf, BorderLayout.SOUTH);
        
        nformePane.add(new Label("Nouvelle forme:"));
        Panel checkpane = new Panel(new GridLayout(3, 1));
        cbg = new CheckboxGroup();
        chkrect = new Checkbox("rectangle", cbg, true);
        chkrect.addItemListener(this);
        checkpane.add(chkrect);
        chkcercle = new Checkbox("cercle", cbg, false);
        checkpane.add(chkcercle);
        chkcercle.addItemListener(this);
        chkpoly = new Checkbox("polygone", cbg, false);
        checkpane.add(chkpoly);
        chkpoly.addItemListener(this);
        if (ic != null)
            ic.setOutil(RECTANGLE);
        nformePane.add(checkpane);
        Button baf = new Button("ajouter");
        baf.setActionCommand("AjouterForme");
        baf.addActionListener(this);
        nformePane.add(baf);
        
        /* textePane avec le BorderLayout
        textePane.add(new Label("Texte de la zone:"), BorderLayout.NORTH);
        taZone = new TextArea("", 3, 35, TextArea.SCROLLBARS_NONE);
        textePane.add(taZone, BorderLayout.CENTER);
        Button bet = new Button("changer");
        bet.setActionCommand("EnregistrerTexte");
        bet.addActionListener(this);
        textePane.add(bet, BorderLayout.SOUTH);
        */
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        textePane.setLayout(gridbag);
        c.fill = GridBagConstraints.BOTH;
        c.gridwidth = GridBagConstraints.REMAINDER;
        Label lab = new Label("Texte de la zone:");
        gridbag.setConstraints(lab, c);
        textePane.add(lab);
        taZone = new TextArea("", 3, 35, TextArea.SCROLLBARS_NONE);
        gridbag.setConstraints(taZone, c);
        textePane.add(taZone);
        Button bet = new Button("changer");
        bet.setActionCommand("EnregistrerTexte");
        bet.addActionListener(this);
        c.fill = GridBagConstraints.NONE;
        c.gridwidth = 1;
        gridbag.setConstraints(bet, c);
        textePane.add(bet);
        
        pack();
        validate();
        setResizable(false);
        show();
        if (ic != null)
            ic.requestFocus();
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("Nouveau".equals(cmd))
            nouveau();
        else if ("Ouvrir".equals(cmd))
            ouvrir();
        else if ("Enregistrer".equals(cmd))
            enregistrer();
        else if ("Quitter".equals(cmd))
            quitter();
        else if ("AjouterZone".equals(cmd))
            ajouterZone();
        else if ("SupprimerZone".equals(cmd))
            supprimerZone();
        else if ("AjouterForme".equals(cmd))
            ajouterForme();
        else if ("SupprimerForme".equals(cmd))
            supprimerForme();
        else if ("EnregistrerTexte".equals(cmd))
            enregistrerTexte();
    }
    
    public void nouveau() {
        FileDialog fd = new FileDialog(this, "Ouvrir le fichier image ou carte");
        fd.show();
        String sf = fd.getFile();
        if (sf == null) {
            miseEnPage();
            return;
        }
        if (sf.endsWith(".carte")) {
            ouvrirFichier(new File(fd.getDirectory(), sf));
            return;
        }
        fimage = new File(fd.getDirectory(), sf);
        fcarte = null;
        miseEnPage();
        Vector va = new Vector();
        va.addElement(new Attribute("image", fimage.getName()));
        xcarte = new XMLTree(null, "CARTE", va, "");
        setTitle("Nouvelle carte");
    }
    
    public void ouvrir() {
        FileDialog fd = new FileDialog(this, "Ouvrir le fichier carte");
        fd.setFilenameFilter(new ExtFilter("carte"));
        fd.show();
        String sf = fd.getFile();
        if (sf != null)
            ouvrirFichier(new File(fd.getDirectory(), sf));
    }
    
    public void ouvrirFichier(File f) {
        if (!f.exists())
            return;

        fcarte = f;
        xcarte = new XMLTree(null, "", null, "");
        try {
            InputStream in = new FileInputStream(f);
            Parser_XML p2 = new Parser_XML(in, System.out, xcarte);
            p2.parse(0);
        } catch (IOException ex) {
            System.err.println("IOException: " + ex.getMessage());
            return;
        }
        if (!"CARTE".equalsIgnoreCase(xcarte.tag)) {
            System.err.println("Mauvais fichier XML (la racine est " + xcarte.tag + " au lieu de CARTE)");
            return;
        }
        String dossier = f.getParent();
        String sfim = xcarte.getAttVal("image");
        fimage = new File(dossier, sfim);

        zones = new Zone[xcarte.getChildrenCount()];
        XMLTree ztree;
        int i=0;
        for (ztree=xcarte.first_child; ztree!=null; ztree=ztree.next_brother)
            zones[i++] = new Zone(ztree);
        
        miseEnPage();
        remplirZones();
        
        setTitle(f.getName());
    }
    
    class ExtFilter implements FilenameFilter {
        String ext;
        public ExtFilter(String ext) {
            this.ext = ext;
        }
        public boolean accept(File dir, String name) {
            return(name.endsWith("." + ext));
        }
    }
    
    public void enregistrer() {
        if (fimage == null)
            return;
        if (fcarte == null) {
            String sfcarte;
            if (fimage.getName().indexOf('.') != -1)
                sfcarte = fimage.getPath().substring(0, fimage.getPath().lastIndexOf('.')) + ".carte";
            else
                sfcarte = fimage.getPath() + ".carte";
            fcarte = new File(sfcarte);
            /*FileDialog fd = new FileDialog(this, "Enregistrer le fichier carte", FileDialog.SAVE);
            fd.show();
            String sf = fd.getFile();
            fcarte = new File(sf);*/
        }
        enregistrerFichier();
    }
    
    public void enregistrerFichier() {
        xcarte.setAttVal("largeur", ""+ic.w);
        xcarte.setAttVal("hauteur", ""+ic.h);
        try {
            xcarte.writeTree(new FileOutputStream(fcarte), null);
        } catch (FileNotFoundException ex) {
            System.err.println("FileNotFoundException: " + ex.getMessage());
        }
        setTitle(fcarte.getName());
    }
    
    public void remplirZones() {
        lZones.removeAll();
        XMLTree ztree;
        int i=0;
        for (ztree=xcarte.first_child; ztree!=null; ztree=ztree.next_brother) {
            lZones.add("Zone " + i);
            i++;
        }
        lZones.validate();
    }
    
    public void remplirFormes() {
        lFormes.removeAll();
        XMLTree ztree = xcarte.getChildAt(zsel);
        XMLTree ftree;
        int i=0;
        for (ftree=ztree.first_child; ftree!=null; ftree=ftree.next_brother) {
            lFormes.add("Forme " + i + " (" + ftree.getAttVal("forme") + ")");
            i++;
        }
        lFormes.validate();
        taZone.setText(ztree.getAttVal("texte"));
    }
    
    public void quitter() {
        Dialog dlg = new SaveDialog(this);
        dlg.show();
        System.exit(0);
    }
    
    public void ajouterZone() {
        taZone.setText("");
        XMLTree ztree = new XMLTree(xcarte, "ZONE", null, "");
        xcarte.addChild(ztree);
        zsel = xcarte.getChildrenCount() - 1;
        if (zones == null)
            zones = new Zone[1];
        else {
            Zone[] zones2 = new Zone[zones.length+1];
            for (int i=0; i<zones.length; i++)
                zones2[i] = zones[i];
            zones = zones2;
        }
        zones[zsel] = new Zone(ztree);
        remplirZones();
        selectionnerZone(zsel);
    }
    
    public void supprimerZone() {
        if (zsel == -1)
            return;
        xcarte.removeChildAt(zsel);
        if (zones.length>0){
        	Zone[] zones2 = new Zone[zones.length-1];
            for (int i=0, j=0; i<zones.length; i++){
            	if (zsel!=i) {	
            		zones2[j] = zones[i];
               	    j++;
            	}
           	}
            zones = zones2;
        }
        if (xcarte.getChildrenCount() > 0){
            zsel = 0;
            selectionnerZone(zsel);
        }    
        else {
            zsel = -1;
            ic.changeImage(image1);
        }    
        remplirZones();
    }
    
    public void ajouterForme() {
    	if (zsel == -1)
            return;
        XMLTree ztree = xcarte.getChildAt(zsel);
        Vector va = new Vector();
        int outil = ic.getOutil();
        String sforme = null;
        if (outil == RECTANGLE)
            sforme = "rectangle";
        else if (outil == CERCLE)
            sforme = "cercle";
        else if (outil == POLYGONE)
            sforme = "polygone";
        va.addElement(new Attribute("forme", sforme));
        String scoords = ic.getCoords();
        if (scoords == null)
            return;
        va.addElement(new Attribute("coords", scoords));
        XMLTree ftree = new XMLTree(ztree, "SOUSZONE", va, "");
        ztree.addChild(ftree);
        fsel = ztree.getChildrenCount() - 1;
        remplirFormes();
        SousZone sz = new SousZone(sforme, scoords);
        zones[zsel].ajouterSousZone(sz);
        ic.changeImage(zones[zsel].imageZone(image1));
    }
    
    public void supprimerForme() {
        if (fsel == -1)
            return;
        XMLTree ztree = xcarte.getChildAt(zsel);
        ztree.removeChildAt(fsel);
        zones[zsel].supprimerSousZone(fsel);
        if (ztree.getChildrenCount() > 0) {
            if (fsel == ztree.getChildrenCount())
                fsel--;
        } else
            fsel = -1;
        remplirFormes();
        ic.changeImage(zones[zsel].imageZone(image1));
    }
    
    public void enregistrerTexte() {
        if (zsel == -1)
            return;
        XMLTree ztree = xcarte.getChildAt(zsel);
        ztree.setAttVal("texte", taZone.getText());
    }
    
    public void itemStateChanged(ItemEvent e) {
        Object sel = e.getItemSelectable();
        if (sel == chkrect)
            ic.setOutil(RECTANGLE);
        else if (sel == chkcercle)
            ic.setOutil(CERCLE);
        else if (sel == chkpoly)
            ic.setOutil(POLYGONE);
        else if (sel == lZones)
            selectionnerZone(lZones.getSelectedIndex());
        else if (sel == lFormes)
            selectionnerForme(lFormes.getSelectedIndex());
    }
    
    public void selectionnerZone(int sel) {
        zsel = sel;
        remplirFormes();
        ic.changeImage(zones[zsel].imageZone(image1));
        lZones.select(zsel);
    }
    
    public void selectionnerForme(int sel) {
        fsel = sel;
        lFormes.select(fsel);
    }
    
    public void setImage1(Image im) {
        image1 = im;
    }
    
    class ImageCanvas extends Canvas implements MouseMotionListener, MouseListener, KeyListener {
        Container pappy;
        Image image;
        Dimension size;
        public int w, h;
        boolean trueSizeKnown=false;
        int outil;
        Point p1 = null, p2 = null;
        Polygon poly = null;
    
        public ImageCanvas(Image image, Container highestContainer, 
                        int initialWidth, int initialHeight) {
            
            if (image == null) {
                System.err.println("Canvas got invalid image object!");
                return;
            }
    
            this.image = image;
            this.pappy = highestContainer;
            
            w = initialWidth;
            h = initialHeight;
    
            size = new Dimension(w,h);
            
            setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
            addMouseMotionListener(this);
            addMouseListener(this);
            addKeyListener(this);
        }
    
        public Dimension getPreferredSize() {
            return getMinimumSize();
        }
    
        public Dimension getMinimumSize() {
            return size;
        }
    
        public void paint (Graphics g) {
            if (image != null) {
                if (!trueSizeKnown) {
                    int imageWidth = image.getWidth(this);
                    int imageHeight = image.getHeight(this);
    
                    //Component-initiated resizing.
                    if (((imageWidth > 0) && (imageHeight > 0)) &&
                        ((w != imageWidth) || (h != imageHeight))) {
                        if (bASM && (imageWidth>300 || imageHeight>300)) {
                            if (imageHeight > imageWidth) {
                                imageWidth = imageWidth * 300 / imageHeight;
                                imageHeight = 300;
                            } else {
                                imageHeight = imageHeight * 300 / imageWidth;
                                imageWidth = 300;
                            }
                            System.out.println("redimensionnement");
                            //image = image.getScaledInstance(imageWidth, imageHeight, Image.SCALE_SMOOTH);
                            // trop lent
                            ImageFilter scalefilter = new ReplicateScaleFilter(imageWidth, imageHeight);
                            ImageProducer producer = new FilteredImageSource(image.getSource(), scalefilter);
                            image = createImage(producer);
                            setImage1(image);
                        }
                        w = imageWidth;
                        h = imageHeight;
                        size = new Dimension(w,h);
                        setSize(w, h);
                        ((Frame)pappy).pack();
                        pappy.validate();
                        trueSizeKnown = true;
                    }
                }
            }
    
            g.drawImage(image, 0, 0, this);
            g.drawRect(0, 0, w - 1, h - 1);
            
            dessinerObjet();
        }
        
        public void update(Graphics g) {
            paint(g);
        }
        
        public void mouseMoved(MouseEvent e) {
            /*String slab = " " + e.getX() + ", " + e.getY();
            if (outil == POINT && p1 != null)
                slab += "  + point en " + p1.x + ", " + p1.y;
            if (outil == LIGNE && p1 != null && p2 != null)
                slab += "  + ligne de longueur " + Math.sqrt(Math.pow(p2.x - p1.x, 2) +
                    Math.pow(p2.y - p1.y, 2));
            if (outil == CERCLE && p1 != null && p2 != null)
                slab += "  + cercle de rayon " + Math.max(Math.abs(p2.x - p1.x),
                    Math.abs(p2.y - p1.y));
            lab.setText(slab);*/
        }
        
        public void mouseDragged(MouseEvent e) {
            if (outil == RECTANGLE && p1 != null) {
                if (p2 != null)
                    dessinerRectangle();
                p2 = e.getPoint();
                dessinerRectangle();
                /*String slab = "ligne de longueur " + Math.sqrt(Math.pow(p2.x - p1.x, 2) +
                    Math.pow(p2.y - p1.y, 2));
                lab.setText(slab);*/
            } else if (outil == CERCLE && p1 != null) {
                if (p2 != null)
                    dessinerCercle();
                p2 = e.getPoint();
                dessinerCercle();
                int rayon = Math.max(Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                /*String slab = "cercle de rayon " + rayon;
                lab.setText(slab);*/
            }
        }
        
        public void mouseClicked(MouseEvent e) {
            if (outil == POLYGONE) {
                if (poly != null) {
                    dessinerPolygone();
                } else
                    poly = new Polygon();
                Point p = e.getPoint();
                poly.addPoint(p.x, p.y);
                if (poly.npoints<3)
                	dessinerCroix(p.x, p.y);     
                else if (poly.npoints==3)
                	repaint();
                dessinerPolygone();
                /*String slab = "point en " + p1.x + ", " + p1.y;
                lab.setText(slab);*/
            }
        }
        
        public void mouseEntered(MouseEvent e) {
        }
        
        public void mouseExited(MouseEvent e) {
        }
        
        public void mousePressed(MouseEvent e) {
            if (outil == RECTANGLE) {
                if (p2 != null) {
                    dessinerRectangle();
                    p2 = null;
                }
                p1 = e.getPoint();
            } else if (outil == CERCLE) {
                if (p2 != null) {
                    dessinerCercle();
                    p2 = null;
                }
                p1 = e.getPoint();
            }
        }
        
        public void mouseReleased(MouseEvent e) {
            if (outil == RECTANGLE) {
                if (p2 != null)
                    dessinerRectangle();
                p2 = e.getPoint();
                dessinerRectangle();
            }
        }
        
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case KeyEvent.VK_LEFT: deplacer(-1, 0); break;
                case KeyEvent.VK_RIGHT: deplacer(1, 0); break;
                case KeyEvent.VK_UP: deplacer(0, -1); break;
                case KeyEvent.VK_DOWN: deplacer(0, 1); break;
                case KeyEvent.VK_ADD: agrandir(1); break;
                case KeyEvent.VK_SUBTRACT: agrandir(-1); break;
                default: ;
            }
        }
        
        public void keyReleased(KeyEvent e) {
        }
        
        public void keyTyped(KeyEvent e) {
        }
        
        public void deplacer(int dx, int dy) {
            dessinerObjet();
            if (p1 != null) {
                p1.x += dx;
                p1.y += dy;
            }
            if (p2 != null) {
                p2.x += dx;
                p2.y += dy;
            }
            dessinerObjet();
            /*if (outil == POINT && p1 != null) {
                String slab = "point en " + p1.x + ", " + p1.y;
                lab.setText(slab);
            }*/
        }
        
        public void agrandir(int dr) {
            if (outil == CERCLE && p1 != null && p2 != null) {
                dessinerCercle();
                if (p2.x > p1.x)
                    p2.x += dr;
                else
                    p2.x -= dr;
                if (p2.y > p1.y)
                    p2.y += dr;
                else
                    p2.y -= dr;
                dessinerCercle();
                int rayon = Math.max(Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
                /*String slab = "cercle de rayon " + rayon;
                lab.setText(slab);*/
            }
        }
        
        public void setOutil(int o) {
            if (outil == RECTANGLE && p2 != null)
                dessinerRectangle();
            else if (outil == CERCLE && p2 != null)
                dessinerCercle();
            else if (outil == POLYGONE && poly != null)
                dessinerPolygone();
            outil = o;
            p1 = null;
            p2 = null;
            poly = null;
        }
        
        public void dessinerObjet() {
            if (outil == RECTANGLE && p1 != null && p2 != null)
                dessinerRectangle();
            else if (outil == CERCLE && p1 != null && p2 != null)
                dessinerCercle();
            else if (outil == POLYGONE && poly != null)
                dessinerPolygone();
        }
        
        public void dessinerCroix(int x, int y) {
            Graphics g = getGraphics();
           	g.setColor(new Color(40,255,40));
            g.setXORMode(new Color((g.getColor().getRed()+60)%255,(g.getColor().getGreen()+60)%255,(g.getColor().getBlue()+60)%255));
            g.drawLine(x-3, y-3, x+3, y+3);
            g.drawLine(x-3, y+3, x+3, y-3);
            g.setPaintMode();
        }
        
        public void dessinerRectangle() {
            Graphics g = getGraphics();
            g.setXORMode(Color.white);
            g.drawRect(p1.x, p1.y, p2.x-p1.x, p2.y-p1.y);
            g.setPaintMode();
        }
        
        public void dessinerCercle() {
            Graphics g = getGraphics();
            g.setXORMode(Color.white);
            int rayon = Math.max(Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
            g.drawOval(p1.x - rayon, p1.y - rayon, rayon*2, rayon*2);
            g.setPaintMode();
        }
        
        public void dessinerPolygone() {
            Graphics g = getGraphics();
            g.setXORMode(Color.white);
            g.drawPolygon(poly);
            g.setPaintMode();
        }
        
        public void changeImage(Image im) {
            image = im;
            p1 = null;
            p2 = null;
            poly = null;
            repaint();
        }
        
        public int getOutil() {
            return(outil);
        }
        
        public String getCoords() {
            String coords = null;
            if (outil == RECTANGLE && p1 != null && p2 != null) {
                coords = p1.x + "," + p1.y + "," + p2.x + "," + p2.y;
            } else if (outil == CERCLE && p1 != null && p2 != null) {
                int dx = p2.x - p1.x;
                int dy = p2.y - p1.y;
                double d = Math.sqrt(dx*dx + dy*dy);
                coords = p1.x + "," + p1.y + "," + Math.round(d);
            } else if (outil == POLYGONE && poly != null) {
                for (int i=0; i<poly.npoints; i++) {
                    if (coords != null)
                        coords += ",";
                    else
                        coords = "";
                    coords += poly.xpoints[i] + "," + poly.ypoints[i];
                }
            }
            return(coords);
        }
    }

    class Zone {
        SousZone[] souszones;
        String texte;
        Image image;
        
        public Zone(XMLTree zonetree) {
            texte = zonetree.getAttVal("texte");
            /*if (texte == null)
                System.err.println("Erreur: aucun texte pour la zone");*/
            souszones = new SousZone[zonetree.getChildrenCount()];
            XMLTree sztree;
            int i=0;
            for (sztree=zonetree.first_child; sztree!=null; sztree=sztree.next_brother) {
                String forme = sztree.getAttVal("forme");
                String coords = sztree.getAttVal("coords");
                souszones[i++] = new SousZone(forme, coords);
            }
            image = null;
        }

        public boolean contains(int x, int y) {
            for (int i=0; i<souszones.length; i++)
                if (souszones[i].contains(x,y))
                    return(true);
            return(false);
        }
        
        public String getTexte() {
            return(texte);
        }
        
        public void initImage() {
            image = null;
        }
        
        public Image imageZone(Image sourceImage) {
            if (image != null)
                return(image);
            ImageFilter filter = new HighlightFilter(this, 0x00ffff);
            ImageProducer producer = new FilteredImageSource(sourceImage.getSource(), filter);
            Image resultImage = createImage(producer);
            image = resultImage;
            return(resultImage);
        }
        
        public void ajouterSousZone(SousZone sz) {
            SousZone[] souszones2 = new SousZone[souszones.length + 1];
            for (int i=0; i<souszones.length; i++)
                souszones2[i] = souszones[i];
            souszones2[souszones.length] = sz;
            souszones = souszones2;
            initImage();
        }
        
        public void supprimerSousZone(int isz) {
            SousZone[] souszones2 = new SousZone[souszones.length - 1];
            for (int i=0; i<souszones.length-1; i++) {
                if (i<isz)
                    souszones2[i] = souszones[i];
                else
                    souszones2[i] = souszones[i+1];
            }
            souszones = souszones2;
            initImage();
        }
    }
    
    class SousZone {
        String forme;
        String coords;
        Polygon poly;
        Rectangle rect;
        Circle circ;
        
        public SousZone(String forme, String coords) {
            this.forme = forme;
            this.coords = coords;
            poly = null;
            rect = null;
            circ = null;
            if ("polygone".equals(forme)) {
                poly = new Polygon();
                String sc = coords;
                while (sc.indexOf(',') != -1) {
                    int iv = sc.indexOf(',');
                    String sx = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                    String sy;
                    if (iv != -1) {
                    	sy = sc.substring(0,iv);
                        sc = sc.substring(iv+1);
                    } else {
                        sy = sc;
                        sc = "";
                    }
                    try {
                        int x = Integer.valueOf(sx).intValue();
                        int y = Integer.valueOf(sy).intValue();
                        poly.addPoint(x, y);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException: " + ex.getMessage());
                    }
                }
            } else if ("rectangle".equals(forme)) {
                String sc = coords;
                String sx1=null,sy1=null,sx2=null,sy2=null;
                int iv = sc.indexOf(',');
                if (iv != -1) {
                    sx1 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sy1 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sx2 = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv == -1)
                    sy2 = sc;
                if (sx1 != null && sy1 != null && sx2 != null && sy2 != null) {
                    try {
                        int x1 = Integer.valueOf(sx1).intValue();
                        int y1 = Integer.valueOf(sy1).intValue();
                        int x2 = Integer.valueOf(sx2).intValue();
                        int y2 = Integer.valueOf(sy2).intValue();
                        rect = new Rectangle(x1, y1, x2-x1, y2-y1);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException " + ex.getMessage());
                    }
                }
            } else if ("cercle".equals(forme)) {
                String sc = coords;
                String sx=null,sy=null,sr=null;
                int iv = sc.indexOf(',');
                if (iv != -1) {
                    sx = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv != -1) {
                    sy = sc.substring(0,iv);
                    sc = sc.substring(iv+1);
                    iv = sc.indexOf(',');
                }
                if (iv == -1)
                    sr = sc;
                if (sx != null && sy != null && sr != null) {
                    try {
                        int x = Integer.valueOf(sx).intValue();
                        int y = Integer.valueOf(sy).intValue();
                        int r = Integer.valueOf(sr).intValue();
                        circ = new Circle(x, y, r);
                    } catch (NumberFormatException ex) {
                        System.err.println("NumberFormatException " + ex.getMessage());
                    }
                }
            }
        }

        public boolean contains(int x, int y) {
            if ("polygone".equals(forme))
                return(poly.contains(x, y));
            else if ("rectangle".equals(forme))
                return(rect.contains(x, y));
            else if ("cercle".equals(forme))
                return(circ.contains(x, y));
            else
                return(false);
        }
        
        public Rectangle getBounds() {
            if ("polygone".equals(forme))
                return(poly.getBounds());
            else if ("rectangle".equals(forme))
                return(rect.getBounds());
            else if ("cercle".equals(forme))
                return(circ.getBounds());
            else
                return(null);
        }
    }
    
    class Circle {
        int cx,cy,cr;
        public Circle(int x, int y, int r) {
            cx = x;
            cy = y;
            cr = r;
        }
        public boolean contains(int x, int y) {
            int x2 = x - cx;
            int y2 = y - cy;
            double d = Math.sqrt(x2*x2 + y2*y2);
            return(d < cr);
        }
        public Rectangle getBounds() {
            Rectangle r = new Rectangle(cx-cr, cy-cr, cr*2, cr*2);
            return(r);
        }
    }

    class HighlightFilter extends RGBImageFilter {
        int rgbf;
        Zone zezone;
        int opacite = 25; // en %
    
        public HighlightFilter(Zone zezone, int rgbf) {
            canFilterIndexColorModel = false;
            this.zezone = zezone;
            this.rgbf = rgbf;
        }
    
        public int filterRGB(int x, int y, int rgb) {
            if (!zezone.contains(x,y))
                return(rgb);
            int r = (rgb >> 16) & 0xff;
            int g = (rgb >> 8) & 0xff;
            int b = (rgb >> 0) & 0xff;
            int r2 = (rgbf >> 16) & 0xff;
            int g2 = (rgbf >> 8) & 0xff;
            int b2 = (rgbf >> 0) & 0xff;
            r = opacite*r2/100 + (100-opacite)*r/100;
            g = opacite*g2/100 + (100-opacite)*g/100;
            b = opacite*b2/100 + (100-opacite)*b/100;
            if (r > 255) r = 255;
            if (g > 255) g = 255;
            if (b > 255) b = 255;
            return (rgb & 0xff000000) | (r << 16) | (g << 8) | (b << 0);
        }
    }

    class SaveDialog extends Dialog implements ActionListener {
        Frame parent;
        Button setButton;
    
        SaveDialog(Frame dw) {
            super(dw, "Quitter", true);
    
            Label label = new Label("Enregistrer avant de quitter ?");
            add(label, BorderLayout.CENTER);
    
            Panel p2 = new Panel();
            p2.setLayout(new FlowLayout(FlowLayout.RIGHT));
            Button bnepas = new Button("Ne pas enregistrer");
            bnepas.addActionListener(this);
            Button benr = new Button("Enregistrer");
            benr.addActionListener(this);
            p2.add(bnepas);
            p2.add(benr);
            add(p2, BorderLayout.SOUTH);
    
            pack();
        }
    
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Enregistrer"))
                enregistrer();
            setVisible(false);
        }
    }
}
