/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import xml.Attribute;
import xml.Parser;
import xml.Parser_XML;
import xml.XMLTree;

public class ImageCarte
extends Applet {
    ImageCanvas ic;
    TextArea lab;
    Zone[] zones;
    String dossier;

    public void init() {
        Object object;
        Object object2;
        this.setLayout(new BorderLayout());
        String string = this.getParameter("image");
        if (string == null) {
            System.err.println("erreur: ImageCarte utilise le param\u00e8tre image, qui n'a pas \u00e9t\u00e9 d\u00e9fini");
        }
        this.dossier = new File(string).getParent();
        XMLTree xMLTree = new XMLTree(null, "", null, "");
        try {
            object2 = this.getParameter("fcarte");
            if (object2 == null && ((String)(object2 = string)).indexOf(46) != -1) {
                object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46)) + ".carte";
            }
            URL uRL = new URL(this.getCodeBase(), (String)object2);
            object = new Parser_XML(uRL.openStream(), (OutputStream)System.out, xMLTree);
            ((Parser)object).parse(0);
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
            return;
        }
        if (!"CARTE".equalsIgnoreCase(xMLTree.tag)) {
            System.err.println("Mauvais fichier XML (la racine est " + xMLTree.tag + " au lieu de CARTE)");
            return;
        }
        this.zones = new Zone[xMLTree.getChildrenCount()];
        int n = 0;
        object2 = xMLTree.first_child;
        while (object2 != null) {
            this.zones[n++] = new Zone((XMLTree)object2);
            object2 = ((XMLTree)object2).next_brother;
        }
        object = this.getImage(this.getCodeBase(), string);
        int n2 = 300;
        int n3 = 300;
        String string2 = xMLTree.getAttVal("largeur");
        String string3 = xMLTree.getAttVal("hauteur");
        if (string2 != null && !"".equals(string2) && string3 != null && !"".equals(string3)) {
            try {
                n2 = Integer.valueOf(string2);
                n3 = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException: " + numberFormatException.getMessage());
            }
        }
        this.ic = new ImageCanvas((Image)object, n2, n3);
        this.lab = new TextArea("", 2, 60, 3);
        this.lab.setEditable(false);
        this.add((Component)this.lab, "South");
        this.add((Component)this.ic, "Center");
        this.validate();
        new Thread(){

            public void run() {
                ImageCarte.this.ic.initialisation();
                ImageCarte.this.ic.requestFocus();
            }
        }.start();
    }

    class HighlightFilter
    extends RGBImageFilter {
        Zone zezone;
        final int opacite = 25;
        int r2op;
        int g2op;
        int b2op;

        public HighlightFilter(Zone zone, int n) {
            this.canFilterIndexColorModel = false;
            this.zezone = zone;
            int n2 = n >> 16 & 0xFF;
            int n3 = n >> 8 & 0xFF;
            int n4 = n >> 0 & 0xFF;
            this.r2op = 25 * n2 / 100;
            this.g2op = 25 * n3 / 100;
            this.b2op = 25 * n4 / 100;
        }

        public int filterRGB(int n, int n2, int n3) {
            if (!this.zezone.contains(n, n2)) {
                return n3;
            }
            int n4 = n3 >> 16 & 0xFF;
            int n5 = n3 >> 8 & 0xFF;
            int n6 = n3 >> 0 & 0xFF;
            n4 = this.r2op + 75 * n4 / 100;
            n5 = this.g2op + 75 * n5 / 100;
            n6 = this.b2op + 75 * n6 / 100;
            if (n4 > 255) {
                n4 = 255;
            }
            if (n5 > 255) {
                n5 = 255;
            }
            if (n6 > 255) {
                n6 = 255;
            }
            return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6 << 0;
        }
    }

    class Circle {
        int cx;
        int cy;
        int cr;

        public Circle(int n, int n2, int n3) {
            this.cx = n;
            this.cy = n2;
            this.cr = n3;
        }

        public boolean contains(int n, int n2) {
            int n3 = n - this.cx;
            int n4 = n2 - this.cy;
            if (n3 > 0 && n3 > this.cr || n3 < 0 && -n3 > this.cr || n4 > 0 && n4 > this.cr || n4 < 0 && -n4 > this.cr) {
                return false;
            }
            double d = Math.sqrt(n3 * n3 + n4 * n4);
            return d < (double)this.cr;
        }

        public Rectangle getBounds() {
            Rectangle rectangle = new Rectangle(this.cx - this.cr, this.cy - this.cr, this.cr * 2, this.cr * 2);
            return rectangle;
        }
    }

    class SousZone {
        static final int FORME_INCONNUE = 0;
        static final int FORME_CERCLE = 1;
        static final int FORME_RECTANGLE = 2;
        static final int FORME_POLYGONE = 3;
        int forme;
        String coords;
        Polygon poly;
        Rectangle rect;
        Circle circ;

        public SousZone(String string, String string2) {
            block18: {
                block19: {
                    block17: {
                        this.coords = string2;
                        this.poly = null;
                        this.rect = null;
                        this.circ = null;
                        this.forme = "polygone".equals(string) ? 3 : ("rectangle".equals(string) ? 2 : ("cercle".equals(string) ? 1 : 0));
                        if (this.forme != 3) break block17;
                        this.poly = new Polygon();
                        String string3 = string2;
                        while (string3.indexOf(44) != -1) {
                            String string4;
                            int n = string3.indexOf(44);
                            String string5 = string3.substring(0, n);
                            if ((n = (string3 = string3.substring(n + 1)).indexOf(44)) != -1) {
                                string4 = string3.substring(0, n);
                                string3 = string3.substring(n + 1);
                            } else {
                                string4 = string3;
                                string3 = "";
                            }
                            try {
                                int n2 = Integer.valueOf(string5);
                                int n3 = Integer.valueOf(string4);
                                this.poly.addPoint(n2, n3);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("NumberFormatException: " + numberFormatException.getMessage());
                            }
                        }
                        break block18;
                    }
                    if (this.forme != 2) break block19;
                    String string6 = string2;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    String string10 = null;
                    int n = string6.indexOf(44);
                    if (n != -1) {
                        string7 = string6.substring(0, n);
                        string6 = string6.substring(n + 1);
                        n = string6.indexOf(44);
                    }
                    if (n != -1) {
                        string8 = string6.substring(0, n);
                        string6 = string6.substring(n + 1);
                        n = string6.indexOf(44);
                    }
                    if (n != -1) {
                        string9 = string6.substring(0, n);
                        string6 = string6.substring(n + 1);
                        n = string6.indexOf(44);
                    }
                    if (n == -1) {
                        string10 = string6;
                    }
                    if (string7 == null || string8 == null || string9 == null || string10 == null) break block18;
                    try {
                        int n4 = Integer.valueOf(string7);
                        int n5 = Integer.valueOf(string8);
                        int n6 = Integer.valueOf(string9);
                        int n7 = Integer.valueOf(string10);
                        this.rect = new Rectangle(n4, n5, n6 - n4, n7 - n5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException " + numberFormatException.getMessage());
                    }
                    break block18;
                }
                if (this.forme != 1) break block18;
                String string11 = string2;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                int n = string11.indexOf(44);
                if (n != -1) {
                    string12 = string11.substring(0, n);
                    string11 = string11.substring(n + 1);
                    n = string11.indexOf(44);
                }
                if (n != -1) {
                    string13 = string11.substring(0, n);
                    string11 = string11.substring(n + 1);
                    n = string11.indexOf(44);
                }
                if (n == -1) {
                    string14 = string11;
                }
                if (string12 != null && string13 != null && string14 != null) {
                    try {
                        int n8 = Integer.valueOf(string12);
                        int n9 = Integer.valueOf(string13);
                        int n10 = Integer.valueOf(string14);
                        this.circ = new Circle(n8, n9, n10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("NumberFormatException " + numberFormatException.getMessage());
                    }
                }
            }
        }

        public boolean contains(int n, int n2) {
            if (this.forme == 3) {
                return this.poly.contains(n, n2);
            }
            if (this.forme == 2) {
                return this.rect.contains(n, n2);
            }
            if (this.forme == 1) {
                return this.circ.contains(n, n2);
            }
            return false;
        }

        public Rectangle getBounds() {
            if (this.forme == 3) {
                return this.poly.getBounds();
            }
            if (this.forme == 2) {
                return this.rect.getBounds();
            }
            if (this.forme == 1) {
                return this.circ.getBounds();
            }
            return null;
        }
    }

    class Zone {
        SousZone[] souszones;
        String texte;
        Image image;

        public Zone(XMLTree xMLTree) {
            this.texte = xMLTree.getAttVal("texte");
            this.souszones = new SousZone[xMLTree.getChildrenCount()];
            int n = 0;
            XMLTree xMLTree2 = xMLTree.first_child;
            while (xMLTree2 != null) {
                String string = xMLTree2.getAttVal("forme");
                String string2 = xMLTree2.getAttVal("coords");
                this.souszones[n++] = new SousZone(string, string2);
                xMLTree2 = xMLTree2.next_brother;
            }
            this.image = null;
        }

        public boolean contains(int n, int n2) {
            for (int i = 0; i < this.souszones.length; ++i) {
                if (!this.souszones[i].contains(n, n2)) continue;
                return true;
            }
            return false;
        }

        public String getTexte() {
            return this.texte;
        }

        public Image imageZone(Image image) {
            Image image2;
            if (this.image != null) {
                return this.image;
            }
            HighlightFilter highlightFilter = new HighlightFilter(this, 65535);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), highlightFilter);
            this.image = image2 = ImageCarte.this.createImage(filteredImageSource);
            return image2;
        }
    }

    class ImageCanvas
    extends Canvas
    implements MouseMotionListener {
        Image image1;
        Image image;
        Dimension size;
        int zonesel = -1;
        Image imageTout = null;

        public ImageCanvas(Image image, int n, int n2) {
            this.image1 = image;
            this.size = new Dimension(n, n2);
            image = null;
        }

        public void initialisation() {
            ImageCarte.this.lab.setText("pr\u00e9paration de la carte...");
            XMLTree xMLTree = new XMLTree(null, "ZONE", null, null);
            Vector<Attribute> vector = new Vector<Attribute>();
            vector.addElement(new Attribute("forme", "rectangle"));
            vector.addElement(new Attribute("coords", "0,0,20,20"));
            XMLTree xMLTree2 = new XMLTree(null, "SOUSZONE", vector, null);
            xMLTree.addChild(xMLTree2);
            Zone zone = new Zone(xMLTree);
            HighlightFilter highlightFilter = new HighlightFilter(zone, 0xFF0000);
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.image1.getSource(), highlightFilter);
            this.image = this.image1 = this.createImage(filteredImageSource);
            this.prepareToutesImages(this.image1);
            this.addMouseMotionListener(this);
            ImageCarte.this.lab.setText("D\u00e9placer le curseur sur la carte pour activer certaines zones. Le coin rouge permet de voir toutes les zones.");
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            return this.size;
        }

        public void paint(Graphics graphics) {
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            }
            graphics.drawRect(0, 0, this.size.width - 1, this.size.height - 1);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            boolean bl = false;
            for (int i = 0; i < ImageCarte.this.zones.length; ++i) {
                if (!ImageCarte.this.zones[i].contains(n, n2)) continue;
                if (this.zonesel != i) {
                    String string = ImageCarte.this.zones[i].getTexte();
                    ImageCarte.this.lab.setText(string);
                    this.changeImage(ImageCarte.this.zones[i].imageZone(this.image1));
                    this.zonesel = i;
                }
                bl = true;
                break;
            }
            if (!bl && n < 20 && n2 < 20) {
                this.changeImage(this.imageToutesZones(this.image1));
                if (this.zonesel != -1) {
                    ImageCarte.this.lab.setText("");
                    this.zonesel = -1;
                }
            } else if (!bl && this.zonesel != -1) {
                ImageCarte.this.lab.setText("");
                this.changeImage(this.image1);
                this.zonesel = -1;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void changeImage(Image image) {
            this.image = image;
            this.repaint();
        }

        public Image imageToutesZones(Image image) {
            if (this.imageTout != null) {
                return this.imageTout;
            }
            Image image2 = image;
            for (int i = 0; i < ImageCarte.this.zones.length; ++i) {
                HighlightFilter highlightFilter = new HighlightFilter(ImageCarte.this.zones[i], 65535);
                FilteredImageSource filteredImageSource = new FilteredImageSource(image2.getSource(), highlightFilter);
                image2 = this.createImage(filteredImageSource);
            }
            this.imageTout = image2;
            return this.imageTout;
        }

        public void prepareToutesImages(Image image) {
            MediaTracker mediaTracker = new MediaTracker(this);
            for (int i = 0; i < ImageCarte.this.zones.length; ++i) {
                mediaTracker.addImage(ImageCarte.this.zones[i].imageZone(image), i);
            }
            mediaTracker.addImage(this.imageToutesZones(image), ImageCarte.this.zones.length);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("InterruptedException: " + interruptedException.getMessage());
            }
        }
    }
}

