/*
Calcotron - Calculateur Scientifique

Copyright (C) 2003 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformément aux dispositions de la Licence Publique Générale GNU, telle que publiée par la Free Software Foundation ; version 2 de la licence, ou encore (à votre choix) toute version ultérieure.

Ce programme est distribué dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans même la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de détail, voir la Licence Publique Générale GNU .

Vous devez avoir reçu un exemplaire de la Licence Publique Générale GNU en même temps que ce programme ; si ce n'est pas le cas, écrivez à la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package calcotron;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

// l'applet doit avoir les dimensions de l'icone (33x50)
public class CalcoApplet extends Applet implements MouseListener {
    Image img, bouton1, bouton2;
    boolean appui;
    
    public void init() {
        try { 
            MediaTracker tracker = new MediaTracker (this);
            URL url = CalcoFrame.class.getResource("bouton1.gif");
            bouton1 = Toolkit.getDefaultToolkit().getImage(url);
            tracker.addImage(bouton1, 0);
            url = CalcoFrame.class.getResource("bouton2.gif");
            bouton2 = Toolkit.getDefaultToolkit().getImage(url);
            tracker.addImage(bouton2, 0);
            tracker.waitForAll();
        } catch (Exception e) { 
            e.printStackTrace();
        }
        img = bouton1;
        appui = false;
        addMouseListener(this);
    }
    
    public void paint(Graphics g) {
        g.drawImage(img, 0, 0, null);
    }
    
    public void mouseClicked(MouseEvent e) { }
    
    public void mousePressed(MouseEvent e) {
        appui = true;
        img = bouton2;
        repaint();
    }
    
    public void mouseReleased(MouseEvent e) {
        appui = false;
        img = bouton1;
        repaint();
        CalcoFrame f = new CalcoFrame(true);
        f.setVisible(true);
    }
    
    public void mouseEntered(MouseEvent e) { }
    
    public void mouseExited(MouseEvent e) { }
}

